/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.InputEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class RegistrationRequest
implements Parcelable {
    public static final int INVALID = 0;
    public static final int REGISTER_SOURCE = 1;
    public static final int REGISTER_TRIGGER = 2;
    private final int mRegistrationType;
    private final Uri mRegistrationUri;
    private final InputEvent mInputEvent;
    private final String mAppPackageName;
    private final String mSdkPackageName;
    private final long mRequestTime;
    private final boolean mIsAdIdPermissionGranted;
    private final String mAdIdValue;
    public static final Parcelable.Creator<RegistrationRequest> CREATOR = new Parcelable.Creator<RegistrationRequest>(){

        @Override
        public RegistrationRequest createFromParcel(Parcel in) {
            return new RegistrationRequest(in);
        }

        public RegistrationRequest[] newArray(int size) {
            return new RegistrationRequest[size];
        }
    };

    private RegistrationRequest(Builder builder) {
        this.mRegistrationType = builder.mRegistrationType;
        this.mRegistrationUri = builder.mRegistrationUri;
        this.mInputEvent = builder.mInputEvent;
        this.mAppPackageName = builder.mAppPackageName;
        this.mSdkPackageName = builder.mSdkPackageName;
        this.mRequestTime = builder.mRequestTime;
        this.mIsAdIdPermissionGranted = builder.mIsAdIdPermissionGranted;
        this.mAdIdValue = builder.mAdIdValue;
    }

    private RegistrationRequest(Parcel in) {
        this.mRegistrationType = in.readInt();
        this.mRegistrationUri = Uri.CREATOR.createFromParcel(in);
        this.mAppPackageName = in.readString();
        this.mSdkPackageName = in.readString();
        boolean hasInputEvent = in.readBoolean();
        this.mInputEvent = hasInputEvent ? InputEvent.CREATOR.createFromParcel(in) : null;
        this.mRequestTime = in.readLong();
        this.mIsAdIdPermissionGranted = in.readBoolean();
        boolean hasAdIdValue = in.readBoolean();
        this.mAdIdValue = hasAdIdValue ? in.readString() : null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        Objects.requireNonNull(out);
        out.writeInt(this.mRegistrationType);
        this.mRegistrationUri.writeToParcel(out, flags);
        out.writeString(this.mAppPackageName);
        out.writeString(this.mSdkPackageName);
        if (this.mInputEvent != null) {
            out.writeBoolean(true);
            this.mInputEvent.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.mRequestTime);
        out.writeBoolean(this.mIsAdIdPermissionGranted);
        if (this.mAdIdValue != null) {
            out.writeBoolean(true);
            out.writeString(this.mAdIdValue);
        } else {
            out.writeBoolean(false);
        }
    }

    public int getRegistrationType() {
        return this.mRegistrationType;
    }

    public Uri getRegistrationUri() {
        return this.mRegistrationUri;
    }

    public InputEvent getInputEvent() {
        return this.mInputEvent;
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public String getSdkPackageName() {
        return this.mSdkPackageName;
    }

    public long getRequestTime() {
        return this.mRequestTime;
    }

    public boolean isAdIdPermissionGranted() {
        return this.mIsAdIdPermissionGranted;
    }

    public String getAdIdValue() {
        return this.mAdIdValue;
    }

    public static class Builder {
        private final int mRegistrationType;
        private final Uri mRegistrationUri;
        private final String mAppPackageName;
        private final String mSdkPackageName;
        private InputEvent mInputEvent;
        private long mRequestTime;
        private boolean mIsAdIdPermissionGranted;
        private String mAdIdValue;

        public Builder(int type, Uri registrationUri, String appPackageName, String sdkPackageName) {
            if (type != 1 && type != 2) {
                throw new IllegalArgumentException("Invalid registrationType");
            }
            Objects.requireNonNull(registrationUri);
            Objects.requireNonNull(appPackageName);
            Objects.requireNonNull(sdkPackageName);
            this.mRegistrationType = type;
            this.mRegistrationUri = registrationUri;
            this.mAppPackageName = appPackageName;
            this.mSdkPackageName = sdkPackageName;
        }

        public Builder setInputEvent(InputEvent event) {
            this.mInputEvent = event;
            return this;
        }

        public Builder setRequestTime(long requestTime) {
            this.mRequestTime = requestTime;
            return this;
        }

        public Builder setAdIdPermissionGranted(boolean adIdPermissionGranted) {
            this.mIsAdIdPermissionGranted = adIdPermissionGranted;
            return this;
        }

        public Builder setAdIdValue(String adIdValue) {
            this.mAdIdValue = adIdValue;
            return this;
        }

        public RegistrationRequest build() {
            if (this.mRegistrationType != 1 && this.mRegistrationType != 2) {
                throw new IllegalArgumentException("Invalid registrationType");
            }
            return new RegistrationRequest(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegistrationType {
    }
}

