/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class WebSourceParams
implements Parcelable {
    public static final Parcelable.Creator<WebSourceParams> CREATOR = new Parcelable.Creator<WebSourceParams>(){

        @Override
        public WebSourceParams createFromParcel(Parcel in) {
            return new WebSourceParams(in);
        }

        public WebSourceParams[] newArray(int size) {
            return new WebSourceParams[size];
        }
    };
    private final Uri mRegistrationUri;
    private final boolean mDebugKeyAllowed;

    private WebSourceParams(Builder builder) {
        this.mRegistrationUri = builder.mRegistrationUri;
        this.mDebugKeyAllowed = builder.mDebugKeyAllowed;
    }

    private WebSourceParams(Parcel in) {
        this.mRegistrationUri = Uri.CREATOR.createFromParcel(in);
        this.mDebugKeyAllowed = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSourceParams)) {
            return false;
        }
        WebSourceParams that = (WebSourceParams)o;
        return this.mDebugKeyAllowed == that.mDebugKeyAllowed && Objects.equals(this.mRegistrationUri, that.mRegistrationUri);
    }

    public int hashCode() {
        return Objects.hash(this.mRegistrationUri, this.mDebugKeyAllowed);
    }

    public Uri getRegistrationUri() {
        return this.mRegistrationUri;
    }

    public boolean isDebugKeyAllowed() {
        return this.mDebugKeyAllowed;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        Objects.requireNonNull(out);
        this.mRegistrationUri.writeToParcel(out, flags);
        out.writeBoolean(this.mDebugKeyAllowed);
    }

    public static class Builder {
        private final Uri mRegistrationUri;
        private boolean mDebugKeyAllowed;

        public Builder(Uri registrationUri) {
            Objects.requireNonNull(registrationUri);
            this.mRegistrationUri = registrationUri;
            this.mDebugKeyAllowed = false;
        }

        public Builder setDebugKeyAllowed(boolean debugKeyAllowed) {
            this.mDebugKeyAllowed = debugKeyAllowed;
            return this;
        }

        public WebSourceParams build() {
            return new WebSourceParams(this);
        }
    }
}

