/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.measurement.WebSourceParams;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.view.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebSourceRegistrationRequest
implements Parcelable {
    private static final String ANDROID_APP_SCHEME = "android-app";
    private static final int WEB_SOURCE_PARAMS_MAX_COUNT = 20;
    public static final Parcelable.Creator<WebSourceRegistrationRequest> CREATOR = new Parcelable.Creator<WebSourceRegistrationRequest>(){

        @Override
        public WebSourceRegistrationRequest createFromParcel(Parcel in) {
            return new WebSourceRegistrationRequest(in);
        }

        public WebSourceRegistrationRequest[] newArray(int size) {
            return new WebSourceRegistrationRequest[size];
        }
    };
    private final List<WebSourceParams> mWebSourceParams;
    private final Uri mTopOriginUri;
    private final InputEvent mInputEvent;
    private final Uri mAppDestination;
    private final Uri mWebDestination;
    private final Uri mVerifiedDestination;

    private WebSourceRegistrationRequest(Builder builder) {
        this.mWebSourceParams = builder.mWebSourceParams;
        this.mInputEvent = builder.mInputEvent;
        this.mTopOriginUri = builder.mTopOriginUri;
        this.mAppDestination = builder.mAppDestination;
        this.mWebDestination = builder.mWebDestination;
        this.mVerifiedDestination = builder.mVerifiedDestination;
    }

    private WebSourceRegistrationRequest(Parcel in) {
        Objects.requireNonNull(in);
        ArrayList<WebSourceParams> sourceRegistrations = new ArrayList<WebSourceParams>();
        if (_Original_Build.VERSION.SDK_INT < 33) {
            in.readList(sourceRegistrations, WebSourceParams.class.getClassLoader());
        } else {
            in.readList(sourceRegistrations, WebSourceParams.class.getClassLoader(), WebSourceParams.class);
        }
        this.mWebSourceParams = sourceRegistrations;
        this.mTopOriginUri = Uri.CREATOR.createFromParcel(in);
        this.mInputEvent = in.readBoolean() ? InputEvent.CREATOR.createFromParcel(in) : null;
        this.mAppDestination = in.readBoolean() ? Uri.CREATOR.createFromParcel(in) : null;
        this.mWebDestination = in.readBoolean() ? Uri.CREATOR.createFromParcel(in) : null;
        this.mVerifiedDestination = in.readBoolean() ? Uri.CREATOR.createFromParcel(in) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSourceRegistrationRequest)) {
            return false;
        }
        WebSourceRegistrationRequest that = (WebSourceRegistrationRequest)o;
        return Objects.equals(this.mWebSourceParams, that.mWebSourceParams) && Objects.equals(this.mTopOriginUri, that.mTopOriginUri) && Objects.equals(this.mInputEvent, that.mInputEvent) && Objects.equals(this.mAppDestination, that.mAppDestination) && Objects.equals(this.mWebDestination, that.mWebDestination) && Objects.equals(this.mVerifiedDestination, that.mVerifiedDestination);
    }

    public int hashCode() {
        return Objects.hash(this.mWebSourceParams, this.mTopOriginUri, this.mInputEvent, this.mAppDestination, this.mWebDestination, this.mVerifiedDestination);
    }

    public List<WebSourceParams> getSourceParams() {
        return this.mWebSourceParams;
    }

    public Uri getTopOriginUri() {
        return this.mTopOriginUri;
    }

    public InputEvent getInputEvent() {
        return this.mInputEvent;
    }

    public Uri getAppDestination() {
        return this.mAppDestination;
    }

    public Uri getWebDestination() {
        return this.mWebDestination;
    }

    public Uri getVerifiedDestination() {
        return this.mVerifiedDestination;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        Objects.requireNonNull(out);
        out.writeList(this.mWebSourceParams);
        this.mTopOriginUri.writeToParcel(out, flags);
        if (this.mInputEvent != null) {
            out.writeBoolean(true);
            this.mInputEvent.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
        if (this.mAppDestination != null) {
            out.writeBoolean(true);
            this.mAppDestination.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
        if (this.mWebDestination != null) {
            out.writeBoolean(true);
            this.mWebDestination.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
        if (this.mVerifiedDestination != null) {
            out.writeBoolean(true);
            this.mVerifiedDestination.writeToParcel(out, flags);
        } else {
            out.writeBoolean(false);
        }
    }

    private static void validateScheme(String name, Uri uri) throws IllegalArgumentException {
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException(name + " must have a scheme.");
        }
    }

    public static class Builder {
        private final List<WebSourceParams> mWebSourceParams;
        private final Uri mTopOriginUri;
        private InputEvent mInputEvent;
        private Uri mAppDestination;
        private Uri mWebDestination;
        private Uri mVerifiedDestination;

        public Builder(List<WebSourceParams> webSourceParams, Uri topOriginUri) {
            Objects.requireNonNull(webSourceParams);
            Objects.requireNonNull(topOriginUri);
            if (webSourceParams.isEmpty() || webSourceParams.size() > 20) {
                throw new IllegalArgumentException("web source params size is not within bounds, size: " + webSourceParams.size());
            }
            this.mWebSourceParams = webSourceParams;
            this.mTopOriginUri = topOriginUri;
        }

        public Builder setInputEvent(InputEvent inputEvent) {
            this.mInputEvent = inputEvent;
            return this;
        }

        public Builder setAppDestination(Uri appDestination) {
            if (appDestination != null) {
                Uri destination;
                String scheme = appDestination.getScheme();
                if (scheme == null) {
                    destination = Uri.parse("android-app://" + appDestination);
                } else {
                    if (!scheme.equals(WebSourceRegistrationRequest.ANDROID_APP_SCHEME)) {
                        throw new IllegalArgumentException(String.format("appDestination scheme must be %s or null. Received: %s", WebSourceRegistrationRequest.ANDROID_APP_SCHEME, scheme));
                    }
                    destination = appDestination;
                }
                this.mAppDestination = destination;
            }
            return this;
        }

        public Builder setWebDestination(Uri webDestination) {
            if (webDestination != null) {
                WebSourceRegistrationRequest.validateScheme("Web destination", webDestination);
                this.mWebDestination = webDestination;
            }
            return this;
        }

        public Builder setVerifiedDestination(Uri verifiedDestination) {
            this.mVerifiedDestination = verifiedDestination;
            return this;
        }

        public WebSourceRegistrationRequest build() {
            return new WebSourceRegistrationRequest(this);
        }
    }
}

