/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class WebTriggerParams
implements Parcelable {
    public static final Parcelable.Creator<WebTriggerParams> CREATOR = new Parcelable.Creator<WebTriggerParams>(){

        @Override
        public WebTriggerParams createFromParcel(Parcel in) {
            return new WebTriggerParams(in);
        }

        public WebTriggerParams[] newArray(int size) {
            return new WebTriggerParams[size];
        }
    };
    private final Uri mRegistrationUri;
    private final boolean mDebugKeyAllowed;

    private WebTriggerParams(Builder builder) {
        this.mRegistrationUri = builder.mRegistrationUri;
        this.mDebugKeyAllowed = builder.mDebugKeyAllowed;
    }

    private WebTriggerParams(Parcel in) {
        this.mRegistrationUri = Uri.CREATOR.createFromParcel(in);
        this.mDebugKeyAllowed = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebTriggerParams)) {
            return false;
        }
        WebTriggerParams that = (WebTriggerParams)o;
        return this.mDebugKeyAllowed == that.mDebugKeyAllowed && Objects.equals(this.mRegistrationUri, that.mRegistrationUri);
    }

    public int hashCode() {
        return Objects.hash(this.mRegistrationUri, this.mDebugKeyAllowed);
    }

    public Uri getRegistrationUri() {
        return this.mRegistrationUri;
    }

    public boolean isDebugKeyAllowed() {
        return this.mDebugKeyAllowed;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        Objects.requireNonNull(out);
        this.mRegistrationUri.writeToParcel(out, flags);
        out.writeBoolean(this.mDebugKeyAllowed);
    }

    public static class Builder {
        private final Uri mRegistrationUri;
        private boolean mDebugKeyAllowed;

        public Builder(Uri registrationUri) {
            Objects.requireNonNull(registrationUri);
            this.mRegistrationUri = registrationUri;
            this.mDebugKeyAllowed = false;
        }

        public Builder setDebugKeyAllowed(boolean debugKeyAllowed) {
            this.mDebugKeyAllowed = debugKeyAllowed;
            return this;
        }

        public WebTriggerParams build() {
            return new WebTriggerParams(this);
        }
    }
}

