/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.measurement.WebTriggerParams;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebTriggerRegistrationRequest
implements Parcelable {
    private static final int WEB_TRIGGER_PARAMS_MAX_COUNT = 20;
    public static final Parcelable.Creator<WebTriggerRegistrationRequest> CREATOR = new Parcelable.Creator<WebTriggerRegistrationRequest>(){

        @Override
        public WebTriggerRegistrationRequest createFromParcel(Parcel in) {
            return new WebTriggerRegistrationRequest(in);
        }

        public WebTriggerRegistrationRequest[] newArray(int size) {
            return new WebTriggerRegistrationRequest[size];
        }
    };
    private final List<WebTriggerParams> mWebTriggerParams;
    private final Uri mDestination;

    private WebTriggerRegistrationRequest(Builder builder) {
        this.mWebTriggerParams = builder.mWebTriggerParams;
        this.mDestination = builder.mDestination;
    }

    private WebTriggerRegistrationRequest(Parcel in) {
        Objects.requireNonNull(in);
        ArrayList<WebTriggerParams> webTriggerParams = new ArrayList<WebTriggerParams>();
        if (_Original_Build.VERSION.SDK_INT < 33) {
            in.readList(webTriggerParams, WebTriggerParams.class.getClassLoader());
        } else {
            in.readList(webTriggerParams, WebTriggerParams.class.getClassLoader(), WebTriggerParams.class);
        }
        this.mWebTriggerParams = webTriggerParams;
        this.mDestination = Uri.CREATOR.createFromParcel(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebTriggerRegistrationRequest)) {
            return false;
        }
        WebTriggerRegistrationRequest that = (WebTriggerRegistrationRequest)o;
        return Objects.equals(this.mWebTriggerParams, that.mWebTriggerParams) && Objects.equals(this.mDestination, that.mDestination);
    }

    public int hashCode() {
        return Objects.hash(this.mWebTriggerParams, this.mDestination);
    }

    public List<WebTriggerParams> getTriggerParams() {
        return this.mWebTriggerParams;
    }

    public Uri getDestination() {
        return this.mDestination;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        Objects.requireNonNull(out);
        out.writeList(this.mWebTriggerParams);
        this.mDestination.writeToParcel(out, flags);
    }

    public static class Builder {
        private List<WebTriggerParams> mWebTriggerParams;
        private final Uri mDestination;

        public Builder(List<WebTriggerParams> webTriggerParams, Uri destination) {
            Objects.requireNonNull(webTriggerParams);
            if (webTriggerParams.isEmpty() || webTriggerParams.size() > 20) {
                throw new IllegalArgumentException("web trigger params size is not within bounds, size: " + webTriggerParams.size());
            }
            Objects.requireNonNull(destination);
            if (destination.getScheme() == null) {
                throw new IllegalArgumentException("Destination origin must have a scheme.");
            }
            this.mWebTriggerParams = webTriggerParams;
            this.mDestination = destination;
        }

        public WebTriggerRegistrationRequest build() {
            return new WebTriggerRegistrationRequest(this);
        }
    }
}

