/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.topics;

import android.adservices.common.AdServicesResponse;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GetTopicsResult
extends AdServicesResponse {
    private final List<Long> mTaxonomyVersions;
    private final List<Long> mModelVersions;
    private final List<Integer> mTopics;
    public static final Parcelable.Creator<GetTopicsResult> CREATOR = new Parcelable.Creator<GetTopicsResult>(){

        @Override
        public GetTopicsResult createFromParcel(Parcel in) {
            return new GetTopicsResult(in);
        }

        public GetTopicsResult[] newArray(int size) {
            return new GetTopicsResult[size];
        }
    };

    private GetTopicsResult(int resultCode, String errorMessage, List<Long> taxonomyVersions, List<Long> modelVersions, List<Integer> topics) {
        super(resultCode, errorMessage);
        this.mTaxonomyVersions = taxonomyVersions;
        this.mModelVersions = modelVersions;
        this.mTopics = topics;
    }

    private GetTopicsResult(Parcel in) {
        super(in.readInt(), in.readString());
        this.mTaxonomyVersions = Collections.unmodifiableList(GetTopicsResult.readLongList(in));
        this.mModelVersions = Collections.unmodifiableList(GetTopicsResult.readLongList(in));
        this.mTopics = Collections.unmodifiableList(GetTopicsResult.readIntegerList(in));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStatusCode);
        out.writeString(this.mErrorMessage);
        GetTopicsResult.writeLongList(out, this.mTaxonomyVersions);
        GetTopicsResult.writeLongList(out, this.mModelVersions);
        GetTopicsResult.writeIntegerList(out, this.mTopics);
    }

    @Override
    public boolean isSuccess() {
        return this.getResultCode() == 0;
    }

    public int getResultCode() {
        return this.mStatusCode;
    }

    @Override
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public List<Long> getTaxonomyVersions() {
        return this.mTaxonomyVersions;
    }

    public List<Long> getModelVersions() {
        return this.mModelVersions;
    }

    public List<Integer> getTopics() {
        return this.mTopics;
    }

    public String toString() {
        return "GetTopicsResult{mResultCode=" + this.mStatusCode + ", mErrorMessage='" + this.mErrorMessage + '\'' + ", mTaxonomyVersions=" + this.mTaxonomyVersions + ", mModelVersions=" + this.mModelVersions + ", mTopics=" + this.mTopics + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTopicsResult)) {
            return false;
        }
        GetTopicsResult that = (GetTopicsResult)o;
        return this.mStatusCode == that.mStatusCode && Objects.equals(this.mErrorMessage, that.mErrorMessage) && this.mTaxonomyVersions.equals(that.mTaxonomyVersions) && this.mModelVersions.equals(that.mModelVersions) && this.mTopics.equals(that.mTopics);
    }

    public int hashCode() {
        return Objects.hash(this.mStatusCode, this.mErrorMessage, this.mTaxonomyVersions, this.mModelVersions, this.mTopics);
    }

    private static List<Long> readLongList(Parcel in) {
        ArrayList<Long> list = new ArrayList<Long>();
        int toReadCount = in.readInt();
        for (int i = 0; i < toReadCount; ++i) {
            list.add(in.readLong());
        }
        return list;
    }

    private static List<Integer> readIntegerList(Parcel in) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int toReadCount = in.readInt();
        for (int i = 0; i < toReadCount; ++i) {
            list.add(in.readInt());
        }
        return list;
    }

    private static void writeLongList(Parcel out, List<Long> val) {
        if (val == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(val.size());
        for (Long l : val) {
            out.writeLong(l);
        }
    }

    private static void writeIntegerList(Parcel out, List<Integer> val) {
        if (val == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(val.size());
        for (Integer integer2 : val) {
            out.writeInt(integer2);
        }
    }

    public static class Builder {
        private int mResultCode;
        private String mErrorMessage;
        private List<Long> mTaxonomyVersions = new ArrayList<Long>();
        private List<Long> mModelVersions = new ArrayList<Long>();
        private List<Integer> mTopics = new ArrayList<Integer>();

        public Builder setResultCode(int resultCode) {
            this.mResultCode = resultCode;
            return this;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        public Builder setTaxonomyVersions(List<Long> taxonomyVersions) {
            this.mTaxonomyVersions = taxonomyVersions;
            return this;
        }

        public Builder setModelVersions(List<Long> modelVersions) {
            this.mModelVersions = modelVersions;
            return this;
        }

        public Builder setTopics(List<Integer> topics) {
            this.mTopics = topics;
            return this;
        }

        public GetTopicsResult build() {
            if (this.mTopics == null || this.mTaxonomyVersions == null || this.mModelVersions == null) {
                throw new IllegalArgumentException("Topics or TaxonomyVersion or ModelVersion is null");
            }
            if (this.mTopics.size() != this.mTaxonomyVersions.size() || this.mTopics.size() != this.mModelVersions.size()) {
                throw new IllegalArgumentException("Size mismatch in Topics");
            }
            return new GetTopicsResult(this.mResultCode, this.mErrorMessage, this.mTaxonomyVersions, this.mModelVersions, this.mTopics);
        }
    }
}

