/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.BidirectionalTypeConverter;
import android.animation.FloatArrayEvaluator;
import android.animation.FloatEvaluator;
import android.animation.IntArrayEvaluator;
import android.animation.IntEvaluator;
import android.animation.Keyframe;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.PathKeyframes;
import android.animation.TypeConverter;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.FloatProperty;
import android.util.IntProperty;
import android.util.Log;
import android.util.PathParser;
import android.util.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

public class PropertyValuesHolder
implements Cloneable {
    String mPropertyName;
    protected Property mProperty;
    Method mSetter = null;
    private Method mGetter = null;
    Class mValueType;
    Keyframes mKeyframes = null;
    private static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    private static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    private static Class[] FLOAT_VARIANTS = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
    private static Class[] INTEGER_VARIANTS = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
    private static Class[] DOUBLE_VARIANTS = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
    public static final HashMap<Class, HashMap<String, Method>> sSetterPropertyMap = new HashMap();
    public static final HashMap<Class, HashMap<String, Method>> sGetterPropertyMap = new HashMap();
    final Object[] mTmpValueArray = new Object[1];
    private TypeEvaluator mEvaluator;
    private Object mAnimatedValue;
    private TypeConverter mConverter;

    private PropertyValuesHolder(String propertyName) {
        this.mPropertyName = propertyName;
    }

    private PropertyValuesHolder(Property property) {
        this.mProperty = property;
        if (property != null) {
            this.mPropertyName = property.getName();
        }
    }

    public static PropertyValuesHolder ofInt(String propertyName, int ... values) {
        return new IntPropertyValuesHolder(propertyName, values);
    }

    public static PropertyValuesHolder ofInt(Property<?, Integer> property, int ... values) {
        return new IntPropertyValuesHolder(property, values);
    }

    public static PropertyValuesHolder ofMultiInt(String propertyName, int[][] values) {
        if (values.length < 2) {
            throw new IllegalArgumentException("At least 2 values must be supplied");
        }
        int numParameters = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("values must not be null");
            }
            int length = values[i].length;
            if (i == 0) {
                numParameters = length;
                continue;
            }
            if (length == numParameters) continue;
            throw new IllegalArgumentException("Values must all have the same length");
        }
        IntArrayEvaluator evaluator = new IntArrayEvaluator(new int[numParameters]);
        return new MultiIntValuesHolder(propertyName, null, (TypeEvaluator)evaluator, (Object[])values);
    }

    public static PropertyValuesHolder ofMultiInt(String propertyName, Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PointFToIntArray converter = new PointFToIntArray();
        return new MultiIntValuesHolder(propertyName, (TypeConverter)converter, null, keyframes);
    }

    @SafeVarargs
    public static <V> PropertyValuesHolder ofMultiInt(String propertyName, TypeConverter<V, int[]> converter, TypeEvaluator<V> evaluator, V ... values) {
        return new MultiIntValuesHolder(propertyName, converter, evaluator, values);
    }

    public static <T> PropertyValuesHolder ofMultiInt(String propertyName, TypeConverter<T, int[]> converter, TypeEvaluator<T> evaluator, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return new MultiIntValuesHolder(propertyName, converter, evaluator, keyframeSet);
    }

    public static PropertyValuesHolder ofFloat(String propertyName, float ... values) {
        return new FloatPropertyValuesHolder(propertyName, values);
    }

    public static PropertyValuesHolder ofFloat(Property<?, Float> property, float ... values) {
        return new FloatPropertyValuesHolder(property, values);
    }

    public static PropertyValuesHolder ofMultiFloat(String propertyName, float[][] values) {
        if (values.length < 2) {
            throw new IllegalArgumentException("At least 2 values must be supplied");
        }
        int numParameters = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("values must not be null");
            }
            int length = values[i].length;
            if (i == 0) {
                numParameters = length;
                continue;
            }
            if (length == numParameters) continue;
            throw new IllegalArgumentException("Values must all have the same length");
        }
        FloatArrayEvaluator evaluator = new FloatArrayEvaluator(new float[numParameters]);
        return new MultiFloatValuesHolder(propertyName, null, (TypeEvaluator)evaluator, (Object[])values);
    }

    public static PropertyValuesHolder ofMultiFloat(String propertyName, Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PointFToFloatArray converter = new PointFToFloatArray();
        return new MultiFloatValuesHolder(propertyName, (TypeConverter)converter, null, keyframes);
    }

    @SafeVarargs
    public static <V> PropertyValuesHolder ofMultiFloat(String propertyName, TypeConverter<V, float[]> converter, TypeEvaluator<V> evaluator, V ... values) {
        return new MultiFloatValuesHolder(propertyName, converter, evaluator, values);
    }

    public static <T> PropertyValuesHolder ofMultiFloat(String propertyName, TypeConverter<T, float[]> converter, TypeEvaluator<T> evaluator, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return new MultiFloatValuesHolder(propertyName, converter, evaluator, keyframeSet);
    }

    public static PropertyValuesHolder ofObject(String propertyName, TypeEvaluator evaluator, Object ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    public static PropertyValuesHolder ofObject(String propertyName, TypeConverter<PointF, ?> converter, Path path) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.mKeyframes = KeyframeSet.ofPath(path);
        pvh.mValueType = PointF.class;
        pvh.setConverter(converter);
        return pvh;
    }

    @SafeVarargs
    public static <V> PropertyValuesHolder ofObject(Property property, TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    @SafeVarargs
    public static <T, V> PropertyValuesHolder ofObject(Property<?, V> property, TypeConverter<T, V> converter, TypeEvaluator<T> evaluator, T ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setConverter(converter);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    public static <V> PropertyValuesHolder ofObject(Property<?, V> property, TypeConverter<PointF, V> converter, Path path) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.mKeyframes = KeyframeSet.ofPath(path);
        pvh.mValueType = PointF.class;
        pvh.setConverter(converter);
        return pvh;
    }

    public static PropertyValuesHolder ofKeyframe(String propertyName, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return PropertyValuesHolder.ofKeyframes(propertyName, (Keyframes)keyframeSet);
    }

    public static PropertyValuesHolder ofKeyframe(Property property, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return PropertyValuesHolder.ofKeyframes(property, (Keyframes)keyframeSet);
    }

    static PropertyValuesHolder ofKeyframes(String propertyName, Keyframes keyframes) {
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(propertyName, (Keyframes.IntKeyframes)keyframes);
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(propertyName, (Keyframes.FloatKeyframes)keyframes);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.mKeyframes = keyframes;
        pvh.mValueType = keyframes.getType();
        return pvh;
    }

    static PropertyValuesHolder ofKeyframes(Property property, Keyframes keyframes) {
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(property, (Keyframes.IntKeyframes)keyframes);
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(property, (Keyframes.FloatKeyframes)keyframes);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.mKeyframes = keyframes;
        pvh.mValueType = keyframes.getType();
        return pvh;
    }

    public void setIntValues(int ... values) {
        this.mValueType = Integer.TYPE;
        this.mKeyframes = KeyframeSet.ofInt(values);
    }

    public void setFloatValues(float ... values) {
        this.mValueType = Float.TYPE;
        this.mKeyframes = KeyframeSet.ofFloat(values);
    }

    public void setKeyframes(Keyframe ... values) {
        int numKeyframes = values.length;
        Keyframe[] keyframes = new Keyframe[Math.max(numKeyframes, 2)];
        this.mValueType = values[0].getType();
        for (int i = 0; i < numKeyframes; ++i) {
            keyframes[i] = values[i];
        }
        this.mKeyframes = new KeyframeSet(keyframes);
    }

    public void setObjectValues(Object ... values) {
        this.mValueType = values[0].getClass();
        this.mKeyframes = KeyframeSet.ofObject(values);
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    public void setConverter(TypeConverter converter) {
        this.mConverter = converter;
    }

    private Method getPropertyFunction(Class targetClass, String prefix, Class valueType) {
        Method returnVal = null;
        String methodName = PropertyValuesHolder.getMethodName(prefix, this.mPropertyName);
        Class[] args = null;
        if (valueType == null) {
            try {
                returnVal = targetClass.getMethod(methodName, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else {
            args = new Class[1];
            Class[] typeVariants = valueType.equals(Float.class) ? FLOAT_VARIANTS : (valueType.equals(Integer.class) ? INTEGER_VARIANTS : (valueType.equals(Double.class) ? DOUBLE_VARIANTS : new Class[]{valueType}));
            Class[] classArray = typeVariants;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class typeVariant;
                args[0] = typeVariant = classArray[i];
                try {
                    returnVal = targetClass.getMethod(methodName, args);
                    if (this.mConverter == null) {
                        this.mValueType = typeVariant;
                    }
                    return returnVal;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        if (returnVal == null) {
            Log.w("PropertyValuesHolder", "Method " + PropertyValuesHolder.getMethodName(prefix, this.mPropertyName) + "() with type " + valueType + " not found on target class " + targetClass);
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method setupSetterOrGetter(Class targetClass, HashMap<Class, HashMap<String, Method>> propertyMapMap, String prefix, Class valueType) {
        Method setterOrGetter = null;
        HashMap<Class, HashMap<String, Method>> hashMap = propertyMapMap;
        synchronized (hashMap) {
            HashMap<String, Method> propertyMap = propertyMapMap.get(targetClass);
            boolean wasInMap = false;
            if (propertyMap != null && (wasInMap = propertyMap.containsKey(this.mPropertyName))) {
                setterOrGetter = propertyMap.get(this.mPropertyName);
            }
            if (!wasInMap) {
                setterOrGetter = this.getPropertyFunction(targetClass, prefix, valueType);
                if (propertyMap == null) {
                    propertyMap = new HashMap();
                    propertyMapMap.put(targetClass, propertyMap);
                }
                propertyMap.put(this.mPropertyName, setterOrGetter);
            }
        }
        return setterOrGetter;
    }

    void setupSetter(Class targetClass) {
        Class propertyType = this.mConverter == null ? this.mValueType : this.mConverter.getTargetType();
        this.mSetter = this.setupSetterOrGetter(targetClass, sSetterPropertyMap, "set", propertyType);
    }

    private void setupGetter(Class targetClass) {
        this.mGetter = this.setupSetterOrGetter(targetClass, sGetterPropertyMap, "get", null);
    }

    void setupSetterAndGetter(Object target) {
        if (this.mProperty != null) {
            try {
                Object testValue = null;
                List<Keyframe> keyframes = this.mKeyframes.getKeyframes();
                int keyframeCount = keyframes == null ? 0 : keyframes.size();
                for (int i = 0; i < keyframeCount; ++i) {
                    Keyframe kf = keyframes.get(i);
                    if (kf.hasValue() && !kf.valueWasSetOnStart()) continue;
                    if (testValue == null) {
                        testValue = this.convertBack(this.mProperty.get(target));
                    }
                    kf.setValue(testValue);
                    kf.setValueWasSetOnStart(true);
                }
                return;
            }
            catch (ClassCastException e) {
                Log.w("PropertyValuesHolder", "No such property (" + this.mProperty.getName() + ") on target object " + target + ". Trying reflection instead");
                this.mProperty = null;
            }
        }
        if (this.mProperty == null) {
            List<Keyframe> keyframes;
            Class<?> targetClass = target.getClass();
            if (this.mSetter == null) {
                this.setupSetter(targetClass);
            }
            int keyframeCount = (keyframes = this.mKeyframes.getKeyframes()) == null ? 0 : keyframes.size();
            for (int i = 0; i < keyframeCount; ++i) {
                Keyframe kf = keyframes.get(i);
                if (kf.hasValue() && !kf.valueWasSetOnStart()) continue;
                if (this.mGetter == null) {
                    this.setupGetter(targetClass);
                    if (this.mGetter == null) {
                        return;
                    }
                }
                try {
                    Object value = this.convertBack(this.mGetter.invoke(target, new Object[0]));
                    kf.setValue(value);
                    kf.setValueWasSetOnStart(true);
                    continue;
                }
                catch (InvocationTargetException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                    continue;
                }
                catch (IllegalAccessException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
            }
        }
    }

    private Object convertBack(Object value) {
        if (this.mConverter != null) {
            if (!(this.mConverter instanceof BidirectionalTypeConverter)) {
                throw new IllegalArgumentException("Converter " + this.mConverter.getClass().getName() + " must be a BidirectionalTypeConverter");
            }
            value = ((BidirectionalTypeConverter)this.mConverter).convertBack(value);
        }
        return value;
    }

    private void setupValue(Object target, Keyframe kf) {
        if (this.mProperty != null) {
            Object value = this.convertBack(this.mProperty.get(target));
            kf.setValue(value);
        } else {
            try {
                if (this.mGetter == null) {
                    Class<?> targetClass = target.getClass();
                    this.setupGetter(targetClass);
                    if (this.mGetter == null) {
                        return;
                    }
                }
                Object value = this.convertBack(this.mGetter.invoke(target, new Object[0]));
                kf.setValue(value);
            }
            catch (InvocationTargetException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
        }
    }

    void setupStartValue(Object target) {
        List<Keyframe> keyframes = this.mKeyframes.getKeyframes();
        if (!keyframes.isEmpty()) {
            this.setupValue(target, keyframes.get(0));
        }
    }

    void setupEndValue(Object target) {
        List<Keyframe> keyframes = this.mKeyframes.getKeyframes();
        if (!keyframes.isEmpty()) {
            this.setupValue(target, keyframes.get(keyframes.size() - 1));
        }
    }

    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder newPVH = (PropertyValuesHolder)super.clone();
            newPVH.mPropertyName = this.mPropertyName;
            newPVH.mProperty = this.mProperty;
            newPVH.mKeyframes = this.mKeyframes.clone();
            newPVH.mEvaluator = this.mEvaluator;
            return newPVH;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    void setAnimatedValue(Object target) {
        if (this.mProperty != null) {
            this.mProperty.set(target, this.getAnimatedValue());
        }
        if (this.mSetter != null) {
            try {
                this.mTmpValueArray[0] = this.getAnimatedValue();
                this.mSetter.invoke(target, this.mTmpValueArray);
            }
            catch (InvocationTargetException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
        }
    }

    void init() {
        if (this.mEvaluator == null) {
            TypeEvaluator typeEvaluator = this.mValueType == Integer.class ? sIntEvaluator : (this.mEvaluator = this.mValueType == Float.class ? sFloatEvaluator : null);
        }
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    public void setEvaluator(TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
        this.mKeyframes.setEvaluator(evaluator);
    }

    void calculateValue(float fraction2) {
        Object value = this.mKeyframes.getValue(fraction2);
        this.mAnimatedValue = this.mConverter == null ? value : this.mConverter.convert(value);
    }

    public void setPropertyName(String propertyName) {
        this.mPropertyName = propertyName;
    }

    public void setProperty(Property property) {
        this.mProperty = property;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    public void getPropertyValues(PropertyValues values) {
        this.init();
        values.propertyName = this.mPropertyName;
        values.type = this.mValueType;
        values.startValue = this.mKeyframes.getValue(0.0f);
        if (values.startValue instanceof PathParser.PathData) {
            values.startValue = new PathParser.PathData((PathParser.PathData)values.startValue);
        }
        values.endValue = this.mKeyframes.getValue(1.0f);
        if (values.endValue instanceof PathParser.PathData) {
            values.endValue = new PathParser.PathData((PathParser.PathData)values.endValue);
        }
        values.dataSource = this.mKeyframes instanceof PathKeyframes.FloatKeyframesBase || this.mKeyframes instanceof PathKeyframes.IntKeyframesBase || this.mKeyframes.getKeyframes() != null && this.mKeyframes.getKeyframes().size() > 2 ? new PropertyValues.DataSource(){

            @Override
            public Object getValueAtFraction(float fraction2) {
                return PropertyValuesHolder.this.mKeyframes.getValue(fraction2);
            }
        } : null;
    }

    public Class getValueType() {
        return this.mValueType;
    }

    public String toString() {
        return this.mPropertyName + ": " + this.mKeyframes.toString();
    }

    static String getMethodName(String prefix, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String theRest = propertyName.substring(1);
        return prefix + firstLetter + theRest;
    }

    private static native long nGetIntMethod(Class var0, String var1);

    private static native long nGetFloatMethod(Class var0, String var1);

    private static native long nGetMultipleIntMethod(Class var0, String var1, int var2);

    private static native long nGetMultipleFloatMethod(Class var0, String var1, int var2);

    private static native void nCallIntMethod(Object var0, long var1, int var3);

    private static native void nCallFloatMethod(Object var0, long var1, float var3);

    private static native void nCallTwoIntMethod(Object var0, long var1, int var3, int var4);

    private static native void nCallFourIntMethod(Object var0, long var1, int var3, int var4, int var5, int var6);

    private static native void nCallMultipleIntMethod(Object var0, long var1, int[] var3);

    private static native void nCallTwoFloatMethod(Object var0, long var1, float var3, float var4);

    private static native void nCallFourFloatMethod(Object var0, long var1, float var3, float var4, float var5, float var6);

    private static native void nCallMultipleFloatMethod(Object var0, long var1, float[] var3);

    static class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        public static final HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap = new HashMap();
        long mJniSetter;
        private IntProperty mIntProperty;
        Keyframes.IntKeyframes mIntKeyframes;
        int mIntAnimatedValue;

        public IntPropertyValuesHolder(String propertyName, Keyframes.IntKeyframes keyframes) {
            super(propertyName);
            this.mValueType = Integer.TYPE;
            this.mKeyframes = keyframes;
            this.mIntKeyframes = keyframes;
        }

        public IntPropertyValuesHolder(Property property, Keyframes.IntKeyframes keyframes) {
            super(property);
            this.mValueType = Integer.TYPE;
            this.mKeyframes = keyframes;
            this.mIntKeyframes = keyframes;
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        public IntPropertyValuesHolder(String propertyName, int ... values) {
            super(propertyName);
            this.setIntValues(values);
        }

        public IntPropertyValuesHolder(Property property, int ... values) {
            super(property);
            this.setIntValues(values);
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        @Override
        public void setProperty(Property property) {
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)property;
            } else {
                super.setProperty(property);
            }
        }

        @Override
        public void setIntValues(int ... values) {
            super.setIntValues(values);
            this.mIntKeyframes = (Keyframes.IntKeyframes)this.mKeyframes;
        }

        @Override
        void calculateValue(float fraction2) {
            this.mIntAnimatedValue = this.mIntKeyframes.getIntValue(fraction2);
        }

        @Override
        Object getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        @Override
        public IntPropertyValuesHolder clone() {
            IntPropertyValuesHolder newPVH = (IntPropertyValuesHolder)super.clone();
            newPVH.mIntKeyframes = (Keyframes.IntKeyframes)newPVH.mKeyframes;
            return newPVH;
        }

        @Override
        void setAnimatedValue(Object target) {
            if (this.mIntProperty != null) {
                this.mIntProperty.setValue(target, this.mIntAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(target, this.mIntAnimatedValue);
                return;
            }
            if (this.mJniSetter != 0L) {
                PropertyValuesHolder.nCallIntMethod(target, this.mJniSetter, this.mIntAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = this.mIntAnimatedValue;
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setupSetter(Class targetClass) {
            if (this.mProperty != null) {
                return;
            }
            HashMap<Class, HashMap<String, Long>> hashMap = sJNISetterPropertyMap;
            synchronized (hashMap) {
                Long jniSetter;
                HashMap<String, Long> propertyMap = sJNISetterPropertyMap.get(targetClass);
                boolean wasInMap = false;
                if (propertyMap != null && (wasInMap = propertyMap.containsKey(this.mPropertyName)) && (jniSetter = propertyMap.get(this.mPropertyName)) != null) {
                    this.mJniSetter = jniSetter;
                }
                if (!wasInMap) {
                    String methodName = IntPropertyValuesHolder.getMethodName("set", this.mPropertyName);
                    try {
                        this.mJniSetter = PropertyValuesHolder.nGetIntMethod(targetClass, methodName);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    if (propertyMap == null) {
                        propertyMap = new HashMap();
                        sJNISetterPropertyMap.put(targetClass, propertyMap);
                    }
                    propertyMap.put(this.mPropertyName, this.mJniSetter);
                }
            }
            if (this.mJniSetter == 0L) {
                super.setupSetter(targetClass);
            }
        }
    }

    static class MultiIntValuesHolder
    extends PropertyValuesHolder {
        private long mJniSetter;
        public static final HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap = new HashMap();

        public MultiIntValuesHolder(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Object ... values) {
            super(propertyName);
            this.setConverter(converter);
            this.setObjectValues(values);
            this.setEvaluator(evaluator);
        }

        public MultiIntValuesHolder(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Keyframes keyframes) {
            super(propertyName);
            this.setConverter(converter);
            this.mKeyframes = keyframes;
            this.setEvaluator(evaluator);
        }

        @Override
        void setAnimatedValue(Object target) {
            int[] values = (int[])this.getAnimatedValue();
            int numParameters = values.length;
            if (this.mJniSetter != 0L) {
                switch (numParameters) {
                    case 1: {
                        PropertyValuesHolder.nCallIntMethod(target, this.mJniSetter, values[0]);
                        break;
                    }
                    case 2: {
                        PropertyValuesHolder.nCallTwoIntMethod(target, this.mJniSetter, values[0], values[1]);
                        break;
                    }
                    case 4: {
                        PropertyValuesHolder.nCallFourIntMethod(target, this.mJniSetter, values[0], values[1], values[2], values[3]);
                        break;
                    }
                    default: {
                        PropertyValuesHolder.nCallMultipleIntMethod(target, this.mJniSetter, values);
                    }
                }
            }
        }

        @Override
        void setupSetterAndGetter(Object target) {
            this.setupSetter(target.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setupSetter(Class targetClass) {
            if (this.mJniSetter != 0L) {
                return;
            }
            HashMap<Class, HashMap<String, Long>> hashMap = sJNISetterPropertyMap;
            synchronized (hashMap) {
                Long jniSetter;
                HashMap<String, Long> propertyMap = sJNISetterPropertyMap.get(targetClass);
                boolean wasInMap = false;
                if (propertyMap != null && (wasInMap = propertyMap.containsKey(this.mPropertyName)) && (jniSetter = propertyMap.get(this.mPropertyName)) != null) {
                    this.mJniSetter = jniSetter;
                }
                if (!wasInMap) {
                    String methodName = MultiIntValuesHolder.getMethodName("set", this.mPropertyName);
                    this.calculateValue(0.0f);
                    int[] values = (int[])this.getAnimatedValue();
                    int numParams = values.length;
                    try {
                        this.mJniSetter = PropertyValuesHolder.nGetMultipleIntMethod(targetClass, methodName, numParams);
                    }
                    catch (NoSuchMethodError e) {
                        try {
                            this.mJniSetter = PropertyValuesHolder.nGetMultipleIntMethod(targetClass, this.mPropertyName, numParams);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                    }
                    if (propertyMap == null) {
                        propertyMap = new HashMap();
                        sJNISetterPropertyMap.put(targetClass, propertyMap);
                    }
                    propertyMap.put(this.mPropertyName, this.mJniSetter);
                }
            }
        }
    }

    private static class PointFToIntArray
    extends TypeConverter<PointF, int[]> {
        private int[] mCoordinates = new int[2];

        public PointFToIntArray() {
            super(PointF.class, int[].class);
        }

        @Override
        public int[] convert(PointF value) {
            this.mCoordinates[0] = Math.round(value.x);
            this.mCoordinates[1] = Math.round(value.y);
            return this.mCoordinates;
        }
    }

    static class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        public static final HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap = new HashMap();
        long mJniSetter;
        private FloatProperty mFloatProperty;
        Keyframes.FloatKeyframes mFloatKeyframes;
        float mFloatAnimatedValue;

        public FloatPropertyValuesHolder(String propertyName, Keyframes.FloatKeyframes keyframes) {
            super(propertyName);
            this.mValueType = Float.TYPE;
            this.mKeyframes = keyframes;
            this.mFloatKeyframes = keyframes;
        }

        public FloatPropertyValuesHolder(Property property, Keyframes.FloatKeyframes keyframes) {
            super(property);
            this.mValueType = Float.TYPE;
            this.mKeyframes = keyframes;
            this.mFloatKeyframes = keyframes;
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        public FloatPropertyValuesHolder(String propertyName, float ... values) {
            super(propertyName);
            this.setFloatValues(values);
        }

        public FloatPropertyValuesHolder(Property property, float ... values) {
            super(property);
            this.setFloatValues(values);
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        @Override
        public void setProperty(Property property) {
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)property;
            } else {
                super.setProperty(property);
            }
        }

        @Override
        public void setFloatValues(float ... values) {
            super.setFloatValues(values);
            this.mFloatKeyframes = (Keyframes.FloatKeyframes)this.mKeyframes;
        }

        @Override
        void calculateValue(float fraction2) {
            this.mFloatAnimatedValue = this.mFloatKeyframes.getFloatValue(fraction2);
        }

        @Override
        Object getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        @Override
        public FloatPropertyValuesHolder clone() {
            FloatPropertyValuesHolder newPVH = (FloatPropertyValuesHolder)super.clone();
            newPVH.mFloatKeyframes = (Keyframes.FloatKeyframes)newPVH.mKeyframes;
            return newPVH;
        }

        @Override
        void setAnimatedValue(Object target) {
            if (this.mFloatProperty != null) {
                this.mFloatProperty.setValue(target, this.mFloatAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(target, Float.valueOf(this.mFloatAnimatedValue));
                return;
            }
            if (this.mJniSetter != 0L) {
                PropertyValuesHolder.nCallFloatMethod(target, this.mJniSetter, this.mFloatAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setupSetter(Class targetClass) {
            if (this.mProperty != null) {
                return;
            }
            HashMap<Class, HashMap<String, Long>> hashMap = sJNISetterPropertyMap;
            synchronized (hashMap) {
                Long jniSetter;
                HashMap<String, Long> propertyMap = sJNISetterPropertyMap.get(targetClass);
                boolean wasInMap = false;
                if (propertyMap != null && (wasInMap = propertyMap.containsKey(this.mPropertyName)) && (jniSetter = propertyMap.get(this.mPropertyName)) != null) {
                    this.mJniSetter = jniSetter;
                }
                if (!wasInMap) {
                    String methodName = FloatPropertyValuesHolder.getMethodName("set", this.mPropertyName);
                    try {
                        this.mJniSetter = PropertyValuesHolder.nGetFloatMethod(targetClass, methodName);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    if (propertyMap == null) {
                        propertyMap = new HashMap();
                        sJNISetterPropertyMap.put(targetClass, propertyMap);
                    }
                    propertyMap.put(this.mPropertyName, this.mJniSetter);
                }
            }
            if (this.mJniSetter == 0L) {
                super.setupSetter(targetClass);
            }
        }
    }

    static class MultiFloatValuesHolder
    extends PropertyValuesHolder {
        private long mJniSetter;
        public static final HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap = new HashMap();

        public MultiFloatValuesHolder(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Object ... values) {
            super(propertyName);
            this.setConverter(converter);
            this.setObjectValues(values);
            this.setEvaluator(evaluator);
        }

        public MultiFloatValuesHolder(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Keyframes keyframes) {
            super(propertyName);
            this.setConverter(converter);
            this.mKeyframes = keyframes;
            this.setEvaluator(evaluator);
        }

        @Override
        void setAnimatedValue(Object target) {
            float[] values = (float[])this.getAnimatedValue();
            int numParameters = values.length;
            if (this.mJniSetter != 0L) {
                switch (numParameters) {
                    case 1: {
                        PropertyValuesHolder.nCallFloatMethod(target, this.mJniSetter, values[0]);
                        break;
                    }
                    case 2: {
                        PropertyValuesHolder.nCallTwoFloatMethod(target, this.mJniSetter, values[0], values[1]);
                        break;
                    }
                    case 4: {
                        PropertyValuesHolder.nCallFourFloatMethod(target, this.mJniSetter, values[0], values[1], values[2], values[3]);
                        break;
                    }
                    default: {
                        PropertyValuesHolder.nCallMultipleFloatMethod(target, this.mJniSetter, values);
                    }
                }
            }
        }

        @Override
        void setupSetterAndGetter(Object target) {
            this.setupSetter(target.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setupSetter(Class targetClass) {
            if (this.mJniSetter != 0L) {
                return;
            }
            HashMap<Class, HashMap<String, Long>> hashMap = sJNISetterPropertyMap;
            synchronized (hashMap) {
                Long jniSetter;
                HashMap<String, Long> propertyMap = sJNISetterPropertyMap.get(targetClass);
                boolean wasInMap = false;
                if (propertyMap != null && (wasInMap = propertyMap.containsKey(this.mPropertyName)) && (jniSetter = propertyMap.get(this.mPropertyName)) != null) {
                    this.mJniSetter = jniSetter;
                }
                if (!wasInMap) {
                    String methodName = MultiFloatValuesHolder.getMethodName("set", this.mPropertyName);
                    this.calculateValue(0.0f);
                    float[] values = (float[])this.getAnimatedValue();
                    int numParams = values.length;
                    try {
                        this.mJniSetter = PropertyValuesHolder.nGetMultipleFloatMethod(targetClass, methodName, numParams);
                    }
                    catch (NoSuchMethodError e) {
                        try {
                            this.mJniSetter = PropertyValuesHolder.nGetMultipleFloatMethod(targetClass, this.mPropertyName, numParams);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                    }
                    if (propertyMap == null) {
                        propertyMap = new HashMap();
                        sJNISetterPropertyMap.put(targetClass, propertyMap);
                    }
                    propertyMap.put(this.mPropertyName, this.mJniSetter);
                }
            }
        }
    }

    private static class PointFToFloatArray
    extends TypeConverter<PointF, float[]> {
        private float[] mCoordinates = new float[2];

        public PointFToFloatArray() {
            super(PointF.class, float[].class);
        }

        @Override
        public float[] convert(PointF value) {
            this.mCoordinates[0] = value.x;
            this.mCoordinates[1] = value.y;
            return this.mCoordinates;
        }
    }

    public static class PropertyValues {
        public String propertyName;
        public Class type;
        public Object startValue;
        public Object endValue;
        public DataSource dataSource = null;

        public String toString() {
            return "property name: " + this.propertyName + ", type: " + this.type + ", startValue: " + this.startValue.toString() + ", endValue: " + this.endValue.toString();
        }

        public static interface DataSource {
            public Object getValueAtFraction(float var1);
        }
    }
}

