/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityOptions;
import android.app.EnterTransitionCoordinator;
import android.app.ExitTransitionCoordinator;
import android.content.Intent;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.transition.Transition;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.android.internal.view.OneShotPreDrawListener;
import com.android.tools.layoutlib.java.Reference_Delegate;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class ActivityTransitionState {
    private static final String PENDING_EXIT_SHARED_ELEMENTS = "android:pendingExitSharedElements";
    private static final String EXITING_MAPPED_FROM = "android:exitingMappedFrom";
    private static final String EXITING_MAPPED_TO = "android:exitingMappedTo";
    private ArrayList<String> mPendingExitNames;
    private ArrayList<String> mExitingFrom;
    private ArrayList<String> mExitingTo;
    private ArrayList<View> mExitingToView;
    private ExitTransitionCoordinator mCalledExitCoordinator;
    private ExitTransitionCoordinator mReturnExitCoordinator;
    private EnterTransitionCoordinator mEnterTransitionCoordinator;
    private ActivityOptions mEnterActivityOptions;
    private boolean mHasExited;
    private boolean mIsEnterPostponed;
    private SparseArray<WeakReference<ExitTransitionCoordinator>> mExitTransitionCoordinators;
    private int mExitTransitionCoordinatorsKey = 1;
    private boolean mIsEnterTriggered;

    public int addExitTransitionCoordinator(ExitTransitionCoordinator exitTransitionCoordinator) {
        if (this.mExitTransitionCoordinators == null) {
            this.mExitTransitionCoordinators = new SparseArray();
        }
        WeakReference<ExitTransitionCoordinator> ref = new WeakReference<ExitTransitionCoordinator>(exitTransitionCoordinator);
        for (int i = this.mExitTransitionCoordinators.size() - 1; i >= 0; --i) {
            WeakReference<ExitTransitionCoordinator> oldRef = this.mExitTransitionCoordinators.valueAt(i);
            if (!Reference_Delegate.refersTo(oldRef, null)) continue;
            this.mExitTransitionCoordinators.removeAt(i);
        }
        int newKey = this.mExitTransitionCoordinatorsKey++;
        this.mExitTransitionCoordinators.append(newKey, ref);
        return newKey;
    }

    public void readState(Bundle bundle) {
        if (bundle != null) {
            if (this.mEnterTransitionCoordinator == null || this.mEnterTransitionCoordinator.isReturning()) {
                this.mPendingExitNames = bundle.getStringArrayList(PENDING_EXIT_SHARED_ELEMENTS);
            }
            if (this.mEnterTransitionCoordinator == null) {
                this.mExitingFrom = bundle.getStringArrayList(EXITING_MAPPED_FROM);
                this.mExitingTo = bundle.getStringArrayList(EXITING_MAPPED_TO);
            }
        }
    }

    private ArrayList<String> getPendingExitNames() {
        if (this.mPendingExitNames == null && this.mEnterTransitionCoordinator != null && !this.mEnterTransitionCoordinator.isReturning()) {
            this.mPendingExitNames = this.mEnterTransitionCoordinator.getPendingExitSharedElementNames();
        }
        return this.mPendingExitNames;
    }

    public void saveState(Bundle bundle) {
        ArrayList<String> pendingExitNames = this.getPendingExitNames();
        if (pendingExitNames != null) {
            bundle.putStringArrayList(PENDING_EXIT_SHARED_ELEMENTS, pendingExitNames);
        }
        if (this.mExitingFrom != null) {
            bundle.putStringArrayList(EXITING_MAPPED_FROM, this.mExitingFrom);
            bundle.putStringArrayList(EXITING_MAPPED_TO, this.mExitingTo);
        }
    }

    public void setEnterActivityOptions(Activity activity, ActivityOptions options) {
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        window.getDecorView();
        if (window.hasFeature(13) && options != null && this.mEnterActivityOptions == null && this.mEnterTransitionCoordinator == null && options.getAnimationType() == 5) {
            this.mEnterActivityOptions = options;
            this.mIsEnterTriggered = false;
            if (this.mEnterActivityOptions.isReturning()) {
                this.restoreExitedViews();
                int result = this.mEnterActivityOptions.getResultCode();
                if (result != 0) {
                    Intent intent = this.mEnterActivityOptions.getResultData();
                    if (intent != null) {
                        intent.setExtrasClassLoader(activity.getClassLoader());
                    }
                    activity.onActivityReenter(result, intent);
                }
            }
        }
    }

    public void enterReady(Activity activity) {
        if (this.mEnterActivityOptions == null || this.mIsEnterTriggered) {
            return;
        }
        this.mIsEnterTriggered = true;
        this.mHasExited = false;
        ArrayList<String> sharedElementNames = this.mEnterActivityOptions.getSharedElementNames();
        ResultReceiver resultReceiver = this.mEnterActivityOptions.getResultReceiver();
        boolean isReturning = this.mEnterActivityOptions.isReturning();
        if (isReturning) {
            this.restoreExitedViews();
            activity.getWindow().getDecorView().setVisibility(0);
        }
        this.getPendingExitNames();
        this.mEnterTransitionCoordinator = new EnterTransitionCoordinator(activity, resultReceiver, sharedElementNames, this.mEnterActivityOptions.isReturning(), this.mEnterActivityOptions.isCrossTask());
        if (this.mEnterActivityOptions.isCrossTask()) {
            this.mExitingFrom = new ArrayList<String>(this.mEnterActivityOptions.getSharedElementNames());
            this.mExitingTo = new ArrayList<String>(this.mEnterActivityOptions.getSharedElementNames());
        }
        if (!this.mIsEnterPostponed) {
            this.startEnter();
        }
    }

    public void postponeEnterTransition() {
        this.mIsEnterPostponed = true;
    }

    public void startPostponedEnterTransition() {
        if (this.mIsEnterPostponed) {
            this.mIsEnterPostponed = false;
            if (this.mEnterTransitionCoordinator != null) {
                this.startEnter();
            }
        }
    }

    private void startEnter() {
        if (this.mEnterTransitionCoordinator.isReturning()) {
            if (this.mExitingToView != null) {
                this.mEnterTransitionCoordinator.viewInstancesReady(this.mExitingFrom, this.mExitingTo, this.mExitingToView);
            } else {
                this.mEnterTransitionCoordinator.namedViewsReady(this.mExitingFrom, this.mExitingTo);
            }
        } else {
            this.mEnterTransitionCoordinator.namedViewsReady(null, null);
            this.mPendingExitNames = null;
        }
        this.mExitingFrom = null;
        this.mExitingTo = null;
        this.mExitingToView = null;
        this.mEnterActivityOptions = null;
    }

    public void onStop(Activity activity) {
        this.restoreExitedViews();
        if (this.mEnterTransitionCoordinator != null) {
            this.getPendingExitNames();
            this.mEnterTransitionCoordinator.stop();
            this.mEnterTransitionCoordinator = null;
        }
        if (this.mReturnExitCoordinator != null) {
            this.mReturnExitCoordinator.stop(activity);
            this.mReturnExitCoordinator = null;
        }
    }

    public void onResume(Activity activity) {
        if (this.mEnterTransitionCoordinator == null || activity.isTopOfTask()) {
            this.restoreExitedViews();
            this.restoreReenteringViews();
        } else {
            activity.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ActivityTransitionState.this.mEnterTransitionCoordinator == null || ActivityTransitionState.this.mEnterTransitionCoordinator.isWaitingForRemoteExit()) {
                        ActivityTransitionState.this.restoreExitedViews();
                        ActivityTransitionState.this.restoreReenteringViews();
                    } else if (ActivityTransitionState.this.mEnterTransitionCoordinator.isReturning()) {
                        ActivityTransitionState.this.mEnterTransitionCoordinator.runAfterTransitionsComplete(() -> {
                            ActivityTransitionState.this.getPendingExitNames();
                            ActivityTransitionState.this.mEnterTransitionCoordinator = null;
                        });
                    }
                }
            }, 1000L);
        }
    }

    public void clear() {
        this.mPendingExitNames = null;
        this.mExitingFrom = null;
        this.mExitingTo = null;
        this.mExitingToView = null;
        this.mCalledExitCoordinator = null;
        this.mEnterTransitionCoordinator = null;
        this.mEnterActivityOptions = null;
        this.mExitTransitionCoordinators = null;
    }

    private void restoreExitedViews() {
        if (this.mCalledExitCoordinator != null) {
            this.mCalledExitCoordinator.resetViews();
            this.mCalledExitCoordinator = null;
        }
    }

    private void restoreReenteringViews() {
        if (this.mEnterTransitionCoordinator != null && this.mEnterTransitionCoordinator.isReturning() && !this.mEnterTransitionCoordinator.isCrossTask()) {
            this.mEnterTransitionCoordinator.forceViewsToAppear();
            this.mExitingFrom = null;
            this.mExitingTo = null;
            this.mExitingToView = null;
        }
    }

    public boolean startExitBackTransition(Activity activity) {
        ArrayList<String> pendingExitNames = this.getPendingExitNames();
        if (pendingExitNames == null || this.mCalledExitCoordinator != null) {
            return false;
        }
        if (!this.mHasExited) {
            this.mHasExited = true;
            Transition enterViewsTransition = null;
            ViewGroup decor = null;
            boolean delayExitBack = false;
            if (this.mEnterTransitionCoordinator != null) {
                enterViewsTransition = this.mEnterTransitionCoordinator.getEnterViewsTransition();
                decor = this.mEnterTransitionCoordinator.getDecor();
                delayExitBack = this.mEnterTransitionCoordinator.cancelEnter();
                this.mEnterTransitionCoordinator = null;
                if (enterViewsTransition != null && decor != null) {
                    enterViewsTransition.pause(decor);
                }
            }
            this.mReturnExitCoordinator = new ExitTransitionCoordinator(new ExitTransitionCoordinator.ActivityExitTransitionCallbacks(activity), activity.getWindow(), activity.mEnterTransitionListener, pendingExitNames, null, null, true);
            if (enterViewsTransition != null && decor != null) {
                enterViewsTransition.resume(decor);
            }
            if (delayExitBack && decor != null) {
                ViewGroup finalDecor = decor;
                OneShotPreDrawListener.add(decor, () -> {
                    if (this.mReturnExitCoordinator != null) {
                        this.mReturnExitCoordinator.startExit(activity);
                    }
                });
            } else {
                this.mReturnExitCoordinator.startExit(activity);
            }
        }
        return true;
    }

    public boolean isTransitionRunning() {
        if (this.mEnterTransitionCoordinator != null && this.mEnterTransitionCoordinator.isTransitionRunning()) {
            return true;
        }
        if (this.mCalledExitCoordinator != null && this.mCalledExitCoordinator.isTransitionRunning()) {
            return true;
        }
        return this.mReturnExitCoordinator != null && this.mReturnExitCoordinator.isTransitionRunning();
    }

    public void startExitOutTransition(Activity activity, Bundle options) {
        int key;
        int index;
        this.getPendingExitNames();
        this.mEnterTransitionCoordinator = null;
        if (!activity.getWindow().hasFeature(13) || this.mExitTransitionCoordinators == null) {
            return;
        }
        ActivityOptions activityOptions = new ActivityOptions(options);
        if (activityOptions.getAnimationType() == 5 && (index = this.mExitTransitionCoordinators.indexOfKey(key = activityOptions.getExitCoordinatorKey())) >= 0) {
            this.mCalledExitCoordinator = (ExitTransitionCoordinator)this.mExitTransitionCoordinators.valueAt(index).get();
            this.mExitTransitionCoordinators.removeAt(index);
            if (this.mCalledExitCoordinator != null) {
                this.mExitingFrom = this.mCalledExitCoordinator.getAcceptedNames();
                this.mExitingTo = this.mCalledExitCoordinator.getMappedNames();
                this.mExitingToView = this.mCalledExitCoordinator.copyMappedViews();
                this.mCalledExitCoordinator.startExit();
            }
        }
    }
}

