/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppOpInfo;
import android.app.Application;
import android.app.AsyncNotedAppOp;
import android.app.PendingIntent;
import android.app.RuntimeAppOpAccessMessage;
import android.app.SyncNotedAppOp;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.database.DatabaseUtils;
import android.health.connect.HealthConnectManager;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.PackageTagsList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os._Original_Build;
import android.provider.DeviceConfig;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.LongSparseArray;
import android.util.LongSparseLongArray;
import android.util.Pools;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.Immutable;
import com.android.internal.app.IAppOpsActiveCallback;
import com.android.internal.app.IAppOpsAsyncNotedCallback;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsNotedCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IAppOpsStartedCallback;
import com.android.internal.app.MessageSamplingConfig;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.ZygoteInit;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Parcelling;
import com.android.internal.util.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AppOpsManager {
    public static final long CALL_BACK_ON_CHANGED_LISTENER_WITH_SWITCHED_OP_CHANGE = 148180766L;
    public static final long SECURITY_EXCEPTION_ON_INVALID_ATTRIBUTION_TAG_CHANGE = 151105954L;
    private static final String FULL_LOG = "privacy_attribution_tag_full_log_enabled";
    private static final int MAX_UNFORWARDED_OPS = 10;
    private static Boolean sFullLog = null;
    final Context mContext;
    @UnsupportedAppUsage
    final IAppOpsService mService;
    @GuardedBy(value={"sLock"})
    static IAppOpsService sService;
    @GuardedBy(value={"mModeWatchers"})
    private final ArrayMap<OnOpChangedListener, IAppOpsCallback> mModeWatchers = new ArrayMap();
    @GuardedBy(value={"mActiveWatchers"})
    private final ArrayMap<OnOpActiveChangedListener, IAppOpsActiveCallback> mActiveWatchers = new ArrayMap();
    @GuardedBy(value={"mStartedWatchers"})
    private final ArrayMap<OnOpStartedListener, IAppOpsStartedCallback> mStartedWatchers = new ArrayMap();
    @GuardedBy(value={"mNotedWatchers"})
    private final ArrayMap<OnOpNotedListener, IAppOpsNotedCallback> mNotedWatchers = new ArrayMap();
    private static final Object sLock;
    @GuardedBy(value={"sLock"})
    private static OnOpNotedCallback sOnOpNotedCallback;
    @GuardedBy(value={"sLock"})
    private static ArrayList<AsyncNotedAppOp> sUnforwardedOps;
    private static OnOpNotedCallback sMessageCollector;
    static IBinder sClientId;
    public static final String KEY_TOP_STATE_SETTLE_TIME = "top_state_settle_time";
    public static final String KEY_FG_SERVICE_STATE_SETTLE_TIME = "fg_service_state_settle_time";
    public static final String KEY_BG_STATE_SETTLE_TIME = "bg_state_settle_time";
    public static final int HISTORICAL_MODE_DISABLED = 0;
    public static final int HISTORICAL_MODE_ENABLED_ACTIVE = 1;
    public static final int HISTORICAL_MODE_ENABLED_PASSIVE = 2;
    public static final int MODE_ALLOWED = 0;
    public static final int MODE_IGNORED = 1;
    public static final int MODE_ERRORED = 2;
    public static final int MODE_DEFAULT = 3;
    public static final int MODE_FOREGROUND = 4;
    public static final int WATCH_FOREGROUND_CHANGES = 1;
    public static final int CALL_BACK_ON_SWITCHED_OP = 2;
    public static final boolean NOTE_OP_COLLECTION_ENABLED = false;
    public static final String[] MODE_NAMES;
    @SystemApi
    public static final int UID_STATE_PERSISTENT = 100;
    @SystemApi
    public static final int UID_STATE_TOP = 200;
    @SystemApi
    @Deprecated
    public static final int UID_STATE_FOREGROUND_SERVICE_LOCATION = 300;
    @SystemApi
    public static final int UID_STATE_FOREGROUND_SERVICE = 400;
    @SystemApi
    public static final int UID_STATE_FOREGROUND = 500;
    public static final int UID_STATE_MAX_LAST_NON_RESTRICTED = 500;
    @SystemApi
    public static final int UID_STATE_BACKGROUND = 600;
    @SystemApi
    public static final int UID_STATE_CACHED = 700;
    public static final int MAX_PRIORITY_UID_STATE = 100;
    public static final int MIN_PRIORITY_UID_STATE = 700;
    public static final int[] UID_STATES;
    @SystemApi
    public static final int OP_FLAG_SELF = 1;
    @SystemApi
    public static final int OP_FLAG_TRUSTED_PROXY = 2;
    @SystemApi
    public static final int OP_FLAG_UNTRUSTED_PROXY = 4;
    @SystemApi
    public static final int OP_FLAG_TRUSTED_PROXIED = 8;
    @SystemApi
    public static final int OP_FLAG_UNTRUSTED_PROXIED = 16;
    @SystemApi
    public static final int OP_FLAGS_ALL = 31;
    @SystemApi
    public static final int OP_FLAGS_ALL_TRUSTED = 13;
    public static final int ATTRIBUTION_FLAG_ACCESSOR = 1;
    public static final int ATTRIBUTION_FLAG_INTERMEDIARY = 2;
    public static final int ATTRIBUTION_FLAG_RECEIVER = 4;
    public static final int ATTRIBUTION_FLAG_TRUSTED = 8;
    public static final int ATTRIBUTION_FLAGS_NONE = 0;
    public static final int ATTRIBUTION_CHAIN_ID_NONE = -1;
    public static final int SAMPLING_STRATEGY_DEFAULT = 0;
    public static final int SAMPLING_STRATEGY_UNIFORM = 1;
    public static final int SAMPLING_STRATEGY_RARELY_USED = 2;
    public static final int SAMPLING_STRATEGY_BOOT_TIME_SAMPLING = 3;
    public static final int SAMPLING_STRATEGY_UNIFORM_OPS = 4;
    private static final int UID_STATE_OFFSET = 31;
    private static final int FLAGS_MASK = -1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int OP_NONE = -1;
    @UnsupportedAppUsage
    public static final int OP_COARSE_LOCATION = 0;
    @UnsupportedAppUsage
    public static final int OP_FINE_LOCATION = 1;
    @UnsupportedAppUsage
    public static final int OP_GPS = 2;
    @UnsupportedAppUsage
    public static final int OP_VIBRATE = 3;
    @UnsupportedAppUsage
    public static final int OP_READ_CONTACTS = 4;
    @UnsupportedAppUsage
    public static final int OP_WRITE_CONTACTS = 5;
    @UnsupportedAppUsage
    public static final int OP_READ_CALL_LOG = 6;
    @UnsupportedAppUsage
    public static final int OP_WRITE_CALL_LOG = 7;
    @UnsupportedAppUsage
    public static final int OP_READ_CALENDAR = 8;
    @UnsupportedAppUsage
    public static final int OP_WRITE_CALENDAR = 9;
    @UnsupportedAppUsage
    public static final int OP_WIFI_SCAN = 10;
    @UnsupportedAppUsage
    public static final int OP_POST_NOTIFICATION = 11;
    @UnsupportedAppUsage
    public static final int OP_NEIGHBORING_CELLS = 12;
    @UnsupportedAppUsage
    public static final int OP_CALL_PHONE = 13;
    @UnsupportedAppUsage
    public static final int OP_READ_SMS = 14;
    @UnsupportedAppUsage
    public static final int OP_WRITE_SMS = 15;
    @UnsupportedAppUsage
    public static final int OP_RECEIVE_SMS = 16;
    @UnsupportedAppUsage
    public static final int OP_RECEIVE_EMERGECY_SMS = 17;
    @UnsupportedAppUsage
    public static final int OP_RECEIVE_MMS = 18;
    @UnsupportedAppUsage
    public static final int OP_RECEIVE_WAP_PUSH = 19;
    @UnsupportedAppUsage
    public static final int OP_SEND_SMS = 20;
    public static final int OP_MANAGE_ONGOING_CALLS = 103;
    @UnsupportedAppUsage
    public static final int OP_READ_ICC_SMS = 21;
    @UnsupportedAppUsage
    public static final int OP_WRITE_ICC_SMS = 22;
    @UnsupportedAppUsage
    public static final int OP_WRITE_SETTINGS = 23;
    @UnsupportedAppUsage
    public static final int OP_SYSTEM_ALERT_WINDOW = 24;
    @UnsupportedAppUsage
    public static final int OP_ACCESS_NOTIFICATIONS = 25;
    @UnsupportedAppUsage
    public static final int OP_CAMERA = 26;
    @UnsupportedAppUsage
    public static final int OP_RECORD_AUDIO = 27;
    @UnsupportedAppUsage
    public static final int OP_PLAY_AUDIO = 28;
    @UnsupportedAppUsage
    public static final int OP_READ_CLIPBOARD = 29;
    @UnsupportedAppUsage
    public static final int OP_WRITE_CLIPBOARD = 30;
    @UnsupportedAppUsage
    public static final int OP_TAKE_MEDIA_BUTTONS = 31;
    @UnsupportedAppUsage
    public static final int OP_TAKE_AUDIO_FOCUS = 32;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_MASTER_VOLUME = 33;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_VOICE_VOLUME = 34;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_RING_VOLUME = 35;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_MEDIA_VOLUME = 36;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_ALARM_VOLUME = 37;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_NOTIFICATION_VOLUME = 38;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_BLUETOOTH_VOLUME = 39;
    @UnsupportedAppUsage
    public static final int OP_WAKE_LOCK = 40;
    @UnsupportedAppUsage
    public static final int OP_MONITOR_LOCATION = 41;
    @UnsupportedAppUsage
    public static final int OP_MONITOR_HIGH_POWER_LOCATION = 42;
    @UnsupportedAppUsage
    public static final int OP_GET_USAGE_STATS = 43;
    @UnsupportedAppUsage
    public static final int OP_MUTE_MICROPHONE = 44;
    @UnsupportedAppUsage
    public static final int OP_TOAST_WINDOW = 45;
    @UnsupportedAppUsage
    public static final int OP_PROJECT_MEDIA = 46;
    @UnsupportedAppUsage
    public static final int OP_ACTIVATE_VPN = 47;
    @UnsupportedAppUsage
    public static final int OP_WRITE_WALLPAPER = 48;
    @UnsupportedAppUsage
    public static final int OP_ASSIST_STRUCTURE = 49;
    @UnsupportedAppUsage
    public static final int OP_ASSIST_SCREENSHOT = 50;
    @UnsupportedAppUsage
    public static final int OP_READ_PHONE_STATE = 51;
    @UnsupportedAppUsage
    public static final int OP_ADD_VOICEMAIL = 52;
    @UnsupportedAppUsage
    public static final int OP_USE_SIP = 53;
    @UnsupportedAppUsage
    public static final int OP_PROCESS_OUTGOING_CALLS = 54;
    @UnsupportedAppUsage
    public static final int OP_USE_FINGERPRINT = 55;
    @UnsupportedAppUsage
    public static final int OP_BODY_SENSORS = 56;
    @UnsupportedAppUsage
    public static final int OP_READ_CELL_BROADCASTS = 57;
    @UnsupportedAppUsage
    public static final int OP_MOCK_LOCATION = 58;
    @UnsupportedAppUsage
    public static final int OP_READ_EXTERNAL_STORAGE = 59;
    @UnsupportedAppUsage
    public static final int OP_WRITE_EXTERNAL_STORAGE = 60;
    @UnsupportedAppUsage
    public static final int OP_TURN_SCREEN_ON = 61;
    @UnsupportedAppUsage
    public static final int OP_GET_ACCOUNTS = 62;
    @UnsupportedAppUsage
    public static final int OP_RUN_IN_BACKGROUND = 63;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_ACCESSIBILITY_VOLUME = 64;
    @UnsupportedAppUsage
    public static final int OP_READ_PHONE_NUMBERS = 65;
    @UnsupportedAppUsage
    public static final int OP_REQUEST_INSTALL_PACKAGES = 66;
    @UnsupportedAppUsage
    public static final int OP_PICTURE_IN_PICTURE = 67;
    @UnsupportedAppUsage
    public static final int OP_INSTANT_APP_START_FOREGROUND = 68;
    @UnsupportedAppUsage
    public static final int OP_ANSWER_PHONE_CALLS = 69;
    @UnsupportedAppUsage
    public static final int OP_RUN_ANY_IN_BACKGROUND = 70;
    @UnsupportedAppUsage
    public static final int OP_CHANGE_WIFI_STATE = 71;
    @UnsupportedAppUsage
    public static final int OP_REQUEST_DELETE_PACKAGES = 72;
    @UnsupportedAppUsage
    public static final int OP_BIND_ACCESSIBILITY_SERVICE = 73;
    @UnsupportedAppUsage
    public static final int OP_ACCEPT_HANDOVER = 74;
    @UnsupportedAppUsage
    public static final int OP_MANAGE_IPSEC_TUNNELS = 75;
    @UnsupportedAppUsage
    public static final int OP_START_FOREGROUND = 76;
    @UnsupportedAppUsage
    public static final int OP_BLUETOOTH_SCAN = 77;
    public static final int OP_BLUETOOTH_CONNECT = 111;
    public static final int OP_BLUETOOTH_ADVERTISE = 114;
    public static final int OP_USE_BIOMETRIC = 78;
    public static final int OP_ACTIVITY_RECOGNITION = 79;
    public static final int OP_SMS_FINANCIAL_TRANSACTIONS = 80;
    public static final int OP_READ_MEDIA_AUDIO = 81;
    public static final int OP_WRITE_MEDIA_AUDIO = 82;
    public static final int OP_READ_MEDIA_VIDEO = 83;
    public static final int OP_WRITE_MEDIA_VIDEO = 84;
    public static final int OP_READ_MEDIA_IMAGES = 85;
    public static final int OP_WRITE_MEDIA_IMAGES = 86;
    public static final int OP_LEGACY_STORAGE = 87;
    public static final int OP_ACCESS_ACCESSIBILITY = 88;
    public static final int OP_READ_DEVICE_IDENTIFIERS = 89;
    public static final int OP_ACCESS_MEDIA_LOCATION = 90;
    public static final int OP_QUERY_ALL_PACKAGES = 91;
    public static final int OP_MANAGE_EXTERNAL_STORAGE = 92;
    public static final int OP_INTERACT_ACROSS_PROFILES = 93;
    public static final int OP_ACTIVATE_PLATFORM_VPN = 94;
    public static final int OP_LOADER_USAGE_STATS = 95;
    private static final int OP_DEPRECATED_1 = 96;
    public static final int OP_AUTO_REVOKE_PERMISSIONS_IF_UNUSED = 97;
    public static final int OP_AUTO_REVOKE_MANAGED_BY_INSTALLER = 98;
    public static final int OP_NO_ISOLATED_STORAGE = 99;
    public static final int OP_PHONE_CALL_MICROPHONE = 100;
    public static final int OP_PHONE_CALL_CAMERA = 101;
    public static final int OP_RECORD_AUDIO_HOTWORD = 102;
    public static final int OP_MANAGE_CREDENTIALS = 104;
    public static final int OP_USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER = 105;
    public static final int OP_RECORD_AUDIO_OUTPUT = 106;
    public static final int OP_SCHEDULE_EXACT_ALARM = 107;
    public static final int OP_FINE_LOCATION_SOURCE = 108;
    public static final int OP_COARSE_LOCATION_SOURCE = 109;
    public static final int OP_MANAGE_MEDIA = 110;
    public static final int OP_UWB_RANGING = 112;
    public static final int OP_NEARBY_WIFI_DEVICES = 116;
    public static final int OP_ACTIVITY_RECOGNITION_SOURCE = 113;
    public static final int OP_RECORD_INCOMING_PHONE_AUDIO = 115;
    public static final int OP_ESTABLISH_VPN_SERVICE = 117;
    public static final int OP_ESTABLISH_VPN_MANAGER = 118;
    public static final int OP_ACCESS_RESTRICTED_SETTINGS = 119;
    public static final int OP_RECEIVE_AMBIENT_TRIGGER_AUDIO = 120;
    public static final int OP_RECEIVE_EXPLICIT_USER_INTERACTION_AUDIO = 121;
    public static final int OP_RUN_USER_INITIATED_JOBS = 122;
    public static final int OP_READ_MEDIA_VISUAL_USER_SELECTED = 123;
    public static final int OP_SYSTEM_EXEMPT_FROM_SUSPENSION = 124;
    public static final int OP_SYSTEM_EXEMPT_FROM_DISMISSIBLE_NOTIFICATIONS = 125;
    public static final int OP_READ_WRITE_HEALTH_DATA = 126;
    public static final int OP_FOREGROUND_SERVICE_SPECIAL_USE = 127;
    public static final int OP_SYSTEM_EXEMPT_FROM_POWER_RESTRICTIONS = 128;
    public static final int OP_SYSTEM_EXEMPT_FROM_HIBERNATION = 129;
    public static final int OP_SYSTEM_EXEMPT_FROM_ACTIVITY_BG_START_RESTRICTION = 130;
    public static final int OP_CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD = 131;
    private static final int OP_DEPRECATED_2 = 132;
    public static final int OP_USE_FULL_SCREEN_INTENT = 133;
    public static final int OP_CAMERA_SANDBOXED = 134;
    public static final int OP_RECORD_AUDIO_SANDBOXED = 135;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int _NUM_OP = 136;
    public static final String OPSTR_COARSE_LOCATION = "android:coarse_location";
    public static final String OPSTR_FINE_LOCATION = "android:fine_location";
    public static final String OPSTR_MONITOR_LOCATION = "android:monitor_location";
    public static final String OPSTR_MONITOR_HIGH_POWER_LOCATION = "android:monitor_location_high_power";
    public static final String OPSTR_GET_USAGE_STATS = "android:get_usage_stats";
    @SystemApi
    public static final String OPSTR_ACTIVATE_VPN = "android:activate_vpn";
    public static final String OPSTR_READ_CONTACTS = "android:read_contacts";
    public static final String OPSTR_WRITE_CONTACTS = "android:write_contacts";
    public static final String OPSTR_READ_CALL_LOG = "android:read_call_log";
    public static final String OPSTR_WRITE_CALL_LOG = "android:write_call_log";
    public static final String OPSTR_READ_CALENDAR = "android:read_calendar";
    public static final String OPSTR_WRITE_CALENDAR = "android:write_calendar";
    public static final String OPSTR_CALL_PHONE = "android:call_phone";
    public static final String OPSTR_READ_SMS = "android:read_sms";
    public static final String OPSTR_RECEIVE_SMS = "android:receive_sms";
    public static final String OPSTR_RECEIVE_MMS = "android:receive_mms";
    public static final String OPSTR_RECEIVE_WAP_PUSH = "android:receive_wap_push";
    public static final String OPSTR_SEND_SMS = "android:send_sms";
    public static final String OPSTR_CAMERA = "android:camera";
    public static final String OPSTR_RECORD_AUDIO = "android:record_audio";
    public static final String OPSTR_READ_PHONE_STATE = "android:read_phone_state";
    public static final String OPSTR_ADD_VOICEMAIL = "android:add_voicemail";
    public static final String OPSTR_USE_SIP = "android:use_sip";
    public static final String OPSTR_PROCESS_OUTGOING_CALLS = "android:process_outgoing_calls";
    public static final String OPSTR_USE_FINGERPRINT = "android:use_fingerprint";
    public static final String OPSTR_BODY_SENSORS = "android:body_sensors";
    public static final String OPSTR_READ_CELL_BROADCASTS = "android:read_cell_broadcasts";
    public static final String OPSTR_MOCK_LOCATION = "android:mock_location";
    public static final String OPSTR_READ_EXTERNAL_STORAGE = "android:read_external_storage";
    public static final String OPSTR_WRITE_EXTERNAL_STORAGE = "android:write_external_storage";
    public static final String OPSTR_SYSTEM_ALERT_WINDOW = "android:system_alert_window";
    public static final String OPSTR_WRITE_SETTINGS = "android:write_settings";
    @SystemApi
    public static final String OPSTR_GET_ACCOUNTS = "android:get_accounts";
    public static final String OPSTR_READ_PHONE_NUMBERS = "android:read_phone_numbers";
    public static final String OPSTR_PICTURE_IN_PICTURE = "android:picture_in_picture";
    @SystemApi
    public static final String OPSTR_INSTANT_APP_START_FOREGROUND = "android:instant_app_start_foreground";
    public static final String OPSTR_ANSWER_PHONE_CALLS = "android:answer_phone_calls";
    @SystemApi
    public static final String OPSTR_ACCEPT_HANDOVER = "android:accept_handover";
    @SystemApi
    public static final String OPSTR_GPS = "android:gps";
    @SystemApi
    public static final String OPSTR_VIBRATE = "android:vibrate";
    @SystemApi
    public static final String OPSTR_WIFI_SCAN = "android:wifi_scan";
    @SystemApi
    public static final String OPSTR_POST_NOTIFICATION = "android:post_notification";
    @SystemApi
    public static final String OPSTR_NEIGHBORING_CELLS = "android:neighboring_cells";
    @SystemApi
    public static final String OPSTR_WRITE_SMS = "android:write_sms";
    @SystemApi
    public static final String OPSTR_RECEIVE_EMERGENCY_BROADCAST = "android:receive_emergency_broadcast";
    @SystemApi
    public static final String OPSTR_READ_ICC_SMS = "android:read_icc_sms";
    @SystemApi
    public static final String OPSTR_WRITE_ICC_SMS = "android:write_icc_sms";
    @SystemApi
    public static final String OPSTR_ACCESS_NOTIFICATIONS = "android:access_notifications";
    @SystemApi
    public static final String OPSTR_PLAY_AUDIO = "android:play_audio";
    @SystemApi
    public static final String OPSTR_READ_CLIPBOARD = "android:read_clipboard";
    @SystemApi
    public static final String OPSTR_WRITE_CLIPBOARD = "android:write_clipboard";
    @SystemApi
    public static final String OPSTR_TAKE_MEDIA_BUTTONS = "android:take_media_buttons";
    @SystemApi
    public static final String OPSTR_TAKE_AUDIO_FOCUS = "android:take_audio_focus";
    @SystemApi
    public static final String OPSTR_AUDIO_MASTER_VOLUME = "android:audio_master_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_VOICE_VOLUME = "android:audio_voice_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_RING_VOLUME = "android:audio_ring_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_MEDIA_VOLUME = "android:audio_media_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_ALARM_VOLUME = "android:audio_alarm_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_NOTIFICATION_VOLUME = "android:audio_notification_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_BLUETOOTH_VOLUME = "android:audio_bluetooth_volume";
    @SystemApi
    public static final String OPSTR_WAKE_LOCK = "android:wake_lock";
    @SystemApi
    public static final String OPSTR_MUTE_MICROPHONE = "android:mute_microphone";
    @SystemApi
    public static final String OPSTR_TOAST_WINDOW = "android:toast_window";
    @SystemApi
    public static final String OPSTR_PROJECT_MEDIA = "android:project_media";
    @SystemApi
    public static final String OPSTR_WRITE_WALLPAPER = "android:write_wallpaper";
    @SystemApi
    public static final String OPSTR_ASSIST_STRUCTURE = "android:assist_structure";
    @SystemApi
    public static final String OPSTR_ASSIST_SCREENSHOT = "android:assist_screenshot";
    @SystemApi
    public static final String OPSTR_TURN_SCREEN_ON = "android:turn_screen_on";
    @SystemApi
    public static final String OPSTR_RUN_IN_BACKGROUND = "android:run_in_background";
    @SystemApi
    public static final String OPSTR_AUDIO_ACCESSIBILITY_VOLUME = "android:audio_accessibility_volume";
    @SystemApi
    public static final String OPSTR_REQUEST_INSTALL_PACKAGES = "android:request_install_packages";
    @SystemApi
    public static final String OPSTR_RUN_ANY_IN_BACKGROUND = "android:run_any_in_background";
    @SystemApi
    public static final String OPSTR_CHANGE_WIFI_STATE = "android:change_wifi_state";
    @SystemApi
    public static final String OPSTR_REQUEST_DELETE_PACKAGES = "android:request_delete_packages";
    @SystemApi
    public static final String OPSTR_BIND_ACCESSIBILITY_SERVICE = "android:bind_accessibility_service";
    @SystemApi
    public static final String OPSTR_MANAGE_IPSEC_TUNNELS = "android:manage_ipsec_tunnels";
    @SystemApi
    public static final String OPSTR_START_FOREGROUND = "android:start_foreground";
    public static final String OPSTR_BLUETOOTH_SCAN = "android:bluetooth_scan";
    public static final String OPSTR_BLUETOOTH_CONNECT = "android:bluetooth_connect";
    public static final String OPSTR_BLUETOOTH_ADVERTISE = "android:bluetooth_advertise";
    public static final String OPSTR_USE_BIOMETRIC = "android:use_biometric";
    public static final String OPSTR_ACTIVITY_RECOGNITION = "android:activity_recognition";
    public static final String OPSTR_SMS_FINANCIAL_TRANSACTIONS = "android:sms_financial_transactions";
    @SystemApi
    public static final String OPSTR_READ_MEDIA_AUDIO = "android:read_media_audio";
    @SystemApi
    public static final String OPSTR_WRITE_MEDIA_AUDIO = "android:write_media_audio";
    @SystemApi
    public static final String OPSTR_READ_MEDIA_VIDEO = "android:read_media_video";
    @SystemApi
    public static final String OPSTR_WRITE_MEDIA_VIDEO = "android:write_media_video";
    @SystemApi
    public static final String OPSTR_READ_MEDIA_IMAGES = "android:read_media_images";
    @SystemApi
    public static final String OPSTR_WRITE_MEDIA_IMAGES = "android:write_media_images";
    @SystemApi
    public static final String OPSTR_LEGACY_STORAGE = "android:legacy_storage";
    public static final String OPSTR_ACCESS_MEDIA_LOCATION = "android:access_media_location";
    @SystemApi
    public static final String OPSTR_ACCESS_ACCESSIBILITY = "android:access_accessibility";
    public static final String OPSTR_READ_DEVICE_IDENTIFIERS = "android:read_device_identifiers";
    public static final String OPSTR_QUERY_ALL_PACKAGES = "android:query_all_packages";
    @SystemApi
    public static final String OPSTR_MANAGE_EXTERNAL_STORAGE = "android:manage_external_storage";
    @SystemApi
    public static final String OPSTR_AUTO_REVOKE_PERMISSIONS_IF_UNUSED = "android:auto_revoke_permissions_if_unused";
    @SystemApi
    public static final String OPSTR_AUTO_REVOKE_MANAGED_BY_INSTALLER = "android:auto_revoke_managed_by_installer";
    @SystemApi
    public static final String OPSTR_INTERACT_ACROSS_PROFILES = "android:interact_across_profiles";
    @SystemApi
    public static final String OPSTR_ACTIVATE_PLATFORM_VPN = "android:activate_platform_vpn";
    @SystemApi
    public static final String OPSTR_LOADER_USAGE_STATS = "android:loader_usage_stats";
    @SystemApi
    public static final String OPSTR_MANAGE_ONGOING_CALLS = "android:manage_ongoing_calls";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String OPSTR_NO_ISOLATED_STORAGE = "android:no_isolated_storage";
    @SystemApi
    public static final String OPSTR_PHONE_CALL_MICROPHONE = "android:phone_call_microphone";
    @SystemApi
    public static final String OPSTR_PHONE_CALL_CAMERA = "android:phone_call_camera";
    public static final String OPSTR_RECORD_AUDIO_HOTWORD = "android:record_audio_hotword";
    public static final String OPSTR_MANAGE_CREDENTIALS = "android:manage_credentials";
    public static final String OPSTR_USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER = "android:use_icc_auth_with_device_identifier";
    public static final String OPSTR_RECORD_AUDIO_OUTPUT = "android:record_audio_output";
    public static final String OPSTR_SCHEDULE_EXACT_ALARM = "android:schedule_exact_alarm";
    public static final String OPSTR_FINE_LOCATION_SOURCE = "android:fine_location_source";
    public static final String OPSTR_COARSE_LOCATION_SOURCE = "android:coarse_location_source";
    public static final String OPSTR_CAMERA_SANDBOXED = "android:camera_sandboxed";
    public static final String OPSTR_RECORD_AUDIO_SANDBOXED = "android:record_audio_sandboxed";
    public static final String OPSTR_MANAGE_MEDIA = "android:manage_media";
    public static final String OPSTR_UWB_RANGING = "android:uwb_ranging";
    public static final String OPSTR_NEARBY_WIFI_DEVICES = "android:nearby_wifi_devices";
    public static final String OPSTR_ACTIVITY_RECOGNITION_SOURCE = "android:activity_recognition_source";
    public static final String OPSTR_RECORD_INCOMING_PHONE_AUDIO = "android:record_incoming_phone_audio";
    @SystemApi
    public static final String OPSTR_ESTABLISH_VPN_SERVICE = "android:establish_vpn_service";
    @SystemApi
    public static final String OPSTR_ESTABLISH_VPN_MANAGER = "android:establish_vpn_manager";
    public static final String OPSTR_ACCESS_RESTRICTED_SETTINGS = "android:access_restricted_settings";
    @SystemApi
    public static final String OPSTR_RECEIVE_AMBIENT_TRIGGER_AUDIO = "android:receive_ambient_trigger_audio";
    @SystemApi
    public static final String OPSTR_READ_MEDIA_VISUAL_USER_SELECTED = "android:read_media_visual_user_selected";
    @SystemApi
    public static final String OPSTR_READ_WRITE_HEALTH_DATA = "android:read_write_health_data";
    @SystemApi
    @SuppressLint(value={"IntentName"})
    public static final String OPSTR_RECEIVE_EXPLICIT_USER_INTERACTION_AUDIO = "android:receive_explicit_user_interaction_audio";
    public static final String OPSTR_RUN_USER_INITIATED_JOBS = "android:run_user_initiated_jobs";
    public static final String OPSTR_SYSTEM_EXEMPT_FROM_SUSPENSION = "android:system_exempt_from_suspension";
    public static final String OPSTR_SYSTEM_EXEMPT_FROM_DISMISSIBLE_NOTIFICATIONS = "android:system_exempt_from_dismissible_notifications";
    public static final String OPSTR_FOREGROUND_SERVICE_SPECIAL_USE = "android:foreground_service_special_use";
    public static final String OPSTR_SYSTEM_EXEMPT_FROM_POWER_RESTRICTIONS = "android:system_exempt_from_power_restrictions";
    @SystemApi
    public static final String OPSTR_SYSTEM_EXEMPT_FROM_HIBERNATION = "android:system_exempt_from_hibernation";
    public static final String OPSTR_SYSTEM_EXEMPT_FROM_ACTIVITY_BG_START_RESTRICTION = "android:system_exempt_from_activity_bg_start_restriction";
    @SystemApi
    public static final String OPSTR_CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD = "android:capture_consentless_bugreport_on_userdebug_build";
    public static final String OPSTR_DEPRECATED_2 = "android:deprecated_2";
    public static final String OPSTR_USE_FULL_SCREEN_INTENT = "android:use_full_screen_intent";
    private static final byte SHOULD_COLLECT_NOTE_OP_NOT_INITIALIZED = 0;
    private static final byte SHOULD_NOT_COLLECT_NOTE_OP = 1;
    private static final byte SHOULD_COLLECT_NOTE_OP = 2;
    private static final byte[] sAppOpsToNote;
    private static final int[] RUNTIME_PERMISSION_OPS;
    private static final int[] APP_OP_PERMISSION_PACKAGE_OPS;
    private static final int[] APP_OP_PERMISSION_UID_OPS;
    static final AppOpInfo[] sAppOpInfos;
    private static final int BITMASK_LEN = 3;
    private static HashMap<String, Integer> sOpStrToOp;
    private static HashMap<String, Integer> sPermToOp;
    private static final ThreadLocal<Integer> sBinderThreadCallingUid;
    private static final ThreadLocal<ArrayMap<String, BitSet>> sAppOpsNotedInThisBinderTransaction;
    private static MessageSamplingConfig sConfig;
    public static final String KEY_HISTORICAL_OPS = "historical_ops";
    private static final String DEBUG_LOGGING_ENABLE_PROP = "appops.logging_enabled";
    private static final String DEBUG_LOGGING_PACKAGES_PROP = "appops.logging_packages";
    private static final String DEBUG_LOGGING_OPS_PROP = "appops.logging_ops";
    private static final String DEBUG_LOGGING_TAG = "AppOpsManager";
    @SystemApi
    public static final int HISTORY_FLAG_AGGREGATE = 1;
    @SystemApi
    public static final int HISTORY_FLAG_DISCRETE = 2;
    @SystemApi
    public static final int HISTORY_FLAG_GET_ATTRIBUTION_CHAINS = 4;
    @SystemApi
    public static final int HISTORY_FLAGS_ALL = 3;
    public static final int FILTER_BY_UID = 1;
    public static final int FILTER_BY_PACKAGE_NAME = 2;
    public static final int FILTER_BY_ATTRIBUTION_TAG = 4;
    public static final int FILTER_BY_OP_NAMES = 8;
    private static final int DONT_COLLECT = 0;
    private static final int COLLECT_SELF = 1;
    private static final int COLLECT_SYNC = 2;
    private static final int COLLECT_ASYNC = 3;

    public static int resolveFirstUnrestrictedUidState(int op) {
        return 500;
    }

    public static int resolveLastRestrictedUidState(int op) {
        return 600;
    }

    public static String getUidStateName(int uidState) {
        switch (uidState) {
            case 100: {
                return "pers";
            }
            case 200: {
                return "top";
            }
            case 300: {
                return "fgsvcl";
            }
            case 400: {
                return "fgsvc";
            }
            case 500: {
                return "fg";
            }
            case 600: {
                return "bg";
            }
            case 700: {
                return "cch";
            }
        }
        return "unknown";
    }

    public static String getFlagName(int flag) {
        switch (flag) {
            case 1: {
                return "s";
            }
            case 2: {
                return "tp";
            }
            case 4: {
                return "up";
            }
            case 8: {
                return "tpd";
            }
            case 16: {
                return "upd";
            }
        }
        return "unknown";
    }

    public static String keyToString(long key) {
        int uidState = AppOpsManager.extractUidStateFromKey(key);
        int flags = AppOpsManager.extractFlagsFromKey(key);
        return "[" + AppOpsManager.getUidStateName(uidState) + "-" + AppOpsManager.flagsToString(flags) + "]";
    }

    public static long makeKey(int uidState, int flags) {
        return (long)uidState << 31 | (long)flags;
    }

    public static int extractUidStateFromKey(long key) {
        return (int)(key >> 31);
    }

    public static int extractFlagsFromKey(long key) {
        return (int)(key & 0xFFFFFFFFFFFFFFFFL);
    }

    public static String flagsToString(int flags) {
        StringBuilder flagsBuilder = new StringBuilder();
        while (flags != 0) {
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            if (flagsBuilder.length() > 0) {
                flagsBuilder.append('|');
            }
            flagsBuilder.append(AppOpsManager.getFlagName(flag));
        }
        return flagsBuilder.toString();
    }

    public static boolean shouldForceCollectNoteForOp(int op) {
        Preconditions.checkArgumentInRange(op, 0, 135, "opCode");
        return AppOpsManager.sAppOpInfos[op].forceCollectNotes;
    }

    @UnsupportedAppUsage
    public static int opToSwitch(int op) {
        return AppOpsManager.sAppOpInfos[op].switchCode;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static String opToName(int op) {
        if (op == -1) {
            return "NONE";
        }
        return op < sAppOpInfos.length ? AppOpsManager.sAppOpInfos[op].simpleName : "Unknown(" + op + ")";
    }

    public static String opToPublicName(int op) {
        return AppOpsManager.sAppOpInfos[op].name;
    }

    public static int strDebugOpToOp(String op) {
        for (int i = 0; i < sAppOpInfos.length; ++i) {
            if (!AppOpsManager.sAppOpInfos[i].simpleName.equals(op)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown operation string: " + op);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static String opToPermission(int op) {
        return AppOpsManager.sAppOpInfos[op].permission;
    }

    @SystemApi
    public static String opToPermission(String op) {
        return AppOpsManager.opToPermission(AppOpsManager.strOpToOp(op));
    }

    public static String opToRestriction(int op) {
        return AppOpsManager.sAppOpInfos[op].restriction;
    }

    @UnsupportedAppUsage
    public static int permissionToOpCode(String permission2) {
        Integer boxedOpCode = sPermToOp.get(permission2);
        if (boxedOpCode != null) {
            return boxedOpCode;
        }
        if (permission2 != null && HealthConnectManager.isHealthPermission(ActivityThread.currentApplication(), permission2)) {
            return 126;
        }
        return -1;
    }

    public static RestrictionBypass opAllowSystemBypassRestriction(int op) {
        return AppOpsManager.sAppOpInfos[op].allowSystemRestrictionBypass;
    }

    public static int opToDefaultMode(int op) {
        return AppOpsManager.sAppOpInfos[op].defaultMode;
    }

    @SystemApi
    public static int opToDefaultMode(String appOp) {
        return AppOpsManager.opToDefaultMode(AppOpsManager.strOpToOp(appOp));
    }

    public static String modeToName(int mode) {
        if (mode >= 0 && mode < MODE_NAMES.length) {
            return MODE_NAMES[mode];
        }
        return "mode=" + mode;
    }

    public static boolean opRestrictsRead(int op) {
        return AppOpsManager.sAppOpInfos[op].restrictRead;
    }

    public static boolean opAllowsReset(int op) {
        return !AppOpsManager.sAppOpInfos[op].disableReset;
    }

    public static boolean opIsPackageAppOpPermission(int op) {
        return ArrayUtils.contains(APP_OP_PERMISSION_PACKAGE_OPS, op);
    }

    public static boolean opIsUidAppOpPermission(int op) {
        return ArrayUtils.contains(APP_OP_PERMISSION_UID_OPS, op);
    }

    public static String toReceiverId(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof PendingIntent) {
            return AppOpsManager.toReceiverId((PendingIntent)obj);
        }
        return obj.getClass().getName() + "@" + System.identityHashCode(obj);
    }

    public static String toReceiverId(PendingIntent pendingIntent) {
        return pendingIntent.getTag("");
    }

    private static long sumForFlagsInStates(LongSparseLongArray counts, int beginUidState, int endUidState, int flags) {
        if (counts == null) {
            return 0L;
        }
        long sum = 0L;
        while (flags != 0) {
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            for (int uidState : UID_STATES) {
                if (uidState < beginUidState || uidState > endUidState) continue;
                long key = AppOpsManager.makeKey(uidState, flag);
                sum += counts.get(key);
            }
        }
        return sum;
    }

    private static List<AttributedOpEntry> listForFlagsInStates(List<AttributedOpEntry> accesses, int beginUidState, int endUidState, int flags) {
        ArrayList<AttributedOpEntry> result = new ArrayList<AttributedOpEntry>();
        if (accesses == null) {
            return result;
        }
        int nAccesses = accesses.size();
        for (int i = 0; i < nAccesses; ++i) {
            AttributedOpEntry entry = accesses.get(i);
            if (entry.getLastAccessTime(beginUidState, endUidState, flags) == -1L) continue;
            result.add(entry);
        }
        return AppOpsManager.deduplicateDiscreteEvents(result);
    }

    AppOpsManager(Context context, IAppOpsService service) {
        this.mContext = context;
        this.mService = service;
        if (this.mContext != null) {
            PackageManager pm = this.mContext.getPackageManager();
            try {
                if (_Original_Build.IS_ENG && pm != null && pm.checkPermission("android.permission.READ_DEVICE_CONFIG", this.mContext.getPackageName()) == 0) {
                    DeviceConfig.addOnPropertiesChangedListener("privacy", this.mContext.getMainExecutor(), properties -> {
                        if (properties.getKeyset().contains(FULL_LOG)) {
                            sFullLog = properties.getBoolean(FULL_LOG, false);
                        }
                    });
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sFullLog = false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public List<PackageOps> getPackagesForOps(String[] ops) {
        List<PackageOps> result;
        int[] opCodes;
        if (ops != null) {
            int opCount = ops.length;
            opCodes = new int[opCount];
            for (int i = 0; i < opCount; ++i) {
                opCodes[i] = sOpStrToOp.get(ops[i]);
            }
        } else {
            opCodes = null;
        }
        return (result = this.getPackagesForOps(opCodes)) != null ? result : Collections.emptyList();
    }

    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    @UnsupportedAppUsage
    public List<PackageOps> getPackagesForOps(int[] ops) {
        try {
            return this.mService.getPackagesForOps(ops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public List<PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) {
        try {
            return this.mService.getOpsForPackage(uid, packageName, ops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public List<PackageOps> getOpsForPackage(int uid, String packageName, String ... ops) {
        int[] opCodes = null;
        if (ops != null) {
            opCodes = new int[ops.length];
            for (int i = 0; i < ops.length; ++i) {
                opCodes[i] = AppOpsManager.strOpToOp(ops[i]);
            }
        }
        try {
            List<PackageOps> result = this.mService.getOpsForPackage(uid, packageName, opCodes);
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public void getHistoricalOps(HistoricalOpsRequest request, Executor executor, Consumer<HistoricalOps> callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        try {
            this.mService.getHistoricalOps(request.mUid, request.mPackageName, request.mAttributionTag, request.mOpNames, request.mHistoryFlags, request.mFilter, request.mBeginTimeMillis, request.mEndTimeMillis, request.mFlags, new RemoteCallback(result -> {
                HistoricalOps ops = result.getParcelable(KEY_HISTORICAL_OPS, HistoricalOps.class);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.accept(ops));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void getHistoricalOpsFromDiskRaw(HistoricalOpsRequest request, Executor executor, Consumer<HistoricalOps> callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        try {
            this.mService.getHistoricalOpsFromDiskRaw(request.mUid, request.mPackageName, request.mAttributionTag, request.mOpNames, request.mHistoryFlags, request.mFilter, request.mBeginTimeMillis, request.mEndTimeMillis, request.mFlags, new RemoteCallback(result -> {
                HistoricalOps ops = result.getParcelable(KEY_HISTORICAL_OPS, HistoricalOps.class);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.accept(ops));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void reloadNonHistoricalState() {
        try {
            this.mService.reloadNonHistoricalState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APP_OPS_MODES")
    public void setUidMode(int code, int uid, int mode) {
        try {
            this.mService.setUidMode(code, uid, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_OPS_MODES")
    public void setUidMode(String appOp, int uid, int mode) {
        try {
            this.mService.setUidMode(AppOpsManager.strOpToOp(appOp), uid, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setUserRestriction(int code, boolean restricted, IBinder token) {
        this.setUserRestriction(code, restricted, token, null);
    }

    public void setUserRestriction(int code, boolean restricted, IBinder token, PackageTagsList excludedPackageTags) {
        this.setUserRestrictionForUser(code, restricted, token, excludedPackageTags, this.mContext.getUserId());
    }

    public void setUserRestrictionForUser(int code, boolean restricted, IBinder token, PackageTagsList excludedPackageTags, int userId) {
        try {
            this.mService.setUserRestriction(code, restricted, token, userId, excludedPackageTags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.MANAGE_APP_OPS_MODES")
    public void setMode(int code, int uid, String packageName, int mode) {
        try {
            this.mService.setMode(code, uid, packageName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_OPS_MODES")
    public void setMode(String op, int uid, String packageName, int mode) {
        try {
            this.mService.setMode(AppOpsManager.strOpToOp(op), uid, packageName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APP_OPS_MODES")
    @UnsupportedAppUsage
    public void setRestriction(int code, int usage, int mode, String[] exceptionPackages) {
        try {
            int uid = Binder.getCallingUid();
            this.mService.setAudioRestriction(code, usage, uid, mode, exceptionPackages);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APP_OPS_MODES")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void resetAllModes() {
        try {
            this.mService.resetAllModes(this.mContext.getUserId(), null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static String permissionToOp(String permission2) {
        Integer opCode = sPermToOp.get(permission2);
        if (opCode != null) {
            return AppOpsManager.sAppOpInfos[opCode.intValue()].name;
        }
        if (HealthConnectManager.isHealthPermission(ActivityThread.currentApplication(), permission2)) {
            return AppOpsManager.sAppOpInfos[126].name;
        }
        return null;
    }

    public static String resolvePackageName(int uid, String packageName) {
        if (uid == 0) {
            return "root";
        }
        if (uid == 2000) {
            return "com.android.shell";
        }
        if (uid == 1013) {
            return "media";
        }
        if (uid == 1041) {
            return "audioserver";
        }
        if (uid == 1047) {
            return "cameraserver";
        }
        if (uid == 1000 && packageName == null) {
            return "android";
        }
        return packageName;
    }

    public void startWatchingMode(String op, String packageName, OnOpChangedListener callback) {
        this.startWatchingMode(AppOpsManager.strOpToOp(op), packageName, callback);
    }

    public void startWatchingMode(String op, String packageName, int flags, OnOpChangedListener callback) {
        this.startWatchingMode(AppOpsManager.strOpToOp(op), packageName, flags, callback);
    }

    @RequiresPermission(value="android.permission.WATCH_APPOPS", conditional=true)
    public void startWatchingMode(int op, String packageName, OnOpChangedListener callback) {
        this.startWatchingMode(op, packageName, 0, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.WATCH_APPOPS", conditional=true)
    public void startWatchingMode(int op, String packageName, int flags, final OnOpChangedListener callback) {
        ArrayMap<OnOpChangedListener, IAppOpsCallback> arrayMap = this.mModeWatchers;
        synchronized (arrayMap) {
            IAppOpsCallback cb = this.mModeWatchers.get(callback);
            if (cb == null) {
                cb = new IAppOpsCallback.Stub(){

                    @Override
                    public void opChanged(int op, int uid, String packageName) {
                        if (callback instanceof OnOpChangedInternalListener) {
                            ((OnOpChangedInternalListener)callback).onOpChanged(op, packageName);
                        }
                        if (AppOpsManager.sAppOpInfos[op].name != null) {
                            callback.onOpChanged(AppOpsManager.sAppOpInfos[op].name, packageName, UserHandle.getUserId(uid));
                        }
                    }
                };
                this.mModeWatchers.put(callback, cb);
            }
            if (!Compatibility.isChangeEnabled(148180766L)) {
                flags |= 2;
            }
            try {
                this.mService.startWatchingModeWithFlags(op, packageName, flags, cb);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatchingMode(OnOpChangedListener callback) {
        ArrayMap<OnOpChangedListener, IAppOpsCallback> arrayMap = this.mModeWatchers;
        synchronized (arrayMap) {
            IAppOpsCallback cb = this.mModeWatchers.remove(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingMode(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @Deprecated
    public void startWatchingActive(int[] ops, OnOpActiveChangedListener callback) {
        String[] strOps = new String[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            strOps[i] = AppOpsManager.opToPublicName(ops[i]);
        }
        this.startWatchingActive(strOps, this.mContext.getMainExecutor(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWatchingActive(String[] ops, final Executor executor, final OnOpActiveChangedListener callback) {
        IAppOpsActiveCallback cb;
        Objects.requireNonNull(ops);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        ArrayMap<OnOpActiveChangedListener, IAppOpsActiveCallback> arrayMap = this.mActiveWatchers;
        synchronized (arrayMap) {
            cb = this.mActiveWatchers.get(callback);
            if (cb != null) {
                return;
            }
            cb = new IAppOpsActiveCallback.Stub(){

                @Override
                public void opActiveChanged(int op, int uid, String packageName, String attributionTag, boolean active, int attributionFlags, int attributionChainId) {
                    executor.execute(() -> {
                        if (callback instanceof OnOpActiveChangedInternalListener) {
                            ((OnOpActiveChangedInternalListener)callback).onOpActiveChanged(op, uid, packageName, active);
                        }
                        if (AppOpsManager.sAppOpInfos[op].name != null) {
                            callback.onOpActiveChanged(AppOpsManager.sAppOpInfos[op].name, uid, packageName, attributionTag, active, attributionFlags, attributionChainId);
                        }
                    });
                }
            };
            this.mActiveWatchers.put(callback, cb);
        }
        int[] rawOps = new int[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            rawOps[i] = AppOpsManager.strOpToOp(ops[i]);
        }
        try {
            this.mService.startWatchingActive(rawOps, cb);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatchingActive(OnOpActiveChangedListener callback) {
        ArrayMap<OnOpActiveChangedListener, IAppOpsActiveCallback> arrayMap = this.mActiveWatchers;
        synchronized (arrayMap) {
            IAppOpsActiveCallback cb = this.mActiveWatchers.remove(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingActive(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.WATCH_APPOPS", conditional=true)
    public void startWatchingStarted(int[] ops, final OnOpStartedListener callback) {
        IAppOpsStartedCallback.Stub cb;
        ArrayMap<OnOpStartedListener, IAppOpsStartedCallback> arrayMap = this.mStartedWatchers;
        synchronized (arrayMap) {
            if (this.mStartedWatchers.containsKey(callback)) {
                return;
            }
            cb = new IAppOpsStartedCallback.Stub(){

                @Override
                public void opStarted(int op, int uid, String packageName, String attributionTag, int flags, int mode, int startType, int attributionFlags, int attributionChainId) {
                    callback.onOpStarted(op, uid, packageName, attributionTag, flags, mode, startType, attributionFlags, attributionChainId);
                }
            };
            this.mStartedWatchers.put(callback, cb);
        }
        try {
            this.mService.startWatchingStarted(ops, cb);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatchingStarted(OnOpStartedListener callback) {
        ArrayMap<OnOpStartedListener, IAppOpsStartedCallback> arrayMap = this.mStartedWatchers;
        synchronized (arrayMap) {
            IAppOpsStartedCallback cb = this.mStartedWatchers.remove(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingStarted(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WATCH_APPOPS", conditional=true)
    public void startWatchingNoted(String[] ops, OnOpNotedListener listener) {
        int[] intOps = new int[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            intOps[i] = AppOpsManager.strOpToOp(ops[i]);
        }
        this.startWatchingNoted(intOps, listener);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WATCH_APPOPS", conditional=true)
    public void startWatchingNoted(String[] ops, Executor executor, OnOpNotedListener listener) {
        int[] intOps = new int[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            intOps[i] = AppOpsManager.strOpToOp(ops[i]);
        }
        this.startWatchingNoted(intOps, executor, listener);
    }

    @RequiresPermission(value="android.permission.WATCH_APPOPS", conditional=true)
    public void startWatchingNoted(int[] ops, OnOpNotedListener listener) {
        this.startWatchingNoted(ops, this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.WATCH_APPOPS", conditional=true)
    public void startWatchingNoted(int[] ops, final Executor executor, final OnOpNotedListener listener) {
        IAppOpsNotedCallback cb;
        ArrayMap<OnOpNotedListener, IAppOpsNotedCallback> arrayMap = this.mNotedWatchers;
        synchronized (arrayMap) {
            cb = this.mNotedWatchers.get(listener);
            if (cb != null) {
                return;
            }
            cb = new IAppOpsNotedCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void opNoted(int op, int uid, String packageName, String attributionTag, int flags, int mode) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> {
                            if (AppOpsManager.sAppOpInfos[op].name != null) {
                                listener.onOpNoted(AppOpsManager.sAppOpInfos[op].name, uid, packageName, attributionTag, flags, mode);
                            }
                        });
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            };
            this.mNotedWatchers.put(listener, cb);
        }
        try {
            this.mService.startWatchingNoted(ops, cb);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void stopWatchingNoted(OnOpNotedListener callback) {
        ArrayMap<OnOpNotedListener, IAppOpsNotedCallback> arrayMap = this.mNotedWatchers;
        synchronized (arrayMap) {
            IAppOpsNotedCallback cb = this.mNotedWatchers.remove(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingNoted(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    private String buildSecurityExceptionMsg(int op, int uid, String packageName) {
        return packageName + " from uid " + uid + " not allowed to perform " + AppOpsManager.sAppOpInfos[op].simpleName;
    }

    @UnsupportedAppUsage
    public static int strOpToOp(String op) {
        Integer val = sOpStrToOp.get(op);
        if (val == null) {
            throw new IllegalArgumentException("Unknown operation string: " + op);
        }
        return val;
    }

    public int unsafeCheckOp(String op, int uid, String packageName) {
        return this.checkOp(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    @Deprecated
    public int checkOp(String op, int uid, String packageName) {
        return this.checkOp(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    public int unsafeCheckOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    @Deprecated
    public int checkOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    public int unsafeCheckOpRaw(String op, int uid, String packageName) {
        return this.unsafeCheckOpRawNoThrow(op, uid, packageName);
    }

    public int unsafeCheckOpRawNoThrow(String op, int uid, String packageName) {
        return this.unsafeCheckOpRawNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    public int unsafeCheckOpRawNoThrow(int op, int uid, String packageName) {
        try {
            return this.mService.checkOperationRaw(op, uid, packageName, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int noteOp(String op, int uid, String packageName) {
        return this.noteOp(op, uid, packageName, null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #noteOp(java.lang.String, int, java.lang.String, java.lang.String, java.lang.String)} instead")
    public int noteOp(int op) {
        return this.noteOp(op, Process.myUid(), this.mContext.getOpPackageName(), null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #noteOp(java.lang.String, int, java.lang.String, java.lang.String, java.lang.String)} instead")
    public int noteOp(int op, int uid, String packageName) {
        return this.noteOp(op, uid, packageName, null, null);
    }

    public int noteOp(String op, int uid, String packageName, String attributionTag, String message) {
        return this.noteOp(AppOpsManager.strOpToOp(op), uid, packageName, attributionTag, message);
    }

    public int noteOp(int op, int uid, String packageName, String attributionTag, String message) {
        int mode = this.noteOpNoThrow(op, uid, packageName, attributionTag, message);
        if (mode == 2) {
            throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
        }
        return mode;
    }

    @Deprecated
    public int noteOpNoThrow(String op, int uid, String packageName) {
        return this.noteOpNoThrow(op, uid, packageName, null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #noteOpNoThrow(java.lang.String, int, java.lang.String, java.lang.String, java.lang.String)} instead")
    public int noteOpNoThrow(int op, int uid, String packageName) {
        return this.noteOpNoThrow(op, uid, packageName, null, null);
    }

    public int noteOpNoThrow(String op, int uid, String packageName, String attributionTag, String message) {
        return this.noteOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName, attributionTag, message);
    }

    public int noteOpNoThrow(int op, int uid, String packageName, String attributionTag, String message) {
        try {
            SyncNotedAppOp syncOp;
            boolean shouldCollectMessage;
            this.collectNoteOpCallsForValidation(op);
            int collectionMode = this.getNotedOpCollectionMode(uid, packageName, op);
            boolean bl = shouldCollectMessage = Process.myUid() == 1000;
            if (collectionMode == 3 && message == null) {
                message = AppOpsManager.getFormattedStackTrace();
                shouldCollectMessage = true;
            }
            if ((syncOp = this.mService.noteOperation(op, uid, packageName, attributionTag, collectionMode == 3, message, shouldCollectMessage)).getOpMode() == 0) {
                if (collectionMode == 1) {
                    this.collectNotedOpForSelf(syncOp);
                } else if (collectionMode == 2) {
                    AppOpsManager.collectNotedOpSync(syncOp);
                }
            }
            return syncOp.getOpMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int noteProxyOp(String op, String proxiedPackageName) {
        return this.noteProxyOp(op, proxiedPackageName, Binder.getCallingUid(), null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #noteProxyOp(java.lang.String, java.lang.String, int, java.lang.String, java.lang.String)} instead")
    public int noteProxyOp(int op, String proxiedPackageName) {
        return this.noteProxyOp(op, proxiedPackageName, Binder.getCallingUid(), null, null);
    }

    public int noteProxyOp(int op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        return this.noteProxyOp(op, new AttributionSource(this.mContext.getAttributionSource(), new AttributionSource(proxiedUid, -1, proxiedPackageName, proxiedAttributionTag, this.mContext.getAttributionSource().getToken())), message, false);
    }

    public int noteProxyOp(String op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        return this.noteProxyOp(AppOpsManager.strOpToOp(op), proxiedPackageName, proxiedUid, proxiedAttributionTag, message);
    }

    public int noteProxyOp(int op, AttributionSource attributionSource, String message, boolean skipProxyOperation) {
        int mode = this.noteProxyOpNoThrow(op, attributionSource, message, skipProxyOperation);
        if (mode == 2) {
            throw new SecurityException("Proxy package " + attributionSource.getPackageName() + " from uid " + attributionSource.getUid() + " or calling package " + attributionSource.getNextPackageName() + " from uid " + attributionSource.getNextUid() + " not allowed to perform " + AppOpsManager.sAppOpInfos[op].simpleName);
        }
        return mode;
    }

    @Deprecated
    public int noteProxyOpNoThrow(String op, String proxiedPackageName) {
        return this.noteProxyOpNoThrow(op, proxiedPackageName, Binder.getCallingUid(), null, null);
    }

    @Deprecated
    public int noteProxyOpNoThrow(String op, String proxiedPackageName, int proxiedUid) {
        return this.noteProxyOpNoThrow(op, proxiedPackageName, proxiedUid, null, null);
    }

    public int noteProxyOpNoThrow(String op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        return this.noteProxyOpNoThrow(AppOpsManager.strOpToOp(op), new AttributionSource(this.mContext.getAttributionSource(), new AttributionSource(proxiedUid, -1, proxiedPackageName, proxiedAttributionTag, this.mContext.getAttributionSource().getToken())), message, false);
    }

    public int noteProxyOpNoThrow(int op, AttributionSource attributionSource, String message, boolean skipProxyOperation) {
        int myUid = Process.myUid();
        try {
            SyncNotedAppOp syncOp;
            boolean shouldCollectMessage;
            this.collectNoteOpCallsForValidation(op);
            int collectionMode = this.getNotedOpCollectionMode(attributionSource.getNextUid(), attributionSource.getNextAttributionTag(), op);
            boolean bl = shouldCollectMessage = myUid == 1000;
            if (collectionMode == 3 && message == null) {
                message = AppOpsManager.getFormattedStackTrace();
                shouldCollectMessage = true;
            }
            if ((syncOp = this.mService.noteProxyOperation(op, attributionSource, collectionMode == 3, message, shouldCollectMessage, skipProxyOperation)).getOpMode() == 0) {
                if (collectionMode == 1) {
                    this.collectNotedOpForSelf(syncOp);
                } else if (collectionMode == 2 && (this.mContext.checkPermission("android.permission.UPDATE_APP_OPS_STATS", -1, myUid) == 0 || Binder.getCallingUid() == attributionSource.getNextUid())) {
                    AppOpsManager.collectNotedOpSync(syncOp);
                }
            }
            return syncOp.getOpMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static String getComponentPackageNameFromString(String from) {
        ComponentName componentName = from != null ? ComponentName.unflattenFromString(from) : null;
        return componentName != null ? componentName.getPackageName() : "";
    }

    private static boolean isPackagePreInstalled(Context context, String packageName, int userId) {
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo info = pm.getApplicationInfoAsUser(packageName, 0, userId);
            return (info.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @UnsupportedAppUsage
    public int checkOp(int op, int uid, String packageName) {
        try {
            int mode = this.mService.checkOperation(op, uid, packageName);
            if (mode == 2) {
                throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public int checkOpNoThrow(int op, int uid, String packageName) {
        try {
            int mode = this.mService.checkOperation(op, uid, packageName);
            return mode == 4 ? 0 : mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void checkPackage(int uid, String packageName) {
        try {
            if (this.mService.checkPackage(uid, packageName) != 0) {
                throw new SecurityException("Package " + packageName + " does not belong to " + uid);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int checkAudioOp(int op, int stream, int uid, String packageName) {
        try {
            int mode = this.mService.checkAudioOperation(op, stream, uid, packageName);
            if (mode == 2) {
                throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int checkAudioOpNoThrow(int op, int stream, int uid, String packageName) {
        try {
            return this.mService.checkAudioOperation(op, stream, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Create own local {@link android.os.Binder}")
    public static IBinder getToken(IAppOpsService service) {
        return AppOpsManager.getClientId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBinder getClientId() {
        Class<AppOpsManager> clazz = AppOpsManager.class;
        synchronized (AppOpsManager.class) {
            if (sClientId == null) {
                sClientId = new Binder();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sClientId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IAppOpsService getService() {
        Object object = sLock;
        synchronized (object) {
            if (sService == null) {
                sService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
            }
            return sService;
        }
    }

    @Deprecated
    public int startOp(String op, int uid, String packageName) {
        return this.startOp(op, uid, packageName, null, null);
    }

    @Deprecated
    public int startOp(int op) {
        return this.startOp(op, Process.myUid(), this.mContext.getOpPackageName(), false, null, null);
    }

    @Deprecated
    public int startOp(int op, int uid, String packageName) {
        return this.startOp(op, uid, packageName, false, null, null);
    }

    @Deprecated
    public int startOp(int op, int uid, String packageName, boolean startIfModeDefault) {
        return this.startOp(op, uid, packageName, startIfModeDefault, null, null);
    }

    public int startOp(String op, int uid, String packageName, String attributionTag, String message) {
        return this.startOp(AppOpsManager.strOpToOp(op), uid, packageName, false, attributionTag, message);
    }

    public int startOp(int op, int uid, String packageName, boolean startIfModeDefault, String attributionTag, String message) {
        int mode = this.startOpNoThrow(op, uid, packageName, startIfModeDefault, attributionTag, message);
        if (mode == 2) {
            throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
        }
        return mode;
    }

    @Deprecated
    public int startOpNoThrow(String op, int uid, String packageName) {
        return this.startOpNoThrow(op, uid, packageName, null, null);
    }

    @Deprecated
    public int startOpNoThrow(int op, int uid, String packageName) {
        return this.startOpNoThrow(op, uid, packageName, false, null, null);
    }

    @Deprecated
    public int startOpNoThrow(int op, int uid, String packageName, boolean startIfModeDefault) {
        return this.startOpNoThrow(op, uid, packageName, startIfModeDefault, null, null);
    }

    public int startOpNoThrow(String op, int uid, String packageName, String attributionTag, String message) {
        return this.startOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName, false, attributionTag, message);
    }

    public int startOpNoThrow(int op, int uid, String packageName, boolean startIfModeDefault, String attributionTag, String message) {
        return this.startOpNoThrow(this.mContext.getAttributionSource().getToken(), op, uid, packageName, startIfModeDefault, attributionTag, message);
    }

    public int startOpNoThrow(IBinder token, int op, int uid, String packageName, boolean startIfModeDefault, String attributionTag, String message) {
        return this.startOpNoThrow(token, op, uid, packageName, startIfModeDefault, attributionTag, message, 0, -1);
    }

    public int startOpNoThrow(IBinder token, int op, int uid, String packageName, boolean startIfModeDefault, String attributionTag, String message, int attributionFlags, int attributionChainId) {
        try {
            SyncNotedAppOp syncOp;
            boolean shouldCollectMessage;
            this.collectNoteOpCallsForValidation(op);
            int collectionMode = this.getNotedOpCollectionMode(uid, packageName, op);
            boolean bl = shouldCollectMessage = Process.myUid() == 1000;
            if (collectionMode == 3 && message == null) {
                message = AppOpsManager.getFormattedStackTrace();
                shouldCollectMessage = true;
            }
            if ((syncOp = this.mService.startOperation(token, op, uid, packageName, attributionTag, startIfModeDefault, collectionMode == 3, message, shouldCollectMessage, attributionFlags, attributionChainId)).getOpMode() == 0) {
                if (collectionMode == 1) {
                    this.collectNotedOpForSelf(syncOp);
                } else if (collectionMode == 2) {
                    AppOpsManager.collectNotedOpSync(syncOp);
                }
            }
            return syncOp.getOpMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int startProxyOp(String op, int proxiedUid, String proxiedPackageName, String proxiedAttributionTag, String message) {
        return this.startProxyOp(op, new AttributionSource(this.mContext.getAttributionSource(), new AttributionSource(proxiedUid, -1, proxiedPackageName, proxiedAttributionTag, this.mContext.getAttributionSource().getToken())), message, false);
    }

    public int startProxyOp(String op, AttributionSource attributionSource, String message, boolean skipProxyOperation) {
        int mode = this.startProxyOpNoThrow(AppOpsManager.strOpToOp(op), attributionSource, message, skipProxyOperation);
        if (mode == 2) {
            throw new SecurityException("Proxy package " + attributionSource.getPackageName() + " from uid " + attributionSource.getUid() + " or calling package " + attributionSource.getNextPackageName() + " from uid " + attributionSource.getNextUid() + " not allowed to perform " + op);
        }
        return mode;
    }

    public int startProxyOpNoThrow(String op, int proxiedUid, String proxiedPackageName, String proxiedAttributionTag, String message) {
        return this.startProxyOpNoThrow(AppOpsManager.strOpToOp(op), new AttributionSource(this.mContext.getAttributionSource(), new AttributionSource(proxiedUid, -1, proxiedPackageName, proxiedAttributionTag, this.mContext.getAttributionSource().getToken())), message, false);
    }

    public int startProxyOpNoThrow(int op, AttributionSource attributionSource, String message, boolean skipProxyOperation) {
        return this.startProxyOpNoThrow(attributionSource.getToken(), op, attributionSource, message, skipProxyOperation, 0, 0, -1);
    }

    public int startProxyOpNoThrow(IBinder clientId, int op, AttributionSource attributionSource, String message, boolean skipProxyOperation, int proxyAttributionFlags, int proxiedAttributionFlags, int attributionChainId) {
        try {
            SyncNotedAppOp syncOp;
            boolean shouldCollectMessage;
            this.collectNoteOpCallsForValidation(op);
            int collectionMode = this.getNotedOpCollectionMode(attributionSource.getNextUid(), attributionSource.getNextPackageName(), op);
            boolean bl = shouldCollectMessage = Process.myUid() == 1000;
            if (collectionMode == 3 && message == null) {
                message = AppOpsManager.getFormattedStackTrace();
                shouldCollectMessage = true;
            }
            if ((syncOp = this.mService.startProxyOperation(clientId, op, attributionSource, false, collectionMode == 3, message, shouldCollectMessage, skipProxyOperation, proxyAttributionFlags, proxiedAttributionFlags, attributionChainId)).getOpMode() == 0) {
                if (collectionMode == 1) {
                    this.collectNotedOpForSelf(syncOp);
                } else if (collectionMode == 2 && (this.mContext.checkPermission("android.permission.UPDATE_APP_OPS_STATS", -1, Process.myUid()) == 0 || Binder.getCallingUid() == attributionSource.getNextUid())) {
                    AppOpsManager.collectNotedOpSync(syncOp);
                }
            }
            return syncOp.getOpMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void finishOp(int op) {
        this.finishOp(op, Process.myUid(), this.mContext.getOpPackageName(), null);
    }

    public void finishOp(String op, int uid, String packageName) {
        this.finishOp(AppOpsManager.strOpToOp(op), uid, packageName, null);
    }

    public void finishOp(String op, int uid, String packageName, String attributionTag) {
        this.finishOp(AppOpsManager.strOpToOp(op), uid, packageName, attributionTag);
    }

    public void finishOp(int op, int uid, String packageName) {
        this.finishOp(op, uid, packageName, null);
    }

    public void finishOp(int op, int uid, String packageName, String attributionTag) {
        this.finishOp(this.mContext.getAttributionSource().getToken(), op, uid, packageName, attributionTag);
    }

    public void finishOp(IBinder token, int op, int uid, String packageName, String attributionTag) {
        try {
            this.mService.finishOperation(token, op, uid, packageName, attributionTag);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void finishProxyOp(String op, int proxiedUid, String proxiedPackageName, String proxiedAttributionTag) {
        IBinder token = this.mContext.getAttributionSource().getToken();
        this.finishProxyOp(token, op, new AttributionSource(this.mContext.getAttributionSource(), new AttributionSource(proxiedUid, -1, proxiedPackageName, proxiedAttributionTag, token)), false);
    }

    public void finishProxyOp(IBinder clientId, String op, AttributionSource attributionSource, boolean skipProxyOperation) {
        try {
            this.mService.finishProxyOperation(clientId, AppOpsManager.strOpToOp(op), attributionSource, skipProxyOperation);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isOpActive(String op, int uid, String packageName) {
        return this.isOperationActive(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    public boolean isProxying(int op, String proxyAttributionTag, int proxiedUid, String proxiedPackageName) {
        try {
            return this.mService.isProxying(op, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), proxiedUid, proxiedPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void resetPackageOpsNoHistory(String packageName) {
        try {
            this.mService.resetPackageOpsNoHistory(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void startNotedAppOpsCollection(int callingUid) {
        sBinderThreadCallingUid.set(callingUid);
    }

    public static PausedNotedAppOpsCollection pauseNotedAppOpsCollection() {
        Integer previousUid = sBinderThreadCallingUid.get();
        if (previousUid != null) {
            ArrayMap<String, BitSet> previousCollectedNotedAppOps = sAppOpsNotedInThisBinderTransaction.get();
            sBinderThreadCallingUid.remove();
            sAppOpsNotedInThisBinderTransaction.remove();
            return new PausedNotedAppOpsCollection(previousUid, previousCollectedNotedAppOps);
        }
        return null;
    }

    public static void resumeNotedAppOpsCollection(PausedNotedAppOpsCollection prevCollection) {
        if (prevCollection != null) {
            sBinderThreadCallingUid.set(prevCollection.mUid);
            if (prevCollection.mCollectedNotedAppOps != null) {
                sAppOpsNotedInThisBinderTransaction.set(prevCollection.mCollectedNotedAppOps);
            }
        }
    }

    public static void finishNotedAppOpsCollection() {
        sBinderThreadCallingUid.remove();
        sAppOpsNotedInThisBinderTransaction.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectNotedOpForSelf(SyncNotedAppOp syncOp) {
        Object object = sLock;
        synchronized (object) {
            if (sOnOpNotedCallback != null) {
                sOnOpNotedCallback.onSelfNoted(syncOp);
            }
        }
        sMessageCollector.onSelfNoted(syncOp);
    }

    public static void collectNotedOpSync(SyncNotedAppOp syncOp) {
        BitSet appOpsNotedForAttribution;
        int op = sOpStrToOp.get(syncOp.getOp());
        ArrayMap<String, BitSet> appOpsNoted = sAppOpsNotedInThisBinderTransaction.get();
        if (appOpsNoted == null) {
            appOpsNoted = new ArrayMap(1);
            sAppOpsNotedInThisBinderTransaction.set(appOpsNoted);
        }
        if ((appOpsNotedForAttribution = appOpsNoted.get(syncOp.getAttributionTag())) == null) {
            appOpsNotedForAttribution = new BitSet(136);
            appOpsNoted.put(syncOp.getAttributionTag(), appOpsNotedForAttribution);
        }
        appOpsNotedForAttribution.set(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNotedOpCollectionMode(int uid, String packageName, int op) {
        if (packageName == null) {
            packageName = "android";
        }
        if (sAppOpsToNote[op] == 0) {
            boolean shouldCollectNotes;
            try {
                shouldCollectNotes = this.mService.shouldCollectNotes(op);
            }
            catch (RemoteException e) {
                return 0;
            }
            AppOpsManager.sAppOpsToNote[op] = shouldCollectNotes ? 2 : 1;
        }
        if (sAppOpsToNote[op] != 2) {
            return 0;
        }
        Object shouldCollectNotes = sLock;
        synchronized (shouldCollectNotes) {
            if (uid == Process.myUid() && packageName.equals(ActivityThread.currentOpPackageName())) {
                return 1;
            }
        }
        Integer binderUid = sBinderThreadCallingUid.get();
        if (binderUid != null && binderUid == uid) {
            return 2;
        }
        return 3;
    }

    public static void prefixParcelWithAppOpsIfNeeded(Parcel p) {
        ArrayMap<String, BitSet> notedAppOps = sAppOpsNotedInThisBinderTransaction.get();
        if (notedAppOps == null) {
            return;
        }
        p.writeInt(-127);
        int numAttributionWithNotesAppOps = notedAppOps.size();
        p.writeInt(numAttributionWithNotesAppOps);
        for (int i = 0; i < numAttributionWithNotesAppOps; ++i) {
            p.writeString(notedAppOps.keyAt(i));
            long[] notedOpsMask = notedAppOps.valueAt(i).toLongArray();
            for (int j = 0; j < 3; ++j) {
                if (j < notedOpsMask.length) {
                    p.writeLong(notedOpsMask[j]);
                    continue;
                }
                p.writeLong(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readAndLogNotedAppops(Parcel p) {
        int numAttributionsWithNotedAppOps = p.readInt();
        for (int i = 0; i < numAttributionsWithNotedAppOps; ++i) {
            String attributionTag = p.readString();
            long[] rawNotedAppOps = new long[3];
            for (int j = 0; j < rawNotedAppOps.length; ++j) {
                rawNotedAppOps[j] = p.readLong();
            }
            BitSet notedAppOps = BitSet.valueOf(rawNotedAppOps);
            if (notedAppOps.isEmpty()) continue;
            Object object = sLock;
            synchronized (object) {
                int code = notedAppOps.nextSetBit(0);
                while (code != -1) {
                    if (sOnOpNotedCallback != null) {
                        sOnOpNotedCallback.onNoted(new SyncNotedAppOp(code, attributionTag));
                    } else {
                        String message = AppOpsManager.getFormattedStackTrace();
                        sUnforwardedOps.add(new AsyncNotedAppOp(code, Process.myUid(), attributionTag, message, System_Delegate.currentTimeMillis()));
                        if (sUnforwardedOps.size() > 10) {
                            sUnforwardedOps.remove(0);
                        }
                    }
                    code = notedAppOps.nextSetBit(code + 1);
                }
            }
            int code = notedAppOps.nextSetBit(0);
            while (code != -1) {
                sMessageCollector.onNoted(new SyncNotedAppOp(code, attributionTag));
                code = notedAppOps.nextSetBit(code + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnOpNotedCallback(Executor asyncExecutor, OnOpNotedCallback callback) {
        Preconditions.checkState(callback == null == (asyncExecutor == null));
        Object object = sLock;
        synchronized (object) {
            if (callback == null) {
                Preconditions.checkState(sOnOpNotedCallback != null, "No callback is currently registered");
                try {
                    this.mService.stopWatchingAsyncNoted(this.mContext.getPackageName(), AppOpsManager.sOnOpNotedCallback.mAsyncCb);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
                sOnOpNotedCallback = null;
            } else {
                Preconditions.checkState(sOnOpNotedCallback == null, "Another callback is already registered");
                callback.mAsyncExecutor = asyncExecutor;
                sOnOpNotedCallback = callback;
                List<AsyncNotedAppOp> missedAsyncOps = null;
                try {
                    this.mService.startWatchingAsyncNoted(this.mContext.getPackageName(), AppOpsManager.sOnOpNotedCallback.mAsyncCb);
                    missedAsyncOps = this.mService.extractAsyncOps(this.mContext.getPackageName());
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
                OnOpNotedCallback onOpNotedCallback = sOnOpNotedCallback;
                if (onOpNotedCallback != null && missedAsyncOps != null) {
                    int numMissedAsyncOps = missedAsyncOps.size();
                    for (int i = 0; i < numMissedAsyncOps; ++i) {
                        AsyncNotedAppOp asyncNotedAppOp = missedAsyncOps.get(i);
                        onOpNotedCallback.getAsyncNotedExecutor().execute(() -> onOpNotedCallback.onAsyncNoted(asyncNotedAppOp));
                    }
                }
                AppOpsManager appOpsManager = this;
                synchronized (appOpsManager) {
                    int numMissedSyncOps = sUnforwardedOps.size();
                    if (onOpNotedCallback != null) {
                        for (int i = 0; i < numMissedSyncOps; ++i) {
                            AsyncNotedAppOp syncNotedAppOp = sUnforwardedOps.get(i);
                            onOpNotedCallback.getAsyncNotedExecutor().execute(() -> onOpNotedCallback.onAsyncNoted(syncNotedAppOp));
                        }
                    }
                    sUnforwardedOps.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @Deprecated
    public void setNotedAppOpsCollector(AppOpsCollector collector) {
        Object object = sLock;
        synchronized (object) {
            if (collector != null) {
                if (AppOpsManager.isListeningForOpNoted()) {
                    this.setOnOpNotedCallback(null, null);
                }
                this.setOnOpNotedCallback(new HandlerExecutor(Handler.getMain()), collector);
            } else if (sOnOpNotedCallback != null) {
                this.setOnOpNotedCallback(null, null);
            }
        }
    }

    public static boolean isListeningForOpNoted() {
        return sOnOpNotedCallback != null || AppOpsManager.isCollectingStackTraces();
    }

    private static boolean isCollectingStackTraces() {
        return sConfig.getSampledOpCode() != -1 || sConfig.getAcceptableLeftDistance() != 0 || sConfig.getExpirationTimeSinceBootMillis() < SystemClock.elapsedRealtime();
    }

    private static String getFormattedStackTrace() {
        StackTraceElement[] trace = new Exception().getStackTrace();
        int firstInteresting = 0;
        int i = 0;
        while (i < trace.length && (trace[i].getClassName().startsWith(AppOpsManager.class.getName()) || trace[i].getClassName().startsWith(Parcel.class.getName()) || trace[i].getClassName().contains("$Stub$Proxy") || trace[i].getClassName().startsWith(DatabaseUtils.class.getName()) || trace[i].getClassName().startsWith("android.content.ContentProviderProxy") || trace[i].getClassName().startsWith(ContentResolver.class.getName()))) {
            firstInteresting = i++;
        }
        int lastInteresting = trace.length - 1;
        int i2 = trace.length - 1;
        while (i2 >= 0 && (trace[i2].getClassName().startsWith(HandlerThread.class.getName()) || trace[i2].getClassName().startsWith(Handler.class.getName()) || trace[i2].getClassName().startsWith(Looper.class.getName()) || trace[i2].getClassName().startsWith(Binder.class.getName()) || trace[i2].getClassName().startsWith(RuntimeInit.class.getName()) || trace[i2].getClassName().startsWith(ZygoteInit.class.getName()) || trace[i2].getClassName().startsWith(ActivityThread.class.getName()) || trace[i2].getClassName().startsWith(Method.class.getName()) || trace[i2].getClassName().startsWith("com.android.server.SystemServer"))) {
            lastInteresting = i2--;
        }
        StringBuilder sb = new StringBuilder();
        for (int i3 = firstInteresting; i3 <= lastInteresting; ++i3) {
            if (sFullLog == null) {
                try {
                    sFullLog = DeviceConfig.getBoolean("privacy", FULL_LOG, false);
                }
                catch (Exception e) {
                    sFullLog = false;
                }
            }
            if (i3 != firstInteresting) {
                sb.append('\n');
            }
            if (!sFullLog.booleanValue() && sb.length() + trace[i3].toString().length() > 600) break;
            sb.append(trace[i3]);
        }
        return sb.toString();
    }

    public boolean isOperationActive(int code, int uid, String packageName) {
        try {
            return this.mService.isOperationActive(code, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void setHistoryParameters(int mode, long baseSnapshotInterval, int compressionStep) {
        try {
            this.mService.setHistoryParameters(mode, baseSnapshotInterval, compressionStep);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void offsetHistory(long offsetMillis) {
        try {
            this.mService.offsetHistory(offsetMillis);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void addHistoricalOps(HistoricalOps ops) {
        try {
            this.mService.addHistoricalOps(ops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void resetHistoryParameters() {
        try {
            this.mService.resetHistoryParameters();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void clearHistory() {
        try {
            this.mService.clearHistory();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_APPOPS")
    public void rebootHistory(long offlineDurationMillis) {
        try {
            this.mService.rebootHistory(offlineDurationMillis);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public RuntimeAppOpAccessMessage collectRuntimeAppOpAccessMessage() {
        try {
            return this.mService.collectRuntimeAppOpAccessMessage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static String[] getOpStrs() {
        String[] opStrs = new String[sAppOpInfos.length];
        for (int i = 0; i < sAppOpInfos.length; ++i) {
            opStrs[i] = AppOpsManager.sAppOpInfos[i].name;
        }
        return opStrs;
    }

    public static int getNumOps() {
        return 136;
    }

    private static NoteOpEvent getLastEvent(LongSparseArray<NoteOpEvent> events, int beginUidState, int endUidState, int flags) {
        if (events == null) {
            return null;
        }
        NoteOpEvent lastEvent = null;
        while (flags != 0) {
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            for (int uidState : UID_STATES) {
                if (uidState < beginUidState || uidState > endUidState) continue;
                long key = AppOpsManager.makeKey(uidState, flag);
                NoteOpEvent event = events.get(key);
                if (lastEvent != null && (event == null || event.getNoteTime() <= lastEvent.getNoteTime())) continue;
                lastEvent = event;
            }
        }
        return lastEvent;
    }

    private static boolean equalsLongSparseLongArray(LongSparseLongArray a, LongSparseLongArray b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        int numEntries = a.size();
        for (int i = 0; i < numEntries; ++i) {
            if (a.keyAt(i) == b.keyAt(i) && a.valueAt(i) == b.valueAt(i)) continue;
            return false;
        }
        return true;
    }

    private static void writeLongSparseLongArrayToParcel(LongSparseLongArray array2, Parcel parcel) {
        if (array2 != null) {
            int size = array2.size();
            parcel.writeInt(size);
            for (int i = 0; i < size; ++i) {
                parcel.writeLong(array2.keyAt(i));
                parcel.writeLong(array2.valueAt(i));
            }
        } else {
            parcel.writeInt(-1);
        }
    }

    private static LongSparseLongArray readLongSparseLongArrayFromParcel(Parcel parcel) {
        int size = parcel.readInt();
        if (size < 0) {
            return null;
        }
        LongSparseLongArray array2 = new LongSparseLongArray(size);
        for (int i = 0; i < size; ++i) {
            array2.append(parcel.readLong(), parcel.readLong());
        }
        return array2;
    }

    private static void writeDiscreteAccessArrayToParcel(List<AttributedOpEntry> array2, Parcel parcel, int flags) {
        ParceledListSlice<AttributedOpEntry> listSlice = array2 == null ? null : new ParceledListSlice<AttributedOpEntry>(array2);
        parcel.writeParcelable(listSlice, flags);
    }

    private static List<AttributedOpEntry> readDiscreteAccessArrayFromParcel(Parcel parcel) {
        ParceledListSlice listSlice = parcel.readParcelable(null, ParceledListSlice.class);
        return listSlice == null ? null : listSlice.getList();
    }

    private static LongSparseArray<Object> collectKeys(LongSparseLongArray array2, LongSparseArray<Object> result) {
        if (array2 != null) {
            if (result == null) {
                result = new LongSparseArray();
            }
            int accessSize = array2.size();
            for (int i = 0; i < accessSize; ++i) {
                result.put(array2.keyAt(i), null);
            }
        }
        return result;
    }

    public static String uidStateToString(int uidState) {
        switch (uidState) {
            case 100: {
                return "UID_STATE_PERSISTENT";
            }
            case 200: {
                return "UID_STATE_TOP";
            }
            case 300: {
                return "UID_STATE_FOREGROUND_SERVICE_LOCATION";
            }
            case 400: {
                return "UID_STATE_FOREGROUND_SERVICE";
            }
            case 500: {
                return "UID_STATE_FOREGROUND";
            }
            case 600: {
                return "UID_STATE_BACKGROUND";
            }
            case 700: {
                return "UID_STATE_CACHED";
            }
        }
        return "UNKNOWN";
    }

    public static int parseHistoricalMode(String mode) {
        switch (mode) {
            case "HISTORICAL_MODE_ENABLED_ACTIVE": {
                return 1;
            }
            case "HISTORICAL_MODE_ENABLED_PASSIVE": {
                return 2;
            }
        }
        return 0;
    }

    public static String historicalModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "HISTORICAL_MODE_DISABLED";
            }
            case 1: {
                return "HISTORICAL_MODE_ENABLED_ACTIVE";
            }
            case 2: {
                return "HISTORICAL_MODE_ENABLED_PASSIVE";
            }
        }
        return "UNKNOWN";
    }

    private static int getSystemAlertWindowDefault() {
        Application context = ActivityThread.currentApplication();
        if (context == null) {
            return 3;
        }
        PackageManager pm = ((Context)context).getPackageManager();
        if (null == pm) {
            return 3;
        }
        if (ActivityManager.isLowRamDeviceStatic() && !pm.hasSystemFeature("android.software.leanback", 0)) {
            return 1;
        }
        return 3;
    }

    public static int leftCircularDistance(int from, int to, int size) {
        return (to + size - from) % size;
    }

    private void collectNoteOpCallsForValidation(int op) {
    }

    private static List<AttributedOpEntry> deduplicateDiscreteEvents(List<AttributedOpEntry> list) {
        int n = list.size();
        int i = 0;
        int j = 0;
        int k = 0;
        while (j < n) {
            long currentAccessTime = list.get(j).getLastAccessTime(31);
            for (k = j + 1; k < n && list.get(k).getLastAccessTime(31) == currentAccessTime; ++k) {
            }
            list.set(i, AppOpsManager.mergeAttributedOpEntries(list.subList(j, k)));
            ++i;
            j = k;
        }
        while (i < n) {
            list.remove(list.size() - 1);
            ++i;
        }
        return list;
    }

    private static AttributedOpEntry mergeAttributedOpEntries(List<AttributedOpEntry> opEntries) {
        if (opEntries.size() == 1) {
            return opEntries.get(0);
        }
        LongSparseArray<NoteOpEvent> accessEvents = new LongSparseArray<NoteOpEvent>();
        LongSparseArray<NoteOpEvent> rejectEvents = new LongSparseArray<NoteOpEvent>();
        int opCount = opEntries.size();
        for (int i = 0; i < opCount; ++i) {
            AttributedOpEntry a = opEntries.get(i);
            ArraySet<Long> keys = a.collectKeys();
            int keyCount = keys.size();
            for (int k = 0; k < keyCount; ++k) {
                long key = keys.valueAt(k);
                int uidState = AppOpsManager.extractUidStateFromKey(key);
                int flags = AppOpsManager.extractFlagsFromKey(key);
                NoteOpEvent access = a.getLastAccessEvent(uidState, uidState, flags);
                NoteOpEvent reject = a.getLastRejectEvent(uidState, uidState, flags);
                if (access != null) {
                    NoteOpEvent existingAccess = accessEvents.get(key);
                    if (existingAccess == null || existingAccess.getDuration() == -1L) {
                        accessEvents.append(key, access);
                    } else if (existingAccess.mProxy == null && access.mProxy != null) {
                        existingAccess.mProxy = access.mProxy;
                    }
                }
                if (reject == null) continue;
                rejectEvents.append(key, reject);
            }
        }
        return new AttributedOpEntry(opEntries.get((int)0).mOp, false, accessEvents, rejectEvents);
    }

    static {
        sLock = new Object();
        sUnforwardedOps = new ArrayList();
        sMessageCollector = new OnOpNotedCallback(){

            @Override
            public void onNoted(SyncNotedAppOp op) {
                this.reportStackTraceIfNeeded(op);
            }

            @Override
            public void onAsyncNoted(AsyncNotedAppOp asyncOp) {
            }

            @Override
            public void onSelfNoted(SyncNotedAppOp op) {
                this.reportStackTraceIfNeeded(op);
            }

            private void reportStackTraceIfNeeded(SyncNotedAppOp op) {
                if (!AppOpsManager.isCollectingStackTraces()) {
                    return;
                }
                MessageSamplingConfig config = sConfig;
                if (AppOpsManager.leftCircularDistance(AppOpsManager.strOpToOp(op.getOp()), config.getSampledOpCode(), 136) <= config.getAcceptableLeftDistance() || config.getExpirationTimeSinceBootMillis() < SystemClock.elapsedRealtime()) {
                    String stackTrace = AppOpsManager.getFormattedStackTrace();
                    try {
                        String packageName = ActivityThread.currentOpPackageName();
                        sConfig = AppOpsManager.getService().reportRuntimeAppOpAccessMessageAndGetConfig(packageName == null ? "" : packageName, op, stackTrace);
                    }
                    catch (RemoteException e) {
                        e.rethrowFromSystemServer();
                    }
                }
            }
        };
        MODE_NAMES = new String[]{"allow", "ignore", "deny", "default", "foreground"};
        UID_STATES = new int[]{100, 200, 300, 400, 500, 600, 700};
        sAppOpsToNote = new byte[136];
        RUNTIME_PERMISSION_OPS = new int[]{4, 5, 62, 8, 9, 20, 16, 14, 19, 18, 57, 59, 60, 90, 0, 1, 51, 65, 13, 6, 7, 52, 53, 54, 69, 74, 27, 26, 56, 79, 81, 82, 83, 84, 85, 86, 77, 111, 114, 112, 116, 11};
        APP_OP_PERMISSION_PACKAGE_OPS = new int[]{25, 24, 23, 66, 76, 80, 75, 68, 95};
        APP_OP_PERMISSION_UID_OPS = new int[]{92, 93, 103, 105, 107, 110, 61, 122, 123, 127, 131, 133};
        sAppOpInfos = new AppOpInfo[]{new AppOpInfo.Builder(0, OPSTR_COARSE_LOCATION, "COARSE_LOCATION").setPermission("android.permission.ACCESS_COARSE_LOCATION").setRestriction("no_share_location").setAllowSystemRestrictionBypass(new RestrictionBypass(true, false, false)).setDefaultMode(0).build(), new AppOpInfo.Builder(1, OPSTR_FINE_LOCATION, "FINE_LOCATION").setPermission("android.permission.ACCESS_FINE_LOCATION").setRestriction("no_share_location").setAllowSystemRestrictionBypass(new RestrictionBypass(true, false, false)).setDefaultMode(0).build(), new AppOpInfo.Builder(2, OPSTR_GPS, "GPS").setSwitchCode(0).setRestriction("no_share_location").setDefaultMode(0).build(), new AppOpInfo.Builder(3, OPSTR_VIBRATE, "VIBRATE").setSwitchCode(3).setPermission("android.permission.VIBRATE").setDefaultMode(0).build(), new AppOpInfo.Builder(4, OPSTR_READ_CONTACTS, "READ_CONTACTS").setPermission("android.permission.READ_CONTACTS").setDefaultMode(0).build(), new AppOpInfo.Builder(5, OPSTR_WRITE_CONTACTS, "WRITE_CONTACTS").setPermission("android.permission.WRITE_CONTACTS").setDefaultMode(0).build(), new AppOpInfo.Builder(6, OPSTR_READ_CALL_LOG, "READ_CALL_LOG").setPermission("android.permission.READ_CALL_LOG").setRestriction("no_outgoing_calls").setDefaultMode(0).build(), new AppOpInfo.Builder(7, OPSTR_WRITE_CALL_LOG, "WRITE_CALL_LOG").setPermission("android.permission.WRITE_CALL_LOG").setRestriction("no_outgoing_calls").setDefaultMode(0).build(), new AppOpInfo.Builder(8, OPSTR_READ_CALENDAR, "READ_CALENDAR").setPermission("android.permission.READ_CALENDAR").setDefaultMode(0).build(), new AppOpInfo.Builder(9, OPSTR_WRITE_CALENDAR, "WRITE_CALENDAR").setPermission("android.permission.WRITE_CALENDAR").setDefaultMode(0).build(), new AppOpInfo.Builder(10, OPSTR_WIFI_SCAN, "WIFI_SCAN").setSwitchCode(0).setPermission("android.permission.ACCESS_WIFI_STATE").setRestriction("no_share_location").setAllowSystemRestrictionBypass(new RestrictionBypass(false, true, false)).setDefaultMode(0).build(), new AppOpInfo.Builder(11, OPSTR_POST_NOTIFICATION, "POST_NOTIFICATION").setPermission("android.permission.POST_NOTIFICATIONS").setDefaultMode(0).build(), new AppOpInfo.Builder(12, OPSTR_NEIGHBORING_CELLS, "NEIGHBORING_CELLS").setSwitchCode(0).setDefaultMode(0).build(), new AppOpInfo.Builder(13, OPSTR_CALL_PHONE, "CALL_PHONE").setSwitchCode(13).setPermission("android.permission.CALL_PHONE").setDefaultMode(0).build(), new AppOpInfo.Builder(14, OPSTR_READ_SMS, "READ_SMS").setPermission("android.permission.READ_SMS").setRestriction("no_sms").setDefaultMode(0).setDisableReset(true).build(), new AppOpInfo.Builder(15, OPSTR_WRITE_SMS, "WRITE_SMS").setRestriction("no_sms").setDefaultMode(1).setDisableReset(true).build(), new AppOpInfo.Builder(16, OPSTR_RECEIVE_SMS, "RECEIVE_SMS").setPermission("android.permission.RECEIVE_SMS").setRestriction("no_sms").setDefaultMode(0).setDisableReset(true).build(), new AppOpInfo.Builder(17, OPSTR_RECEIVE_EMERGENCY_BROADCAST, "RECEIVE_EMERGENCY_BROADCAST").setSwitchCode(16).setPermission("android.permission.RECEIVE_EMERGENCY_BROADCAST").setDefaultMode(0).build(), new AppOpInfo.Builder(18, OPSTR_RECEIVE_MMS, "RECEIVE_MMS").setPermission("android.permission.RECEIVE_MMS").setRestriction("no_sms").setDefaultMode(0).build(), new AppOpInfo.Builder(19, OPSTR_RECEIVE_WAP_PUSH, "RECEIVE_WAP_PUSH").setPermission("android.permission.RECEIVE_WAP_PUSH").setDefaultMode(0).setDisableReset(true).build(), new AppOpInfo.Builder(20, OPSTR_SEND_SMS, "SEND_SMS").setPermission("android.permission.SEND_SMS").setRestriction("no_sms").setDefaultMode(0).setDisableReset(true).build(), new AppOpInfo.Builder(21, OPSTR_READ_ICC_SMS, "READ_ICC_SMS").setSwitchCode(14).setPermission("android.permission.READ_SMS").setRestriction("no_sms").setDefaultMode(0).build(), new AppOpInfo.Builder(22, OPSTR_WRITE_ICC_SMS, "WRITE_ICC_SMS").setSwitchCode(15).setRestriction("no_sms").setDefaultMode(0).build(), new AppOpInfo.Builder(23, OPSTR_WRITE_SETTINGS, "WRITE_SETTINGS").setPermission("android.permission.WRITE_SETTINGS").build(), new AppOpInfo.Builder(24, OPSTR_SYSTEM_ALERT_WINDOW, "SYSTEM_ALERT_WINDOW").setPermission("android.permission.SYSTEM_ALERT_WINDOW").setRestriction("no_create_windows").setAllowSystemRestrictionBypass(new RestrictionBypass(false, true, false)).setDefaultMode(AppOpsManager.getSystemAlertWindowDefault()).build(), new AppOpInfo.Builder(25, OPSTR_ACCESS_NOTIFICATIONS, "ACCESS_NOTIFICATIONS").setPermission("android.permission.ACCESS_NOTIFICATIONS").setDefaultMode(0).build(), new AppOpInfo.Builder(26, OPSTR_CAMERA, "CAMERA").setPermission("android.permission.CAMERA").setRestriction("no_camera").setDefaultMode(0).build(), new AppOpInfo.Builder(27, OPSTR_RECORD_AUDIO, "RECORD_AUDIO").setPermission("android.permission.RECORD_AUDIO").setRestriction("no_record_audio").setAllowSystemRestrictionBypass(new RestrictionBypass(false, false, true)).setDefaultMode(0).build(), new AppOpInfo.Builder(28, OPSTR_PLAY_AUDIO, "PLAY_AUDIO").setDefaultMode(0).build(), new AppOpInfo.Builder(29, OPSTR_READ_CLIPBOARD, "READ_CLIPBOARD").setDefaultMode(0).build(), new AppOpInfo.Builder(30, OPSTR_WRITE_CLIPBOARD, "WRITE_CLIPBOARD").setDefaultMode(0).build(), new AppOpInfo.Builder(31, OPSTR_TAKE_MEDIA_BUTTONS, "TAKE_MEDIA_BUTTONS").setDefaultMode(0).build(), new AppOpInfo.Builder(32, OPSTR_TAKE_AUDIO_FOCUS, "TAKE_AUDIO_FOCUS").setDefaultMode(0).build(), new AppOpInfo.Builder(33, OPSTR_AUDIO_MASTER_VOLUME, "AUDIO_MASTER_VOLUME").setSwitchCode(33).setRestriction("no_adjust_volume").setDefaultMode(0).build(), new AppOpInfo.Builder(34, OPSTR_AUDIO_VOICE_VOLUME, "AUDIO_VOICE_VOLUME").setRestriction("no_adjust_volume").setDefaultMode(0).build(), new AppOpInfo.Builder(35, OPSTR_AUDIO_RING_VOLUME, "AUDIO_RING_VOLUME").setRestriction("no_adjust_volume").setDefaultMode(0).build(), new AppOpInfo.Builder(36, OPSTR_AUDIO_MEDIA_VOLUME, "AUDIO_MEDIA_VOLUME").setRestriction("no_adjust_volume").setDefaultMode(0).build(), new AppOpInfo.Builder(37, OPSTR_AUDIO_ALARM_VOLUME, "AUDIO_ALARM_VOLUME").setRestriction("no_adjust_volume").setDefaultMode(0).build(), new AppOpInfo.Builder(38, OPSTR_AUDIO_NOTIFICATION_VOLUME, "AUDIO_NOTIFICATION_VOLUME").setSwitchCode(38).setRestriction("no_adjust_volume").setDefaultMode(0).build(), new AppOpInfo.Builder(39, OPSTR_AUDIO_BLUETOOTH_VOLUME, "AUDIO_BLUETOOTH_VOLUME").setRestriction("no_adjust_volume").setDefaultMode(0).build(), new AppOpInfo.Builder(40, OPSTR_WAKE_LOCK, "WAKE_LOCK").setPermission("android.permission.WAKE_LOCK").setDefaultMode(0).build(), new AppOpInfo.Builder(41, OPSTR_MONITOR_LOCATION, "MONITOR_LOCATION").setSwitchCode(0).setRestriction("no_share_location").setDefaultMode(0).build(), new AppOpInfo.Builder(42, OPSTR_MONITOR_HIGH_POWER_LOCATION, "MONITOR_HIGH_POWER_LOCATION").setSwitchCode(0).setRestriction("no_share_location").setDefaultMode(0).build(), new AppOpInfo.Builder(43, OPSTR_GET_USAGE_STATS, "GET_USAGE_STATS").setPermission("android.permission.PACKAGE_USAGE_STATS").build(), new AppOpInfo.Builder(44, OPSTR_MUTE_MICROPHONE, "MUTE_MICROPHONE").setRestriction("no_unmute_microphone").setDefaultMode(0).build(), new AppOpInfo.Builder(45, OPSTR_TOAST_WINDOW, "TOAST_WINDOW").setRestriction("no_create_windows").setAllowSystemRestrictionBypass(new RestrictionBypass(false, true, false)).setDefaultMode(0).build(), new AppOpInfo.Builder(46, OPSTR_PROJECT_MEDIA, "PROJECT_MEDIA").setDefaultMode(1).build(), new AppOpInfo.Builder(47, OPSTR_ACTIVATE_VPN, "ACTIVATE_VPN").setDefaultMode(1).build(), new AppOpInfo.Builder(48, OPSTR_WRITE_WALLPAPER, "WRITE_WALLPAPER").setRestriction("no_wallpaper").setDefaultMode(0).build(), new AppOpInfo.Builder(49, OPSTR_ASSIST_STRUCTURE, "ASSIST_STRUCTURE").setDefaultMode(0).build(), new AppOpInfo.Builder(50, OPSTR_ASSIST_SCREENSHOT, "ASSIST_SCREENSHOT").setDefaultMode(0).build(), new AppOpInfo.Builder(51, OPSTR_READ_PHONE_STATE, "READ_PHONE_STATE").setPermission("android.permission.READ_PHONE_STATE").setDefaultMode(0).build(), new AppOpInfo.Builder(52, OPSTR_ADD_VOICEMAIL, "ADD_VOICEMAIL").setPermission("com.android.voicemail.permission.ADD_VOICEMAIL").setDefaultMode(0).build(), new AppOpInfo.Builder(53, OPSTR_USE_SIP, "USE_SIP").setPermission("android.permission.USE_SIP").setDefaultMode(0).build(), new AppOpInfo.Builder(54, OPSTR_PROCESS_OUTGOING_CALLS, "PROCESS_OUTGOING_CALLS").setSwitchCode(54).setPermission("android.permission.PROCESS_OUTGOING_CALLS").setDefaultMode(0).build(), new AppOpInfo.Builder(55, OPSTR_USE_FINGERPRINT, "USE_FINGERPRINT").setPermission("android.permission.USE_FINGERPRINT").setDefaultMode(0).build(), new AppOpInfo.Builder(56, OPSTR_BODY_SENSORS, "BODY_SENSORS").setPermission("android.permission.BODY_SENSORS").setDefaultMode(0).build(), new AppOpInfo.Builder(57, OPSTR_READ_CELL_BROADCASTS, "READ_CELL_BROADCASTS").setPermission("android.permission.READ_CELL_BROADCASTS").setDefaultMode(0).setDisableReset(true).build(), new AppOpInfo.Builder(58, OPSTR_MOCK_LOCATION, "MOCK_LOCATION").setDefaultMode(2).build(), new AppOpInfo.Builder(59, OPSTR_READ_EXTERNAL_STORAGE, "READ_EXTERNAL_STORAGE").setPermission("android.permission.READ_EXTERNAL_STORAGE").setDefaultMode(0).build(), new AppOpInfo.Builder(60, OPSTR_WRITE_EXTERNAL_STORAGE, "WRITE_EXTERNAL_STORAGE").setPermission("android.permission.WRITE_EXTERNAL_STORAGE").setDefaultMode(0).build(), new AppOpInfo.Builder(61, OPSTR_TURN_SCREEN_ON, "TURN_SCREEN_ON").setPermission("android.permission.TURN_SCREEN_ON").setDefaultMode(3).build(), new AppOpInfo.Builder(62, OPSTR_GET_ACCOUNTS, "GET_ACCOUNTS").setPermission("android.permission.GET_ACCOUNTS").setDefaultMode(0).build(), new AppOpInfo.Builder(63, OPSTR_RUN_IN_BACKGROUND, "RUN_IN_BACKGROUND").setDefaultMode(0).build(), new AppOpInfo.Builder(64, OPSTR_AUDIO_ACCESSIBILITY_VOLUME, "AUDIO_ACCESSIBILITY_VOLUME").setRestriction("no_adjust_volume").setDefaultMode(0).build(), new AppOpInfo.Builder(65, OPSTR_READ_PHONE_NUMBERS, "READ_PHONE_NUMBERS").setPermission("android.permission.READ_PHONE_NUMBERS").setDefaultMode(0).build(), new AppOpInfo.Builder(66, OPSTR_REQUEST_INSTALL_PACKAGES, "REQUEST_INSTALL_PACKAGES").setSwitchCode(66).setPermission("android.permission.REQUEST_INSTALL_PACKAGES").build(), new AppOpInfo.Builder(67, OPSTR_PICTURE_IN_PICTURE, "PICTURE_IN_PICTURE").setSwitchCode(67).setDefaultMode(0).build(), new AppOpInfo.Builder(68, OPSTR_INSTANT_APP_START_FOREGROUND, "INSTANT_APP_START_FOREGROUND").setPermission("android.permission.INSTANT_APP_FOREGROUND_SERVICE").build(), new AppOpInfo.Builder(69, OPSTR_ANSWER_PHONE_CALLS, "ANSWER_PHONE_CALLS").setSwitchCode(69).setPermission("android.permission.ANSWER_PHONE_CALLS").setDefaultMode(0).build(), new AppOpInfo.Builder(70, OPSTR_RUN_ANY_IN_BACKGROUND, "RUN_ANY_IN_BACKGROUND").setDefaultMode(0).build(), new AppOpInfo.Builder(71, OPSTR_CHANGE_WIFI_STATE, "CHANGE_WIFI_STATE").setSwitchCode(71).setPermission("android.permission.CHANGE_WIFI_STATE").setDefaultMode(0).build(), new AppOpInfo.Builder(72, OPSTR_REQUEST_DELETE_PACKAGES, "REQUEST_DELETE_PACKAGES").setPermission("android.permission.REQUEST_DELETE_PACKAGES").setDefaultMode(0).build(), new AppOpInfo.Builder(73, OPSTR_BIND_ACCESSIBILITY_SERVICE, "BIND_ACCESSIBILITY_SERVICE").setPermission("android.permission.BIND_ACCESSIBILITY_SERVICE").setDefaultMode(0).build(), new AppOpInfo.Builder(74, OPSTR_ACCEPT_HANDOVER, "ACCEPT_HANDOVER").setSwitchCode(74).setPermission("android.permission.ACCEPT_HANDOVER").setDefaultMode(0).build(), new AppOpInfo.Builder(75, OPSTR_MANAGE_IPSEC_TUNNELS, "MANAGE_IPSEC_TUNNELS").setPermission("android.permission.MANAGE_IPSEC_TUNNELS").setDefaultMode(2).build(), new AppOpInfo.Builder(76, OPSTR_START_FOREGROUND, "START_FOREGROUND").setPermission("android.permission.FOREGROUND_SERVICE").setDefaultMode(0).build(), new AppOpInfo.Builder(77, OPSTR_BLUETOOTH_SCAN, "BLUETOOTH_SCAN").setPermission("android.permission.BLUETOOTH_SCAN").setAllowSystemRestrictionBypass(new RestrictionBypass(false, true, false)).setDefaultMode(0).build(), new AppOpInfo.Builder(78, OPSTR_USE_BIOMETRIC, "USE_BIOMETRIC").setPermission("android.permission.USE_BIOMETRIC").setDefaultMode(0).build(), new AppOpInfo.Builder(79, OPSTR_ACTIVITY_RECOGNITION, "ACTIVITY_RECOGNITION").setPermission("android.permission.ACTIVITY_RECOGNITION").setDefaultMode(0).build(), new AppOpInfo.Builder(80, OPSTR_SMS_FINANCIAL_TRANSACTIONS, "SMS_FINANCIAL_TRANSACTIONS").setPermission("android.permission.SMS_FINANCIAL_TRANSACTIONS").setRestriction("no_sms").build(), new AppOpInfo.Builder(81, OPSTR_READ_MEDIA_AUDIO, "READ_MEDIA_AUDIO").setPermission("android.permission.READ_MEDIA_AUDIO").setDefaultMode(0).build(), new AppOpInfo.Builder(82, OPSTR_WRITE_MEDIA_AUDIO, "WRITE_MEDIA_AUDIO").setDefaultMode(2).build(), new AppOpInfo.Builder(83, OPSTR_READ_MEDIA_VIDEO, "READ_MEDIA_VIDEO").setPermission("android.permission.READ_MEDIA_VIDEO").setDefaultMode(0).build(), new AppOpInfo.Builder(84, OPSTR_WRITE_MEDIA_VIDEO, "WRITE_MEDIA_VIDEO").setDefaultMode(2).setDisableReset(true).build(), new AppOpInfo.Builder(85, OPSTR_READ_MEDIA_IMAGES, "READ_MEDIA_IMAGES").setPermission("android.permission.READ_MEDIA_IMAGES").setDefaultMode(0).build(), new AppOpInfo.Builder(86, OPSTR_WRITE_MEDIA_IMAGES, "WRITE_MEDIA_IMAGES").setDefaultMode(2).setDisableReset(true).build(), new AppOpInfo.Builder(87, OPSTR_LEGACY_STORAGE, "LEGACY_STORAGE").setDisableReset(true).build(), new AppOpInfo.Builder(88, OPSTR_ACCESS_ACCESSIBILITY, "ACCESS_ACCESSIBILITY").setDefaultMode(0).build(), new AppOpInfo.Builder(89, OPSTR_READ_DEVICE_IDENTIFIERS, "READ_DEVICE_IDENTIFIERS").setDefaultMode(2).build(), new AppOpInfo.Builder(90, OPSTR_ACCESS_MEDIA_LOCATION, "ACCESS_MEDIA_LOCATION").setPermission("android.permission.ACCESS_MEDIA_LOCATION").setDefaultMode(0).build(), new AppOpInfo.Builder(91, OPSTR_QUERY_ALL_PACKAGES, "QUERY_ALL_PACKAGES").build(), new AppOpInfo.Builder(92, OPSTR_MANAGE_EXTERNAL_STORAGE, "MANAGE_EXTERNAL_STORAGE").setPermission("android.permission.MANAGE_EXTERNAL_STORAGE").build(), new AppOpInfo.Builder(93, OPSTR_INTERACT_ACROSS_PROFILES, "INTERACT_ACROSS_PROFILES").setPermission("android.permission.INTERACT_ACROSS_PROFILES").build(), new AppOpInfo.Builder(94, OPSTR_ACTIVATE_PLATFORM_VPN, "ACTIVATE_PLATFORM_VPN").setDefaultMode(1).build(), new AppOpInfo.Builder(95, OPSTR_LOADER_USAGE_STATS, "LOADER_USAGE_STATS").setPermission("android.permission.LOADER_USAGE_STATS").build(), new AppOpInfo.Builder(-1, "", "").setDefaultMode(1).build(), new AppOpInfo.Builder(97, OPSTR_AUTO_REVOKE_PERMISSIONS_IF_UNUSED, "AUTO_REVOKE_PERMISSIONS_IF_UNUSED").build(), new AppOpInfo.Builder(98, OPSTR_AUTO_REVOKE_MANAGED_BY_INSTALLER, "AUTO_REVOKE_MANAGED_BY_INSTALLER").setDefaultMode(0).build(), new AppOpInfo.Builder(99, OPSTR_NO_ISOLATED_STORAGE, "NO_ISOLATED_STORAGE").setDefaultMode(2).setDisableReset(true).build(), new AppOpInfo.Builder(100, OPSTR_PHONE_CALL_MICROPHONE, "PHONE_CALL_MICROPHONE").setDefaultMode(0).build(), new AppOpInfo.Builder(101, OPSTR_PHONE_CALL_CAMERA, "PHONE_CALL_CAMERA").setDefaultMode(0).build(), new AppOpInfo.Builder(102, OPSTR_RECORD_AUDIO_HOTWORD, "RECORD_AUDIO_HOTWORD").setDefaultMode(0).build(), new AppOpInfo.Builder(103, OPSTR_MANAGE_ONGOING_CALLS, "MANAGE_ONGOING_CALLS").setPermission("android.permission.MANAGE_ONGOING_CALLS").setDisableReset(true).build(), new AppOpInfo.Builder(104, OPSTR_MANAGE_CREDENTIALS, "MANAGE_CREDENTIALS").build(), new AppOpInfo.Builder(105, OPSTR_USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER, "USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER").setPermission("android.permission.USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER").setDisableReset(true).build(), new AppOpInfo.Builder(106, OPSTR_RECORD_AUDIO_OUTPUT, "RECORD_AUDIO_OUTPUT").setDefaultMode(0).build(), new AppOpInfo.Builder(107, OPSTR_SCHEDULE_EXACT_ALARM, "SCHEDULE_EXACT_ALARM").setPermission("android.permission.SCHEDULE_EXACT_ALARM").build(), new AppOpInfo.Builder(108, OPSTR_FINE_LOCATION_SOURCE, "FINE_LOCATION_SOURCE").setSwitchCode(1).setDefaultMode(0).build(), new AppOpInfo.Builder(109, OPSTR_COARSE_LOCATION_SOURCE, "COARSE_LOCATION_SOURCE").setSwitchCode(0).setDefaultMode(0).build(), new AppOpInfo.Builder(110, OPSTR_MANAGE_MEDIA, "MANAGE_MEDIA").setPermission("android.permission.MANAGE_MEDIA").build(), new AppOpInfo.Builder(111, OPSTR_BLUETOOTH_CONNECT, "BLUETOOTH_CONNECT").setPermission("android.permission.BLUETOOTH_CONNECT").setDefaultMode(0).build(), new AppOpInfo.Builder(112, OPSTR_UWB_RANGING, "UWB_RANGING").setPermission("android.permission.UWB_RANGING").setDefaultMode(0).build(), new AppOpInfo.Builder(113, OPSTR_ACTIVITY_RECOGNITION_SOURCE, "ACTIVITY_RECOGNITION_SOURCE").setSwitchCode(79).setDefaultMode(0).build(), new AppOpInfo.Builder(114, OPSTR_BLUETOOTH_ADVERTISE, "BLUETOOTH_ADVERTISE").setPermission("android.permission.BLUETOOTH_ADVERTISE").setDefaultMode(0).build(), new AppOpInfo.Builder(115, OPSTR_RECORD_INCOMING_PHONE_AUDIO, "RECORD_INCOMING_PHONE_AUDIO").setDefaultMode(0).build(), new AppOpInfo.Builder(116, OPSTR_NEARBY_WIFI_DEVICES, "NEARBY_WIFI_DEVICES").setPermission("android.permission.NEARBY_WIFI_DEVICES").setDefaultMode(0).build(), new AppOpInfo.Builder(117, OPSTR_ESTABLISH_VPN_SERVICE, "ESTABLISH_VPN_SERVICE").setDefaultMode(0).build(), new AppOpInfo.Builder(118, OPSTR_ESTABLISH_VPN_MANAGER, "ESTABLISH_VPN_MANAGER").setDefaultMode(0).build(), new AppOpInfo.Builder(119, OPSTR_ACCESS_RESTRICTED_SETTINGS, "ACCESS_RESTRICTED_SETTINGS").setDefaultMode(0).setDisableReset(true).setRestrictRead(true).build(), new AppOpInfo.Builder(120, OPSTR_RECEIVE_AMBIENT_TRIGGER_AUDIO, "RECEIVE_SOUNDTRIGGER_AUDIO").setDefaultMode(0).setForceCollectNotes(true).build(), new AppOpInfo.Builder(121, OPSTR_RECEIVE_EXPLICIT_USER_INTERACTION_AUDIO, "RECEIVE_EXPLICIT_USER_INTERACTION_AUDIO").setDefaultMode(0).build(), new AppOpInfo.Builder(122, OPSTR_RUN_USER_INITIATED_JOBS, "RUN_USER_INITIATED_JOBS").setDefaultMode(0).build(), new AppOpInfo.Builder(123, OPSTR_READ_MEDIA_VISUAL_USER_SELECTED, "READ_MEDIA_VISUAL_USER_SELECTED").setPermission("android.permission.READ_MEDIA_VISUAL_USER_SELECTED").setDefaultMode(0).build(), new AppOpInfo.Builder(124, OPSTR_SYSTEM_EXEMPT_FROM_SUSPENSION, "SYSTEM_EXEMPT_FROM_SUSPENSION").setDisableReset(true).build(), new AppOpInfo.Builder(125, OPSTR_SYSTEM_EXEMPT_FROM_DISMISSIBLE_NOTIFICATIONS, "SYSTEM_EXEMPT_FROM_DISMISSIBLE_NOTIFICATIONS").setDisableReset(true).build(), new AppOpInfo.Builder(126, OPSTR_READ_WRITE_HEALTH_DATA, "READ_WRITE_HEALTH_DATA").setDefaultMode(0).build(), new AppOpInfo.Builder(127, OPSTR_FOREGROUND_SERVICE_SPECIAL_USE, "FOREGROUND_SERVICE_SPECIAL_USE").setPermission("android.permission.FOREGROUND_SERVICE_SPECIAL_USE").build(), new AppOpInfo.Builder(128, OPSTR_SYSTEM_EXEMPT_FROM_POWER_RESTRICTIONS, "SYSTEM_EXEMPT_FROM_POWER_RESTRICTIONS").setDisableReset(true).build(), new AppOpInfo.Builder(129, OPSTR_SYSTEM_EXEMPT_FROM_HIBERNATION, "SYSTEM_EXEMPT_FROM_HIBERNATION").setDisableReset(true).build(), new AppOpInfo.Builder(130, OPSTR_SYSTEM_EXEMPT_FROM_ACTIVITY_BG_START_RESTRICTION, "SYSTEM_EXEMPT_FROM_ACTIVITY_BG_START_RESTRICTION").setDisableReset(true).build(), new AppOpInfo.Builder(131, OPSTR_CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD, "CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD").setPermission("android.permission.CAPTURE_CONSENTLESS_BUGREPORT_ON_USERDEBUG_BUILD").build(), new AppOpInfo.Builder(132, OPSTR_DEPRECATED_2, "DEPRECATED_2").setDefaultMode(1).build(), new AppOpInfo.Builder(133, OPSTR_USE_FULL_SCREEN_INTENT, "USE_FULL_SCREEN_INTENT").setPermission("android.permission.USE_FULL_SCREEN_INTENT").build(), new AppOpInfo.Builder(134, OPSTR_CAMERA_SANDBOXED, "CAMERA_SANDBOXED").setDefaultMode(0).build(), new AppOpInfo.Builder(135, OPSTR_RECORD_AUDIO_SANDBOXED, "RECORD_AUDIO_SANDBOXED").setDefaultMode(0).build()};
        sOpStrToOp = new HashMap();
        sPermToOp = new HashMap();
        sBinderThreadCallingUid = new ThreadLocal();
        sAppOpsNotedInThisBinderTransaction = new ThreadLocal();
        if (sAppOpInfos.length != 136) {
            throw new IllegalStateException("mAppOpInfos length " + sAppOpInfos.length + " should be " + 136);
        }
        for (int i = 0; i < 136; ++i) {
            if (AppOpsManager.sAppOpInfos[i].name == null) continue;
            sOpStrToOp.put(AppOpsManager.sAppOpInfos[i].name, i);
        }
        for (int op : RUNTIME_PERMISSION_OPS) {
            if (AppOpsManager.sAppOpInfos[op].permission == null) continue;
            sPermToOp.put(AppOpsManager.sAppOpInfos[op].permission, op);
        }
        for (int op : APP_OP_PERMISSION_PACKAGE_OPS) {
            if (AppOpsManager.sAppOpInfos[op].permission == null) continue;
            sPermToOp.put(AppOpsManager.sAppOpInfos[op].permission, op);
        }
        for (int op : APP_OP_PERMISSION_UID_OPS) {
            if (AppOpsManager.sAppOpInfos[op].permission == null) continue;
            sPermToOp.put(AppOpsManager.sAppOpInfos[op].permission, op);
        }
        sConfig = new MessageSamplingConfig(-1, 0, 0L);
    }

    public static class RestrictionBypass {
        public boolean isSystemUid;
        public boolean isPrivileged;
        public boolean isRecordAudioRestrictionExcept;
        public static RestrictionBypass UNRESTRICTED = new RestrictionBypass(false, true, true);

        public RestrictionBypass(boolean isSystemUid, boolean isPrivileged, boolean isRecordAudioRestrictionExcept) {
            this.isSystemUid = isSystemUid;
            this.isPrivileged = isPrivileged;
            this.isRecordAudioRestrictionExcept = isRecordAudioRestrictionExcept;
        }
    }

    @SystemApi
    @Immutable
    public static class AttributedOpEntry
    implements Parcelable {
        private final int mOp;
        private final boolean mRunning;
        private final LongSparseArray<NoteOpEvent> mAccessEvents;
        private final LongSparseArray<NoteOpEvent> mRejectEvents;
        static Parcelling<LongSparseArray<NoteOpEvent>> sParcellingForAccessEvents = Parcelling.Cache.get(LongSparseArrayParceling.class);
        static Parcelling<LongSparseArray<NoteOpEvent>> sParcellingForRejectEvents;
        public static final Parcelable.Creator<AttributedOpEntry> CREATOR;

        private AttributedOpEntry(AttributedOpEntry other) {
            this.mOp = other.mOp;
            this.mRunning = other.mRunning;
            this.mAccessEvents = other.mAccessEvents == null ? null : other.mAccessEvents.clone();
            this.mRejectEvents = other.mRejectEvents == null ? null : other.mRejectEvents.clone();
        }

        public ArraySet<Long> collectKeys() {
            int i;
            int numEvents;
            ArraySet<Long> keys = new ArraySet<Long>();
            if (this.mAccessEvents != null) {
                numEvents = this.mAccessEvents.size();
                for (i = 0; i < numEvents; ++i) {
                    keys.add(this.mAccessEvents.keyAt(i));
                }
            }
            if (this.mRejectEvents != null) {
                numEvents = this.mRejectEvents.size();
                for (i = 0; i < numEvents; ++i) {
                    keys.add(this.mRejectEvents.keyAt(i));
                }
            }
            return keys;
        }

        public long getLastAccessTime(int flags) {
            return this.getLastAccessTime(100, 700, flags);
        }

        public long getLastAccessForegroundTime(int flags) {
            return this.getLastAccessTime(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastAccessBackgroundTime(int flags) {
            return this.getLastAccessTime(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        private NoteOpEvent getLastAccessEvent(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.getLastEvent(this.mAccessEvents, fromUidState, toUidState, flags);
        }

        public long getLastAccessTime(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getNoteTime();
        }

        public long getLastRejectTime(int flags) {
            return this.getLastRejectTime(100, 700, flags);
        }

        public long getLastRejectForegroundTime(int flags) {
            return this.getLastRejectTime(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastRejectBackgroundTime(int flags) {
            return this.getLastRejectTime(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        private NoteOpEvent getLastRejectEvent(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.getLastEvent(this.mRejectEvents, fromUidState, toUidState, flags);
        }

        public long getLastRejectTime(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastRejectEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getNoteTime();
        }

        public long getLastDuration(int flags) {
            return this.getLastDuration(100, 700, flags);
        }

        public long getLastForegroundDuration(int flags) {
            return this.getLastDuration(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastBackgroundDuration(int flags) {
            return this.getLastDuration(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getLastDuration(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getDuration();
        }

        public OpEventProxyInfo getLastProxyInfo(int flags) {
            return this.getLastProxyInfo(100, 700, flags);
        }

        public OpEventProxyInfo getLastForegroundProxyInfo(int flags) {
            return this.getLastProxyInfo(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public OpEventProxyInfo getLastBackgroundProxyInfo(int flags) {
            return this.getLastProxyInfo(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public OpEventProxyInfo getLastProxyInfo(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return null;
            }
            return lastEvent.getProxy();
        }

        String getOpName() {
            return AppOpsManager.opToPublicName(this.mOp);
        }

        int getOp() {
            return this.mOp;
        }

        public AttributedOpEntry(int op, boolean running, LongSparseArray<NoteOpEvent> accessEvents, LongSparseArray<NoteOpEvent> rejectEvents) {
            this.mOp = op;
            AnnotationValidations.validate(IntRange.class, null, this.mOp, "from", 0L, "to", 135L);
            this.mRunning = running;
            this.mAccessEvents = accessEvents;
            this.mRejectEvents = rejectEvents;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mRunning) {
                flg = (byte)(flg | 2);
            }
            if (this.mAccessEvents != null) {
                flg = (byte)(flg | 4);
            }
            if (this.mRejectEvents != null) {
                flg = (byte)(flg | 8);
            }
            dest.writeByte(flg);
            dest.writeInt(this.mOp);
            sParcellingForAccessEvents.parcel(this.mAccessEvents, dest, flags);
            sParcellingForRejectEvents.parcel(this.mRejectEvents, dest, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        AttributedOpEntry(Parcel in) {
            byte flg = in.readByte();
            boolean running = (flg & 2) != 0;
            int op = in.readInt();
            LongSparseArray<NoteOpEvent> accessEvents = sParcellingForAccessEvents.unparcel(in);
            LongSparseArray<NoteOpEvent> rejectEvents = sParcellingForRejectEvents.unparcel(in);
            this.mOp = op;
            AnnotationValidations.validate(IntRange.class, null, this.mOp, "from", 0L, "to", 135L);
            this.mRunning = running;
            this.mAccessEvents = accessEvents;
            this.mRejectEvents = rejectEvents;
        }

        static {
            if (sParcellingForAccessEvents == null) {
                sParcellingForAccessEvents = Parcelling.Cache.put(new LongSparseArrayParceling());
            }
            if ((sParcellingForRejectEvents = Parcelling.Cache.get(LongSparseArrayParceling.class)) == null) {
                sParcellingForRejectEvents = Parcelling.Cache.put(new LongSparseArrayParceling());
            }
            CREATOR = new Parcelable.Creator<AttributedOpEntry>(){

                public AttributedOpEntry[] newArray(int size) {
                    return new AttributedOpEntry[size];
                }

                @Override
                public AttributedOpEntry createFromParcel(Parcel in) {
                    return new AttributedOpEntry(in);
                }
            };
        }

        private static class LongSparseArrayParceling
        implements Parcelling<LongSparseArray<NoteOpEvent>> {
            private LongSparseArrayParceling() {
            }

            @Override
            public void parcel(LongSparseArray<NoteOpEvent> array2, Parcel dest, int parcelFlags) {
                if (array2 == null) {
                    dest.writeInt(-1);
                    return;
                }
                int numEntries = array2.size();
                dest.writeInt(numEntries);
                for (int i = 0; i < numEntries; ++i) {
                    dest.writeLong(array2.keyAt(i));
                    dest.writeParcelable(array2.valueAt(i), parcelFlags);
                }
            }

            @Override
            public LongSparseArray<NoteOpEvent> unparcel(Parcel source) {
                int numEntries = source.readInt();
                if (numEntries == -1) {
                    return null;
                }
                LongSparseArray<NoteOpEvent> array2 = new LongSparseArray<NoteOpEvent>(numEntries);
                for (int i = 0; i < numEntries; ++i) {
                    array2.put(source.readLong(), source.readParcelable(null, NoteOpEvent.class));
                }
                return array2;
            }
        }
    }

    @SystemApi
    @Immutable
    public static class HistoricalOpsRequest {
        private final int mUid;
        private final String mPackageName;
        private final String mAttributionTag;
        private final List<String> mOpNames;
        private final int mHistoryFlags;
        private final int mFilter;
        private final long mBeginTimeMillis;
        private final long mEndTimeMillis;
        private final int mFlags;

        private HistoricalOpsRequest(int uid, String packageName, String attributionTag, List<String> opNames, int historyFlags, int filter, long beginTimeMillis, long endTimeMillis, int flags) {
            this.mUid = uid;
            this.mPackageName = packageName;
            this.mAttributionTag = attributionTag;
            this.mOpNames = opNames;
            this.mHistoryFlags = historyFlags;
            this.mFilter = filter;
            this.mBeginTimeMillis = beginTimeMillis;
            this.mEndTimeMillis = endTimeMillis;
            this.mFlags = flags;
        }

        @SystemApi
        public static class Builder {
            private int mUid = -1;
            private String mPackageName;
            private String mAttributionTag;
            private List<String> mOpNames;
            private int mHistoryFlags;
            private int mFilter;
            private final long mBeginTimeMillis;
            private final long mEndTimeMillis;
            private int mFlags = 31;

            public Builder(long beginTimeMillis, long endTimeMillis) {
                Preconditions.checkArgument(beginTimeMillis >= 0L && beginTimeMillis < endTimeMillis, "beginTimeMillis must be non negative and lesser than endTimeMillis");
                this.mBeginTimeMillis = beginTimeMillis;
                this.mEndTimeMillis = endTimeMillis;
                this.mHistoryFlags = 1;
            }

            public Builder setUid(int uid) {
                Preconditions.checkArgument(uid == -1 || uid >= 0, "uid must be -1 or non negative");
                this.mUid = uid;
                this.mFilter = uid == -1 ? (this.mFilter &= 0xFFFFFFFE) : (this.mFilter |= 1);
                return this;
            }

            public Builder setPackageName(String packageName) {
                this.mPackageName = packageName;
                this.mFilter = packageName == null ? (this.mFilter &= 0xFFFFFFFD) : (this.mFilter |= 2);
                return this;
            }

            public Builder setAttributionTag(String attributionTag) {
                this.mAttributionTag = attributionTag;
                this.mFilter |= 4;
                return this;
            }

            public Builder setOpNames(List<String> opNames) {
                if (opNames != null) {
                    int opCount = opNames.size();
                    for (int i = 0; i < opCount; ++i) {
                        Preconditions.checkArgument(AppOpsManager.strOpToOp(opNames.get(i)) != -1);
                    }
                }
                this.mOpNames = opNames;
                this.mFilter = this.mOpNames == null ? (this.mFilter &= 0xFFFFFFF7) : (this.mFilter |= 8);
                return this;
            }

            public Builder setFlags(int flags) {
                Preconditions.checkFlagsArgument(flags, 31);
                this.mFlags = flags;
                return this;
            }

            public Builder setHistoryFlags(int flags) {
                Preconditions.checkFlagsArgument(flags, 7);
                this.mHistoryFlags = flags;
                return this;
            }

            public HistoricalOpsRequest build() {
                return new HistoricalOpsRequest(this.mUid, this.mPackageName, this.mAttributionTag, this.mOpNames, this.mHistoryFlags, this.mFilter, this.mBeginTimeMillis, this.mEndTimeMillis, this.mFlags);
            }
        }
    }

    public static interface OnOpChangedListener {
        public void onOpChanged(String var1, String var2);

        default public void onOpChanged(String op, String packageName, int userId) {
            this.onOpChanged(op, packageName);
        }
    }

    public static interface OnOpActiveChangedListener {
        public void onOpActiveChanged(String var1, int var2, String var3, boolean var4);

        default public void onOpActiveChanged(String op, int uid, String packageName, String attributionTag, boolean active, int attributionFlags, int attributionChainId) {
            this.onOpActiveChanged(op, uid, packageName, active);
        }
    }

    public static interface OnOpStartedListener {
        public static final int START_TYPE_FAILED = 0;
        public static final int START_TYPE_STARTED = 1;
        public static final int START_TYPE_RESUMED = 2;

        public void onOpStarted(int var1, int var2, String var3, String var4, int var5, int var6);

        default public void onOpStarted(int op, int uid, String packageName, String attributionTag, int flags, int result, int startType, int attributionFlags, int attributionChainId) {
            if (startType != 2) {
                this.onOpStarted(op, uid, packageName, attributionTag, flags, result);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StartedType {
        }
    }

    @SystemApi
    public static interface OnOpNotedListener {
        public void onOpNoted(String var1, int var2, String var3, String var4, int var5, int var6);
    }

    public static class PausedNotedAppOpsCollection {
        final int mUid;
        final ArrayMap<String, BitSet> mCollectedNotedAppOps;

        PausedNotedAppOpsCollection(int uid, ArrayMap<String, BitSet> collectedNotedAppOps) {
            this.mUid = uid;
            this.mCollectedNotedAppOps = collectedNotedAppOps;
        }
    }

    public static abstract class OnOpNotedCallback {
        private Executor mAsyncExecutor;
        private final IAppOpsAsyncNotedCallback mAsyncCb = new IAppOpsAsyncNotedCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void opNoted(AsyncNotedAppOp op) {
                Objects.requireNonNull(op);
                long token = Binder.clearCallingIdentity();
                try {
                    this.getAsyncNotedExecutor().execute(() -> this.onAsyncNoted(op));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };

        protected Executor getAsyncNotedExecutor() {
            return this.mAsyncExecutor;
        }

        public abstract void onNoted(SyncNotedAppOp var1);

        public abstract void onSelfNoted(SyncNotedAppOp var1);

        public abstract void onAsyncNoted(AsyncNotedAppOp var1);
    }

    @SystemApi
    public static class HistoricalOps
    implements Parcelable {
        private long mBeginTimeMillis;
        private long mEndTimeMillis;
        private SparseArray<HistoricalUidOps> mHistoricalUidOps;
        public static final Parcelable.Creator<HistoricalOps> CREATOR = new Parcelable.Creator<HistoricalOps>(){

            @Override
            public HistoricalOps createFromParcel(Parcel parcel) {
                return new HistoricalOps(parcel);
            }

            public HistoricalOps[] newArray(int size) {
                return new HistoricalOps[size];
            }
        };

        public HistoricalOps(long beginTimeMillis, long endTimeMillis) {
            Preconditions.checkState(beginTimeMillis <= endTimeMillis);
            this.mBeginTimeMillis = beginTimeMillis;
            this.mEndTimeMillis = endTimeMillis;
        }

        public HistoricalOps(HistoricalOps other) {
            this.mBeginTimeMillis = other.mBeginTimeMillis;
            this.mEndTimeMillis = other.mEndTimeMillis;
            Preconditions.checkState(this.mBeginTimeMillis <= this.mEndTimeMillis);
            if (other.mHistoricalUidOps != null) {
                int opCount = other.getUidCount();
                for (int i = 0; i < opCount; ++i) {
                    HistoricalUidOps origOps = other.getUidOpsAt(i);
                    HistoricalUidOps clonedOps = new HistoricalUidOps(origOps);
                    if (this.mHistoricalUidOps == null) {
                        this.mHistoricalUidOps = new SparseArray(opCount);
                    }
                    this.mHistoricalUidOps.put(clonedOps.getUid(), clonedOps);
                }
            }
        }

        private HistoricalOps(Parcel parcel) {
            this.mBeginTimeMillis = parcel.readLong();
            this.mEndTimeMillis = parcel.readLong();
            int[] uids = parcel.createIntArray();
            if (!ArrayUtils.isEmpty(uids)) {
                List uidOps;
                ParceledListSlice listSlice = parcel.readParcelable(HistoricalOps.class.getClassLoader(), ParceledListSlice.class);
                List list = uidOps = listSlice != null ? listSlice.getList() : null;
                if (uidOps == null) {
                    return;
                }
                for (int i = 0; i < uids.length; ++i) {
                    if (this.mHistoricalUidOps == null) {
                        this.mHistoricalUidOps = new SparseArray();
                    }
                    this.mHistoricalUidOps.put(uids[i], (HistoricalUidOps)uidOps.get(i));
                }
            }
        }

        public HistoricalOps spliceFromBeginning(double splicePoint) {
            return this.splice(splicePoint, true);
        }

        public HistoricalOps spliceFromEnd(double fractionToRemove) {
            return this.splice(fractionToRemove, false);
        }

        private HistoricalOps splice(double fractionToRemove, boolean beginning) {
            long spliceEndTimeMills;
            long spliceBeginTimeMills;
            if (beginning) {
                spliceBeginTimeMills = this.mBeginTimeMillis;
                this.mBeginTimeMillis = spliceEndTimeMills = (long)((double)this.mBeginTimeMillis + (double)this.getDurationMillis() * fractionToRemove);
            } else {
                spliceBeginTimeMills = (long)((double)this.mEndTimeMillis - (double)this.getDurationMillis() * fractionToRemove);
                spliceEndTimeMills = this.mEndTimeMillis;
                this.mEndTimeMillis = spliceBeginTimeMills;
            }
            HistoricalOps splice = null;
            int uidCount = this.getUidCount();
            for (int i = 0; i < uidCount; ++i) {
                HistoricalUidOps origOps = this.getUidOpsAt(i);
                HistoricalUidOps spliceOps = origOps.splice(fractionToRemove);
                if (spliceOps == null) continue;
                if (splice == null) {
                    splice = new HistoricalOps(spliceBeginTimeMills, spliceEndTimeMills);
                }
                if (splice.mHistoricalUidOps == null) {
                    splice.mHistoricalUidOps = new SparseArray();
                }
                splice.mHistoricalUidOps.put(spliceOps.getUid(), spliceOps);
            }
            return splice;
        }

        public void merge(HistoricalOps other) {
            this.mBeginTimeMillis = Math.min(this.mBeginTimeMillis, other.mBeginTimeMillis);
            this.mEndTimeMillis = Math.max(this.mEndTimeMillis, other.mEndTimeMillis);
            int uidCount = other.getUidCount();
            for (int i = 0; i < uidCount; ++i) {
                HistoricalUidOps otherUidOps = other.getUidOpsAt(i);
                HistoricalUidOps thisUidOps = this.getUidOps(otherUidOps.getUid());
                if (thisUidOps != null) {
                    thisUidOps.merge(otherUidOps);
                    continue;
                }
                if (this.mHistoricalUidOps == null) {
                    this.mHistoricalUidOps = new SparseArray();
                }
                this.mHistoricalUidOps.put(otherUidOps.getUid(), otherUidOps);
            }
        }

        public void filter(int uid, String packageName, String attributionTag, String[] opNames, int historyFilter, int filter, long beginTimeMillis, long endTimeMillis) {
            long durationMillis = this.getDurationMillis();
            this.mBeginTimeMillis = Math.max(this.mBeginTimeMillis, beginTimeMillis);
            this.mEndTimeMillis = Math.min(this.mEndTimeMillis, endTimeMillis);
            double scaleFactor = Math.min((double)(endTimeMillis - beginTimeMillis) / (double)durationMillis, 1.0);
            int uidCount = this.getUidCount();
            for (int i = uidCount - 1; i >= 0; --i) {
                HistoricalUidOps uidOp = this.mHistoricalUidOps.valueAt(i);
                if ((filter & 1) != 0 && uid != uidOp.getUid()) {
                    this.mHistoricalUidOps.removeAt(i);
                    continue;
                }
                uidOp.filter(packageName, attributionTag, opNames, filter, historyFilter, scaleFactor, this.mBeginTimeMillis, this.mEndTimeMillis);
                if (uidOp.getPackageCount() != 0) continue;
                this.mHistoricalUidOps.removeAt(i);
            }
        }

        public boolean isEmpty() {
            if (this.getBeginTimeMillis() >= this.getEndTimeMillis()) {
                return true;
            }
            int uidCount = this.getUidCount();
            for (int i = uidCount - 1; i >= 0; --i) {
                HistoricalUidOps uidOp = this.mHistoricalUidOps.valueAt(i);
                if (uidOp.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public long getDurationMillis() {
            return this.mEndTimeMillis - this.mBeginTimeMillis;
        }

        public void increaseAccessCount(int opCode, int uid, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalUidOps(uid).increaseAccessCount(opCode, packageName, attributionTag, uidState, flags, increment);
        }

        public void increaseRejectCount(int opCode, int uid, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalUidOps(uid).increaseRejectCount(opCode, packageName, attributionTag, uidState, flags, increment);
        }

        public void increaseAccessDuration(int opCode, int uid, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalUidOps(uid).increaseAccessDuration(opCode, packageName, attributionTag, uidState, flags, increment);
        }

        public void addDiscreteAccess(int opCode, int uid, String packageName, String attributionTag, int uidState, int opFlag, long discreteAccessTime, long discreteAccessDuration) {
            this.getOrCreateHistoricalUidOps(uid).addDiscreteAccess(opCode, packageName, attributionTag, uidState, opFlag, discreteAccessTime, discreteAccessDuration, null);
        }

        public void addDiscreteAccess(int opCode, int uid, String packageName, String attributionTag, int uidState, int opFlag, long discreteAccessTime, long discreteAccessDuration, OpEventProxyInfo proxy) {
            this.getOrCreateHistoricalUidOps(uid).addDiscreteAccess(opCode, packageName, attributionTag, uidState, opFlag, discreteAccessTime, discreteAccessDuration, proxy);
        }

        public void offsetBeginAndEndTime(long offsetMillis) {
            this.mBeginTimeMillis += offsetMillis;
            this.mEndTimeMillis += offsetMillis;
        }

        public void setBeginAndEndTime(long beginTimeMillis, long endTimeMillis) {
            this.mBeginTimeMillis = beginTimeMillis;
            this.mEndTimeMillis = endTimeMillis;
        }

        public void setBeginTime(long beginTimeMillis) {
            this.mBeginTimeMillis = beginTimeMillis;
        }

        public void setEndTime(long endTimeMillis) {
            this.mEndTimeMillis = endTimeMillis;
        }

        public long getBeginTimeMillis() {
            return this.mBeginTimeMillis;
        }

        public long getEndTimeMillis() {
            return this.mEndTimeMillis;
        }

        public int getUidCount() {
            if (this.mHistoricalUidOps == null) {
                return 0;
            }
            return this.mHistoricalUidOps.size();
        }

        public HistoricalUidOps getUidOpsAt(int index) {
            if (this.mHistoricalUidOps == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mHistoricalUidOps.valueAt(index);
        }

        public HistoricalUidOps getUidOps(int uid) {
            if (this.mHistoricalUidOps == null) {
                return null;
            }
            return this.mHistoricalUidOps.get(uid);
        }

        public void clearHistory(int uid, String packageName) {
            HistoricalUidOps historicalUidOps = this.getOrCreateHistoricalUidOps(uid);
            historicalUidOps.clearHistory(packageName);
            if (historicalUidOps.isEmpty()) {
                this.mHistoricalUidOps.remove(uid);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeLong(this.mBeginTimeMillis);
            parcel.writeLong(this.mEndTimeMillis);
            if (this.mHistoricalUidOps != null) {
                int uidCount = this.mHistoricalUidOps.size();
                parcel.writeInt(uidCount);
                for (int i = 0; i < uidCount; ++i) {
                    parcel.writeInt(this.mHistoricalUidOps.keyAt(i));
                }
                ArrayList<HistoricalUidOps> opsList = new ArrayList<HistoricalUidOps>(uidCount);
                for (int i = 0; i < uidCount; ++i) {
                    opsList.add(this.mHistoricalUidOps.valueAt(i));
                }
                parcel.writeParcelable(new ParceledListSlice(opsList), flags);
            } else {
                parcel.writeInt(-1);
            }
        }

        public void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalOps(this);
            int uidCount = this.getUidCount();
            for (int i = 0; i < uidCount; ++i) {
                this.getUidOpsAt(i).accept(visitor);
            }
        }

        private HistoricalUidOps getOrCreateHistoricalUidOps(int uid) {
            HistoricalUidOps historicalUidOp;
            if (this.mHistoricalUidOps == null) {
                this.mHistoricalUidOps = new SparseArray();
            }
            if ((historicalUidOp = this.mHistoricalUidOps.get(uid)) == null) {
                historicalUidOp = new HistoricalUidOps(uid);
                this.mHistoricalUidOps.put(uid, historicalUidOp);
            }
            return historicalUidOp;
        }

        public static double round(double value) {
            return Math.floor(value + 0.5);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalOps other = (HistoricalOps)obj;
            if (this.mBeginTimeMillis != other.mBeginTimeMillis) {
                return false;
            }
            if (this.mEndTimeMillis != other.mEndTimeMillis) {
                return false;
            }
            return !(this.mHistoricalUidOps == null ? other.mHistoricalUidOps != null : !this.mHistoricalUidOps.equals(other.mHistoricalUidOps));
        }

        public int hashCode() {
            int result = (int)(this.mBeginTimeMillis ^ this.mBeginTimeMillis >>> 32);
            result = 31 * result + this.mHistoricalUidOps.hashCode();
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[from:" + this.mBeginTimeMillis + " to:" + this.mEndTimeMillis + "]";
        }
    }

    public static class NoteOpEvent
    implements Parcelable {
        private long mNoteTime;
        private long mDuration;
        private OpEventProxyInfo mProxy;
        public static final Parcelable.Creator<NoteOpEvent> CREATOR = new Parcelable.Creator<NoteOpEvent>(){

            public NoteOpEvent[] newArray(int size) {
                return new NoteOpEvent[size];
            }

            @Override
            public NoteOpEvent createFromParcel(Parcel in) {
                return new NoteOpEvent(in);
            }
        };

        public void reinit(long noteTime, long duration, OpEventProxyInfo proxy, Pools.Pool<OpEventProxyInfo> proxyPool) {
            this.mNoteTime = Preconditions.checkArgumentNonnegative(noteTime);
            this.mDuration = Preconditions.checkArgumentInRange(duration, -1L, Long.MAX_VALUE, "duration");
            if (this.mProxy != null) {
                proxyPool.release(this.mProxy);
            }
            this.mProxy = proxy;
        }

        public NoteOpEvent(NoteOpEvent original) {
            this(original.mNoteTime, original.mDuration, original.mProxy != null ? new OpEventProxyInfo(original.mProxy) : null);
        }

        public NoteOpEvent(long noteTime, long duration, OpEventProxyInfo proxy) {
            this.mNoteTime = noteTime;
            AnnotationValidations.validate(IntRange.class, null, this.mNoteTime, "from", 0L);
            this.mDuration = duration;
            AnnotationValidations.validate(IntRange.class, null, this.mDuration, "from", -1L);
            this.mProxy = proxy;
        }

        public long getNoteTime() {
            return this.mNoteTime;
        }

        public long getDuration() {
            return this.mDuration;
        }

        public OpEventProxyInfo getProxy() {
            return this.mProxy;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mProxy != null) {
                flg = (byte)(flg | 4);
            }
            dest.writeByte(flg);
            dest.writeLong(this.mNoteTime);
            dest.writeLong(this.mDuration);
            if (this.mProxy != null) {
                dest.writeTypedObject(this.mProxy, flags);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        NoteOpEvent(Parcel in) {
            byte flg = in.readByte();
            long noteTime = in.readLong();
            long duration = in.readLong();
            OpEventProxyInfo proxy = (flg & 4) == 0 ? null : in.readTypedObject(OpEventProxyInfo.CREATOR);
            this.mNoteTime = noteTime;
            AnnotationValidations.validate(IntRange.class, null, this.mNoteTime, "from", 0L);
            this.mDuration = duration;
            AnnotationValidations.validate(IntRange.class, null, this.mDuration, "from", -1L);
            this.mProxy = proxy;
        }
    }

    @SystemApi
    public static class OpEventProxyInfo
    implements Parcelable {
        private int mUid;
        private String mPackageName;
        private String mAttributionTag;
        public static final Parcelable.Creator<OpEventProxyInfo> CREATOR = new Parcelable.Creator<OpEventProxyInfo>(){

            public OpEventProxyInfo[] newArray(int size) {
                return new OpEventProxyInfo[size];
            }

            @Override
            public OpEventProxyInfo createFromParcel(Parcel in) {
                return new OpEventProxyInfo(in);
            }
        };

        public void reinit(int uid, String packageName, String attributionTag) {
            this.mUid = Preconditions.checkArgumentNonnegative(uid);
            this.mPackageName = packageName;
            this.mAttributionTag = attributionTag;
        }

        public OpEventProxyInfo(int uid, String packageName, String attributionTag) {
            this.mUid = uid;
            AnnotationValidations.validate(IntRange.class, null, this.mUid, "from", 0L);
            this.mPackageName = packageName;
            this.mAttributionTag = attributionTag;
        }

        public OpEventProxyInfo(OpEventProxyInfo orig) {
            this.mUid = orig.mUid;
            this.mPackageName = orig.mPackageName;
            this.mAttributionTag = orig.mAttributionTag;
        }

        public int getUid() {
            return this.mUid;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public String getAttributionTag() {
            return this.mAttributionTag;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mPackageName != null) {
                flg = (byte)(flg | 2);
            }
            if (this.mAttributionTag != null) {
                flg = (byte)(flg | 4);
            }
            dest.writeByte(flg);
            dest.writeInt(this.mUid);
            if (this.mPackageName != null) {
                dest.writeString(this.mPackageName);
            }
            if (this.mAttributionTag != null) {
                dest.writeString(this.mAttributionTag);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        OpEventProxyInfo(Parcel in) {
            byte flg = in.readByte();
            int uid = in.readInt();
            String packageName = (flg & 2) == 0 ? null : in.readString();
            String attributionTag = (flg & 4) == 0 ? null : in.readString();
            this.mUid = uid;
            AnnotationValidations.validate(IntRange.class, null, this.mUid, "from", 0L);
            this.mPackageName = packageName;
            this.mAttributionTag = attributionTag;
        }
    }

    @SystemApi
    @Deprecated
    public static abstract class AppOpsCollector
    extends OnOpNotedCallback {
        @Override
        public Executor getAsyncNotedExecutor() {
            return new HandlerExecutor(Handler.getMain());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface NotedOpCollectionMode {
    }

    public static interface OnOpActiveChangedInternalListener
    extends OnOpActiveChangedListener {
        @Override
        default public void onOpActiveChanged(String op, int uid, String packageName, boolean active) {
        }

        default public void onOpActiveChanged(int op, int uid, String packageName, boolean active) {
        }
    }

    public static class OnOpChangedInternalListener
    implements OnOpChangedListener {
        @Override
        public void onOpChanged(String op, String packageName) {
        }

        public void onOpChanged(int op, String packageName) {
        }
    }

    public static interface OnOpNotedInternalListener
    extends OnOpNotedListener {
        public void onOpNoted(int var1, int var2, String var3, String var4, int var5, int var6);

        @Override
        default public void onOpNoted(String op, int uid, String packageName, String attributionTag, int flags, int result) {
            this.onOpNoted(AppOpsManager.strOpToOp(op), uid, packageName, attributionTag, flags, result);
        }
    }

    @SystemApi
    public static class HistoricalOp
    implements Parcelable {
        private final int mOp;
        private LongSparseLongArray mAccessCount;
        private LongSparseLongArray mRejectCount;
        private LongSparseLongArray mAccessDuration;
        private List<AttributedOpEntry> mDiscreteAccesses;
        public static final Parcelable.Creator<HistoricalOp> CREATOR = new Parcelable.Creator<HistoricalOp>(){

            @Override
            public HistoricalOp createFromParcel(Parcel source) {
                return new HistoricalOp(source);
            }

            public HistoricalOp[] newArray(int size) {
                return new HistoricalOp[size];
            }
        };

        public HistoricalOp(int op) {
            this.mOp = op;
        }

        private HistoricalOp(HistoricalOp other) {
            this.mOp = other.mOp;
            if (other.mAccessCount != null) {
                this.mAccessCount = other.mAccessCount.clone();
            }
            if (other.mRejectCount != null) {
                this.mRejectCount = other.mRejectCount.clone();
            }
            if (other.mAccessDuration != null) {
                this.mAccessDuration = other.mAccessDuration.clone();
            }
            int historicalOpCount = other.getDiscreteAccessCount();
            for (int i = 0; i < historicalOpCount; ++i) {
                AttributedOpEntry origOp = other.getDiscreteAccessAt(i);
                AttributedOpEntry cloneOp = new AttributedOpEntry(origOp);
                this.getOrCreateDiscreteAccesses().add(cloneOp);
            }
        }

        private HistoricalOp(Parcel parcel) {
            this.mOp = parcel.readInt();
            this.mAccessCount = AppOpsManager.readLongSparseLongArrayFromParcel(parcel);
            this.mRejectCount = AppOpsManager.readLongSparseLongArrayFromParcel(parcel);
            this.mAccessDuration = AppOpsManager.readLongSparseLongArrayFromParcel(parcel);
            this.mDiscreteAccesses = AppOpsManager.readDiscreteAccessArrayFromParcel(parcel);
        }

        private void filter(int historyFlag, double scaleFactor, long beginTimeMillis, long endTimeMillis) {
            if ((historyFlag & 1) == 0) {
                this.mAccessCount = null;
                this.mRejectCount = null;
                this.mAccessDuration = null;
            } else {
                HistoricalOp.scale(this.mAccessCount, scaleFactor);
                HistoricalOp.scale(this.mRejectCount, scaleFactor);
                HistoricalOp.scale(this.mAccessDuration, scaleFactor);
            }
            if ((historyFlag & 2) == 0) {
                this.mDiscreteAccesses = null;
                return;
            }
            int discreteOpCount = this.getDiscreteAccessCount();
            for (int i = discreteOpCount - 1; i >= 0; --i) {
                AttributedOpEntry op = this.mDiscreteAccesses.get(i);
                long opBeginTime = op.getLastAccessTime(31);
                long opEndTime = opBeginTime + op.getLastDuration(31);
                if ((opEndTime = Long.max(opBeginTime, opEndTime)) >= beginTimeMillis && opBeginTime <= endTimeMillis) continue;
                this.mDiscreteAccesses.remove(i);
            }
        }

        private boolean isEmpty() {
            return !this.hasData(this.mAccessCount) && !this.hasData(this.mRejectCount) && !this.hasData(this.mAccessDuration) && this.mDiscreteAccesses == null;
        }

        private boolean hasData(LongSparseLongArray array2) {
            return array2 != null && array2.size() > 0;
        }

        private HistoricalOp splice(double fractionToRemove) {
            HistoricalOp splice = new HistoricalOp(this.mOp);
            HistoricalOp.splice(this.mAccessCount, splice::getOrCreateAccessCount, fractionToRemove);
            HistoricalOp.splice(this.mRejectCount, splice::getOrCreateRejectCount, fractionToRemove);
            HistoricalOp.splice(this.mAccessDuration, splice::getOrCreateAccessDuration, fractionToRemove);
            return splice;
        }

        private static void splice(LongSparseLongArray sourceContainer, Supplier<LongSparseLongArray> destContainerProvider, double fractionToRemove) {
            if (sourceContainer != null) {
                int size = sourceContainer.size();
                for (int i = 0; i < size; ++i) {
                    long key = sourceContainer.keyAt(i);
                    long value = sourceContainer.valueAt(i);
                    long removedFraction = Math.round((double)value * fractionToRemove);
                    if (removedFraction <= 0L) continue;
                    destContainerProvider.get().put(key, removedFraction);
                    sourceContainer.put(key, value - removedFraction);
                }
            }
        }

        private void merge(HistoricalOp other) {
            HistoricalOp.merge(this::getOrCreateAccessCount, other.mAccessCount);
            HistoricalOp.merge(this::getOrCreateRejectCount, other.mRejectCount);
            HistoricalOp.merge(this::getOrCreateAccessDuration, other.mAccessDuration);
            if (other.mDiscreteAccesses == null) {
                return;
            }
            if (this.mDiscreteAccesses == null) {
                this.mDiscreteAccesses = new ArrayList<AttributedOpEntry>(other.mDiscreteAccesses);
                return;
            }
            ArrayList<AttributedOpEntry> historicalDiscreteAccesses = new ArrayList<AttributedOpEntry>();
            int otherHistoricalOpCount = other.getDiscreteAccessCount();
            int historicalOpCount = this.getDiscreteAccessCount();
            int i = 0;
            int j = 0;
            while (i < otherHistoricalOpCount || j < historicalOpCount) {
                if (i == otherHistoricalOpCount) {
                    historicalDiscreteAccesses.add(this.mDiscreteAccesses.get(j++));
                    continue;
                }
                if (j == historicalOpCount) {
                    historicalDiscreteAccesses.add(other.mDiscreteAccesses.get(i++));
                    continue;
                }
                if (this.mDiscreteAccesses.get(j).getLastAccessTime(31) < other.mDiscreteAccesses.get(i).getLastAccessTime(31)) {
                    historicalDiscreteAccesses.add(this.mDiscreteAccesses.get(j++));
                    continue;
                }
                historicalDiscreteAccesses.add(other.mDiscreteAccesses.get(i++));
            }
            this.mDiscreteAccesses = AppOpsManager.deduplicateDiscreteEvents(historicalDiscreteAccesses);
        }

        private void increaseAccessCount(int uidState, int flags, long increment) {
            this.increaseCount(this.getOrCreateAccessCount(), uidState, flags, increment);
        }

        private void increaseRejectCount(int uidState, int flags, long increment) {
            this.increaseCount(this.getOrCreateRejectCount(), uidState, flags, increment);
        }

        private void increaseAccessDuration(int uidState, int flags, long increment) {
            this.increaseCount(this.getOrCreateAccessDuration(), uidState, flags, increment);
        }

        private void increaseCount(LongSparseLongArray counts, int uidState, int flags, long increment) {
            while (flags != 0) {
                int flag = 1 << Integer.numberOfTrailingZeros(flags);
                flags &= ~flag;
                long key = AppOpsManager.makeKey(uidState, flag);
                counts.put(key, counts.get(key) + increment);
            }
        }

        private void addDiscreteAccess(int uidState, int flag, long discreteAccessTime, long discreteAccessDuration, OpEventProxyInfo proxy) {
            int insertionPoint;
            List<AttributedOpEntry> discreteAccesses = this.getOrCreateDiscreteAccesses();
            LongSparseArray<NoteOpEvent> accessEvents = new LongSparseArray<NoteOpEvent>();
            long key = AppOpsManager.makeKey(uidState, flag);
            NoteOpEvent note = new NoteOpEvent(discreteAccessTime, discreteAccessDuration, proxy);
            accessEvents.append(key, note);
            AttributedOpEntry access = new AttributedOpEntry(this.mOp, false, accessEvents, null);
            for (insertionPoint = discreteAccesses.size() - 1; insertionPoint >= 0 && discreteAccesses.get(insertionPoint).getLastAccessTime(31) >= discreteAccessTime; --insertionPoint) {
            }
            if (++insertionPoint < discreteAccesses.size() && discreteAccesses.get(insertionPoint).getLastAccessTime(31) == discreteAccessTime) {
                discreteAccesses.set(insertionPoint, AppOpsManager.mergeAttributedOpEntries(Arrays.asList(discreteAccesses.get(insertionPoint), access)));
            } else {
                discreteAccesses.add(insertionPoint, access);
            }
        }

        public String getOpName() {
            return AppOpsManager.sAppOpInfos[this.mOp].name;
        }

        public int getOpCode() {
            return this.mOp;
        }

        public int getDiscreteAccessCount() {
            if (this.mDiscreteAccesses == null) {
                return 0;
            }
            return this.mDiscreteAccesses.size();
        }

        public AttributedOpEntry getDiscreteAccessAt(int index) {
            if (this.mDiscreteAccesses == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mDiscreteAccesses.get(index);
        }

        public long getForegroundAccessCount(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessCount, 100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public List<AttributedOpEntry> getForegroundDiscreteAccesses(int flags) {
            return AppOpsManager.listForFlagsInStates(this.mDiscreteAccesses, 100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getBackgroundAccessCount(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessCount, AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public List<AttributedOpEntry> getBackgroundDiscreteAccesses(int flags) {
            return AppOpsManager.listForFlagsInStates(this.mDiscreteAccesses, AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getAccessCount(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessCount, fromUidState, toUidState, flags);
        }

        public List<AttributedOpEntry> getDiscreteAccesses(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.listForFlagsInStates(this.mDiscreteAccesses, fromUidState, toUidState, flags);
        }

        public long getForegroundRejectCount(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mRejectCount, 100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getBackgroundRejectCount(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mRejectCount, AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getRejectCount(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mRejectCount, fromUidState, toUidState, flags);
        }

        public long getForegroundAccessDuration(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessDuration, 100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getBackgroundAccessDuration(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessDuration, AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getAccessDuration(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessDuration, fromUidState, toUidState, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeInt(this.mOp);
            AppOpsManager.writeLongSparseLongArrayToParcel(this.mAccessCount, parcel);
            AppOpsManager.writeLongSparseLongArrayToParcel(this.mRejectCount, parcel);
            AppOpsManager.writeLongSparseLongArrayToParcel(this.mAccessDuration, parcel);
            AppOpsManager.writeDiscreteAccessArrayToParcel(this.mDiscreteAccesses, parcel, flags);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalOp other = (HistoricalOp)obj;
            if (this.mOp != other.mOp) {
                return false;
            }
            if (!AppOpsManager.equalsLongSparseLongArray(this.mAccessCount, other.mAccessCount)) {
                return false;
            }
            if (!AppOpsManager.equalsLongSparseLongArray(this.mRejectCount, other.mRejectCount)) {
                return false;
            }
            if (!AppOpsManager.equalsLongSparseLongArray(this.mAccessDuration, other.mAccessDuration)) {
                return false;
            }
            return this.mDiscreteAccesses == null ? other.mDiscreteAccesses == null : this.mDiscreteAccesses.equals(other.mDiscreteAccesses);
        }

        public int hashCode() {
            int result = this.mOp;
            result = 31 * result + Objects.hashCode(this.mAccessCount);
            result = 31 * result + Objects.hashCode(this.mRejectCount);
            result = 31 * result + Objects.hashCode(this.mAccessDuration);
            result = 31 * result + Objects.hashCode(this.mDiscreteAccesses);
            return result;
        }

        private void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalOp(this);
        }

        private LongSparseLongArray getOrCreateAccessCount() {
            if (this.mAccessCount == null) {
                this.mAccessCount = new LongSparseLongArray();
            }
            return this.mAccessCount;
        }

        private LongSparseLongArray getOrCreateRejectCount() {
            if (this.mRejectCount == null) {
                this.mRejectCount = new LongSparseLongArray();
            }
            return this.mRejectCount;
        }

        private LongSparseLongArray getOrCreateAccessDuration() {
            if (this.mAccessDuration == null) {
                this.mAccessDuration = new LongSparseLongArray();
            }
            return this.mAccessDuration;
        }

        private List<AttributedOpEntry> getOrCreateDiscreteAccesses() {
            if (this.mDiscreteAccesses == null) {
                this.mDiscreteAccesses = new ArrayList<AttributedOpEntry>();
            }
            return this.mDiscreteAccesses;
        }

        private static void scale(LongSparseLongArray data, double scaleFactor) {
            if (data != null) {
                int size = data.size();
                for (int i = 0; i < size; ++i) {
                    data.put(data.keyAt(i), (long)HistoricalOps.round((double)data.valueAt(i) * scaleFactor));
                }
            }
        }

        private static void merge(Supplier<LongSparseLongArray> thisSupplier, LongSparseLongArray other) {
            if (other != null) {
                int otherSize = other.size();
                for (int i = 0; i < otherSize; ++i) {
                    LongSparseLongArray that = thisSupplier.get();
                    long otherKey = other.keyAt(i);
                    long otherValue = other.valueAt(i);
                    that.put(otherKey, that.get(otherKey) + otherValue);
                }
            }
        }

        public LongSparseArray<Object> collectKeys() {
            LongSparseArray<Object> result = AppOpsManager.collectKeys(this.mAccessCount, null);
            result = AppOpsManager.collectKeys(this.mRejectCount, result);
            result = AppOpsManager.collectKeys(this.mAccessDuration, result);
            return result;
        }
    }

    @SystemApi
    public static class AttributedHistoricalOps
    implements Parcelable {
        private final String mTag;
        private ArrayMap<String, HistoricalOp> mHistoricalOps;
        public static final Parcelable.Creator<AttributedHistoricalOps> CREATOR = new Parcelable.Creator<AttributedHistoricalOps>(){

            public AttributedHistoricalOps[] newArray(int size) {
                return new AttributedHistoricalOps[size];
            }

            @Override
            public AttributedHistoricalOps createFromParcel(Parcel in) {
                return new AttributedHistoricalOps(in);
            }
        };

        public AttributedHistoricalOps(String tag) {
            this.mTag = tag;
        }

        private AttributedHistoricalOps(AttributedHistoricalOps other) {
            this.mTag = other.mTag;
            int opCount = other.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                HistoricalOp origOp = other.getOpAt(i);
                HistoricalOp cloneOp = new HistoricalOp(origOp);
                if (this.mHistoricalOps == null) {
                    this.mHistoricalOps = new ArrayMap(opCount);
                }
                this.mHistoricalOps.put(cloneOp.getOpName(), cloneOp);
            }
        }

        private AttributedHistoricalOps splice(double fractionToRemove) {
            AttributedHistoricalOps splice = null;
            int opCount = this.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                HistoricalOp origOps = this.getOpAt(i);
                HistoricalOp spliceOps = origOps.splice(fractionToRemove);
                if (spliceOps == null) continue;
                if (splice == null) {
                    splice = new AttributedHistoricalOps(this.mTag, null);
                }
                if (splice.mHistoricalOps == null) {
                    splice.mHistoricalOps = new ArrayMap();
                }
                splice.mHistoricalOps.put(spliceOps.getOpName(), spliceOps);
            }
            return splice;
        }

        private void merge(AttributedHistoricalOps other) {
            int opCount = other.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                HistoricalOp otherOp = other.getOpAt(i);
                HistoricalOp thisOp = this.getOp(otherOp.getOpName());
                if (thisOp != null) {
                    thisOp.merge(otherOp);
                    continue;
                }
                if (this.mHistoricalOps == null) {
                    this.mHistoricalOps = new ArrayMap();
                }
                this.mHistoricalOps.put(otherOp.getOpName(), otherOp);
            }
        }

        private void filter(String[] opNames, int filter, int historyFilter, double scaleFactor, long beginTimeMillis, long endTimeMillis) {
            int opCount = this.getOpCount();
            for (int i = opCount - 1; i >= 0; --i) {
                HistoricalOp op = this.mHistoricalOps.valueAt(i);
                if ((filter & 8) != 0 && !ArrayUtils.contains(opNames, op.getOpName())) {
                    this.mHistoricalOps.removeAt(i);
                    continue;
                }
                op.filter(historyFilter, scaleFactor, beginTimeMillis, endTimeMillis);
            }
        }

        private boolean isEmpty() {
            int opCount = this.getOpCount();
            for (int i = opCount - 1; i >= 0; --i) {
                HistoricalOp op = this.mHistoricalOps.valueAt(i);
                if (op.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private void increaseAccessCount(int opCode, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalOp(opCode).increaseAccessCount(uidState, flags, increment);
        }

        private void increaseRejectCount(int opCode, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalOp(opCode).increaseRejectCount(uidState, flags, increment);
        }

        private void increaseAccessDuration(int opCode, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalOp(opCode).increaseAccessDuration(uidState, flags, increment);
        }

        private void addDiscreteAccess(int opCode, int uidState, int flag, long discreteAccessTime, long discreteAccessDuration, OpEventProxyInfo proxy) {
            this.getOrCreateHistoricalOp(opCode).addDiscreteAccess(uidState, flag, discreteAccessTime, discreteAccessDuration, proxy);
        }

        public int getOpCount() {
            if (this.mHistoricalOps == null) {
                return 0;
            }
            return this.mHistoricalOps.size();
        }

        public HistoricalOp getOpAt(int index) {
            if (this.mHistoricalOps == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mHistoricalOps.valueAt(index);
        }

        public HistoricalOp getOp(String opName) {
            if (this.mHistoricalOps == null) {
                return null;
            }
            return this.mHistoricalOps.get(opName);
        }

        private void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalAttributionOps(this);
            int opCount = this.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                this.getOpAt(i).accept(visitor);
            }
        }

        private HistoricalOp getOrCreateHistoricalOp(int opCode) {
            String opStr;
            HistoricalOp op;
            if (this.mHistoricalOps == null) {
                this.mHistoricalOps = new ArrayMap();
            }
            if ((op = this.mHistoricalOps.get(opStr = AppOpsManager.sAppOpInfos[opCode].name)) == null) {
                op = new HistoricalOp(opCode);
                this.mHistoricalOps.put(opStr, op);
            }
            return op;
        }

        public AttributedHistoricalOps(String tag, ArrayMap<String, HistoricalOp> historicalOps) {
            this.mTag = tag;
            this.mHistoricalOps = historicalOps;
        }

        public String getTag() {
            return this.mTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributedHistoricalOps that = (AttributedHistoricalOps)o;
            return Objects.equals(this.mTag, that.mTag) && Objects.equals(this.mHistoricalOps, that.mHistoricalOps);
        }

        public int hashCode() {
            int _hash = 1;
            _hash = 31 * _hash + Objects.hashCode(this.mTag);
            _hash = 31 * _hash + Objects.hashCode(this.mHistoricalOps);
            return _hash;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mTag != null) {
                flg = (byte)(flg | 1);
            }
            if (this.mHistoricalOps != null) {
                flg = (byte)(flg | 2);
            }
            dest.writeByte(flg);
            if (this.mTag != null) {
                dest.writeString(this.mTag);
            }
            if (this.mHistoricalOps != null) {
                dest.writeMap(this.mHistoricalOps);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        AttributedHistoricalOps(Parcel in) {
            byte flg = in.readByte();
            String attributionTag = (flg & 1) == 0 ? null : in.readString();
            ArrayMap historicalOps = null;
            if ((flg & 2) != 0) {
                historicalOps = new ArrayMap();
                in.readMap(historicalOps, HistoricalOp.class.getClassLoader());
            }
            this.mTag = attributionTag;
            this.mHistoricalOps = historicalOps;
        }
    }

    @SystemApi
    public static class HistoricalPackageOps
    implements Parcelable {
        private final String mPackageName;
        private ArrayMap<String, AttributedHistoricalOps> mAttributedHistoricalOps;
        public static final Parcelable.Creator<HistoricalPackageOps> CREATOR = new Parcelable.Creator<HistoricalPackageOps>(){

            @Override
            public HistoricalPackageOps createFromParcel(Parcel parcel) {
                return new HistoricalPackageOps(parcel);
            }

            public HistoricalPackageOps[] newArray(int size) {
                return new HistoricalPackageOps[size];
            }
        };

        public HistoricalPackageOps(String packageName) {
            this.mPackageName = packageName;
        }

        private HistoricalPackageOps(HistoricalPackageOps other) {
            this.mPackageName = other.mPackageName;
            int opCount = other.getAttributedOpsCount();
            for (int i = 0; i < opCount; ++i) {
                AttributedHistoricalOps origOps = other.getAttributedOpsAt(i);
                AttributedHistoricalOps cloneOps = new AttributedHistoricalOps(origOps);
                if (this.mAttributedHistoricalOps == null) {
                    this.mAttributedHistoricalOps = new ArrayMap(opCount);
                }
                this.mAttributedHistoricalOps.put(cloneOps.getTag(), cloneOps);
            }
        }

        private HistoricalPackageOps(Parcel parcel) {
            this.mPackageName = parcel.readString();
            this.mAttributedHistoricalOps = parcel.createTypedArrayMap(AttributedHistoricalOps.CREATOR);
        }

        private HistoricalPackageOps splice(double fractionToRemove) {
            HistoricalPackageOps splice = null;
            int attributionCount = this.getAttributedOpsCount();
            for (int i = 0; i < attributionCount; ++i) {
                AttributedHistoricalOps origOps = this.getAttributedOpsAt(i);
                AttributedHistoricalOps spliceOps = origOps.splice(fractionToRemove);
                if (spliceOps == null) continue;
                if (splice == null) {
                    splice = new HistoricalPackageOps(this.mPackageName);
                }
                if (splice.mAttributedHistoricalOps == null) {
                    splice.mAttributedHistoricalOps = new ArrayMap();
                }
                splice.mAttributedHistoricalOps.put(spliceOps.getTag(), spliceOps);
            }
            return splice;
        }

        private void merge(HistoricalPackageOps other) {
            int attributionCount = other.getAttributedOpsCount();
            for (int i = 0; i < attributionCount; ++i) {
                AttributedHistoricalOps otherAttributionOps = other.getAttributedOpsAt(i);
                AttributedHistoricalOps thisAttributionOps = this.getAttributedOps(otherAttributionOps.getTag());
                if (thisAttributionOps != null) {
                    thisAttributionOps.merge(otherAttributionOps);
                    continue;
                }
                if (this.mAttributedHistoricalOps == null) {
                    this.mAttributedHistoricalOps = new ArrayMap();
                }
                this.mAttributedHistoricalOps.put(otherAttributionOps.getTag(), otherAttributionOps);
            }
        }

        private void filter(String attributionTag, String[] opNames, int filter, int historyFilter, double fractionToRemove, long beginTimeMillis, long endTimeMillis) {
            int attributionCount = this.getAttributedOpsCount();
            for (int i = attributionCount - 1; i >= 0; --i) {
                AttributedHistoricalOps attributionOps = this.getAttributedOpsAt(i);
                if ((filter & 4) != 0 && !Objects.equals(attributionTag, attributionOps.getTag())) {
                    this.mAttributedHistoricalOps.removeAt(i);
                    continue;
                }
                attributionOps.filter(opNames, filter, historyFilter, fractionToRemove, beginTimeMillis, endTimeMillis);
                if (attributionOps.getOpCount() != 0) continue;
                this.mAttributedHistoricalOps.removeAt(i);
            }
        }

        private void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalPackageOps(this);
            int attributionCount = this.getAttributedOpsCount();
            for (int i = 0; i < attributionCount; ++i) {
                this.getAttributedOpsAt(i).accept(visitor);
            }
        }

        private boolean isEmpty() {
            int attributionCount = this.getAttributedOpsCount();
            for (int i = attributionCount - 1; i >= 0; --i) {
                AttributedHistoricalOps attributionOps = this.mAttributedHistoricalOps.valueAt(i);
                if (attributionOps.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private void increaseAccessCount(int opCode, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateAttributedHistoricalOps(attributionTag).increaseAccessCount(opCode, uidState, flags, increment);
        }

        private void increaseRejectCount(int opCode, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateAttributedHistoricalOps(attributionTag).increaseRejectCount(opCode, uidState, flags, increment);
        }

        private void increaseAccessDuration(int opCode, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateAttributedHistoricalOps(attributionTag).increaseAccessDuration(opCode, uidState, flags, increment);
        }

        private void addDiscreteAccess(int opCode, String attributionTag, int uidState, int flag, long discreteAccessTime, long discreteAccessDuration, OpEventProxyInfo proxy) {
            this.getOrCreateAttributedHistoricalOps(attributionTag).addDiscreteAccess(opCode, uidState, flag, discreteAccessTime, discreteAccessDuration, proxy);
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        private AttributedHistoricalOps getOrCreateAttributedHistoricalOps(String attributionTag) {
            AttributedHistoricalOps historicalAttributionOp;
            if (this.mAttributedHistoricalOps == null) {
                this.mAttributedHistoricalOps = new ArrayMap();
            }
            if ((historicalAttributionOp = this.mAttributedHistoricalOps.get(attributionTag)) == null) {
                historicalAttributionOp = new AttributedHistoricalOps(attributionTag);
                this.mAttributedHistoricalOps.put(attributionTag, historicalAttributionOp);
            }
            return historicalAttributionOp;
        }

        public int getOpCount() {
            int numOps = 0;
            int numAttributions = this.getAttributedOpsCount();
            block0: for (int code = 0; code < 136; ++code) {
                String opName = AppOpsManager.opToPublicName(code);
                for (int attributionNum = 0; attributionNum < numAttributions; ++attributionNum) {
                    if (this.getAttributedOpsAt(attributionNum).getOp(opName) == null) continue;
                    ++numOps;
                    continue block0;
                }
            }
            return numOps;
        }

        public HistoricalOp getOpAt(int index) {
            int numOpsFound = 0;
            int numAttributions = this.getAttributedOpsCount();
            block0: for (int code = 0; code < 136; ++code) {
                String opName = AppOpsManager.opToPublicName(code);
                for (int attributionNum = 0; attributionNum < numAttributions; ++attributionNum) {
                    if (this.getAttributedOpsAt(attributionNum).getOp(opName) == null) continue;
                    if (numOpsFound == index) {
                        return this.getOp(opName);
                    }
                    ++numOpsFound;
                    continue block0;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public HistoricalOp getOp(String opName) {
            if (this.mAttributedHistoricalOps == null) {
                return null;
            }
            HistoricalOp combinedOp = null;
            int numAttributions = this.getAttributedOpsCount();
            for (int i = 0; i < numAttributions; ++i) {
                HistoricalOp attributionOp = this.getAttributedOpsAt(i).getOp(opName);
                if (attributionOp == null) continue;
                if (combinedOp == null) {
                    combinedOp = new HistoricalOp(attributionOp);
                    continue;
                }
                combinedOp.merge(attributionOp);
            }
            return combinedOp;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeString(this.mPackageName);
            parcel.writeTypedArrayMap(this.mAttributedHistoricalOps, flags);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalPackageOps other = (HistoricalPackageOps)obj;
            if (!this.mPackageName.equals(other.mPackageName)) {
                return false;
            }
            return !(this.mAttributedHistoricalOps == null ? other.mAttributedHistoricalOps != null : !this.mAttributedHistoricalOps.equals(other.mAttributedHistoricalOps));
        }

        public int hashCode() {
            int result = this.mPackageName != null ? this.mPackageName.hashCode() : 0;
            result = 31 * result + (this.mAttributedHistoricalOps != null ? this.mAttributedHistoricalOps.hashCode() : 0);
            return result;
        }

        public int getAttributedOpsCount() {
            if (this.mAttributedHistoricalOps == null) {
                return 0;
            }
            return this.mAttributedHistoricalOps.size();
        }

        public AttributedHistoricalOps getAttributedOpsAt(int index) {
            if (this.mAttributedHistoricalOps == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mAttributedHistoricalOps.valueAt(index);
        }

        public AttributedHistoricalOps getAttributedOps(String attributionTag) {
            if (this.mAttributedHistoricalOps == null) {
                return null;
            }
            return this.mAttributedHistoricalOps.get(attributionTag);
        }
    }

    @SystemApi
    public static class HistoricalUidOps
    implements Parcelable {
        private final int mUid;
        private ArrayMap<String, HistoricalPackageOps> mHistoricalPackageOps;
        public static final Parcelable.Creator<HistoricalUidOps> CREATOR = new Parcelable.Creator<HistoricalUidOps>(){

            @Override
            public HistoricalUidOps createFromParcel(Parcel parcel) {
                return new HistoricalUidOps(parcel);
            }

            public HistoricalUidOps[] newArray(int size) {
                return new HistoricalUidOps[size];
            }
        };

        public HistoricalUidOps(int uid) {
            this.mUid = uid;
        }

        private HistoricalUidOps(HistoricalUidOps other) {
            this.mUid = other.mUid;
            int opCount = other.getPackageCount();
            for (int i = 0; i < opCount; ++i) {
                HistoricalPackageOps origOps = other.getPackageOpsAt(i);
                HistoricalPackageOps cloneOps = new HistoricalPackageOps(origOps);
                if (this.mHistoricalPackageOps == null) {
                    this.mHistoricalPackageOps = new ArrayMap(opCount);
                }
                this.mHistoricalPackageOps.put(cloneOps.getPackageName(), cloneOps);
            }
        }

        private HistoricalUidOps(Parcel parcel) {
            this.mUid = parcel.readInt();
            this.mHistoricalPackageOps = parcel.createTypedArrayMap(HistoricalPackageOps.CREATOR);
        }

        private HistoricalUidOps splice(double fractionToRemove) {
            HistoricalUidOps splice = null;
            int packageCount = this.getPackageCount();
            for (int i = 0; i < packageCount; ++i) {
                HistoricalPackageOps origOps = this.getPackageOpsAt(i);
                HistoricalPackageOps spliceOps = origOps.splice(fractionToRemove);
                if (spliceOps == null) continue;
                if (splice == null) {
                    splice = new HistoricalUidOps(this.mUid);
                }
                if (splice.mHistoricalPackageOps == null) {
                    splice.mHistoricalPackageOps = new ArrayMap();
                }
                splice.mHistoricalPackageOps.put(spliceOps.getPackageName(), spliceOps);
            }
            return splice;
        }

        private void merge(HistoricalUidOps other) {
            int packageCount = other.getPackageCount();
            for (int i = 0; i < packageCount; ++i) {
                HistoricalPackageOps otherPackageOps = other.getPackageOpsAt(i);
                HistoricalPackageOps thisPackageOps = this.getPackageOps(otherPackageOps.getPackageName());
                if (thisPackageOps != null) {
                    thisPackageOps.merge(otherPackageOps);
                    continue;
                }
                if (this.mHistoricalPackageOps == null) {
                    this.mHistoricalPackageOps = new ArrayMap();
                }
                this.mHistoricalPackageOps.put(otherPackageOps.getPackageName(), otherPackageOps);
            }
        }

        private void filter(String packageName, String attributionTag, String[] opNames, int filter, int historyFilter, double fractionToRemove, long beginTimeMillis, long endTimeMillis) {
            int packageCount = this.getPackageCount();
            for (int i = packageCount - 1; i >= 0; --i) {
                HistoricalPackageOps packageOps = this.getPackageOpsAt(i);
                if ((filter & 2) != 0 && !packageName.equals(packageOps.getPackageName())) {
                    this.mHistoricalPackageOps.removeAt(i);
                    continue;
                }
                packageOps.filter(attributionTag, opNames, filter, historyFilter, fractionToRemove, beginTimeMillis, endTimeMillis);
                if (packageOps.getAttributedOpsCount() != 0) continue;
                this.mHistoricalPackageOps.removeAt(i);
            }
        }

        private boolean isEmpty() {
            int packageCount = this.getPackageCount();
            for (int i = packageCount - 1; i >= 0; --i) {
                HistoricalPackageOps packageOps = this.mHistoricalPackageOps.valueAt(i);
                if (packageOps.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private void increaseAccessCount(int opCode, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalPackageOps(packageName).increaseAccessCount(opCode, attributionTag, uidState, flags, increment);
        }

        private void increaseRejectCount(int opCode, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalPackageOps(packageName).increaseRejectCount(opCode, attributionTag, uidState, flags, increment);
        }

        private void increaseAccessDuration(int opCode, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalPackageOps(packageName).increaseAccessDuration(opCode, attributionTag, uidState, flags, increment);
        }

        private void addDiscreteAccess(int opCode, String packageName, String attributionTag, int uidState, int flag, long discreteAccessTime, long discreteAccessDuration, OpEventProxyInfo proxy) {
            this.getOrCreateHistoricalPackageOps(packageName).addDiscreteAccess(opCode, attributionTag, uidState, flag, discreteAccessTime, discreteAccessDuration, proxy);
        }

        public int getUid() {
            return this.mUid;
        }

        public int getPackageCount() {
            if (this.mHistoricalPackageOps == null) {
                return 0;
            }
            return this.mHistoricalPackageOps.size();
        }

        public HistoricalPackageOps getPackageOpsAt(int index) {
            if (this.mHistoricalPackageOps == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mHistoricalPackageOps.valueAt(index);
        }

        public HistoricalPackageOps getPackageOps(String packageName) {
            if (this.mHistoricalPackageOps == null) {
                return null;
            }
            return this.mHistoricalPackageOps.get(packageName);
        }

        private void clearHistory(String packageName) {
            if (this.mHistoricalPackageOps != null) {
                this.mHistoricalPackageOps.remove(packageName);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeInt(this.mUid);
            parcel.writeTypedArrayMap(this.mHistoricalPackageOps, flags);
        }

        private void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalUidOps(this);
            int packageCount = this.getPackageCount();
            for (int i = 0; i < packageCount; ++i) {
                this.getPackageOpsAt(i).accept(visitor);
            }
        }

        private HistoricalPackageOps getOrCreateHistoricalPackageOps(String packageName) {
            HistoricalPackageOps historicalPackageOp;
            if (this.mHistoricalPackageOps == null) {
                this.mHistoricalPackageOps = new ArrayMap();
            }
            if ((historicalPackageOp = this.mHistoricalPackageOps.get(packageName)) == null) {
                historicalPackageOp = new HistoricalPackageOps(packageName);
                this.mHistoricalPackageOps.put(packageName, historicalPackageOp);
            }
            return historicalPackageOp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalUidOps other = (HistoricalUidOps)obj;
            if (this.mUid != other.mUid) {
                return false;
            }
            return !(this.mHistoricalPackageOps == null ? other.mHistoricalPackageOps != null : !this.mHistoricalPackageOps.equals(other.mHistoricalPackageOps));
        }

        public int hashCode() {
            int result = this.mUid;
            result = 31 * result + (this.mHistoricalPackageOps != null ? this.mHistoricalPackageOps.hashCode() : 0);
            return result;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HistoricalOpsRequestFilter {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OpHistoryFlags {
    }

    public static interface HistoricalOpsVisitor {
        public void visitHistoricalOps(HistoricalOps var1);

        public void visitHistoricalUidOps(HistoricalUidOps var1);

        public void visitHistoricalPackageOps(HistoricalPackageOps var1);

        public void visitHistoricalAttributionOps(AttributedHistoricalOps var1);

        public void visitHistoricalOp(HistoricalOp var1);
    }

    @SystemApi
    @Immutable
    public static class OpEntry
    implements Parcelable {
        private final int mOp;
        private final int mMode;
        private final Map<String, AttributedOpEntry> mAttributedOpEntries;
        public static final Parcelable.Creator<OpEntry> CREATOR = new Parcelable.Creator<OpEntry>(){

            public OpEntry[] newArray(int size) {
                return new OpEntry[size];
            }

            @Override
            public OpEntry createFromParcel(Parcel in) {
                return new OpEntry(in);
            }
        };

        @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="{@code #getOpStr()}")
        public int getOp() {
            return this.mOp;
        }

        public String getOpStr() {
            return AppOpsManager.sAppOpInfos[this.mOp].name;
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="{@code #getLastAccessTime(int)}")
        public long getTime() {
            return this.getLastAccessTime(31);
        }

        public long getLastAccessTime(int flags) {
            return this.getLastAccessTime(100, 700, flags);
        }

        public long getLastAccessForegroundTime(int flags) {
            return this.getLastAccessTime(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastAccessBackgroundTime(int flags) {
            return this.getLastAccessTime(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        private NoteOpEvent getLastAccessEvent(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastAccessEvent = null;
            for (AttributedOpEntry attributionEntry : this.mAttributedOpEntries.values()) {
                NoteOpEvent lastAttributionAccessEvent = attributionEntry.getLastAccessEvent(fromUidState, toUidState, flags);
                if (lastAccessEvent != null && (lastAttributionAccessEvent == null || lastAttributionAccessEvent.getNoteTime() <= lastAccessEvent.getNoteTime())) continue;
                lastAccessEvent = lastAttributionAccessEvent;
            }
            return lastAccessEvent;
        }

        public long getLastAccessTime(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getNoteTime();
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="{@code #getLastRejectTime(int)}")
        public long getRejectTime() {
            return this.getLastRejectTime(31);
        }

        public long getLastRejectTime(int flags) {
            return this.getLastRejectTime(100, 700, flags);
        }

        public long getLastRejectForegroundTime(int flags) {
            return this.getLastRejectTime(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastRejectBackgroundTime(int flags) {
            return this.getLastRejectTime(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        private NoteOpEvent getLastRejectEvent(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastAccessEvent = null;
            for (AttributedOpEntry attributionEntry : this.mAttributedOpEntries.values()) {
                NoteOpEvent lastAttributionAccessEvent = attributionEntry.getLastRejectEvent(fromUidState, toUidState, flags);
                if (lastAccessEvent != null && (lastAttributionAccessEvent == null || lastAttributionAccessEvent.getNoteTime() <= lastAccessEvent.getNoteTime())) continue;
                lastAccessEvent = lastAttributionAccessEvent;
            }
            return lastAccessEvent;
        }

        public long getLastRejectTime(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastRejectEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getNoteTime();
        }

        public boolean isRunning() {
            for (AttributedOpEntry opAttributionEntry : this.mAttributedOpEntries.values()) {
                if (!opAttributionEntry.isRunning()) continue;
                return true;
            }
            return false;
        }

        @Deprecated
        public long getDuration() {
            return this.getLastDuration(31);
        }

        public long getLastDuration(int flags) {
            return this.getLastDuration(100, 700, flags);
        }

        public long getLastForegroundDuration(int flags) {
            return this.getLastDuration(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastBackgroundDuration(int flags) {
            return this.getLastDuration(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getLastDuration(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getDuration();
        }

        @Deprecated
        public int getProxyUid() {
            OpEventProxyInfo proxy = this.getLastProxyInfo(31);
            if (proxy == null) {
                return -1;
            }
            return proxy.getUid();
        }

        @Deprecated
        public int getProxyUid(int uidState, int flags) {
            OpEventProxyInfo proxy = this.getLastProxyInfo(uidState, uidState, flags);
            if (proxy == null) {
                return -1;
            }
            return proxy.getUid();
        }

        @Deprecated
        public String getProxyPackageName() {
            OpEventProxyInfo proxy = this.getLastProxyInfo(31);
            if (proxy == null) {
                return null;
            }
            return proxy.getPackageName();
        }

        @Deprecated
        public String getProxyPackageName(int uidState, int flags) {
            OpEventProxyInfo proxy = this.getLastProxyInfo(uidState, uidState, flags);
            if (proxy == null) {
                return null;
            }
            return proxy.getPackageName();
        }

        public OpEventProxyInfo getLastProxyInfo(int flags) {
            return this.getLastProxyInfo(100, 700, flags);
        }

        public OpEventProxyInfo getLastForegroundProxyInfo(int flags) {
            return this.getLastProxyInfo(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public OpEventProxyInfo getLastBackgroundProxyInfo(int flags) {
            return this.getLastProxyInfo(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public OpEventProxyInfo getLastProxyInfo(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return null;
            }
            return lastEvent.getProxy();
        }

        public OpEntry(int op, int mode, Map<String, AttributedOpEntry> attributedOpEntries) {
            this.mOp = op;
            AnnotationValidations.validate(IntRange.class, null, this.mOp, "from", 0L, "to", 135L);
            this.mMode = mode;
            AnnotationValidations.validate(Mode.class, null, this.mMode);
            this.mAttributedOpEntries = attributedOpEntries;
            AnnotationValidations.validate(NonNull.class, null, this.mAttributedOpEntries);
        }

        public int getMode() {
            return this.mMode;
        }

        public Map<String, AttributedOpEntry> getAttributedOpEntries() {
            return this.mAttributedOpEntries;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mOp);
            dest.writeInt(this.mMode);
            dest.writeMap(this.mAttributedOpEntries);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        OpEntry(Parcel in) {
            int op = in.readInt();
            int mode = in.readInt();
            LinkedHashMap<String, AttributedOpEntry> attributions = new LinkedHashMap<String, AttributedOpEntry>();
            in.readMap(attributions, AttributedOpEntry.class.getClassLoader());
            this.mOp = op;
            AnnotationValidations.validate(IntRange.class, null, this.mOp, "from", 0L, "to", 135L);
            this.mMode = mode;
            AnnotationValidations.validate(Mode.class, null, this.mMode);
            this.mAttributedOpEntries = attributions;
            AnnotationValidations.validate(NonNull.class, null, this.mAttributedOpEntries);
        }
    }

    @SystemApi
    public static class PackageOps
    implements Parcelable {
        private final String mPackageName;
        private final int mUid;
        private final List<OpEntry> mEntries;
        public static final Parcelable.Creator<PackageOps> CREATOR = new Parcelable.Creator<PackageOps>(){

            @Override
            public PackageOps createFromParcel(Parcel source) {
                return new PackageOps(source);
            }

            public PackageOps[] newArray(int size) {
                return new PackageOps[size];
            }
        };

        @UnsupportedAppUsage
        public PackageOps(String packageName, int uid, List<OpEntry> entries) {
            this.mPackageName = packageName;
            this.mUid = uid;
            this.mEntries = entries;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public int getUid() {
            return this.mUid;
        }

        public List<OpEntry> getOps() {
            return this.mEntries;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mPackageName);
            dest.writeInt(this.mUid);
            dest.writeInt(this.mEntries.size());
            for (int i = 0; i < this.mEntries.size(); ++i) {
                this.mEntries.get(i).writeToParcel(dest, flags);
            }
        }

        PackageOps(Parcel source) {
            this.mPackageName = source.readString();
            this.mUid = source.readInt();
            this.mEntries = new ArrayList<OpEntry>();
            int N = source.readInt();
            for (int i = 0; i < N; ++i) {
                this.mEntries.add(OpEntry.CREATOR.createFromParcel(source));
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ShouldCollectNoteOp {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppOpString {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
    public static @interface DataBucketKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SamplingStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttributionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OpFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UidState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HistoricalMode {
    }
}

