/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ComponentOptions;
import android.app.compat.CompatChanges;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.BundleMerger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class BroadcastOptions
extends ComponentOptions {
    private int mFlags;
    private long mTemporaryAppAllowlistDuration;
    private int mTemporaryAppAllowlistType;
    private int mTemporaryAppAllowlistReasonCode;
    private String mTemporaryAppAllowlistReason;
    private int mMinManifestReceiverApiLevel = 0;
    private int mMaxManifestReceiverApiLevel = 10000;
    private String[] mRequireAllOfPermissions;
    private String[] mRequireNoneOfPermissions;
    private long mRequireCompatChangeId = Long.MIN_VALUE;
    private long mIdForResponseEvent;
    private int mDeliveryGroupPolicy;
    private String mDeliveryGroupMatchingNamespaceFragment;
    private String mDeliveryGroupMatchingKeyFragment;
    private BundleMerger mDeliveryGroupExtrasMerger;
    private IntentFilter mDeliveryGroupMatchingFilter;
    private int mDeferralPolicy;
    private static final int FLAG_DONT_SEND_TO_RESTRICTED_APPS = 1;
    private static final int FLAG_ALLOW_BACKGROUND_ACTIVITY_STARTS = 2;
    private static final int FLAG_REQUIRE_COMPAT_CHANGE_ENABLED = 4;
    private static final int FLAG_IS_ALARM_BROADCAST = 8;
    private static final int FLAG_SHARE_IDENTITY = 16;
    private static final int FLAG_INTERACTIVE = 32;
    public static final long CHANGE_INVALID = Long.MIN_VALUE;
    public static final long CHANGE_ALWAYS_ENABLED = 209888056L;
    public static final long CHANGE_ALWAYS_DISABLED = 210856463L;
    private static final String KEY_FLAGS = "android:broadcast.flags";
    private static final String KEY_TEMPORARY_APP_ALLOWLIST_DURATION = "android:broadcast.temporaryAppAllowlistDuration";
    private static final String KEY_TEMPORARY_APP_ALLOWLIST_TYPE = "android:broadcast.temporaryAppAllowlistType";
    private static final String KEY_TEMPORARY_APP_ALLOWLIST_REASON_CODE = "android:broadcast.temporaryAppAllowlistReasonCode";
    private static final String KEY_TEMPORARY_APP_ALLOWLIST_REASON = "android:broadcast.temporaryAppAllowlistReason";
    private static final String KEY_MIN_MANIFEST_RECEIVER_API_LEVEL = "android:broadcast.minManifestReceiverApiLevel";
    private static final String KEY_MAX_MANIFEST_RECEIVER_API_LEVEL = "android:broadcast.maxManifestReceiverApiLevel";
    public static final String KEY_REQUIRE_ALL_OF_PERMISSIONS = "android:broadcast.requireAllOfPermissions";
    public static final String KEY_REQUIRE_NONE_OF_PERMISSIONS = "android:broadcast.requireNoneOfPermissions";
    private static final String KEY_REQUIRE_COMPAT_CHANGE_ID = "android:broadcast.requireCompatChangeId";
    @Deprecated
    public static final int TEMPORARY_WHITELIST_TYPE_FOREGROUND_SERVICE_ALLOWED = 0;
    @Deprecated
    public static final int TEMPORARY_WHITELIST_TYPE_FOREGROUND_SERVICE_NOT_ALLOWED = 1;
    private static final String KEY_ID_FOR_RESPONSE_EVENT = "android:broadcast.idForResponseEvent";
    private static final String KEY_DELIVERY_GROUP_POLICY = "android:broadcast.deliveryGroupPolicy";
    private static final String KEY_DELIVERY_GROUP_NAMESPACE = "android:broadcast.deliveryGroupMatchingNamespace";
    private static final String KEY_DELIVERY_GROUP_KEY = "android:broadcast.deliveryGroupMatchingKey";
    private static final String KEY_DELIVERY_GROUP_EXTRAS_MERGER = "android:broadcast.deliveryGroupExtrasMerger";
    private static final String KEY_DELIVERY_GROUP_MATCHING_FILTER = "android:broadcast.deliveryGroupMatchingFilter";
    private static final String KEY_DEFERRAL_POLICY = "android:broadcast.deferralPolicy";
    public static final int DELIVERY_GROUP_POLICY_ALL = 0;
    public static final int DELIVERY_GROUP_POLICY_MOST_RECENT = 1;
    public static final int DELIVERY_GROUP_POLICY_MERGED = 2;
    public static final int DEFERRAL_POLICY_DEFAULT = 0;
    public static final int DEFERRAL_POLICY_NONE = 1;
    public static final int DEFERRAL_POLICY_UNTIL_ACTIVE = 2;

    public static BroadcastOptions makeBasic() {
        BroadcastOptions opts = new BroadcastOptions();
        return opts;
    }

    public BroadcastOptions() {
        this.resetTemporaryAppAllowlist();
    }

    public BroadcastOptions(Bundle opts) {
        super(opts);
        this.mFlags = opts.getInt(KEY_FLAGS, 0);
        if (opts.containsKey(KEY_TEMPORARY_APP_ALLOWLIST_DURATION)) {
            this.mTemporaryAppAllowlistDuration = opts.getLong(KEY_TEMPORARY_APP_ALLOWLIST_DURATION);
            this.mTemporaryAppAllowlistType = opts.getInt(KEY_TEMPORARY_APP_ALLOWLIST_TYPE);
            this.mTemporaryAppAllowlistReasonCode = opts.getInt(KEY_TEMPORARY_APP_ALLOWLIST_REASON_CODE, 0);
            this.mTemporaryAppAllowlistReason = opts.getString(KEY_TEMPORARY_APP_ALLOWLIST_REASON);
        } else {
            this.resetTemporaryAppAllowlist();
        }
        this.mMinManifestReceiverApiLevel = opts.getInt(KEY_MIN_MANIFEST_RECEIVER_API_LEVEL, 0);
        this.mMaxManifestReceiverApiLevel = opts.getInt(KEY_MAX_MANIFEST_RECEIVER_API_LEVEL, 10000);
        this.mRequireAllOfPermissions = opts.getStringArray(KEY_REQUIRE_ALL_OF_PERMISSIONS);
        this.mRequireNoneOfPermissions = opts.getStringArray(KEY_REQUIRE_NONE_OF_PERMISSIONS);
        this.mRequireCompatChangeId = opts.getLong(KEY_REQUIRE_COMPAT_CHANGE_ID, Long.MIN_VALUE);
        this.mIdForResponseEvent = opts.getLong(KEY_ID_FOR_RESPONSE_EVENT);
        this.mDeliveryGroupPolicy = opts.getInt(KEY_DELIVERY_GROUP_POLICY, 0);
        this.mDeliveryGroupMatchingNamespaceFragment = opts.getString(KEY_DELIVERY_GROUP_NAMESPACE);
        this.mDeliveryGroupMatchingKeyFragment = opts.getString(KEY_DELIVERY_GROUP_KEY);
        this.mDeliveryGroupExtrasMerger = opts.getParcelable(KEY_DELIVERY_GROUP_EXTRAS_MERGER, BundleMerger.class);
        this.mDeliveryGroupMatchingFilter = opts.getParcelable(KEY_DELIVERY_GROUP_MATCHING_FILTER, IntentFilter.class);
        this.mDeferralPolicy = opts.getInt(KEY_DEFERRAL_POLICY, 0);
    }

    public static BroadcastOptions makeWithDeferUntilActive(boolean deferUntilActive) {
        BroadcastOptions opts = BroadcastOptions.makeBasic();
        if (deferUntilActive) {
            opts.setDeferralPolicy(2);
        }
        return opts;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", "android.permission.START_ACTIVITIES_FROM_BACKGROUND", "android.permission.START_FOREGROUND_SERVICES_FROM_BACKGROUND"})
    public void setTemporaryAppWhitelistDuration(long duration) {
        this.setTemporaryAppAllowlist(duration, 0, 0, null);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", "android.permission.START_ACTIVITIES_FROM_BACKGROUND", "android.permission.START_FOREGROUND_SERVICES_FROM_BACKGROUND"})
    public void setTemporaryAppAllowlist(long duration, int type, int reasonCode, String reason) {
        this.mTemporaryAppAllowlistDuration = duration;
        this.mTemporaryAppAllowlistType = type;
        this.mTemporaryAppAllowlistReasonCode = reasonCode;
        this.mTemporaryAppAllowlistReason = reason;
        if (!this.isTemporaryAppAllowlistSet()) {
            this.resetTemporaryAppAllowlist();
        }
    }

    private boolean isTemporaryAppAllowlistSet() {
        return this.mTemporaryAppAllowlistDuration > 0L && this.mTemporaryAppAllowlistType != -1;
    }

    private void resetTemporaryAppAllowlist() {
        this.mTemporaryAppAllowlistDuration = 0L;
        this.mTemporaryAppAllowlistType = -1;
        this.mTemporaryAppAllowlistReasonCode = 0;
        this.mTemporaryAppAllowlistReason = null;
    }

    public long getTemporaryAppAllowlistDuration() {
        return this.mTemporaryAppAllowlistDuration;
    }

    public int getTemporaryAppAllowlistType() {
        return this.mTemporaryAppAllowlistType;
    }

    public int getTemporaryAppAllowlistReasonCode() {
        return this.mTemporaryAppAllowlistReasonCode;
    }

    public String getTemporaryAppAllowlistReason() {
        return this.mTemporaryAppAllowlistReason;
    }

    @Deprecated
    public void setMinManifestReceiverApiLevel(int apiLevel) {
        this.mMinManifestReceiverApiLevel = apiLevel;
    }

    @Deprecated
    public int getMinManifestReceiverApiLevel() {
        return this.mMinManifestReceiverApiLevel;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @Deprecated
    public void setMaxManifestReceiverApiLevel(int apiLevel) {
        this.mMaxManifestReceiverApiLevel = apiLevel;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @Deprecated
    public int getMaxManifestReceiverApiLevel() {
        return this.mMaxManifestReceiverApiLevel;
    }

    @SystemApi
    public void setDontSendToRestrictedApps(boolean dontSendToRestrictedApps) {
        this.mFlags = dontSendToRestrictedApps ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
    }

    public boolean isDontSendToRestrictedApps() {
        return (this.mFlags & 1) != 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.START_ACTIVITIES_FROM_BACKGROUND")
    public void setBackgroundActivityStartsAllowed(boolean allowBackgroundActivityStarts) {
        this.mFlags = allowBackgroundActivityStarts ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
    }

    @Deprecated
    public boolean allowsBackgroundActivityStarts() {
        return (this.mFlags & 2) != 0;
    }

    @SystemApi
    public void setRequireAllOfPermissions(String[] requiredPermissions) {
        this.mRequireAllOfPermissions = requiredPermissions;
    }

    @SystemApi
    public void setRequireNoneOfPermissions(String[] excludedPermissions) {
        this.mRequireNoneOfPermissions = excludedPermissions;
    }

    @SystemApi
    public void setRequireCompatChange(long changeId, boolean enabled) {
        this.mRequireCompatChangeId = changeId;
        this.mFlags = enabled ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
    }

    @SystemApi
    public void clearRequireCompatChange() {
        this.setRequireCompatChange(Long.MIN_VALUE, true);
    }

    public void setAlarmBroadcast(boolean senderIsAlarm) {
        this.mFlags = senderIsAlarm ? (this.mFlags |= 8) : (this.mFlags &= 0xFFFFFFF7);
    }

    public boolean isAlarmBroadcast() {
        return (this.mFlags & 8) != 0;
    }

    public BroadcastOptions setShareIdentityEnabled(boolean shareIdentityEnabled) {
        this.mFlags = shareIdentityEnabled ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
        return this;
    }

    public boolean isShareIdentityEnabled() {
        return (this.mFlags & 0x10) != 0;
    }

    public boolean isPushMessagingBroadcast() {
        return this.mTemporaryAppAllowlistReasonCode == 101;
    }

    public boolean isPushMessagingOverQuotaBroadcast() {
        return this.mTemporaryAppAllowlistReasonCode == 102;
    }

    public long getRequireCompatChangeId() {
        return this.mRequireCompatChangeId;
    }

    public boolean testRequireCompatChange(int uid) {
        if (this.mRequireCompatChangeId != Long.MIN_VALUE) {
            boolean requireEnabled = (this.mFlags & 4) != 0;
            return CompatChanges.isChangeEnabled(this.mRequireCompatChangeId, uid) == requireEnabled;
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RESPONSE_STATS")
    public void recordResponseEventWhileInBackground(long id2) {
        this.mIdForResponseEvent = id2;
    }

    public long getIdForResponseEvent() {
        return this.mIdForResponseEvent;
    }

    public BroadcastOptions setDeferralPolicy(int deferralPolicy) {
        this.mDeferralPolicy = deferralPolicy;
        return this;
    }

    public int getDeferralPolicy() {
        return this.mDeferralPolicy;
    }

    public void clearDeferralPolicy() {
        this.mDeferralPolicy = 0;
    }

    public BroadcastOptions setDeliveryGroupPolicy(int policy) {
        this.mDeliveryGroupPolicy = policy;
        return this;
    }

    public int getDeliveryGroupPolicy() {
        return this.mDeliveryGroupPolicy;
    }

    public void clearDeliveryGroupPolicy() {
        this.mDeliveryGroupPolicy = 0;
    }

    public BroadcastOptions setDeliveryGroupMatchingKey(String namespace, String key) {
        this.mDeliveryGroupMatchingNamespaceFragment = Objects.requireNonNull(namespace);
        this.mDeliveryGroupMatchingKeyFragment = Objects.requireNonNull(key);
        return this;
    }

    public String getDeliveryGroupMatchingKey() {
        if (this.mDeliveryGroupMatchingNamespaceFragment == null || this.mDeliveryGroupMatchingKeyFragment == null) {
            return null;
        }
        return String.join((CharSequence)":", this.mDeliveryGroupMatchingNamespaceFragment, this.mDeliveryGroupMatchingKeyFragment);
    }

    public String getDeliveryGroupMatchingNamespaceFragment() {
        return this.mDeliveryGroupMatchingNamespaceFragment;
    }

    public String getDeliveryGroupMatchingKeyFragment() {
        return this.mDeliveryGroupMatchingKeyFragment;
    }

    public void clearDeliveryGroupMatchingKey() {
        this.mDeliveryGroupMatchingNamespaceFragment = null;
        this.mDeliveryGroupMatchingKeyFragment = null;
    }

    public BroadcastOptions setDeliveryGroupMatchingFilter(IntentFilter matchingFilter) {
        this.mDeliveryGroupMatchingFilter = Objects.requireNonNull(matchingFilter);
        return this;
    }

    public IntentFilter getDeliveryGroupMatchingFilter() {
        return this.mDeliveryGroupMatchingFilter;
    }

    public void clearDeliveryGroupMatchingFilter() {
        this.mDeliveryGroupMatchingFilter = null;
    }

    public BroadcastOptions setDeliveryGroupExtrasMerger(BundleMerger extrasMerger) {
        this.mDeliveryGroupExtrasMerger = Objects.requireNonNull(extrasMerger);
        return this;
    }

    public BundleMerger getDeliveryGroupExtrasMerger() {
        return this.mDeliveryGroupExtrasMerger;
    }

    public void clearDeliveryGroupExtrasMerger() {
        this.mDeliveryGroupExtrasMerger = null;
    }

    @RequiresPermission(value="android.permission.BROADCAST_OPTION_INTERACTIVE")
    public BroadcastOptions setInteractive(boolean interactive) {
        this.mFlags = interactive ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
        return this;
    }

    @RequiresPermission(value="android.permission.BROADCAST_OPTION_INTERACTIVE")
    public boolean isInteractive() {
        return (this.mFlags & 0x20) != 0;
    }

    @Override
    @SystemApi
    @Deprecated
    public void setPendingIntentBackgroundActivityLaunchAllowed(boolean allowed) {
        super.setPendingIntentBackgroundActivityLaunchAllowed(allowed);
    }

    @Override
    @SystemApi
    @Deprecated
    public boolean isPendingIntentBackgroundActivityLaunchAllowed() {
        return super.isPendingIntentBackgroundActivityLaunchAllowed();
    }

    @Override
    @SystemApi
    public BroadcastOptions setPendingIntentBackgroundActivityStartMode(int state) {
        super.setPendingIntentBackgroundActivityStartMode(state);
        return this;
    }

    @Override
    @SystemApi
    public int getPendingIntentBackgroundActivityStartMode() {
        return super.getPendingIntentBackgroundActivityStartMode();
    }

    @Override
    public Bundle toBundle() {
        Bundle b = super.toBundle();
        if (this.mFlags != 0) {
            b.putInt(KEY_FLAGS, this.mFlags);
        }
        if (this.isTemporaryAppAllowlistSet()) {
            b.putLong(KEY_TEMPORARY_APP_ALLOWLIST_DURATION, this.mTemporaryAppAllowlistDuration);
            b.putInt(KEY_TEMPORARY_APP_ALLOWLIST_TYPE, this.mTemporaryAppAllowlistType);
            b.putInt(KEY_TEMPORARY_APP_ALLOWLIST_REASON_CODE, this.mTemporaryAppAllowlistReasonCode);
            b.putString(KEY_TEMPORARY_APP_ALLOWLIST_REASON, this.mTemporaryAppAllowlistReason);
        }
        if (this.mMinManifestReceiverApiLevel != 0) {
            b.putInt(KEY_MIN_MANIFEST_RECEIVER_API_LEVEL, this.mMinManifestReceiverApiLevel);
        }
        if (this.mMaxManifestReceiverApiLevel != 10000) {
            b.putInt(KEY_MAX_MANIFEST_RECEIVER_API_LEVEL, this.mMaxManifestReceiverApiLevel);
        }
        if (this.mRequireAllOfPermissions != null) {
            b.putStringArray(KEY_REQUIRE_ALL_OF_PERMISSIONS, this.mRequireAllOfPermissions);
        }
        if (this.mRequireNoneOfPermissions != null) {
            b.putStringArray(KEY_REQUIRE_NONE_OF_PERMISSIONS, this.mRequireNoneOfPermissions);
        }
        if (this.mRequireCompatChangeId != Long.MIN_VALUE) {
            b.putLong(KEY_REQUIRE_COMPAT_CHANGE_ID, this.mRequireCompatChangeId);
        }
        if (this.mIdForResponseEvent != 0L) {
            b.putLong(KEY_ID_FOR_RESPONSE_EVENT, this.mIdForResponseEvent);
        }
        if (this.mDeliveryGroupPolicy != 0) {
            b.putInt(KEY_DELIVERY_GROUP_POLICY, this.mDeliveryGroupPolicy);
        }
        if (this.mDeliveryGroupMatchingNamespaceFragment != null) {
            b.putString(KEY_DELIVERY_GROUP_NAMESPACE, this.mDeliveryGroupMatchingNamespaceFragment);
        }
        if (this.mDeliveryGroupMatchingKeyFragment != null) {
            b.putString(KEY_DELIVERY_GROUP_KEY, this.mDeliveryGroupMatchingKeyFragment);
        }
        if (this.mDeliveryGroupPolicy == 2) {
            if (this.mDeliveryGroupExtrasMerger != null) {
                b.putParcelable(KEY_DELIVERY_GROUP_EXTRAS_MERGER, this.mDeliveryGroupExtrasMerger);
            } else {
                throw new IllegalStateException("Extras merger cannot be empty when delivery group policy is 'MERGED'");
            }
        }
        if (this.mDeliveryGroupMatchingFilter != null) {
            b.putParcelable(KEY_DELIVERY_GROUP_MATCHING_FILTER, this.mDeliveryGroupMatchingFilter);
        }
        if (this.mDeferralPolicy != 0) {
            b.putInt(KEY_DEFERRAL_POLICY, this.mDeferralPolicy);
        }
        return b;
    }

    public static BroadcastOptions fromBundle(Bundle options) {
        return new BroadcastOptions(options);
    }

    public static BroadcastOptions fromBundleNullable(Bundle options) {
        return options != null ? new BroadcastOptions(options) : null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeferralPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeliveryGroupPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

