/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SuppressLint;
import android.os.Bundle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"UserHandleName"})
public class ComponentOptions {
    public static final String KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED = "android.pendingIntent.backgroundActivityAllowed";
    public static final String KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED_BY_PERMISSION = "android.pendingIntent.backgroundActivityAllowedByPermission";
    private Boolean mPendingIntentBalAllowed = null;
    private boolean mPendingIntentBalAllowedByPermission = false;
    public static final int MODE_BACKGROUND_ACTIVITY_START_SYSTEM_DEFINED = 0;
    public static final int MODE_BACKGROUND_ACTIVITY_START_ALLOWED = 1;
    public static final int MODE_BACKGROUND_ACTIVITY_START_DENIED = 2;

    ComponentOptions() {
    }

    ComponentOptions(Bundle opts) {
        opts.setDefusable(true);
        boolean pendingIntentBalAllowedIsSetExplicitly = opts.containsKey(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED);
        if (pendingIntentBalAllowedIsSetExplicitly) {
            this.mPendingIntentBalAllowed = opts.getBoolean(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED);
        }
        this.setPendingIntentBackgroundActivityLaunchAllowedByPermission(opts.getBoolean(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED_BY_PERMISSION, false));
    }

    @Deprecated
    public void setPendingIntentBackgroundActivityLaunchAllowed(boolean allowed) {
        this.mPendingIntentBalAllowed = allowed;
    }

    @Deprecated
    public boolean isPendingIntentBackgroundActivityLaunchAllowed() {
        if (this.mPendingIntentBalAllowed == null) {
            return true;
        }
        return this.mPendingIntentBalAllowed;
    }

    public ComponentOptions setPendingIntentBackgroundActivityStartMode(int state) {
        switch (state) {
            case 0: {
                this.mPendingIntentBalAllowed = null;
                break;
            }
            case 1: {
                this.mPendingIntentBalAllowed = true;
                break;
            }
            case 2: {
                this.mPendingIntentBalAllowed = false;
                break;
            }
            default: {
                throw new IllegalArgumentException(state + " is not valid");
            }
        }
        return this;
    }

    public int getPendingIntentBackgroundActivityStartMode() {
        if (this.mPendingIntentBalAllowed == null) {
            return 0;
        }
        if (this.mPendingIntentBalAllowed.booleanValue()) {
            return 1;
        }
        return 2;
    }

    public void setPendingIntentBackgroundActivityLaunchAllowedByPermission(boolean allowed) {
        this.mPendingIntentBalAllowedByPermission = allowed;
    }

    public boolean isPendingIntentBackgroundActivityLaunchAllowedByPermission() {
        return this.mPendingIntentBalAllowedByPermission;
    }

    public Bundle toBundle() {
        Bundle b = new Bundle();
        if (this.mPendingIntentBalAllowed != null) {
            b.putBoolean(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED, this.mPendingIntentBalAllowed);
        }
        if (this.mPendingIntentBalAllowedByPermission) {
            b.putBoolean(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED_BY_PERMISSION, this.mPendingIntentBalAllowedByPermission);
        }
        return b;
    }

    public static ComponentOptions fromBundle(Bundle options) {
        return options != null ? new ComponentOptions(options) : null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackgroundActivityStartMode {
    }
}

