/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.content.ComponentName;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.dreams.IDreamManager;

public class DreamManager {
    private final IDreamManager mService = IDreamManager.Stub.asInterface(ServiceManager.getServiceOrThrow("dreams"));
    private final Context mContext;

    public DreamManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
    }

    public boolean isScreensaverEnabled() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "screensaver_enabled", 0, -2) != 0;
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setScreensaverEnabled(boolean enabled) {
        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "screensaver_enabled", enabled ? 1 : 0, -2);
    }

    public boolean areDreamsSupported() {
        return this.mContext.getResources().getBoolean(17891637);
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void startDream() {
        try {
            this.mService.dream();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void stopDream() {
        try {
            this.mService.awaken();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setActiveDream(ComponentName dreamComponent) {
        ComponentName[] dreams = new ComponentName[]{dreamComponent};
        try {
            this.mService.setDreamComponentsForUser(this.mContext.getUserId(), (ComponentName[])(dreamComponent != null ? dreams : null));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setSystemDreamComponent(ComponentName dreamComponent) {
        try {
            this.mService.setSystemDreamComponent(dreamComponent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setDreamOverlay(ComponentName dreamOverlayComponent) {
        try {
            this.mService.registerDreamOverlayService(dreamOverlayComponent);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isDreaming() {
        try {
            return this.mService.isDreaming();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }
}

