/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.LayoutTransition;
import android.app.Activity;
import android.app.BackStackRecord;
import android.app.FragmentManager;
import android.app.FragmentManagerImpl;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.R;

@Deprecated
public class FragmentBreadCrumbs
extends ViewGroup
implements FragmentManager.OnBackStackChangedListener {
    Activity mActivity;
    LayoutInflater mInflater;
    LinearLayout mContainer;
    int mMaxVisible = -1;
    BackStackRecord mTopEntry;
    BackStackRecord mParentEntry;
    private View.OnClickListener mParentClickListener;
    private OnBreadCrumbClickListener mOnBreadCrumbClickListener;
    private int mGravity;
    private int mLayoutResId;
    private int mTextColor;
    private static final int DEFAULT_GRAVITY = 8388627;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        @Override
        public void onClick(View v) {
            if (v.getTag() instanceof FragmentManager.BackStackEntry) {
                FragmentManager.BackStackEntry bse = (FragmentManager.BackStackEntry)v.getTag();
                if (bse == FragmentBreadCrumbs.this.mParentEntry) {
                    if (FragmentBreadCrumbs.this.mParentClickListener != null) {
                        FragmentBreadCrumbs.this.mParentClickListener.onClick(v);
                    }
                } else {
                    if (FragmentBreadCrumbs.this.mOnBreadCrumbClickListener != null && FragmentBreadCrumbs.this.mOnBreadCrumbClickListener.onBreadCrumbClick(bse == FragmentBreadCrumbs.this.mTopEntry ? null : bse, 0)) {
                        return;
                    }
                    if (bse == FragmentBreadCrumbs.this.mTopEntry) {
                        FragmentBreadCrumbs.this.mActivity.getFragmentManager().popBackStack();
                    } else {
                        FragmentBreadCrumbs.this.mActivity.getFragmentManager().popBackStack(bse.getId(), 0);
                    }
                }
            }
        }
    };

    public FragmentBreadCrumbs(Context context) {
        this(context, null);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attrs) {
        this(context, attrs, 17956951);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FragmentBreadCrumbs, defStyleAttr, defStyleRes);
        this.mGravity = a.getInt(0, 8388627);
        this.mLayoutResId = a.getResourceId(2, 17367169);
        this.mTextColor = a.getColor(1, 0);
        a.recycle();
    }

    public void setActivity(Activity a) {
        this.mActivity = a;
        this.mInflater = (LayoutInflater)a.getSystemService("layout_inflater");
        this.mContainer = (LinearLayout)this.mInflater.inflate(17367171, (ViewGroup)this, false);
        this.addView(this.mContainer);
        a.getFragmentManager().addOnBackStackChangedListener(this);
        this.updateCrumbs();
        this.setLayoutTransition(new LayoutTransition());
    }

    public void setMaxVisible(int visibleCrumbs) {
        if (visibleCrumbs < 1) {
            throw new IllegalArgumentException("visibleCrumbs must be greater than zero");
        }
        this.mMaxVisible = visibleCrumbs;
    }

    public void setParentTitle(CharSequence title, CharSequence shortTitle, View.OnClickListener listener) {
        this.mParentEntry = this.createBackStackEntry(title, shortTitle);
        this.mParentClickListener = listener;
        this.updateCrumbs();
    }

    public void setOnBreadCrumbClickListener(OnBreadCrumbClickListener listener) {
        this.mOnBreadCrumbClickListener = listener;
    }

    private BackStackRecord createBackStackEntry(CharSequence title, CharSequence shortTitle) {
        if (title == null) {
            return null;
        }
        BackStackRecord entry = new BackStackRecord((FragmentManagerImpl)this.mActivity.getFragmentManager());
        entry.setBreadCrumbTitle(title);
        entry.setBreadCrumbShortTitle(shortTitle);
        return entry;
    }

    public void setTitle(CharSequence title, CharSequence shortTitle) {
        this.mTopEntry = this.createBackStackEntry(title, shortTitle);
        this.updateCrumbs();
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childLeft;
        int childRight;
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return;
        }
        View child = this.getChildAt(0);
        int childTop = this.mPaddingTop;
        int childBottom = this.mPaddingTop + child.getMeasuredHeight() - this.mPaddingBottom;
        int layoutDirection = this.getLayoutDirection();
        int horizontalGravity = this.mGravity & 0x800007;
        switch (Gravity.getAbsoluteGravity(horizontalGravity, layoutDirection)) {
            case 5: {
                childRight = this.mRight - this.mLeft - this.mPaddingRight;
                childLeft = childRight - child.getMeasuredWidth();
                break;
            }
            case 1: {
                childLeft = this.mPaddingLeft + (this.mRight - this.mLeft - child.getMeasuredWidth()) / 2;
                childRight = childLeft + child.getMeasuredWidth();
                break;
            }
            default: {
                childLeft = this.mPaddingLeft;
                childRight = childLeft + child.getMeasuredWidth();
            }
        }
        if (childLeft < this.mPaddingLeft) {
            childLeft = this.mPaddingLeft;
        }
        if (childRight > this.mRight - this.mLeft - this.mPaddingRight) {
            childRight = this.mRight - this.mLeft - this.mPaddingRight;
        }
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        int measuredChildState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            measuredChildState = FragmentBreadCrumbs.combineMeasuredStates(measuredChildState, child.getMeasuredState());
        }
        maxWidth += this.mPaddingLeft + this.mPaddingRight;
        maxHeight += this.mPaddingTop + this.mPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(FragmentBreadCrumbs.resolveSizeAndState(maxWidth, widthMeasureSpec, measuredChildState), FragmentBreadCrumbs.resolveSizeAndState(maxHeight, heightMeasureSpec, measuredChildState << 16));
    }

    @Override
    public void onBackStackChanged() {
        this.updateCrumbs();
    }

    private int getPreEntryCount() {
        return (this.mTopEntry != null ? 1 : 0) + (this.mParentEntry != null ? 1 : 0);
    }

    private FragmentManager.BackStackEntry getPreEntry(int index) {
        if (this.mParentEntry != null) {
            return index == 0 ? this.mParentEntry : this.mTopEntry;
        }
        return this.mTopEntry;
    }

    void updateCrumbs() {
        FragmentManager fm = this.mActivity.getFragmentManager();
        int numEntries = fm.getBackStackEntryCount();
        int numPreEntries = this.getPreEntryCount();
        int numViews = this.mContainer.getChildCount();
        for (int i = 0; i < numEntries + numPreEntries; ++i) {
            View v;
            Object tag;
            FragmentManager.BackStackEntry bse;
            FragmentManager.BackStackEntry backStackEntry = bse = i < numPreEntries ? this.getPreEntry(i) : fm.getBackStackEntryAt(i - numPreEntries);
            if (i < numViews && (tag = (v = this.mContainer.getChildAt(i)).getTag()) != bse) {
                for (int j = i; j < numViews; ++j) {
                    this.mContainer.removeViewAt(i);
                }
                numViews = i;
            }
            if (i < numViews) continue;
            View item = this.mInflater.inflate(this.mLayoutResId, (ViewGroup)this, false);
            TextView text = (TextView)item.findViewById(16908310);
            text.setText(bse.getBreadCrumbTitle());
            text.setTag(bse);
            text.setTextColor(this.mTextColor);
            if (i == 0) {
                ((View)item.findViewById(16909191)).setVisibility(8);
            }
            this.mContainer.addView(item);
            text.setOnClickListener(this.mOnClickListener);
        }
        int viewI = numEntries + numPreEntries;
        for (numViews = this.mContainer.getChildCount(); numViews > viewI; --numViews) {
            this.mContainer.removeViewAt(numViews - 1);
        }
        for (int i = 0; i < numViews; ++i) {
            View child = this.mContainer.getChildAt(i);
            ((View)child.findViewById(16908310)).setEnabled(i < numViews - 1);
            if (this.mMaxVisible <= 0) continue;
            child.setVisibility(i < numViews - this.mMaxVisible ? 8 : 0);
            Object leftIcon = child.findViewById(16909191);
            ((View)leftIcon).setVisibility(i > numViews - this.mMaxVisible && i != 0 ? 0 : 8);
        }
    }

    @Deprecated
    public static interface OnBreadCrumbClickListener {
        public boolean onBreadCrumbClick(FragmentManager.BackStackEntry var1, int var2);
    }
}

