/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityClient;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.OutcomeReceiver;

public class FullscreenRequestHandler {
    public static final int RESULT_APPROVED = 0;
    public static final int RESULT_FAILED_NOT_IN_FREEFORM = 1;
    public static final int RESULT_FAILED_NOT_IN_FULLSCREEN_WITH_HISTORY = 2;
    public static final int RESULT_FAILED_NOT_DEFAULT_FREEFORM = 3;
    public static final int RESULT_FAILED_NOT_TOP_FOCUSED = 4;
    public static final String REMOTE_CALLBACK_RESULT_KEY = "result";

    static void requestFullscreenMode(@Activity.FullscreenModeRequest int request, final OutcomeReceiver<Void, Throwable> approvalCallback, Configuration config, IBinder token) {
        block6: {
            int earlyCheck = FullscreenRequestHandler.earlyCheckRequestMatchesWindowingMode(request, config.windowConfiguration.getWindowingMode());
            if (earlyCheck != 0) {
                if (approvalCallback != null) {
                    FullscreenRequestHandler.notifyFullscreenRequestResult(approvalCallback, earlyCheck);
                }
                return;
            }
            try {
                if (approvalCallback != null) {
                    ActivityClient.getInstance().requestMultiwindowFullscreen(token, request, new IRemoteCallback.Stub(){

                        @Override
                        public void sendResult(Bundle res) {
                            FullscreenRequestHandler.notifyFullscreenRequestResult(approvalCallback, res.getInt(FullscreenRequestHandler.REMOTE_CALLBACK_RESULT_KEY));
                        }
                    });
                } else {
                    ActivityClient.getInstance().requestMultiwindowFullscreen(token, request, null);
                }
            }
            catch (Throwable e) {
                if (approvalCallback == null) break block6;
                approvalCallback.onError(e);
            }
        }
    }

    private static void notifyFullscreenRequestResult(OutcomeReceiver<Void, Throwable> callback, int result) {
        IllegalStateException e = null;
        switch (result) {
            case 1: {
                e = new IllegalStateException("The window is not a freeform window, the request to get into fullscreen cannot be approved.");
                break;
            }
            case 2: {
                e = new IllegalStateException("The window is not in fullscreen by calling the requestFullscreenMode API before, such that cannot be restored.");
                break;
            }
            case 3: {
                e = new IllegalStateException("The window is not launched in freeform by default.");
                break;
            }
            case 4: {
                e = new IllegalStateException("The window is not the top focused window.");
                break;
            }
            default: {
                callback.onResult(null);
            }
        }
        if (e != null) {
            callback.onError(e);
        }
    }

    private static int earlyCheckRequestMatchesWindowingMode(int request, int windowingMode) {
        if (request == 1) {
            if (windowingMode != 5) {
                return 1;
            }
        } else if (windowingMode != 1) {
            return 2;
        }
        return 0;
    }

    public static @interface RequestResult {
    }
}

