/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.GameModeConfiguration;
import android.app.GameModeInfo;
import android.app.GameState;
import android.app.IGameManagerService;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class GameManager {
    private static final String TAG = "GameManager";
    private final Context mContext;
    private final IGameManagerService mService;
    public static final int GAME_MODE_UNSUPPORTED = 0;
    public static final int GAME_MODE_STANDARD = 1;
    public static final int GAME_MODE_PERFORMANCE = 2;
    public static final int GAME_MODE_BATTERY = 3;
    public static final int GAME_MODE_CUSTOM = 4;

    GameManager(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = IGameManagerService.Stub.asInterface(ServiceManager.getServiceOrThrow("game"));
    }

    public int getGameMode() {
        return this.getGameModeImpl(this.mContext.getPackageName(), this.mContext.getApplicationInfo().targetSdkVersion);
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public int getGameMode(String packageName) {
        int targetSdkVersion;
        try {
            ApplicationInfo applicationInfo = this.mContext.getPackageManager().getApplicationInfo(packageName, PackageManager.ApplicationInfoFlags.of(0L));
            targetSdkVersion = applicationInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException ex) {
            return 0;
        }
        return this.getGameModeImpl(packageName, targetSdkVersion);
    }

    private int getGameModeImpl(String packageName, int targetSdkVersion) {
        int gameMode;
        try {
            gameMode = this.mService.getGameMode(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (gameMode == 4 && targetSdkVersion <= 33) {
            return 1;
        }
        return gameMode;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public GameModeInfo getGameModeInfo(String packageName) {
        try {
            return this.mService.getGameModeInfo(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void setGameMode(String packageName, int gameMode) {
        try {
            this.mService.setGameMode(packageName, gameMode, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public int[] getAvailableGameModes(String packageName) {
        try {
            return this.mService.getAvailableGameModes(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public boolean isAngleEnabled(String packageName) {
        try {
            return this.mService.isAngleEnabled(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void notifyGraphicsEnvironmentSetup() {
        try {
            this.mService.notifyGraphicsEnvironmentSetup(this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setGameState(GameState gameState) {
        try {
            this.mService.setGameState(this.mContext.getPackageName(), gameState, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setGameServiceProvider(String packageName) {
        try {
            this.mService.setGameServiceProvider(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void updateCustomGameModeConfiguration(String packageName, GameModeConfiguration gameModeConfig) {
        try {
            this.mService.updateCustomGameModeConfiguration(packageName, gameModeConfig, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GameMode {
    }
}

