/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.GameModeConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import androidx.annotation.Nullable;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Map;

@SystemApi
public class GameModeInfo
implements Parcelable {
    public static final Parcelable.Creator<GameModeInfo> CREATOR = new Parcelable.Creator<GameModeInfo>(){

        @Override
        public GameModeInfo createFromParcel(Parcel in) {
            return new GameModeInfo(in);
        }

        public GameModeInfo[] newArray(int size) {
            return new GameModeInfo[size];
        }
    };
    private final int[] mAvailableGameModes;
    private final int[] mOverriddenGameModes;
    private final int mActiveGameMode;
    private final boolean mIsDownscalingAllowed;
    private final boolean mIsFpsOverrideAllowed;
    private final Map<Integer, GameModeConfiguration> mConfigMap;

    public GameModeInfo(int activeGameMode, int[] availableGameModes) {
        this(activeGameMode, availableGameModes, new int[0], true, true, new ArrayMap<Integer, GameModeConfiguration>());
    }

    private GameModeInfo(int activeGameMode, int[] availableGameModes, int[] overriddenGameModes, boolean isDownscalingAllowed, boolean isFpsOverrideAllowed, Map<Integer, GameModeConfiguration> configMap) {
        this.mActiveGameMode = activeGameMode;
        this.mAvailableGameModes = Arrays.copyOf(availableGameModes, availableGameModes.length);
        this.mOverriddenGameModes = Arrays.copyOf(overriddenGameModes, overriddenGameModes.length);
        this.mIsDownscalingAllowed = isDownscalingAllowed;
        this.mIsFpsOverrideAllowed = isFpsOverrideAllowed;
        this.mConfigMap = configMap;
    }

    @VisibleForTesting
    public GameModeInfo(Parcel in) {
        this.mActiveGameMode = in.readInt();
        this.mAvailableGameModes = in.createIntArray();
        this.mOverriddenGameModes = in.createIntArray();
        this.mIsDownscalingAllowed = in.readBoolean();
        this.mIsFpsOverrideAllowed = in.readBoolean();
        this.mConfigMap = new ArrayMap<Integer, GameModeConfiguration>();
        in.readMap(this.mConfigMap, this.getClass().getClassLoader(), Integer.class, GameModeConfiguration.class);
    }

    public int getActiveGameMode() {
        return this.mActiveGameMode;
    }

    public int[] getAvailableGameModes() {
        return Arrays.copyOf(this.mAvailableGameModes, this.mAvailableGameModes.length);
    }

    public int[] getOverriddenGameModes() {
        return Arrays.copyOf(this.mOverriddenGameModes, this.mOverriddenGameModes.length);
    }

    @Nullable
    public GameModeConfiguration getGameModeConfiguration(int gameMode) {
        return this.mConfigMap.get(gameMode);
    }

    public boolean isDownscalingAllowed() {
        return this.mIsDownscalingAllowed;
    }

    public boolean isFpsOverrideAllowed() {
        return this.mIsFpsOverrideAllowed;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mActiveGameMode);
        dest.writeIntArray(this.mAvailableGameModes);
        dest.writeIntArray(this.mOverriddenGameModes);
        dest.writeBoolean(this.mIsDownscalingAllowed);
        dest.writeBoolean(this.mIsFpsOverrideAllowed);
        dest.writeMap(this.mConfigMap);
    }

    @SystemApi
    public static class Builder {
        private int[] mAvailableGameModes = new int[0];
        private int[] mOverriddenGameModes = new int[0];
        private int mActiveGameMode;
        private boolean mIsDownscalingAllowed;
        private boolean mIsFpsOverrideAllowed;
        private Map<Integer, GameModeConfiguration> mConfigMap = new ArrayMap<Integer, GameModeConfiguration>();

        public Builder setAvailableGameModes(int[] availableGameModes) {
            this.mAvailableGameModes = availableGameModes;
            return this;
        }

        public Builder setOverriddenGameModes(int[] overriddenGameModes) {
            this.mOverriddenGameModes = overriddenGameModes;
            return this;
        }

        public Builder setActiveGameMode(int activeGameMode) {
            this.mActiveGameMode = activeGameMode;
            return this;
        }

        public Builder setDownscalingAllowed(boolean allowed) {
            this.mIsDownscalingAllowed = allowed;
            return this;
        }

        public Builder setFpsOverrideAllowed(boolean allowed) {
            this.mIsFpsOverrideAllowed = allowed;
            return this;
        }

        public Builder setGameModeConfiguration(int gameMode, GameModeConfiguration gameModeConfiguration) {
            this.mConfigMap.put(gameMode, gameModeConfiguration);
            return this;
        }

        public GameModeInfo build() {
            return new GameModeInfo(this.mActiveGameMode, this.mAvailableGameModes, this.mOverriddenGameModes, this.mIsDownscalingAllowed, this.mIsFpsOverrideAllowed, this.mConfigMap);
        }
    }
}

