/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.backup.BackupRestoreEventLogger;
import android.app.backup.IBackupCallback;
import android.app.backup.IBackupManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.android.internal.infra.AndroidFuture;
import java.util.ArrayList;
import java.util.List;

public interface IBackupAgent
extends IInterface {
    public void doBackup(ParcelFileDescriptor var1, ParcelFileDescriptor var2, ParcelFileDescriptor var3, long var4, IBackupCallback var6, int var7) throws RemoteException;

    public void doRestore(ParcelFileDescriptor var1, long var2, ParcelFileDescriptor var4, int var5, IBackupManager var6) throws RemoteException;

    public void doRestoreWithExcludedKeys(ParcelFileDescriptor var1, long var2, ParcelFileDescriptor var4, int var5, IBackupManager var6, List<String> var7) throws RemoteException;

    public void doFullBackup(ParcelFileDescriptor var1, long var2, int var4, IBackupManager var5, int var6) throws RemoteException;

    public void doMeasureFullBackup(long var1, int var3, IBackupManager var4, int var5) throws RemoteException;

    public void doQuotaExceeded(long var1, long var3, IBackupCallback var5) throws RemoteException;

    public void doRestoreFile(ParcelFileDescriptor var1, long var2, int var4, String var5, String var6, long var7, long var9, int var11, IBackupManager var12) throws RemoteException;

    public void doRestoreFinished(int var1, IBackupManager var2) throws RemoteException;

    public void fail(String var1) throws RemoteException;

    public void getLoggerResults(AndroidFuture<List<BackupRestoreEventLogger.DataTypeResult>> var1) throws RemoteException;

    public void getOperationType(AndroidFuture<Integer> var1) throws RemoteException;

    public void clearBackupRestoreEventLogger() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBackupAgent {
        public static final String DESCRIPTOR = "android.app.IBackupAgent";
        static final int TRANSACTION_doBackup = 1;
        static final int TRANSACTION_doRestore = 2;
        static final int TRANSACTION_doRestoreWithExcludedKeys = 3;
        static final int TRANSACTION_doFullBackup = 4;
        static final int TRANSACTION_doMeasureFullBackup = 5;
        static final int TRANSACTION_doQuotaExceeded = 6;
        static final int TRANSACTION_doRestoreFile = 7;
        static final int TRANSACTION_doRestoreFinished = 8;
        static final int TRANSACTION_fail = 9;
        static final int TRANSACTION_getLoggerResults = 10;
        static final int TRANSACTION_getOperationType = 11;
        static final int TRANSACTION_clearBackupRestoreEventLogger = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBackupAgent asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBackupAgent) {
                return (IBackupAgent)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "doBackup";
                }
                case 2: {
                    return "doRestore";
                }
                case 3: {
                    return "doRestoreWithExcludedKeys";
                }
                case 4: {
                    return "doFullBackup";
                }
                case 5: {
                    return "doMeasureFullBackup";
                }
                case 6: {
                    return "doQuotaExceeded";
                }
                case 7: {
                    return "doRestoreFile";
                }
                case 8: {
                    return "doRestoreFinished";
                }
                case 9: {
                    return "fail";
                }
                case 10: {
                    return "getLoggerResults";
                }
                case 11: {
                    return "getOperationType";
                }
                case 12: {
                    return "clearBackupRestoreEventLogger";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    ParcelFileDescriptor _arg2 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg3 = data.readLong();
                    IBackupCallback _arg4 = IBackupCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    this.doBackup(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 2: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    ParcelFileDescriptor _arg2 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    int _arg3 = data.readInt();
                    IBackupManager _arg4 = IBackupManager.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.doRestore(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 3: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    ParcelFileDescriptor _arg2 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    int _arg3 = data.readInt();
                    IBackupManager _arg4 = IBackupManager.Stub.asInterface(data.readStrongBinder());
                    ArrayList<String> _arg5 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    this.doRestoreWithExcludedKeys(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 4: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    IBackupManager _arg3 = IBackupManager.Stub.asInterface(data.readStrongBinder());
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.doFullBackup(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 5: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    IBackupManager _arg2 = IBackupManager.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.doMeasureFullBackup(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 6: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    IBackupCallback _arg2 = IBackupCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.doQuotaExceeded(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    long _arg5 = data.readLong();
                    long _arg6 = data.readLong();
                    int _arg7 = data.readInt();
                    IBackupManager _arg8 = IBackupManager.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.doRestoreFile(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    IBackupManager _arg1 = IBackupManager.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.doRestoreFinished(_arg0, _arg1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.fail(_arg0);
                    break;
                }
                case 10: {
                    AndroidFuture _arg0 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getLoggerResults(_arg0);
                    break;
                }
                case 11: {
                    AndroidFuture _arg0 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getOperationType(_arg0);
                    break;
                }
                case 12: {
                    this.clearBackupRestoreEventLogger();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IBackupAgent {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doBackup(ParcelFileDescriptor oldState, ParcelFileDescriptor data, ParcelFileDescriptor newState, long quotaBytes, IBackupCallback callbackBinder, int transportFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(oldState, 0);
                    _data.writeTypedObject(data, 0);
                    _data.writeTypedObject(newState, 0);
                    _data.writeLong(quotaBytes);
                    _data.writeStrongInterface(callbackBinder);
                    _data.writeInt(transportFlags);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRestore(ParcelFileDescriptor data, long appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(data, 0);
                    _data.writeLong(appVersionCode);
                    _data.writeTypedObject(newState, 0);
                    _data.writeInt(token);
                    _data.writeStrongInterface(callbackBinder);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRestoreWithExcludedKeys(ParcelFileDescriptor data, long appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder, List<String> excludedKeys) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(data, 0);
                    _data.writeLong(appVersionCode);
                    _data.writeTypedObject(newState, 0);
                    _data.writeInt(token);
                    _data.writeStrongInterface(callbackBinder);
                    _data.writeStringList(excludedKeys);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doFullBackup(ParcelFileDescriptor data, long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(data, 0);
                    _data.writeLong(quotaBytes);
                    _data.writeInt(token);
                    _data.writeStrongInterface(callbackBinder);
                    _data.writeInt(transportFlags);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doMeasureFullBackup(long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(quotaBytes);
                    _data.writeInt(token);
                    _data.writeStrongInterface(callbackBinder);
                    _data.writeInt(transportFlags);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doQuotaExceeded(long backupDataBytes, long quotaBytes, IBackupCallback callbackBinder) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(backupDataBytes);
                    _data.writeLong(quotaBytes);
                    _data.writeStrongInterface(callbackBinder);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime, int token, IBackupManager callbackBinder) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(data, 0);
                    _data.writeLong(size);
                    _data.writeInt(type);
                    _data.writeString(domain);
                    _data.writeString(path);
                    _data.writeLong(mode);
                    _data.writeLong(mtime);
                    _data.writeInt(token);
                    _data.writeStrongInterface(callbackBinder);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRestoreFinished(int token, IBackupManager callbackBinder) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeStrongInterface(callbackBinder);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fail(String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getLoggerResults(AndroidFuture<List<BackupRestoreEventLogger.DataTypeResult>> resultsFuture) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(resultsFuture, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getOperationType(AndroidFuture<Integer> operationTypeFuture) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(operationTypeFuture, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void clearBackupRestoreEventLogger() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBackupAgent {
        @Override
        public void doBackup(ParcelFileDescriptor oldState, ParcelFileDescriptor data, ParcelFileDescriptor newState, long quotaBytes, IBackupCallback callbackBinder, int transportFlags) throws RemoteException {
        }

        @Override
        public void doRestore(ParcelFileDescriptor data, long appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
        }

        @Override
        public void doRestoreWithExcludedKeys(ParcelFileDescriptor data, long appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder, List<String> excludedKeys) throws RemoteException {
        }

        @Override
        public void doFullBackup(ParcelFileDescriptor data, long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) throws RemoteException {
        }

        @Override
        public void doMeasureFullBackup(long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) throws RemoteException {
        }

        @Override
        public void doQuotaExceeded(long backupDataBytes, long quotaBytes, IBackupCallback callbackBinder) throws RemoteException {
        }

        @Override
        public void doRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime, int token, IBackupManager callbackBinder) throws RemoteException {
        }

        @Override
        public void doRestoreFinished(int token, IBackupManager callbackBinder) throws RemoteException {
        }

        @Override
        public void fail(String message) throws RemoteException {
        }

        @Override
        public void getLoggerResults(AndroidFuture<List<BackupRestoreEventLogger.DataTypeResult>> resultsFuture) throws RemoteException {
        }

        @Override
        public void getOperationType(AndroidFuture<Integer> operationTypeFuture) throws RemoteException {
        }

        @Override
        public void clearBackupRestoreEventLogger() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

