/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.app.GameModeConfiguration;
import android.app.GameModeInfo;
import android.app.GameState;
import android.app.IGameModeListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IGameManagerService
extends IInterface {
    public static final String DESCRIPTOR = "android.app.IGameManagerService";

    public int getGameMode(String var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void setGameMode(String var1, int var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public int[] getAvailableGameModes(String var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public boolean isAngleEnabled(String var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void notifyGraphicsEnvironmentSetup(String var1, int var2) throws RemoteException;

    public void setGameState(String var1, GameState var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public GameModeInfo getGameModeInfo(String var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.SET_GAME_SERVICE")
    public void setGameServiceProvider(String var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void updateResolutionScalingFactor(String var1, int var2, float var3, int var4) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public float getResolutionScalingFactor(String var1, int var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void updateCustomGameModeConfiguration(String var1, GameModeConfiguration var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void addGameModeListener(IGameModeListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void removeGameModeListener(IGameModeListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IGameManagerService {
        static final int TRANSACTION_getGameMode = 1;
        static final int TRANSACTION_setGameMode = 2;
        static final int TRANSACTION_getAvailableGameModes = 3;
        static final int TRANSACTION_isAngleEnabled = 4;
        static final int TRANSACTION_notifyGraphicsEnvironmentSetup = 5;
        static final int TRANSACTION_setGameState = 6;
        static final int TRANSACTION_getGameModeInfo = 7;
        static final int TRANSACTION_setGameServiceProvider = 8;
        static final int TRANSACTION_updateResolutionScalingFactor = 9;
        static final int TRANSACTION_getResolutionScalingFactor = 10;
        static final int TRANSACTION_updateCustomGameModeConfiguration = 11;
        static final int TRANSACTION_addGameModeListener = 12;
        static final int TRANSACTION_removeGameModeListener = 13;

        public Stub() {
            this.attachInterface(this, IGameManagerService.DESCRIPTOR);
        }

        public static IGameManagerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IGameManagerService.DESCRIPTOR);
            if (iin != null && iin instanceof IGameManagerService) {
                return (IGameManagerService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getGameMode";
                }
                case 2: {
                    return "setGameMode";
                }
                case 3: {
                    return "getAvailableGameModes";
                }
                case 4: {
                    return "isAngleEnabled";
                }
                case 5: {
                    return "notifyGraphicsEnvironmentSetup";
                }
                case 6: {
                    return "setGameState";
                }
                case 7: {
                    return "getGameModeInfo";
                }
                case 8: {
                    return "setGameServiceProvider";
                }
                case 9: {
                    return "updateResolutionScalingFactor";
                }
                case 10: {
                    return "getResolutionScalingFactor";
                }
                case 11: {
                    return "updateCustomGameModeConfiguration";
                }
                case 12: {
                    return "addGameModeListener";
                }
                case 13: {
                    return "removeGameModeListener";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IGameManagerService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getGameMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setGameMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int[] _result = this.getAvailableGameModes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAngleEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyGraphicsEnvironmentSetup(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    GameState _arg1 = data.readTypedObject(GameState.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setGameState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    GameModeInfo _result = this.getGameModeInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setGameServiceProvider(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    float _arg2 = data.readFloat();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateResolutionScalingFactor(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getResolutionScalingFactor(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    GameModeConfiguration _arg1 = data.readTypedObject(GameModeConfiguration.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateCustomGameModeConfiguration(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IGameModeListener _arg0 = IGameModeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addGameModeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    IGameModeListener _arg0 = IGameModeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeGameModeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 12;
        }

        private static class Proxy
        implements IGameManagerService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IGameManagerService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getGameMode(String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGameMode(String packageName, int gameMode, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(gameMode);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAvailableGameModes(String packageName, int userId) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAngleEnabled(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyGraphicsEnvironmentSetup(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGameState(String packageName, GameState gameState, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(gameState, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GameModeInfo getGameModeInfo(String packageName, int userId) throws RemoteException {
                GameModeInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(GameModeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGameServiceProvider(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateResolutionScalingFactor(String packageName, int gameMode, float scalingFactor, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(gameMode);
                    _data.writeFloat(scalingFactor);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getResolutionScalingFactor(String packageName, int gameMode, int userId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(gameMode);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCustomGameModeConfiguration(String packageName, GameModeConfiguration gameModeConfig, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(gameModeConfig, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addGameModeListener(IGameModeListener gameModeListener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeStrongInterface(gameModeListener);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGameModeListener(IGameModeListener gameModeListener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGameManagerService.DESCRIPTOR);
                    _data.writeStrongInterface(gameModeListener);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IGameManagerService {
        @Override
        public int getGameMode(String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void setGameMode(String packageName, int gameMode, int userId) throws RemoteException {
        }

        @Override
        public int[] getAvailableGameModes(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isAngleEnabled(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void notifyGraphicsEnvironmentSetup(String packageName, int userId) throws RemoteException {
        }

        @Override
        public void setGameState(String packageName, GameState gameState, int userId) throws RemoteException {
        }

        @Override
        public GameModeInfo getGameModeInfo(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setGameServiceProvider(String packageName) throws RemoteException {
        }

        @Override
        public void updateResolutionScalingFactor(String packageName, int gameMode, float scalingFactor, int userId) throws RemoteException {
        }

        @Override
        public float getResolutionScalingFactor(String packageName, int gameMode, int userId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public void updateCustomGameModeConfiguration(String packageName, GameModeConfiguration gameModeConfig, int userId) throws RemoteException {
        }

        @Override
        public void addGameModeListener(IGameModeListener gameModeListener) throws RemoteException {
        }

        @Override
        public void removeGameModeListener(IGameModeListener gameModeListener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

