/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITransientNotificationCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ITransientNotificationCallback";

    public void onToastShown() throws RemoteException;

    public void onToastHidden() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITransientNotificationCallback {
        static final int TRANSACTION_onToastShown = 1;
        static final int TRANSACTION_onToastHidden = 2;

        public Stub() {
            this.attachInterface(this, ITransientNotificationCallback.DESCRIPTOR);
        }

        public static ITransientNotificationCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITransientNotificationCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITransientNotificationCallback) {
                return (ITransientNotificationCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onToastShown";
                }
                case 2: {
                    return "onToastHidden";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITransientNotificationCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.onToastShown();
                    break;
                }
                case 2: {
                    this.onToastHidden();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ITransientNotificationCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITransientNotificationCallback.DESCRIPTOR;
            }

            @Override
            public void onToastShown() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITransientNotificationCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onToastHidden() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITransientNotificationCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITransientNotificationCallback {
        @Override
        public void onToastShown() throws RemoteException {
        }

        @Override
        public void onToastHidden() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

