/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.app.IOnProjectionStateChangedListener;
import android.app.IUiModeManagerCallback;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IUiModeManager
extends IInterface {
    public void addCallback(IUiModeManagerCallback var1) throws RemoteException;

    public void enableCarMode(int var1, int var2, String var3) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/app/IUiModeManager.aidl:41:1:41:44")
    public void disableCarMode(int var1) throws RemoteException;

    public void disableCarModeByCallingPackage(int var1, String var2) throws RemoteException;

    public int getCurrentModeType() throws RemoteException;

    public void setNightMode(int var1) throws RemoteException;

    public int getNightMode() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public void setNightModeCustomType(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public int getNightModeCustomType() throws RemoteException;

    public void setApplicationNightMode(int var1) throws RemoteException;

    public boolean isUiModeLocked() throws RemoteException;

    public boolean isNightModeLocked() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_DAY_NIGHT_MODE")
    public boolean setNightModeActivatedForCustomMode(int var1, boolean var2) throws RemoteException;

    public boolean setNightModeActivated(boolean var1) throws RemoteException;

    public long getCustomNightModeStart() throws RemoteException;

    public void setCustomNightModeStart(long var1) throws RemoteException;

    public long getCustomNightModeEnd() throws RemoteException;

    public void setCustomNightModeEnd(long var1) throws RemoteException;

    public boolean requestProjection(IBinder var1, int var2, String var3) throws RemoteException;

    public boolean releaseProjection(int var1, String var2) throws RemoteException;

    public void addOnProjectionStateChangedListener(IOnProjectionStateChangedListener var1, int var2) throws RemoteException;

    public void removeOnProjectionStateChangedListener(IOnProjectionStateChangedListener var1) throws RemoteException;

    public List<String> getProjectingPackages(int var1) throws RemoteException;

    public int getActiveProjectionTypes() throws RemoteException;

    public float getContrast() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUiModeManager {
        public static final String DESCRIPTOR = "android.app.IUiModeManager";
        static final int TRANSACTION_addCallback = 1;
        static final int TRANSACTION_enableCarMode = 2;
        static final int TRANSACTION_disableCarMode = 3;
        static final int TRANSACTION_disableCarModeByCallingPackage = 4;
        static final int TRANSACTION_getCurrentModeType = 5;
        static final int TRANSACTION_setNightMode = 6;
        static final int TRANSACTION_getNightMode = 7;
        static final int TRANSACTION_setNightModeCustomType = 8;
        static final int TRANSACTION_getNightModeCustomType = 9;
        static final int TRANSACTION_setApplicationNightMode = 10;
        static final int TRANSACTION_isUiModeLocked = 11;
        static final int TRANSACTION_isNightModeLocked = 12;
        static final int TRANSACTION_setNightModeActivatedForCustomMode = 13;
        static final int TRANSACTION_setNightModeActivated = 14;
        static final int TRANSACTION_getCustomNightModeStart = 15;
        static final int TRANSACTION_setCustomNightModeStart = 16;
        static final int TRANSACTION_getCustomNightModeEnd = 17;
        static final int TRANSACTION_setCustomNightModeEnd = 18;
        static final int TRANSACTION_requestProjection = 19;
        static final int TRANSACTION_releaseProjection = 20;
        static final int TRANSACTION_addOnProjectionStateChangedListener = 21;
        static final int TRANSACTION_removeOnProjectionStateChangedListener = 22;
        static final int TRANSACTION_getProjectingPackages = 23;
        static final int TRANSACTION_getActiveProjectionTypes = 24;
        static final int TRANSACTION_getContrast = 25;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IUiModeManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IUiModeManager) {
                return (IUiModeManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addCallback";
                }
                case 2: {
                    return "enableCarMode";
                }
                case 3: {
                    return "disableCarMode";
                }
                case 4: {
                    return "disableCarModeByCallingPackage";
                }
                case 5: {
                    return "getCurrentModeType";
                }
                case 6: {
                    return "setNightMode";
                }
                case 7: {
                    return "getNightMode";
                }
                case 8: {
                    return "setNightModeCustomType";
                }
                case 9: {
                    return "getNightModeCustomType";
                }
                case 10: {
                    return "setApplicationNightMode";
                }
                case 11: {
                    return "isUiModeLocked";
                }
                case 12: {
                    return "isNightModeLocked";
                }
                case 13: {
                    return "setNightModeActivatedForCustomMode";
                }
                case 14: {
                    return "setNightModeActivated";
                }
                case 15: {
                    return "getCustomNightModeStart";
                }
                case 16: {
                    return "setCustomNightModeStart";
                }
                case 17: {
                    return "getCustomNightModeEnd";
                }
                case 18: {
                    return "setCustomNightModeEnd";
                }
                case 19: {
                    return "requestProjection";
                }
                case 20: {
                    return "releaseProjection";
                }
                case 21: {
                    return "addOnProjectionStateChangedListener";
                }
                case 22: {
                    return "removeOnProjectionStateChangedListener";
                }
                case 23: {
                    return "getProjectingPackages";
                }
                case 24: {
                    return "getActiveProjectionTypes";
                }
                case 25: {
                    return "getContrast";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IUiModeManagerCallback _arg0 = IUiModeManagerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.enableCarMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableCarMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.disableCarModeByCallingPackage(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _result = this.getCurrentModeType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setNightMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _result = this.getNightMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setNightModeCustomType(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _result = this.getNightModeCustomType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setApplicationNightMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    boolean _result = this.isUiModeLocked();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    boolean _result = this.isNightModeLocked();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNightModeActivatedForCustomMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNightModeActivated(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    long _result = this.getCustomNightModeStart();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 16: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setCustomNightModeStart(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    long _result = this.getCustomNightModeEnd();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 18: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setCustomNightModeEnd(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.requestProjection(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.releaseProjection(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    IOnProjectionStateChangedListener _arg0 = IOnProjectionStateChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addOnProjectionStateChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IOnProjectionStateChangedListener _arg0 = IOnProjectionStateChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnProjectionStateChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getProjectingPackages(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 24: {
                    int _result = this.getActiveProjectionTypes();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 25: {
                    float _result = this.getContrast();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 24;
        }

        private static class Proxy
        implements IUiModeManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCallback(IUiModeManagerCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableCarMode(int flags, int priority, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeInt(priority);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableCarMode(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableCarModeByCallingPackage(int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCurrentModeType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNightMode(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNightMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNightModeCustomType(int nightModeCustomType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(nightModeCustomType);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNightModeCustomType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setApplicationNightMode(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUiModeLocked() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNightModeLocked() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNightModeActivatedForCustomMode(int nightModeCustom, boolean active) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(nightModeCustom);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNightModeActivated(boolean active) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getCustomNightModeStart() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCustomNightModeStart(long time) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getCustomNightModeEnd() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCustomNightModeEnd(long time) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestProjection(IBinder binder, int projectionType, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeInt(projectionType);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean releaseProjection(int projectionType, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(projectionType);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnProjectionStateChangedListener(IOnProjectionStateChangedListener listener, int projectionType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(projectionType);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnProjectionStateChangedListener(IOnProjectionStateChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getProjectingPackages(int projectionType) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(projectionType);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveProjectionTypes() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getContrast() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IUiModeManager {
        @Override
        public void addCallback(IUiModeManagerCallback callback) throws RemoteException {
        }

        @Override
        public void enableCarMode(int flags, int priority, String callingPackage) throws RemoteException {
        }

        @Override
        public void disableCarMode(int flags) throws RemoteException {
        }

        @Override
        public void disableCarModeByCallingPackage(int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public int getCurrentModeType() throws RemoteException {
            return 0;
        }

        @Override
        public void setNightMode(int mode) throws RemoteException {
        }

        @Override
        public int getNightMode() throws RemoteException {
            return 0;
        }

        @Override
        public void setNightModeCustomType(int nightModeCustomType) throws RemoteException {
        }

        @Override
        public int getNightModeCustomType() throws RemoteException {
            return 0;
        }

        @Override
        public void setApplicationNightMode(int mode) throws RemoteException {
        }

        @Override
        public boolean isUiModeLocked() throws RemoteException {
            return false;
        }

        @Override
        public boolean isNightModeLocked() throws RemoteException {
            return false;
        }

        @Override
        public boolean setNightModeActivatedForCustomMode(int nightModeCustom, boolean active) throws RemoteException {
            return false;
        }

        @Override
        public boolean setNightModeActivated(boolean active) throws RemoteException {
            return false;
        }

        @Override
        public long getCustomNightModeStart() throws RemoteException {
            return 0L;
        }

        @Override
        public void setCustomNightModeStart(long time) throws RemoteException {
        }

        @Override
        public long getCustomNightModeEnd() throws RemoteException {
            return 0L;
        }

        @Override
        public void setCustomNightModeEnd(long time) throws RemoteException {
        }

        @Override
        public boolean requestProjection(IBinder binder, int projectionType, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean releaseProjection(int projectionType, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public void addOnProjectionStateChangedListener(IOnProjectionStateChangedListener listener, int projectionType) throws RemoteException {
        }

        @Override
        public void removeOnProjectionStateChangedListener(IOnProjectionStateChangedListener listener) throws RemoteException {
        }

        @Override
        public List<String> getProjectingPackages(int projectionType) throws RemoteException {
            return null;
        }

        @Override
        public int getActiveProjectionTypes() throws RemoteException {
            return 0;
        }

        @Override
        public float getContrast() throws RemoteException {
            return 0.0f;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

