/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.res.Configuration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWindowToken
extends IInterface {
    public static final String DESCRIPTOR = "android.app.IWindowToken";

    public void onConfigurationChanged(Configuration var1, int var2) throws RemoteException;

    public void onWindowTokenRemoved() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowToken {
        static final int TRANSACTION_onConfigurationChanged = 1;
        static final int TRANSACTION_onWindowTokenRemoved = 2;

        public Stub() {
            this.attachInterface(this, IWindowToken.DESCRIPTOR);
        }

        public static IWindowToken asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWindowToken.DESCRIPTOR);
            if (iin != null && iin instanceof IWindowToken) {
                return (IWindowToken)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConfigurationChanged";
                }
                case 2: {
                    return "onWindowTokenRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWindowToken.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Configuration _arg0 = data.readTypedObject(Configuration.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConfigurationChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    this.onWindowTokenRemoved();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IWindowToken {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWindowToken.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(Configuration newConfig, int newDisplayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IWindowToken.DESCRIPTOR);
                    _data.writeTypedObject(newConfig, 0);
                    _data.writeInt(newDisplayId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onWindowTokenRemoved() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IWindowToken.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowToken {
        @Override
        public void onConfigurationChanged(Configuration newConfig, int newDisplayId) throws RemoteException {
        }

        @Override
        public void onWindowTokenRemoved() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

