/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.app.job.IJobScheduler;
import android.app.job.IUserVisibleJobObserver;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.app.job.JobSnapshot;
import android.app.job.JobWorkItem;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.util.ArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JobSchedulerImpl
extends JobScheduler {
    IJobScheduler mBinder;
    private final Context mContext;
    private final String mNamespace;

    public JobSchedulerImpl(Context context, IJobScheduler binder) {
        this(context, binder, null);
    }

    private JobSchedulerImpl(Context context, IJobScheduler binder, String namespace) {
        this.mContext = context;
        this.mBinder = binder;
        this.mNamespace = namespace;
    }

    private JobSchedulerImpl(JobSchedulerImpl jsi, String namespace) {
        this(jsi.mContext, jsi.mBinder, namespace);
    }

    @Override
    public JobScheduler forNamespace(String namespace) {
        if ((namespace = JobSchedulerImpl.sanitizeNamespace(namespace)) == null) {
            throw new NullPointerException("namespace cannot be null");
        }
        if (namespace.isEmpty()) {
            throw new IllegalArgumentException("namespace cannot be empty");
        }
        return new JobSchedulerImpl(this, namespace);
    }

    @Override
    public String getNamespace() {
        return this.mNamespace;
    }

    @Override
    public int schedule(JobInfo job) {
        try {
            return this.mBinder.schedule(this.mNamespace, job);
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    @Override
    public int enqueue(JobInfo job, JobWorkItem work) {
        try {
            return this.mBinder.enqueue(this.mNamespace, job, work);
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    @Override
    public int scheduleAsPackage(JobInfo job, String packageName, int userId, String tag) {
        try {
            return this.mBinder.scheduleAsPackage(this.mNamespace, job, packageName, userId, tag);
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    @Override
    public void cancel(int jobId) {
        try {
            this.mBinder.cancel(this.mNamespace, jobId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void cancelAll() {
        try {
            this.mBinder.cancelAllInNamespace(this.mNamespace);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void cancelInAllNamespaces() {
        try {
            this.mBinder.cancelAll();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public List<JobInfo> getAllPendingJobs() {
        try {
            return this.mBinder.getAllPendingJobsInNamespace(this.mNamespace).getList();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public Map<String, List<JobInfo>> getPendingJobsInAllNamespaces() {
        try {
            Map<String, ParceledListSlice<JobInfo>> parceledList = this.mBinder.getAllPendingJobs();
            ArrayMap<String, List<JobInfo>> jobMap = new ArrayMap<String, List<JobInfo>>();
            Set<String> keys = parceledList.keySet();
            for (String key : keys) {
                jobMap.put(key, parceledList.get(key).getList());
            }
            return jobMap;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public JobInfo getPendingJob(int jobId) {
        try {
            return this.mBinder.getPendingJob(this.mNamespace, jobId);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public int getPendingJobReason(int jobId) {
        try {
            return this.mBinder.getPendingJobReason(this.mNamespace, jobId);
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    @Override
    public boolean canRunUserInitiatedJobs() {
        try {
            return this.mBinder.canRunUserInitiatedJobs(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean hasRunUserInitiatedJobsPermission(String packageName, int userId) {
        try {
            return this.mBinder.hasRunUserInitiatedJobsPermission(packageName, userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public List<JobInfo> getStartedJobs() {
        try {
            return this.mBinder.getStartedJobs();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public List<JobSnapshot> getAllJobSnapshots() {
        try {
            return this.mBinder.getAllJobSnapshots().getList();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void registerUserVisibleJobObserver(IUserVisibleJobObserver observer) {
        try {
            this.mBinder.registerUserVisibleJobObserver(observer);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void unregisterUserVisibleJobObserver(IUserVisibleJobObserver observer) {
        try {
            this.mBinder.unregisterUserVisibleJobObserver(observer);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void notePendingUserRequestedAppStop(String packageName, int userId, String debugReason) {
        try {
            this.mBinder.notePendingUserRequestedAppStop(packageName, userId, debugReason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

