/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppComponentFactory;
import android.app.Application;
import android.app.ApplicationLoaders;
import android.app.ContextImpl;
import android.app.DexLoadReporter;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.IntentReceiverLeaked;
import android.app.ResourcesManager;
import android.app.ServiceConnectionLeaked;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.dex.ArtManager;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.GraphicsEnvironment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.security.net.config.NetworkSecurityConfigProvider;
import android.sysprop.VndkProperties;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayAdjustments;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

public class LoadedApk {
    static final String TAG = "LoadedApk";
    static final boolean DEBUG = false;
    @UnsupportedAppUsage
    private final ActivityThread mActivityThread;
    @UnsupportedAppUsage
    final String mPackageName;
    @UnsupportedAppUsage
    private ApplicationInfo mApplicationInfo;
    @UnsupportedAppUsage
    private String mAppDir;
    @UnsupportedAppUsage
    private String mResDir;
    private String[] mLegacyOverlayDirs;
    private String[] mOverlayPaths;
    @UnsupportedAppUsage
    private String mDataDir;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private String mLibDir;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private File mDataDirFile;
    private File mDeviceProtectedDataDirFile;
    private File mCredentialProtectedDataDirFile;
    @UnsupportedAppUsage
    private final ClassLoader mBaseClassLoader;
    private ClassLoader mDefaultClassLoader;
    private final boolean mSecurityViolation;
    private final boolean mIncludeCode;
    private final boolean mRegisterPackage;
    @UnsupportedAppUsage
    private final DisplayAdjustments mDisplayAdjustments = new DisplayAdjustments();
    @UnsupportedAppUsage
    Resources mResources;
    @UnsupportedAppUsage
    private ClassLoader mClassLoader;
    @UnsupportedAppUsage
    private Application mApplication;
    private String[] mSplitNames;
    private String[] mSplitAppDirs;
    @UnsupportedAppUsage
    private String[] mSplitResDirs;
    private String[] mSplitClassLoaderNames;
    @UnsupportedAppUsage
    private final ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> mReceivers = new ArrayMap();
    private final ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> mUnregisteredReceivers = new ArrayMap();
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> mServices = new ArrayMap();
    private final ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> mUnboundServices = new ArrayMap();
    private AppComponentFactory mAppComponentFactory;
    @GuardedBy(value={"sApplications"})
    private static final ArrayMap<String, Application> sApplications = new ArrayMap(4);
    private final Object mLock = new Object();
    private SplitDependencyLoaderImpl mSplitLoader;

    Application getApplication() {
        return this.mApplication;
    }

    public LoadedApk(ActivityThread activityThread, ApplicationInfo aInfo, CompatibilityInfo compatInfo, ClassLoader baseLoader, boolean securityViolation, boolean includeCode, boolean registerPackage) {
        this.mActivityThread = activityThread;
        this.setApplicationInfo(aInfo);
        this.mPackageName = aInfo.packageName;
        this.mBaseClassLoader = baseLoader;
        this.mSecurityViolation = securityViolation;
        this.mIncludeCode = includeCode;
        this.mRegisterPackage = registerPackage;
        this.mDisplayAdjustments.setCompatibilityInfo(compatInfo);
        this.mAppComponentFactory = this.createAppFactory(this.mApplicationInfo, this.mBaseClassLoader);
    }

    private static ApplicationInfo adjustNativeLibraryPaths(ApplicationInfo info) {
        if (info.primaryCpuAbi != null && info.secondaryCpuAbi != null) {
            String runtimeIsa = VMRuntime.getRuntime().vmInstructionSet();
            String secondaryIsa = VMRuntime.getInstructionSet(info.secondaryCpuAbi);
            String secondaryDexCodeIsa = SystemProperties.get("ro.dalvik.vm.isa." + secondaryIsa);
            String string2 = secondaryIsa = secondaryDexCodeIsa.isEmpty() ? secondaryIsa : secondaryDexCodeIsa;
            if (runtimeIsa.equals(secondaryIsa)) {
                ApplicationInfo modified = new ApplicationInfo(info);
                modified.nativeLibraryDir = modified.secondaryNativeLibraryDir;
                modified.primaryCpuAbi = modified.secondaryCpuAbi;
                return modified;
            }
        }
        return info;
    }

    LoadedApk(ActivityThread activityThread) {
        this.mActivityThread = activityThread;
        this.mApplicationInfo = new ApplicationInfo();
        this.mApplicationInfo.packageName = "android";
        this.mPackageName = "android";
        this.mAppDir = null;
        this.mResDir = null;
        this.mSplitAppDirs = null;
        this.mSplitResDirs = null;
        this.mSplitClassLoaderNames = null;
        this.mLegacyOverlayDirs = null;
        this.mOverlayPaths = null;
        this.mDataDir = null;
        this.mDataDirFile = null;
        this.mDeviceProtectedDataDirFile = null;
        this.mCredentialProtectedDataDirFile = null;
        this.mLibDir = null;
        this.mBaseClassLoader = null;
        this.mSecurityViolation = false;
        this.mIncludeCode = true;
        this.mRegisterPackage = false;
        this.mResources = Resources.getSystem();
        this.mDefaultClassLoader = ClassLoader.getSystemClassLoader();
        this.mAppComponentFactory = this.createAppFactory(this.mApplicationInfo, this.mDefaultClassLoader);
        this.mClassLoader = this.mAppComponentFactory.instantiateClassLoader(this.mDefaultClassLoader, new ApplicationInfo(this.mApplicationInfo));
    }

    void installSystemApplicationInfo(ApplicationInfo info, ClassLoader classLoader) {
        assert (info.packageName.equals("android"));
        this.mApplicationInfo = info;
        this.mDefaultClassLoader = classLoader;
        this.mAppComponentFactory = this.createAppFactory(info, this.mDefaultClassLoader);
        this.mClassLoader = this.mAppComponentFactory.instantiateClassLoader(this.mDefaultClassLoader, new ApplicationInfo(this.mApplicationInfo));
    }

    private AppComponentFactory createAppFactory(ApplicationInfo appInfo, ClassLoader cl) {
        if (this.mIncludeCode && appInfo.appComponentFactory != null && cl != null) {
            try {
                return (AppComponentFactory)cl.loadClass(appInfo.appComponentFactory).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Slog.e(TAG, "Unable to instantiate appComponentFactory", e);
            }
        }
        return AppComponentFactory.DEFAULT;
    }

    public AppComponentFactory getAppFactory() {
        return this.mAppComponentFactory;
    }

    @UnsupportedAppUsage
    public String getPackageName() {
        return this.mPackageName;
    }

    @UnsupportedAppUsage
    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    public int getTargetSdkVersion() {
        return this.mApplicationInfo.targetSdkVersion;
    }

    public boolean isSecurityViolation() {
        return this.mSecurityViolation;
    }

    @UnsupportedAppUsage(trackingBug=172409979L)
    public CompatibilityInfo getCompatibilityInfo() {
        return this.mDisplayAdjustments.getCompatibilityInfo();
    }

    public void setCompatibilityInfo(CompatibilityInfo compatInfo) {
        this.mDisplayAdjustments.setCompatibilityInfo(compatInfo);
    }

    private static String[] getLibrariesFor(String packageName) {
        ApplicationInfo ai = null;
        try {
            ai = ActivityThread.getPackageManager().getApplicationInfo(packageName, 1024L, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (ai == null) {
            return null;
        }
        return ai.sharedLibraryFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplicationInfo(ApplicationInfo aInfo, List<String> oldPaths) {
        this.setApplicationInfo(aInfo);
        ArrayList<String> newPaths = new ArrayList<String>();
        LoadedApk.makePaths(this.mActivityThread, aInfo, newPaths);
        ArrayList<String> addedPaths = new ArrayList<String>(newPaths.size());
        if (oldPaths != null) {
            for (String path : newPaths) {
                String apkName = path.substring(path.lastIndexOf(File.separator));
                boolean match = false;
                for (String oldPath : oldPaths) {
                    String oldApkName = oldPath.substring(oldPath.lastIndexOf(File.separator));
                    if (!apkName.equals(oldApkName)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                addedPaths.add(path);
            }
        } else {
            addedPaths.addAll(newPaths);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.createOrUpdateClassLoaderLocked(addedPaths);
            if (this.mResources != null) {
                String[] splitPaths;
                try {
                    splitPaths = this.getSplitPaths(null);
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new AssertionError((Object)"null split not found");
                }
                this.mResources = ResourcesManager.getInstance().getResources(null, this.mResDir, splitPaths, this.mLegacyOverlayDirs, this.mOverlayPaths, this.mApplicationInfo.sharedLibraryFiles, null, null, this.getCompatibilityInfo(), this.getClassLoader(), this.mApplication == null ? null : this.mApplication.getResources().getLoaders());
            }
        }
        this.mAppComponentFactory = this.createAppFactory(aInfo, this.mDefaultClassLoader);
    }

    private void setApplicationInfo(ApplicationInfo aInfo) {
        int myUid = Process.myUid();
        this.mApplicationInfo = aInfo = LoadedApk.adjustNativeLibraryPaths(aInfo);
        this.mAppDir = aInfo.sourceDir;
        this.mResDir = aInfo.uid == myUid ? aInfo.sourceDir : aInfo.publicSourceDir;
        this.mLegacyOverlayDirs = aInfo.resourceDirs;
        this.mOverlayPaths = aInfo.overlayPaths;
        this.mDataDir = aInfo.dataDir;
        this.mLibDir = aInfo.nativeLibraryDir;
        this.mDataDirFile = FileUtils.newFileOrNull(aInfo.dataDir);
        this.mDeviceProtectedDataDirFile = FileUtils.newFileOrNull(aInfo.deviceProtectedDataDir);
        this.mCredentialProtectedDataDirFile = FileUtils.newFileOrNull(aInfo.credentialProtectedDataDir);
        this.mSplitNames = aInfo.splitNames;
        this.mSplitAppDirs = aInfo.splitSourceDirs;
        this.mSplitResDirs = aInfo.uid == myUid ? aInfo.splitSourceDirs : aInfo.splitPublicSourceDirs;
        this.mSplitClassLoaderNames = aInfo.splitClassLoaderNames;
        if (aInfo.requestsIsolatedSplitLoading() && !ArrayUtils.isEmpty(this.mSplitNames)) {
            this.mSplitLoader = new SplitDependencyLoaderImpl(aInfo.splitDependencies);
        }
    }

    void setSdkSandboxStorage(String sdkSandboxClientAppVolumeUuid, String sdkSandboxClientAppPackage) {
        int userId = UserHandle.myUserId();
        this.mDeviceProtectedDataDirFile = Environment.getDataMiscDeSharedSdkSandboxDirectory(sdkSandboxClientAppVolumeUuid, userId, sdkSandboxClientAppPackage).getAbsoluteFile();
        this.mCredentialProtectedDataDirFile = Environment.getDataMiscCeSharedSdkSandboxDirectory(sdkSandboxClientAppVolumeUuid, userId, sdkSandboxClientAppPackage).getAbsoluteFile();
        this.mDataDirFile = (this.mApplicationInfo.privateFlags & 0x20) != 0 ? this.mDeviceProtectedDataDirFile : this.mCredentialProtectedDataDirFile;
        this.mDataDir = this.mDataDirFile.getAbsolutePath();
    }

    public static void makePaths(ActivityThread activityThread, ApplicationInfo aInfo, List<String> outZipPaths) {
        LoadedApk.makePaths(activityThread, false, aInfo, outZipPaths, null);
    }

    private static void appendSharedLibrariesLibPathsIfNeeded(List<SharedLibraryInfo> sharedLibraries, ApplicationInfo aInfo, Set<String> outSeenPaths, List<String> outLibPaths) {
        if (sharedLibraries == null) {
            return;
        }
        for (SharedLibraryInfo lib : sharedLibraries) {
            if (lib.isNative()) continue;
            List<String> paths = lib.getAllCodePaths();
            outSeenPaths.addAll(paths);
            for (String path : paths) {
                LoadedApk.appendApkLibPathIfNeeded(path, aInfo, outLibPaths);
            }
            LoadedApk.appendSharedLibrariesLibPathsIfNeeded(lib.getDependencies(), aInfo, outSeenPaths, outLibPaths);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void makePaths(ActivityThread activityThread, boolean isBundledApp, ApplicationInfo aInfo, List<String> outZipPaths, List<String> outLibPaths) {
        String appDir = aInfo.sourceDir;
        String libDir = aInfo.nativeLibraryDir;
        outZipPaths.clear();
        outZipPaths.add(appDir);
        if (aInfo.splitSourceDirs != null && !aInfo.requestsIsolatedSplitLoading()) {
            Collections.addAll(outZipPaths, aInfo.splitSourceDirs);
        }
        if (outLibPaths != null) {
            outLibPaths.clear();
        }
        String[] instrumentationLibs = null;
        if (activityThread != null) {
            String instrumentationPackageName = activityThread.mInstrumentationPackageName;
            String instrumentationAppDir = activityThread.mInstrumentationAppDir;
            String[] instrumentationSplitAppDirs = activityThread.mInstrumentationSplitAppDirs;
            String instrumentationLibDir = activityThread.mInstrumentationLibDir;
            String string2 = activityThread.mInstrumentedAppDir;
            String[] instrumentedSplitAppDirs = activityThread.mInstrumentedSplitAppDirs;
            String instrumentedLibDir = activityThread.mInstrumentedLibDir;
            if (appDir.equals(instrumentationAppDir) || appDir.equals(string2)) {
                outZipPaths.clear();
                outZipPaths.add(instrumentationAppDir);
                if (!instrumentationAppDir.equals(string2)) {
                    outZipPaths.add(string2);
                }
                if (!aInfo.requestsIsolatedSplitLoading()) {
                    if (instrumentationSplitAppDirs != null) {
                        Collections.addAll(outZipPaths, instrumentationSplitAppDirs);
                    }
                    if (!instrumentationAppDir.equals(string2) && instrumentedSplitAppDirs != null) {
                        Collections.addAll(outZipPaths, instrumentedSplitAppDirs);
                    }
                }
                if (outLibPaths != null) {
                    outLibPaths.add(instrumentationLibDir);
                    if (!instrumentationLibDir.equals(instrumentedLibDir)) {
                        outLibPaths.add(instrumentedLibDir);
                    }
                }
                if (!string2.equals(instrumentationAppDir)) {
                    instrumentationLibs = LoadedApk.getLibrariesFor(instrumentationPackageName);
                }
            }
        }
        if (outLibPaths != null) {
            if (outLibPaths.isEmpty()) {
                outLibPaths.add(libDir);
            }
            if (aInfo.primaryCpuAbi != null) {
                if (aInfo.targetSdkVersion < 24) {
                    outLibPaths.add("/system/fake-libs" + (VMRuntime.is64BitAbi(aInfo.primaryCpuAbi) ? "64" : ""));
                }
                for (String apk : outZipPaths) {
                    outLibPaths.add(apk + "!/lib/" + aInfo.primaryCpuAbi);
                }
            }
            if (isBundledApp) {
                outLibPaths.add(System.getProperty("java.library.path"));
            }
        }
        LinkedHashSet<String> outSeenPaths = new LinkedHashSet<String>();
        LoadedApk.appendSharedLibrariesLibPathsIfNeeded(aInfo.sharedLibraryInfos, aInfo, outSeenPaths, outLibPaths);
        if (aInfo.sharedLibraryFiles != null) {
            void var12_18;
            int index = 0;
            String[] stringArray = aInfo.sharedLibraryFiles;
            int n = stringArray.length;
            boolean bl = false;
            while (var12_18 < n) {
                String lib = stringArray[var12_18];
                if (lib.endsWith(".apk") && !outSeenPaths.contains(lib) && !outZipPaths.contains(lib)) {
                    outZipPaths.add(index, lib);
                    ++index;
                    LoadedApk.appendApkLibPathIfNeeded(lib, aInfo, outLibPaths);
                }
                ++var12_18;
            }
        }
        if (instrumentationLibs != null) {
            for (void var12_20 : instrumentationLibs) {
                if (outZipPaths.contains(var12_20)) continue;
                outZipPaths.add(0, (String)var12_20);
                LoadedApk.appendApkLibPathIfNeeded((String)var12_20, aInfo, outLibPaths);
            }
        }
    }

    private static void appendApkLibPathIfNeeded(String path, ApplicationInfo applicationInfo, List<String> outLibPaths) {
        if (outLibPaths != null && applicationInfo.primaryCpuAbi != null && path.endsWith(".apk") && applicationInfo.targetSdkVersion >= 26) {
            outLibPaths.add(path + "!/lib/" + applicationInfo.primaryCpuAbi);
        }
    }

    ClassLoader getSplitClassLoader(String splitName) throws PackageManager.NameNotFoundException {
        if (this.mSplitLoader == null) {
            return this.mClassLoader;
        }
        return this.mSplitLoader.getClassLoaderForSplit(splitName);
    }

    String[] getSplitPaths(String splitName) throws PackageManager.NameNotFoundException {
        if (this.mSplitLoader == null) {
            return this.mSplitResDirs;
        }
        return this.mSplitLoader.getSplitPathsForSplit(splitName);
    }

    ClassLoader createSharedLibraryLoader(SharedLibraryInfo sharedLibrary, boolean isBundledApp, String librarySearchPath, String libraryPermittedPath) {
        List<String> paths = sharedLibrary.getAllCodePaths();
        Pair<List<ClassLoader>, List<ClassLoader>> sharedLibraries = this.createSharedLibrariesLoaders(sharedLibrary.getDependencies(), isBundledApp, librarySearchPath, libraryPermittedPath);
        String jars = paths.size() == 1 ? paths.get(0) : TextUtils.join((CharSequence)File.pathSeparator, paths);
        return ApplicationLoaders.getDefault().getSharedLibraryClassLoaderWithSharedLibraries(jars, this.mApplicationInfo.targetSdkVersion, isBundledApp, librarySearchPath, libraryPermittedPath, null, null, (List)sharedLibraries.first, (List)sharedLibraries.second);
    }

    private Pair<List<ClassLoader>, List<ClassLoader>> createSharedLibrariesLoaders(List<SharedLibraryInfo> sharedLibraries, boolean isBundledApp, String librarySearchPath, String libraryPermittedPath) {
        if (sharedLibraries == null || sharedLibraries.isEmpty()) {
            return new Pair<Object, Object>(null, null);
        }
        HashSet libsToLoadAfter = new HashSet();
        Resources systemR = Resources.getSystem();
        Collections.addAll(libsToLoadAfter, systemR.getStringArray(17236144));
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        ArrayList<ClassLoader> after = new ArrayList<ClassLoader>();
        for (SharedLibraryInfo info : sharedLibraries) {
            if (info.isNative() || info.isSdk()) continue;
            if (libsToLoadAfter.contains(info.getName())) {
                after.add(this.createSharedLibraryLoader(info, isBundledApp, librarySearchPath, libraryPermittedPath));
                continue;
            }
            loaders.add(this.createSharedLibraryLoader(info, isBundledApp, librarySearchPath, libraryPermittedPath));
        }
        return new Pair<List<ClassLoader>, List<ClassLoader>>(loaders, after);
    }

    private StrictMode.ThreadPolicy allowThreadDiskReads() {
        if (this.mActivityThread == null) {
            return null;
        }
        return StrictMode.allowThreadDiskReads();
    }

    private void setThreadPolicy(StrictMode.ThreadPolicy policy) {
        if (this.mActivityThread != null && policy != null) {
            StrictMode.setThreadPolicy(policy);
        }
    }

    private StrictMode.VmPolicy allowVmViolations() {
        if (this.mActivityThread == null) {
            return null;
        }
        return StrictMode.allowVmViolations();
    }

    private void setVmPolicy(StrictMode.VmPolicy policy) {
        if (this.mActivityThread != null && policy != null) {
            StrictMode.setVmPolicy(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    private void createOrUpdateClassLoaderLocked(List<String> addedPaths) {
        StrictMode.ThreadPolicy oldPolicy;
        String gpuDebugApp;
        String libraryPermittedPath;
        boolean treatVendorApkAsUnbundled;
        if (this.mPackageName.equals("android")) {
            if (this.mClassLoader != null) {
                return;
            }
            this.mDefaultClassLoader = this.mBaseClassLoader != null ? this.mBaseClassLoader : ClassLoader.getSystemClassLoader();
            this.mAppComponentFactory = this.createAppFactory(this.mApplicationInfo, this.mDefaultClassLoader);
            this.mClassLoader = this.mAppComponentFactory.instantiateClassLoader(this.mDefaultClassLoader, new ApplicationInfo(this.mApplicationInfo));
            return;
        }
        if (this.mActivityThread != null && !Objects.equals(this.mPackageName, ActivityThread.currentPackageName()) && this.mIncludeCode) {
            try {
                ActivityThread.getPackageManager().notifyPackageUse(this.mPackageName, 6);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        if (this.mRegisterPackage) {
            try {
                ActivityManager.getService().addPackageDependency(this.mPackageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        ArrayList<String> zipPaths = new ArrayList<String>(10);
        ArrayList<String> libPaths = new ArrayList<String>(10);
        boolean isBundledApp = this.mApplicationInfo.isSystemApp() && !this.mApplicationInfo.isUpdatedSystemApp();
        String defaultSearchPaths = System.getProperty("java.library.path");
        boolean bl = treatVendorApkAsUnbundled = !defaultSearchPaths.contains("/vendor/lib");
        if (this.mApplicationInfo.getCodePath() != null && this.mApplicationInfo.isVendor() && treatVendorApkAsUnbundled) {
            isBundledApp = false;
        }
        if (this.mApplicationInfo.getCodePath() != null && this.mApplicationInfo.isProduct() && VndkProperties.product_vndk_version().isPresent()) {
            isBundledApp = false;
        }
        LoadedApk.makePaths(this.mActivityThread, isBundledApp, this.mApplicationInfo, zipPaths, libPaths);
        String string2 = libraryPermittedPath = this.canAccessDataDir() ? this.mDataDir : "";
        if (isBundledApp) {
            libraryPermittedPath = libraryPermittedPath + File.pathSeparator + Paths.get(this.getAppDir(), new String[0]).getParent().toString();
            libraryPermittedPath = libraryPermittedPath + File.pathSeparator + defaultSearchPaths;
        }
        String librarySearchPath = TextUtils.join((CharSequence)File.pathSeparator, libPaths);
        if (this.mActivityThread != null && !(gpuDebugApp = this.mActivityThread.getStringCoreSetting("gpu_debug_app", "")).isEmpty() && this.mPackageName.equals(gpuDebugApp)) {
            try {
                ApplicationInfo ai = ActivityThread.getPackageManager().getApplicationInfo(this.mPackageName, 128L, UserHandle.myUserId());
                String debugLayerPath = GraphicsEnvironment.getInstance().getDebugLayerPathsFromSettings(this.mActivityThread.getCoreSettings(), ActivityThread.getPackageManager(), this.mPackageName, ai);
                if (debugLayerPath != null) {
                    libraryPermittedPath = libraryPermittedPath + File.pathSeparator + debugLayerPath;
                }
            }
            catch (RemoteException e) {
                Slog.e("ActivityThread", "RemoteException when fetching debug layer paths for: " + this.mPackageName);
            }
        }
        if (!this.mIncludeCode) {
            if (this.mDefaultClassLoader == null) {
                StrictMode.ThreadPolicy oldPolicy2 = this.allowThreadDiskReads();
                this.mDefaultClassLoader = ApplicationLoaders.getDefault().getClassLoader("", this.mApplicationInfo.targetSdkVersion, isBundledApp, librarySearchPath, libraryPermittedPath, this.mBaseClassLoader, null);
                this.setThreadPolicy(oldPolicy2);
                this.mAppComponentFactory = AppComponentFactory.DEFAULT;
            }
            if (this.mClassLoader == null) {
                this.mClassLoader = this.mAppComponentFactory.instantiateClassLoader(this.mDefaultClassLoader, new ApplicationInfo(this.mApplicationInfo));
            }
            return;
        }
        String zip = zipPaths.size() == 1 ? (String)zipPaths.get(0) : TextUtils.join((CharSequence)File.pathSeparator, zipPaths);
        boolean registerAppInfoToArt = false;
        if (this.mDefaultClassLoader == null) {
            if (this.mActivityThread != null && !ActivityThread.isSystem()) {
                BaseDexClassLoader.setReporter(DexLoadReporter.getInstance());
            }
            oldPolicy = this.allowThreadDiskReads();
            Pair<List<ClassLoader>, List<ClassLoader>> sharedLibraries = this.createSharedLibrariesLoaders(this.mApplicationInfo.sharedLibraryInfos, isBundledApp, librarySearchPath, libraryPermittedPath);
            ArrayList<String> nativeSharedLibraries = new ArrayList<String>();
            if (this.mApplicationInfo.sharedLibraryInfos != null) {
                for (SharedLibraryInfo info : this.mApplicationInfo.sharedLibraryInfos) {
                    if (!info.isNative()) continue;
                    nativeSharedLibraries.add(info.getName());
                }
            }
            this.mDefaultClassLoader = ApplicationLoaders.getDefault().getClassLoaderWithSharedLibraries(zip, this.mApplicationInfo.targetSdkVersion, isBundledApp, librarySearchPath, libraryPermittedPath, this.mBaseClassLoader, this.mApplicationInfo.classLoaderName, (List)sharedLibraries.first, nativeSharedLibraries, (List)sharedLibraries.second);
            this.mAppComponentFactory = this.createAppFactory(this.mApplicationInfo, this.mDefaultClassLoader);
            this.setThreadPolicy(oldPolicy);
            registerAppInfoToArt = true;
        }
        if (!libPaths.isEmpty()) {
            oldPolicy = this.allowThreadDiskReads();
            try {
                ApplicationLoaders.getDefault().addNative(this.mDefaultClassLoader, libPaths);
            }
            finally {
                this.setThreadPolicy(oldPolicy);
            }
        }
        if (addedPaths != null && addedPaths.size() > 0) {
            String add = TextUtils.join((CharSequence)File.pathSeparator, addedPaths);
            ApplicationLoaders.getDefault().addPath(this.mDefaultClassLoader, add);
            registerAppInfoToArt = true;
        }
        if (registerAppInfoToArt && !ActivityThread.isSystem() && this.mActivityThread != null) {
            this.registerAppInfoToArt();
        }
        if (this.mClassLoader == null) {
            this.mClassLoader = this.mAppComponentFactory.instantiateClassLoader(this.mDefaultClassLoader, new ApplicationInfo(this.mApplicationInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canAccessDataDir() {
        if (this.mActivityThread == null) {
            return false;
        }
        if (Objects.equals(this.mPackageName, ActivityThread.currentPackageName())) {
            return true;
        }
        StrictMode.ThreadPolicy oldThreadPolicy = this.allowThreadDiskReads();
        StrictMode.VmPolicy oldVmPolicy = this.allowVmViolations();
        try {
            boolean bl = new File(this.mDataDir).canExecute();
            return bl;
        }
        finally {
            this.setThreadPolicy(oldThreadPolicy);
            this.setVmPolicy(oldVmPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public ClassLoader getClassLoader() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClassLoader == null) {
                this.createOrUpdateClassLoaderLocked(null);
            }
            return this.mClassLoader;
        }
    }

    private void registerAppInfoToArt() {
        if (this.mApplicationInfo.uid != Process.myUid()) {
            return;
        }
        ArrayList<String> codePaths = new ArrayList<String>();
        if ((this.mApplicationInfo.flags & 4) != 0) {
            codePaths.add(this.mApplicationInfo.sourceDir);
        }
        if (this.mApplicationInfo.splitSourceDirs != null) {
            Collections.addAll(codePaths, this.mApplicationInfo.splitSourceDirs);
        }
        if (codePaths.isEmpty()) {
            return;
        }
        for (int i = codePaths.size() - 1; i >= 0; --i) {
            String splitName = i == 0 ? null : this.mApplicationInfo.splitNames[i - 1];
            String curProfileFile = ArtManager.getCurrentProfilePath(this.mPackageName, UserHandle.myUserId(), splitName);
            String refProfileFile = ArtManager.getReferenceProfilePath(this.mPackageName, UserHandle.myUserId(), splitName);
            int codePathType = ((String)codePaths.get(i)).equals(this.mApplicationInfo.sourceDir) ? 1 : 2;
            VMRuntime.registerAppInfo(this.mPackageName, curProfileFile, refProfileFile, new String[]{(String)codePaths.get(i)}, codePathType);
        }
        DexLoadReporter.getInstance().registerAppDataDir(this.mPackageName, this.mDataDir);
    }

    private void initializeJavaContextClassLoader() {
        IPackageManager pm = ActivityThread.getPackageManager();
        PackageInfo pi = PackageManager.getPackageInfoAsUserCached(this.mPackageName, 0x10000000L, UserHandle.myUserId());
        if (pi == null) {
            throw new IllegalStateException("Unable to get package info for " + this.mPackageName + "; is package not installed?");
        }
        boolean sharedUserIdSet = pi.sharedUserId != null;
        boolean processNameNotDefault = pi.applicationInfo != null && !this.mPackageName.equals(pi.applicationInfo.processName);
        boolean sharable = sharedUserIdSet || processNameNotDefault;
        ClassLoader contextClassLoader = sharable ? new WarningContextClassLoader() : this.mClassLoader;
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    @UnsupportedAppUsage
    public String getAppDir() {
        return this.mAppDir;
    }

    public String getLibDir() {
        return this.mLibDir;
    }

    @UnsupportedAppUsage
    public String getResDir() {
        return this.mResDir;
    }

    public String[] getSplitAppDirs() {
        return this.mSplitAppDirs;
    }

    @UnsupportedAppUsage
    public String[] getSplitResDirs() {
        return this.mSplitResDirs;
    }

    @UnsupportedAppUsage
    public String[] getOverlayDirs() {
        return this.mLegacyOverlayDirs;
    }

    public String[] getOverlayPaths() {
        return this.mOverlayPaths;
    }

    public String getDataDir() {
        return this.mDataDir;
    }

    @UnsupportedAppUsage
    public File getDataDirFile() {
        return this.mDataDirFile;
    }

    public File getDeviceProtectedDataDirFile() {
        return this.mDeviceProtectedDataDirFile;
    }

    public File getCredentialProtectedDataDirFile() {
        return this.mCredentialProtectedDataDirFile;
    }

    @UnsupportedAppUsage
    public AssetManager getAssets() {
        return this.getResources().getAssets();
    }

    @UnsupportedAppUsage
    public Resources getResources() {
        if (this.mResources == null) {
            String[] splitPaths;
            try {
                splitPaths = this.getSplitPaths(null);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new AssertionError((Object)"null split not found");
            }
            if (Process.myUid() == this.mApplicationInfo.uid) {
                ResourcesManager.getInstance().initializeApplicationPaths(this.mResDir, splitPaths);
            }
            this.mResources = ResourcesManager.getInstance().getResources(null, this.mResDir, splitPaths, this.mLegacyOverlayDirs, this.mOverlayPaths, this.mApplicationInfo.sharedLibraryFiles, null, null, this.getCompatibilityInfo(), this.getClassLoader(), null);
        }
        return this.mResources;
    }

    @UnsupportedAppUsage
    public Application makeApplication(boolean forceDefaultAppClass, Instrumentation instrumentation) {
        return this.makeApplicationInner(forceDefaultAppClass, instrumentation, true);
    }

    public Application makeApplicationInner(boolean forceDefaultAppClass, Instrumentation instrumentation) {
        return this.makeApplicationInner(forceDefaultAppClass, instrumentation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Application makeApplicationInner(boolean forceDefaultAppClass, Instrumentation instrumentation, boolean allowDuplicateInstances) {
        Application app;
        block20: {
            block19: {
                if (this.mApplication != null) {
                    return this.mApplication;
                }
                Trace.traceBegin(64L, "makeApplication");
                ArrayMap<String, Application> arrayMap = sApplications;
                synchronized (arrayMap) {
                    Application cached = sApplications.get(this.mPackageName);
                    if (cached != null) {
                        if (!"android".equals(this.mPackageName)) {
                            Slog.wtfStack(TAG, "App instance already created for package=" + this.mPackageName + " instance=" + cached);
                        }
                        if (!allowDuplicateInstances) {
                            this.mApplication = cached;
                            return cached;
                        }
                    }
                }
                app = null;
                String myProcessName = Process.myProcessName();
                String appClass = this.mApplicationInfo.getCustomApplicationClassNameForProcess(myProcessName);
                if (forceDefaultAppClass || appClass == null) {
                    appClass = "android.app.Application";
                }
                try {
                    ClassLoader cl = this.getClassLoader();
                    if (!this.mPackageName.equals("android")) {
                        Trace.traceBegin(64L, "initializeJavaContextClassLoader");
                        this.initializeJavaContextClassLoader();
                        Trace.traceEnd(64L);
                    }
                    SparseArray<String> packageIdentifiers = this.getAssets().getAssignedPackageIdentifiers(false, false);
                    int n = packageIdentifiers.size();
                    for (int i = 0; i < n; ++i) {
                        int id2 = packageIdentifiers.keyAt(i);
                        if (id2 == 1 || id2 == 127) continue;
                        this.rewriteRValues(cl, packageIdentifiers.valueAt(i), id2);
                    }
                    ContextImpl appContext = ContextImpl.createAppContext(this.mActivityThread, this);
                    NetworkSecurityConfigProvider.handleNewApplication(appContext);
                    app = this.mActivityThread.mInstrumentation.newApplication(cl, appClass, appContext);
                    appContext.setOuterContext(app);
                }
                catch (Exception e) {
                    if (this.mActivityThread.mInstrumentation.onException(app, e)) break block19;
                    Trace.traceEnd(64L);
                    throw new RuntimeException("Unable to instantiate application " + appClass + " package " + this.mPackageName + ": " + e.toString(), e);
                }
            }
            this.mActivityThread.mAllApplications.add(app);
            this.mApplication = app;
            if (!allowDuplicateInstances) {
                ArrayMap<String, Application> e = sApplications;
                synchronized (e) {
                    sApplications.put(this.mPackageName, app);
                }
            }
            if (instrumentation != null) {
                try {
                    instrumentation.callApplicationOnCreate(app);
                }
                catch (Exception e) {
                    if (instrumentation.onException(app, e)) break block20;
                    Trace.traceEnd(64L);
                    throw new RuntimeException("Unable to create application " + app.getClass().getName() + ": " + e.toString(), e);
                }
            }
        }
        Trace.traceEnd(64L);
        return app;
    }

    @UnsupportedAppUsage
    private void rewriteRValues(ClassLoader cl, String packageName, int id2) {
        Throwable cause;
        Method callback;
        Class<?> rClazz;
        try {
            rClazz = cl.loadClass(packageName + ".R");
        }
        catch (ClassNotFoundException e) {
            Log.i(TAG, "No resource references to update in package " + packageName);
            return;
        }
        try {
            callback = rClazz.getMethod("onResourcesLoaded", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        try {
            callback.invoke(null, id2);
            return;
        }
        catch (IllegalAccessException e) {
            cause = e;
        }
        catch (InvocationTargetException e) {
            cause = e.getCause();
        }
        throw new RuntimeException("Failed to rewrite resource references for " + packageName, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextRegistrations(Context context, String who, String what) {
        AndroidRuntimeException leak;
        int i;
        boolean reportRegistrationLeaks = StrictMode.vmRegistrationLeaksEnabled();
        ArrayMap<Context, ArrayMap<Object, Object>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> rmap = this.mReceivers.remove(context);
            if (rmap != null) {
                for (i = 0; i < rmap.size(); ++i) {
                    ReceiverDispatcher rd = rmap.valueAt(i);
                    leak = new IntentReceiverLeaked(what + " " + who + " has leaked IntentReceiver " + rd.getIntentReceiver() + " that was originally registered here. Are you missing a call to unregisterReceiver()?");
                    leak.setStackTrace(rd.getLocation().getStackTrace());
                    Slog.e("ActivityThread", leak.getMessage(), leak);
                    if (reportRegistrationLeaks) {
                        StrictMode.onIntentReceiverLeaked(leak);
                    }
                    try {
                        ActivityManager.getService().unregisterReceiver(rd.getIIntentReceiver());
                        continue;
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
            this.mUnregisteredReceivers.remove(context);
        }
        arrayMap = this.mServices;
        synchronized (arrayMap) {
            ArrayMap<ServiceConnection, ServiceDispatcher> smap = this.mServices.remove(context);
            if (smap != null) {
                for (i = 0; i < smap.size(); ++i) {
                    ServiceDispatcher sd = smap.valueAt(i);
                    leak = new ServiceConnectionLeaked(what + " " + who + " has leaked ServiceConnection " + sd.getServiceConnection() + " that was originally bound here");
                    leak.setStackTrace(sd.getLocation().getStackTrace());
                    Slog.e("ActivityThread", leak.getMessage(), leak);
                    if (reportRegistrationLeaks) {
                        StrictMode.onServiceConnectionLeaked(leak);
                    }
                    try {
                        ActivityManager.getService().unbindService(sd.getIServiceConnection());
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    sd.doForget();
                }
            }
            this.mUnboundServices.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIntentReceiver getReceiverDispatcher(BroadcastReceiver r, Context context, Handler handler, Instrumentation instrumentation, boolean registered) {
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ReceiverDispatcher rd = null;
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> map = null;
            if (registered && (map = this.mReceivers.get(context)) != null) {
                rd = map.get(r);
            }
            if (rd == null) {
                rd = new ReceiverDispatcher(this.mActivityThread.getApplicationThread(), r, context, handler, instrumentation, registered);
                if (registered) {
                    if (map == null) {
                        map = new ArrayMap();
                        this.mReceivers.put(context, map);
                    }
                    map.put(r, rd);
                }
            } else {
                rd.validate(context, handler);
            }
            rd.mForgotten = false;
            return rd.getIIntentReceiver();
        }
    }

    public IIntentReceiver forgetReceiverDispatcher(Context context, BroadcastReceiver r) {
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> map = this.mReceivers.get(context);
            ReceiverDispatcher rd = null;
            if (map != null && (rd = map.get(r)) != null) {
                map.remove(r);
                if (map.size() == 0) {
                    this.mReceivers.remove(context);
                }
                if (r.getDebugUnregister()) {
                    ArrayMap<BroadcastReceiver, ReceiverDispatcher> holder = this.mUnregisteredReceivers.get(context);
                    if (holder == null) {
                        holder = new ArrayMap();
                        this.mUnregisteredReceivers.put(context, holder);
                    }
                    IllegalArgumentException ex = new IllegalArgumentException("Originally unregistered here:");
                    ex.fillInStackTrace();
                    rd.setUnregisterLocation(ex);
                    holder.put(r, rd);
                }
                rd.mForgotten = true;
                return rd.getIIntentReceiver();
            }
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> holder = this.mUnregisteredReceivers.get(context);
            if (holder != null && (rd = holder.get(r)) != null) {
                RuntimeException ex = rd.getUnregisterLocation();
                throw new IllegalArgumentException("Unregistering Receiver " + r + " that was already unregistered", ex);
            }
            if (context == null) {
                throw new IllegalStateException("Unbinding Receiver " + r + " from Context that is no longer in use: " + context);
            }
            throw new IllegalArgumentException("Receiver not registered: " + r);
        }
    }

    @UnsupportedAppUsage
    public IServiceConnection getServiceDispatcher(ServiceConnection c, Context context, Handler handler, long flags) {
        return this.getServiceDispatcherCommon(c, context, handler, null, flags);
    }

    public IServiceConnection getServiceDispatcher(ServiceConnection c, Context context, Executor executor, long flags) {
        return this.getServiceDispatcherCommon(c, context, null, executor, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServiceConnection getServiceDispatcherCommon(ServiceConnection c, Context context, Handler handler, Executor executor, long flags) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ServiceDispatcher sd = null;
            ArrayMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            if (map != null) {
                sd = map.get(c);
            }
            if (sd == null) {
                sd = executor != null ? new ServiceDispatcher(c, context, executor, flags) : new ServiceDispatcher(c, context, handler, flags);
                if (map == null) {
                    map = new ArrayMap();
                    this.mServices.put(context, map);
                }
                map.put(c, sd);
            } else {
                sd.validate(context, handler, executor);
            }
            return sd.getIServiceConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public IServiceConnection lookupServiceDispatcher(ServiceConnection c, Context context) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ServiceDispatcher sd = null;
            ArrayMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            if (map != null) {
                sd = map.get(c);
            }
            return sd != null ? sd.getIServiceConnection() : null;
        }
    }

    public IServiceConnection forgetServiceDispatcher(Context context, ServiceConnection c) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ArrayMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            ServiceDispatcher sd = null;
            if (map != null && (sd = map.get(c)) != null) {
                map.remove(c);
                sd.doForget();
                if (map.size() == 0) {
                    this.mServices.remove(context);
                }
                if ((sd.getFlags() & 2L) != 0L) {
                    ArrayMap<ServiceConnection, ServiceDispatcher> holder = this.mUnboundServices.get(context);
                    if (holder == null) {
                        holder = new ArrayMap();
                        this.mUnboundServices.put(context, holder);
                    }
                    IllegalArgumentException ex = new IllegalArgumentException("Originally unbound here:");
                    ex.fillInStackTrace();
                    sd.setUnbindLocation(ex);
                    holder.put(c, sd);
                }
                return sd.getIServiceConnection();
            }
            ArrayMap<ServiceConnection, ServiceDispatcher> holder = this.mUnboundServices.get(context);
            if (holder != null && (sd = holder.get(c)) != null) {
                RuntimeException ex = sd.getUnbindLocation();
                throw new IllegalArgumentException("Unbinding Service " + c + " that was already unbound", ex);
            }
            if (context == null) {
                throw new IllegalStateException("Unbinding Service " + c + " from Context that is no longer in use: " + context);
            }
            throw new IllegalArgumentException("Service not registered: " + c);
        }
    }

    public static void checkAndUpdateApkPaths(ApplicationInfo expectedAppInfo) {
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        if (activityThread == null) {
            Log.e(TAG, "Cannot find activity thread");
            return;
        }
        LoadedApk.checkAndUpdateApkPaths(activityThread, expectedAppInfo, true);
        LoadedApk.checkAndUpdateApkPaths(activityThread, expectedAppInfo, false);
    }

    private static void checkAndUpdateApkPaths(ActivityThread activityThread, ApplicationInfo expectedAppInfo, boolean cacheWithCode) {
        String expectedCodePath = expectedAppInfo.getCodePath();
        LoadedApk loadedApk = activityThread.peekPackageInfo(expectedAppInfo.packageName, cacheWithCode);
        if (loadedApk == null || loadedApk.getApplicationInfo() == null || loadedApk.getApplicationInfo().getCodePath().equals(expectedCodePath)) {
            return;
        }
        ArrayList<String> oldPaths = new ArrayList<String>();
        LoadedApk.makePaths(activityThread, expectedAppInfo, oldPaths);
        loadedApk.updateApplicationInfo(expectedAppInfo, oldPaths);
    }

    private class SplitDependencyLoaderImpl
    extends SplitDependencyLoader<PackageManager.NameNotFoundException> {
        @GuardedBy(value={"mLock"})
        private final String[][] mCachedResourcePaths;
        @GuardedBy(value={"mLock"})
        private final ClassLoader[] mCachedClassLoaders;

        SplitDependencyLoaderImpl(SparseArray<int[]> dependencies) {
            super(dependencies);
            this.mCachedResourcePaths = new String[LoadedApk.this.mSplitNames.length + 1][];
            this.mCachedClassLoaders = new ClassLoader[LoadedApk.this.mSplitNames.length + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean isSplitCached(int splitIdx) {
            Object object = LoadedApk.this.mLock;
            synchronized (object) {
                return this.mCachedClassLoaders[splitIdx] != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void constructSplit(int splitIdx, int[] configSplitIndices, int parentSplitIdx) throws PackageManager.NameNotFoundException {
            Object object = LoadedApk.this.mLock;
            synchronized (object) {
                ArrayList<String> splitPaths = new ArrayList<String>();
                if (splitIdx == 0) {
                    LoadedApk.this.createOrUpdateClassLoaderLocked(null);
                    this.mCachedClassLoaders[0] = LoadedApk.this.mClassLoader;
                    for (int configSplitIdx : configSplitIndices) {
                        splitPaths.add(LoadedApk.this.mSplitResDirs[configSplitIdx - 1]);
                    }
                    this.mCachedResourcePaths[0] = splitPaths.toArray(new String[splitPaths.size()]);
                    return;
                }
                ClassLoader parent = this.mCachedClassLoaders[parentSplitIdx];
                this.mCachedClassLoaders[splitIdx] = ApplicationLoaders.getDefault().getClassLoader(LoadedApk.this.mSplitAppDirs[splitIdx - 1], LoadedApk.this.getTargetSdkVersion(), false, null, null, parent, LoadedApk.this.mSplitClassLoaderNames[splitIdx - 1]);
                Collections.addAll(splitPaths, this.mCachedResourcePaths[parentSplitIdx]);
                splitPaths.add(LoadedApk.this.mSplitResDirs[splitIdx - 1]);
                for (int configSplitIdx : configSplitIndices) {
                    splitPaths.add(LoadedApk.this.mSplitResDirs[configSplitIdx - 1]);
                }
                this.mCachedResourcePaths[splitIdx] = splitPaths.toArray(new String[splitPaths.size()]);
            }
        }

        private int ensureSplitLoaded(String splitName) throws PackageManager.NameNotFoundException {
            int idx = 0;
            if (splitName != null) {
                idx = Arrays.binarySearch(LoadedApk.this.mSplitNames, splitName);
                if (idx < 0) {
                    throw new PackageManager.NameNotFoundException("Split name '" + splitName + "' is not installed");
                }
                ++idx;
            }
            this.loadDependenciesForSplit(idx);
            return idx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassLoader getClassLoaderForSplit(String splitName) throws PackageManager.NameNotFoundException {
            int idx = this.ensureSplitLoaded(splitName);
            Object object = LoadedApk.this.mLock;
            synchronized (object) {
                return this.mCachedClassLoaders[idx];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] getSplitPathsForSplit(String splitName) throws PackageManager.NameNotFoundException {
            int idx = this.ensureSplitLoaded(splitName);
            Object object = LoadedApk.this.mLock;
            synchronized (object) {
                return this.mCachedResourcePaths[idx];
            }
        }
    }

    private static class WarningContextClassLoader
    extends ClassLoader {
        private static boolean warned = false;

        private WarningContextClassLoader() {
        }

        private void warn(String methodName) {
            if (warned) {
                return;
            }
            warned = true;
            Thread.currentThread().setContextClassLoader(this.getParent());
            Slog.w("ActivityThread", "ClassLoader." + methodName + ": The class loader returned by Thread.getContextClassLoader() may fail for processes that host multiple applications. You should explicitly specify a context class loader. For example: Thread.setContextClassLoader(getClass().getClassLoader());");
        }

        @Override
        public URL getResource(String resName) {
            this.warn("getResource");
            return this.getParent().getResource(resName);
        }

        @Override
        public Enumeration<URL> getResources(String resName) throws IOException {
            this.warn("getResources");
            return this.getParent().getResources(resName);
        }

        @Override
        public InputStream getResourceAsStream(String resName) {
            this.warn("getResourceAsStream");
            return this.getParent().getResourceAsStream(resName);
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            this.warn("loadClass");
            return this.getParent().loadClass(className);
        }

        @Override
        public void setClassAssertionStatus(String cname, boolean enable) {
            this.warn("setClassAssertionStatus");
            this.getParent().setClassAssertionStatus(cname, enable);
        }

        @Override
        public void setPackageAssertionStatus(String pname, boolean enable) {
            this.warn("setPackageAssertionStatus");
            this.getParent().setPackageAssertionStatus(pname, enable);
        }

        @Override
        public void setDefaultAssertionStatus(boolean enable) {
            this.warn("setDefaultAssertionStatus");
            this.getParent().setDefaultAssertionStatus(enable);
        }

        @Override
        public void clearAssertionStatus() {
            this.warn("clearAssertionStatus");
            this.getParent().clearAssertionStatus();
        }
    }

    static class ReceiverDispatcher {
        final IApplicationThread mAppThread;
        final IIntentReceiver.Stub mIIntentReceiver;
        @UnsupportedAppUsage
        final BroadcastReceiver mReceiver;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        final Context mContext;
        final Handler mActivityThread;
        final Instrumentation mInstrumentation;
        final boolean mRegistered;
        final IntentReceiverLeaked mLocation;
        RuntimeException mUnregisterLocation;
        boolean mForgotten;

        ReceiverDispatcher(IApplicationThread appThread, BroadcastReceiver receiver, Context context, Handler activityThread, Instrumentation instrumentation, boolean registered) {
            if (activityThread == null) {
                throw new NullPointerException("Handler must not be null");
            }
            this.mAppThread = appThread;
            this.mIIntentReceiver = new InnerReceiver(this.mAppThread, this, !registered);
            this.mReceiver = receiver;
            this.mContext = context;
            this.mActivityThread = activityThread;
            this.mInstrumentation = instrumentation;
            this.mRegistered = registered;
            this.mLocation = new IntentReceiverLeaked(null);
            this.mLocation.fillInStackTrace();
        }

        void validate(Context context, Handler activityThread) {
            if (this.mContext != context) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != activityThread) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing handler (was " + this.mActivityThread + " now " + activityThread + ")");
            }
        }

        IntentReceiverLeaked getLocation() {
            return this.mLocation;
        }

        @UnsupportedAppUsage
        BroadcastReceiver getIntentReceiver() {
            return this.mReceiver;
        }

        @UnsupportedAppUsage
        IIntentReceiver getIIntentReceiver() {
            return this.mIIntentReceiver;
        }

        void setUnregisterLocation(RuntimeException ex) {
            this.mUnregisterLocation = ex;
        }

        RuntimeException getUnregisterLocation() {
            return this.mUnregisterLocation;
        }

        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, boolean assumeDelivered, int sendingUser, int sendingUid, String sendingPackage) {
            Args args = new Args(intent, resultCode, data, extras, ordered, sticky, assumeDelivered, sendingUser, sendingUid, sendingPackage);
            if (intent == null) {
                Log.wtf(LoadedApk.TAG, "Null intent received");
            }
            if (intent == null || !this.mActivityThread.post(args.getRunnable())) {
                IActivityManager mgr = ActivityManager.getService();
                args.sendFinished(mgr);
            }
        }

        static class InnerReceiver
        extends IIntentReceiver.Stub {
            final IApplicationThread mApplicationThread;
            final WeakReference<ReceiverDispatcher> mDispatcher;
            final ReceiverDispatcher mStrongRef;

            InnerReceiver(IApplicationThread thread, ReceiverDispatcher rd, boolean strong) {
                this.mApplicationThread = thread;
                this.mDispatcher = new WeakReference<ReceiverDispatcher>(rd);
                this.mStrongRef = strong ? rd : null;
            }

            @Override
            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                Log.wtf(LoadedApk.TAG, "performReceive() called targeting raw IIntentReceiver for " + intent);
                this.performReceive(intent, resultCode, data, extras, ordered, sticky, BroadcastReceiver.PendingResult.guessAssumeDelivered(1, ordered), sendingUser, -1, null);
            }

            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, boolean assumeDelivered, int sendingUser, int sendingUid, String sendingPackage) {
                ReceiverDispatcher rd;
                if (intent == null) {
                    Log.wtf(LoadedApk.TAG, "Null intent received");
                    rd = null;
                } else {
                    rd = (ReceiverDispatcher)this.mDispatcher.get();
                }
                if (rd != null) {
                    rd.performReceive(intent, resultCode, data, extras, ordered, sticky, assumeDelivered, sendingUser, sendingUid, sendingPackage);
                } else if (!assumeDelivered) {
                    IActivityManager mgr = ActivityManager.getService();
                    try {
                        if (extras != null) {
                            extras.setAllowFds(false);
                        }
                        mgr.finishReceiver(this.mApplicationThread.asBinder(), resultCode, data, extras, false, intent.getFlags());
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        class Args
        extends BroadcastReceiver.PendingResult {
            private Intent mCurIntent;
            private boolean mDispatched;
            private boolean mRunCalled;

            public Args(Intent intent, int resultCode, String resultData, Bundle resultExtras, boolean ordered, boolean sticky, boolean assumeDelivered, int sendingUser, int sendingUid, String sendingPackage) {
                super(resultCode, resultData, resultExtras, ReceiverDispatcher.this.mRegistered ? 1 : 2, ordered, sticky, assumeDelivered, ReceiverDispatcher.this.mAppThread.asBinder(), sendingUser, intent.getFlags(), sendingUid, sendingPackage);
                this.mCurIntent = intent;
            }

            public Runnable getRunnable() {
                return () -> {
                    BroadcastReceiver receiver;
                    block6: {
                        receiver = ReceiverDispatcher.this.mReceiver;
                        IActivityManager mgr = ActivityManager.getService();
                        Intent intent = this.mCurIntent;
                        if (intent == null) {
                            Log.wtf(LoadedApk.TAG, "Null intent being dispatched, mDispatched=" + this.mDispatched + (this.mRunCalled ? ", run() has already been called" : ""));
                        }
                        this.mCurIntent = null;
                        this.mDispatched = true;
                        this.mRunCalled = true;
                        if (receiver == null || intent == null || ReceiverDispatcher.this.mForgotten) {
                            this.sendFinished(mgr);
                            return;
                        }
                        if (Trace.isTagEnabled(64L)) {
                            Trace.traceBegin(64L, "broadcastReceiveReg: " + intent.getAction());
                        }
                        try {
                            ClassLoader cl = ReceiverDispatcher.this.mReceiver.getClass().getClassLoader();
                            intent.setExtrasClassLoader(cl);
                            intent.prepareToEnterProcess(ActivityThread.isProtectedBroadcast(intent), ReceiverDispatcher.this.mContext.getAttributionSource());
                            this.setExtrasClassLoader(cl);
                            receiver.setPendingResult(this);
                            receiver.onReceive(ReceiverDispatcher.this.mContext, intent);
                        }
                        catch (Exception e) {
                            this.sendFinished(mgr);
                            if (ReceiverDispatcher.this.mInstrumentation != null && ReceiverDispatcher.this.mInstrumentation.onException(ReceiverDispatcher.this.mReceiver, e)) break block6;
                            Trace.traceEnd(64L);
                            throw new RuntimeException("Error receiving broadcast " + intent + " in " + ReceiverDispatcher.this.mReceiver, e);
                        }
                    }
                    if (receiver.getPendingResult() != null) {
                        this.finish();
                    }
                    Trace.traceEnd(64L);
                };
            }
        }
    }

    static class ServiceDispatcher {
        private final InnerConnection mIServiceConnection;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final ServiceConnection mConnection;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        private final Context mContext;
        private final Handler mActivityThread;
        private final Executor mActivityExecutor;
        private final ServiceConnectionLeaked mLocation;
        private final long mFlags;
        private RuntimeException mUnbindLocation;
        private boolean mForgotten;
        private final ArrayMap<ComponentName, ConnectionInfo> mActiveConnections = new ArrayMap();

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        ServiceDispatcher(ServiceConnection conn, Context context, Handler activityThread, long flags) {
            this.mIServiceConnection = new InnerConnection(this);
            this.mConnection = conn;
            this.mContext = context;
            this.mActivityThread = activityThread;
            this.mActivityExecutor = null;
            this.mLocation = new ServiceConnectionLeaked(null);
            this.mLocation.fillInStackTrace();
            this.mFlags = flags;
        }

        ServiceDispatcher(ServiceConnection conn, Context context, Executor activityExecutor, long flags) {
            this.mIServiceConnection = new InnerConnection(this);
            this.mConnection = conn;
            this.mContext = context;
            this.mActivityThread = null;
            this.mActivityExecutor = activityExecutor;
            this.mLocation = new ServiceConnectionLeaked(null);
            this.mLocation.fillInStackTrace();
            this.mFlags = flags;
        }

        void validate(Context context, Handler activityThread, Executor activityExecutor) {
            if (this.mContext != context) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != activityThread) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing handler (was " + this.mActivityThread + " now " + activityThread + ")");
            }
            if (this.mActivityExecutor != activityExecutor) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing executor (was " + this.mActivityExecutor + " now " + activityExecutor + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doForget() {
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                for (int i = 0; i < this.mActiveConnections.size(); ++i) {
                    ConnectionInfo ci = this.mActiveConnections.valueAt(i);
                    ci.binder.unlinkToDeath(ci.deathMonitor, 0);
                }
                this.mActiveConnections.clear();
                this.mForgotten = true;
            }
        }

        ServiceConnectionLeaked getLocation() {
            return this.mLocation;
        }

        ServiceConnection getServiceConnection() {
            return this.mConnection;
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        IServiceConnection getIServiceConnection() {
            return this.mIServiceConnection;
        }

        long getFlags() {
            return this.mFlags;
        }

        void setUnbindLocation(RuntimeException ex) {
            this.mUnbindLocation = ex;
        }

        RuntimeException getUnbindLocation() {
            return this.mUnbindLocation;
        }

        public void connected(ComponentName name, IBinder service, boolean dead) {
            if (this.mActivityExecutor != null) {
                this.mActivityExecutor.execute(new RunConnection(name, service, 0, dead));
            } else if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(name, service, 0, dead));
            } else {
                this.doConnected(name, service, dead);
            }
        }

        public void death(ComponentName name, IBinder service) {
            if (this.mActivityExecutor != null) {
                this.mActivityExecutor.execute(new RunConnection(name, service, 1, false));
            } else if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(name, service, 1, false));
            } else {
                this.doDeath(name, service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doConnected(ComponentName name, IBinder service, boolean dead) {
            ConnectionInfo old;
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                if (this.mForgotten) {
                    return;
                }
                old = this.mActiveConnections.get(name);
                if (old != null && old.binder == service) {
                    return;
                }
                if (service != null) {
                    ConnectionInfo info = new ConnectionInfo();
                    info.binder = service;
                    info.deathMonitor = new DeathMonitor(name, service);
                    try {
                        service.linkToDeath(info.deathMonitor, 0);
                        this.mActiveConnections.put(name, info);
                    }
                    catch (RemoteException e) {
                        this.mActiveConnections.remove(name);
                        return;
                    }
                } else {
                    this.mActiveConnections.remove(name);
                }
                if (old != null) {
                    old.binder.unlinkToDeath(old.deathMonitor, 0);
                }
            }
            if (old != null) {
                this.mConnection.onServiceDisconnected(name);
            }
            if (dead) {
                this.mConnection.onBindingDied(name);
            } else if (service != null) {
                this.mConnection.onServiceConnected(name, service);
            } else {
                this.mConnection.onNullBinding(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doDeath(ComponentName name, IBinder service) {
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                ConnectionInfo old = this.mActiveConnections.get(name);
                if (old == null || old.binder != service) {
                    return;
                }
                this.mActiveConnections.remove(name);
                old.binder.unlinkToDeath(old.deathMonitor, 0);
            }
            this.mConnection.onServiceDisconnected(name);
        }

        private static class InnerConnection
        extends IServiceConnection.Stub {
            @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
            final WeakReference<ServiceDispatcher> mDispatcher;

            InnerConnection(ServiceDispatcher sd) {
                this.mDispatcher = new WeakReference<ServiceDispatcher>(sd);
            }

            @Override
            public void connected(ComponentName name, IBinder service, boolean dead) throws RemoteException {
                ServiceDispatcher sd = (ServiceDispatcher)this.mDispatcher.get();
                if (sd != null) {
                    sd.connected(name, service, dead);
                }
            }
        }

        private static class ConnectionInfo {
            IBinder binder;
            IBinder.DeathRecipient deathMonitor;

            private ConnectionInfo() {
            }
        }

        private class RunConnection
        implements Runnable {
            final ComponentName mName;
            final IBinder mService;
            final int mCommand;
            final boolean mDead;

            RunConnection(ComponentName name, IBinder service, int command, boolean dead) {
                this.mName = name;
                this.mService = service;
                this.mCommand = command;
                this.mDead = dead;
            }

            @Override
            public void run() {
                if (this.mCommand == 0) {
                    ServiceDispatcher.this.doConnected(this.mName, this.mService, this.mDead);
                } else if (this.mCommand == 1) {
                    ServiceDispatcher.this.doDeath(this.mName, this.mService);
                }
            }
        }

        private class DeathMonitor
        implements IBinder.DeathRecipient {
            final ComponentName mName;
            final IBinder mService;

            DeathMonitor(ComponentName name, IBinder service) {
                this.mName = name;
                this.mService = service;
            }

            @Override
            public void binderDied() {
                ServiceDispatcher.this.death(this.mName, this.mService);
            }
        }
    }
}

