/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ILocaleManager;
import android.app.LocaleConfig;
import android.content.Context;
import android.content.res.Configuration;
import android.os.LocaleList;
import android.os.RemoteException;

public class LocaleManager {
    private static final String TAG = "LocaleManager";
    private Context mContext;
    private ILocaleManager mService;

    public LocaleManager(Context context, ILocaleManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public void setApplicationLocales(LocaleList locales) {
        this.setApplicationLocales(this.mContext.getPackageName(), locales, false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHANGE_CONFIGURATION")
    public void setApplicationLocales(String appPackageName, LocaleList locales) {
        this.setApplicationLocales(appPackageName, locales, true);
    }

    private void setApplicationLocales(String appPackageName, LocaleList locales, boolean fromDelegate) {
        try {
            this.mService.setApplicationLocales(appPackageName, this.mContext.getUserId(), locales, fromDelegate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public LocaleList getApplicationLocales() {
        return this.getApplicationLocales(this.mContext.getPackageName());
    }

    @RequiresPermission(value="android.permission.READ_APP_SPECIFIC_LOCALES", conditional=true)
    public LocaleList getApplicationLocales(String appPackageName) {
        try {
            return this.mService.getApplicationLocales(appPackageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public LocaleList getSystemLocales() {
        try {
            return this.mService.getSystemLocales();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setSystemLocales(LocaleList locales) {
        try {
            Configuration conf = new Configuration();
            conf.setLocales(locales);
            ActivityManager.getService().updatePersistentConfiguration(conf);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setOverrideLocaleConfig(LocaleConfig localeConfig) {
        try {
            this.mService.setOverrideLocaleConfig(this.mContext.getPackageName(), this.mContext.getUserId(), localeConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public LocaleConfig getOverrideLocaleConfig() {
        try {
            return this.mService.getOverrideLocaleConfig(this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

