/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import java.io.IOException;
import java.util.Objects;

public class ProfilerInfo
implements Parcelable {
    public static final int CLOCK_TYPE_DEFAULT = 0;
    public static final int CLOCK_TYPE_WALL = 16;
    public static final int CLOCK_TYPE_THREAD_CPU = 256;
    public static final int CLOCK_TYPE_DUAL = 272;
    private static final String TAG = "ProfilerInfo";
    public final String profileFile;
    public ParcelFileDescriptor profileFd;
    public final int samplingInterval;
    public final boolean autoStopProfiler;
    public final boolean streamingOutput;
    public final String agent;
    public final boolean attachAgentDuringBind;
    public final int clockType;
    public static final Parcelable.Creator<ProfilerInfo> CREATOR = new Parcelable.Creator<ProfilerInfo>(){

        @Override
        public ProfilerInfo createFromParcel(Parcel in) {
            return new ProfilerInfo(in);
        }

        public ProfilerInfo[] newArray(int size) {
            return new ProfilerInfo[size];
        }
    };

    public ProfilerInfo(String filename, ParcelFileDescriptor fd, int interval, boolean autoStop, boolean streaming, String agent, boolean attachAgentDuringBind, int clockType) {
        this.profileFile = filename;
        this.profileFd = fd;
        this.samplingInterval = interval;
        this.autoStopProfiler = autoStop;
        this.streamingOutput = streaming;
        this.clockType = clockType;
        this.agent = agent;
        this.attachAgentDuringBind = attachAgentDuringBind;
    }

    public ProfilerInfo(ProfilerInfo in) {
        this.profileFile = in.profileFile;
        this.profileFd = in.profileFd;
        this.samplingInterval = in.samplingInterval;
        this.autoStopProfiler = in.autoStopProfiler;
        this.streamingOutput = in.streamingOutput;
        this.agent = in.agent;
        this.attachAgentDuringBind = in.attachAgentDuringBind;
        this.clockType = in.clockType;
    }

    public static int getClockTypeFromString(String type) {
        if ("thread-cpu".equals(type)) {
            return 256;
        }
        if ("wall".equals(type)) {
            return 16;
        }
        if ("dual".equals(type)) {
            return 272;
        }
        return 0;
    }

    public ProfilerInfo setAgent(String agent, boolean attachAgentDuringBind) {
        return new ProfilerInfo(this.profileFile, this.profileFd, this.samplingInterval, this.autoStopProfiler, this.streamingOutput, agent, attachAgentDuringBind, this.clockType);
    }

    public void closeFd() {
        if (this.profileFd != null) {
            try {
                this.profileFd.close();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failure closing profile fd", e);
            }
            this.profileFd = null;
        }
    }

    @Override
    public int describeContents() {
        if (this.profileFd != null) {
            return this.profileFd.describeContents();
        }
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.profileFile);
        if (this.profileFd != null) {
            out.writeInt(1);
            this.profileFd.writeToParcel(out, flags);
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.samplingInterval);
        out.writeInt(this.autoStopProfiler ? 1 : 0);
        out.writeInt(this.streamingOutput ? 1 : 0);
        out.writeString(this.agent);
        out.writeBoolean(this.attachAgentDuringBind);
        out.writeInt(this.clockType);
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.profileFile);
        if (this.profileFd != null) {
            proto.write(1120986464258L, this.profileFd.getFd());
        }
        proto.write(1120986464259L, this.samplingInterval);
        proto.write(1133871366148L, this.autoStopProfiler);
        proto.write(1133871366149L, this.streamingOutput);
        proto.write(1138166333446L, this.agent);
        proto.write(1120986464263L, this.clockType);
        proto.end(token);
    }

    private ProfilerInfo(Parcel in) {
        this.profileFile = in.readString();
        this.profileFd = in.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(in) : null;
        this.samplingInterval = in.readInt();
        this.autoStopProfiler = in.readInt() != 0;
        this.streamingOutput = in.readInt() != 0;
        this.agent = in.readString();
        this.attachAgentDuringBind = in.readBoolean();
        this.clockType = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfilerInfo other = (ProfilerInfo)o;
        return Objects.equals(this.profileFile, other.profileFile) && this.autoStopProfiler == other.autoStopProfiler && this.samplingInterval == other.samplingInterval && this.streamingOutput == other.streamingOutput && Objects.equals(this.agent, other.agent) && this.clockType == other.clockType;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.profileFile);
        result = 31 * result + this.samplingInterval;
        result = 31 * result + (this.autoStopProfiler ? 1 : 0);
        result = 31 * result + (this.streamingOutput ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.agent);
        result = 31 * result + this.clockType;
        return result;
    }
}

