/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.KeyguardManager;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class RemoteLockscreenValidationSession
implements Parcelable {
    @KeyguardManager.LockTypes
    private int mLockType;
    private byte[] mSourcePublicKey;
    private int mRemainingAttempts;
    public static final Parcelable.Creator<RemoteLockscreenValidationSession> CREATOR = new Parcelable.Creator<RemoteLockscreenValidationSession>(){

        @Override
        public RemoteLockscreenValidationSession createFromParcel(Parcel source) {
            return new RemoteLockscreenValidationSession(source);
        }

        public RemoteLockscreenValidationSession[] newArray(int size) {
            return new RemoteLockscreenValidationSession[size];
        }
    };

    @KeyguardManager.LockTypes
    public int getLockType() {
        return this.mLockType;
    }

    public byte[] getSourcePublicKey() {
        return this.mSourcePublicKey;
    }

    public int getRemainingAttempts() {
        return this.mRemainingAttempts;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mLockType);
        out.writeByteArray(this.mSourcePublicKey);
        out.writeInt(this.mRemainingAttempts);
    }

    private RemoteLockscreenValidationSession() {
    }

    private RemoteLockscreenValidationSession(Parcel in) {
        this.mLockType = in.readInt();
        this.mSourcePublicKey = in.createByteArray();
        this.mRemainingAttempts = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private RemoteLockscreenValidationSession mInstance = new RemoteLockscreenValidationSession();

        public Builder setLockType(@KeyguardManager.LockTypes int lockType) {
            this.mInstance.mLockType = lockType;
            return this;
        }

        public Builder setSourcePublicKey(byte[] publicKey) {
            this.mInstance.mSourcePublicKey = publicKey;
            return this;
        }

        public Builder setRemainingAttempts(int remainingAttempts) {
            this.mInstance.mRemainingAttempts = remainingAttempts;
            return this;
        }

        public RemoteLockscreenValidationSession build() {
            Objects.requireNonNull(this.mInstance.mSourcePublicKey);
            return this.mInstance;
        }
    }
}

