/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.StatsCursor;
import android.app.StatsQuery;
import android.content.Context;
import android.os.Binder;
import android.os.IPullAtomCallback;
import android.os.IPullAtomResultReceiver;
import android.os.IStatsManagerService;
import android.os.IStatsQueryCallback;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.StatsFrameworkInitializer;
import android.util.AndroidException;
import android.util.Log;
import android.util.StatsEvent;
import android.util.StatsEventParcel;
import androidx.annotation.RequiresApi;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.statsd.com.android.modules.utils.build.SdkLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

@SystemApi
public class StatsManager {
    private static final String TAG = "StatsManager";
    private static final boolean DEBUG = false;
    private static final Object sLock = new Object();
    private final Context mContext;
    @GuardedBy(value={"sLock"})
    private IStatsManagerService mStatsManagerService;
    public static final String EXTRA_STATS_CONFIG_UID = "android.app.extra.STATS_CONFIG_UID";
    public static final String EXTRA_STATS_CONFIG_KEY = "android.app.extra.STATS_CONFIG_KEY";
    public static final String EXTRA_STATS_SUBSCRIPTION_ID = "android.app.extra.STATS_SUBSCRIPTION_ID";
    public static final String EXTRA_STATS_SUBSCRIPTION_RULE_ID = "android.app.extra.STATS_SUBSCRIPTION_RULE_ID";
    public static final String EXTRA_STATS_BROADCAST_SUBSCRIBER_COOKIES = "android.app.extra.STATS_BROADCAST_SUBSCRIBER_COOKIES";
    public static final String EXTRA_STATS_DIMENSIONS_VALUE = "android.app.extra.STATS_DIMENSIONS_VALUE";
    public static final String EXTRA_STATS_ACTIVE_CONFIG_KEYS = "android.app.extra.STATS_ACTIVE_CONFIG_KEYS";
    public static final String EXTRA_STATS_RESTRICTED_METRIC_IDS = "android.app.extra.STATS_RESTRICTED_METRIC_IDS";
    public static final String ACTION_STATSD_STARTED = "android.app.action.STATSD_STARTED";
    public static final int PULL_SUCCESS = 0;
    public static final int PULL_SKIP = 1;
    @VisibleForTesting
    public static final long DEFAULT_COOL_DOWN_MILLIS = 1000L;
    @VisibleForTesting
    public static final long DEFAULT_TIMEOUT_MILLIS = 1500L;

    public StatsManager(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public void addConfig(long configKey, byte[] config) throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                service.addConfiguration(configKey, config, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to connect to statsmanager when adding configuration");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                Log.e(TAG, "Failed to addConfig in statsmanager");
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public boolean addConfiguration(long configKey, byte[] config) {
        try {
            this.addConfig(configKey, config);
            return true;
        }
        catch (StatsUnavailableException | IllegalArgumentException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public void removeConfig(long configKey) throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                service.removeConfiguration(configKey, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to connect to statsmanager when removing configuration");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                Log.e(TAG, "Failed to removeConfig in statsmanager");
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public boolean removeConfiguration(long configKey) {
        try {
            this.removeConfig(configKey);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public void setBroadcastSubscriber(PendingIntent pendingIntent, long configKey, long subscriberId) throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                if (pendingIntent != null) {
                    service.setBroadcastSubscriber(configKey, subscriberId, pendingIntent, this.mContext.getOpPackageName());
                } else {
                    service.unsetBroadcastSubscriber(configKey, subscriberId, this.mContext.getOpPackageName());
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to connect to statsmanager when adding broadcast subscriber", e);
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public boolean setBroadcastSubscriber(long configKey, long subscriberId, PendingIntent pendingIntent) {
        try {
            this.setBroadcastSubscriber(pendingIntent, configKey, subscriberId);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public void setFetchReportsOperation(PendingIntent pendingIntent, long configKey) throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                if (pendingIntent == null) {
                    service.removeDataFetchOperation(configKey, this.mContext.getOpPackageName());
                } else {
                    service.setDataFetchOperation(configKey, pendingIntent, this.mContext.getOpPackageName());
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to connect to statsmanager when registering data listener.");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public long[] setActiveConfigsChangedOperation(PendingIntent pendingIntent) throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                if (pendingIntent == null) {
                    service.removeActiveConfigsChangedOperation(this.mContext.getOpPackageName());
                    return new long[0];
                }
                return service.setActiveConfigsChangedOperation(pendingIntent, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to connect to statsmanager when registering active configs listener.");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    @RequiresPermission(value="android.permission.READ_RESTRICTED_STATS")
    @RequiresApi(value=34)
    public long[] setRestrictedMetricsChangedOperation(long configKey, String configPackage, PendingIntent pendingIntent) throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                if (pendingIntent == null) {
                    service.removeRestrictedMetricsChangedOperation(configKey, configPackage);
                    return new long[0];
                }
                return service.setRestrictedMetricsChangedOperation(pendingIntent, configKey, configPackage);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to connect to statsmanager when registering restricted metrics  listener.");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.READ_RESTRICTED_STATS")
    @RequiresApi(value=34)
    public void query(long configKey, String configPackage, StatsQuery query, Executor executor, OutcomeReceiver<StatsCursor, StatsQueryException> outcomeReceiver) throws StatsUnavailableException {
        if (query.getSqlDialect() != 1) {
            executor.execute(() -> outcomeReceiver.onError(new StatsQueryException("Unsupported Sql Dialect")));
            return;
        }
        StatsQueryCallbackInternal callbackInternal = new StatsQueryCallbackInternal(outcomeReceiver, executor);
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                service.querySql(query.getRawSql(), query.getMinSqlClientVersion(), query.getPolicyConfig(), callbackInternal, configKey, configPackage);
            }
            catch (RemoteException | IllegalStateException e) {
                throw new StatsUnavailableException("could not connect", e);
            }
        }
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public boolean setDataFetchOperation(long configKey, PendingIntent pendingIntent) {
        try {
            this.setFetchReportsOperation(pendingIntent, configKey);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public byte[] getReports(long configKey) throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                return service.getData(configKey, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to connect to statsmanager when getting data");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                Log.e(TAG, "Failed to getReports in statsmanager");
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public byte[] getData(long configKey) {
        try {
            return this.getReports(configKey);
        }
        catch (StatsUnavailableException e) {
            return null;
        }
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public byte[] getStatsMetadata() throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                return service.getMetadata(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to connect to statsmanager when getting metadata");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                Log.e(TAG, "Failed to getStatsMetadata in statsmanager");
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public byte[] getMetadata() {
        try {
            return this.getStatsMetadata();
        }
        catch (StatsUnavailableException e) {
            return null;
        }
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public long[] getRegisteredExperimentIds() throws StatsUnavailableException {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                return service.getRegisteredExperimentIds();
            }
            catch (RemoteException e) {
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                Log.e(TAG, "Failed to getRegisteredExperimentIds in statsmanager");
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.REGISTER_STATS_PULL_ATOM")
    public void setPullAtomCallback(int atomTag, PullAtomMetadata metadata, Executor executor, StatsPullAtomCallback callback) {
        int[] additiveFields;
        long coolDownMillis = metadata == null ? 1000L : metadata.mCoolDownMillis;
        long timeoutMillis = metadata == null ? 1500L : metadata.mTimeoutMillis;
        int[] nArray = additiveFields = metadata == null ? new int[]{} : metadata.mAdditiveFields;
        if (additiveFields == null) {
            additiveFields = new int[]{};
        }
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                PullAtomCallbackInternal rec = new PullAtomCallbackInternal(atomTag, callback, executor);
                service.registerPullAtomCallback(atomTag, coolDownMillis, timeoutMillis, additiveFields, rec);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Unable to register pull callback", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.REGISTER_STATS_PULL_ATOM")
    public void clearPullAtomCallback(int atomTag) {
        Object object = sLock;
        synchronized (object) {
            try {
                IStatsManagerService service = this.getIStatsManagerServiceLocked();
                service.unregisterPullAtomCallback(atomTag);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Unable to unregister pull atom callback");
            }
        }
    }

    @GuardedBy(value={"sLock"})
    private IStatsManagerService getIStatsManagerServiceLocked() {
        if (this.mStatsManagerService != null) {
            return this.mStatsManagerService;
        }
        this.mStatsManagerService = IStatsManagerService.Stub.asInterface(StatsFrameworkInitializer.getStatsServiceManager().getStatsManagerServiceRegisterer().get());
        return this.mStatsManagerService;
    }

    public static class StatsUnavailableException
    extends AndroidException {
        public StatsUnavailableException(String reason) {
            super("Failed to connect to statsd: " + reason);
        }

        public StatsUnavailableException(String reason, Throwable e) {
            super("Failed to connect to statsd: " + reason, e);
        }
    }

    private static class StatsQueryCallbackInternal
    extends IStatsQueryCallback.Stub {
        OutcomeReceiver<StatsCursor, StatsQueryException> queryCallback;
        Executor mExecutor;

        StatsQueryCallbackInternal(OutcomeReceiver<StatsCursor, StatsQueryException> queryCallback, Executor executor) {
            this.queryCallback = queryCallback;
            this.mExecutor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendResults(String[] queryData, String[] columnNames, int[] columnTypes, int rowCount) {
            if (!SdkLevel.isAtLeastU()) {
                throw new IllegalStateException("StatsManager#query is not available before Android U");
            }
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> {
                    StatsCursor cursor = new StatsCursor(queryData, columnNames, columnTypes, rowCount);
                    this.queryCallback.onResult(cursor);
                });
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendFailure(String error) {
            if (!SdkLevel.isAtLeastU()) {
                throw new IllegalStateException("StatsManager#query is not available before Android U");
            }
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.queryCallback.onError(new StatsQueryException(error)));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public static class PullAtomMetadata {
        private final long mCoolDownMillis;
        private final long mTimeoutMillis;
        private final int[] mAdditiveFields;

        private PullAtomMetadata(long coolDownMillis, long timeoutMillis, int[] additiveFields) {
            this.mCoolDownMillis = coolDownMillis;
            this.mTimeoutMillis = timeoutMillis;
            this.mAdditiveFields = additiveFields;
        }

        public long getCoolDownMillis() {
            return this.mCoolDownMillis;
        }

        public long getTimeoutMillis() {
            return this.mTimeoutMillis;
        }

        public int[] getAdditiveFields() {
            return this.mAdditiveFields;
        }

        public static class Builder {
            private long mCoolDownMillis = 1000L;
            private long mTimeoutMillis = 1500L;
            private int[] mAdditiveFields = null;

            public Builder setCoolDownMillis(long coolDownMillis) {
                this.mCoolDownMillis = coolDownMillis;
                return this;
            }

            public Builder setTimeoutMillis(long timeoutMillis) {
                this.mTimeoutMillis = timeoutMillis;
                return this;
            }

            public Builder setAdditiveFields(int[] additiveFields) {
                this.mAdditiveFields = additiveFields;
                return this;
            }

            public PullAtomMetadata build() {
                return new PullAtomMetadata(this.mCoolDownMillis, this.mTimeoutMillis, this.mAdditiveFields);
            }
        }
    }

    private static class PullAtomCallbackInternal
    extends IPullAtomCallback.Stub {
        public final int mAtomId;
        public final StatsPullAtomCallback mCallback;
        public final Executor mExecutor;

        PullAtomCallbackInternal(int atomId, StatsPullAtomCallback callback, Executor executor) {
            this.mAtomId = atomId;
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPullAtom(int atomTag, IPullAtomResultReceiver resultReceiver) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> {
                    ArrayList<StatsEvent> data = new ArrayList<StatsEvent>();
                    int successInt = this.mCallback.onPullAtom(atomTag, data);
                    boolean success = successInt == 0;
                    StatsEventParcel[] parcels = new StatsEventParcel[data.size()];
                    for (int i = 0; i < data.size(); ++i) {
                        parcels[i] = new StatsEventParcel();
                        parcels[i].buffer = ((StatsEvent)data.get(i)).getBytes();
                    }
                    try {
                        resultReceiver.pullFinished(atomTag, success, parcels);
                    }
                    catch (RemoteException e) {
                        Log.w(StatsManager.TAG, "StatsPullResultReceiver failed for tag " + this.mAtomId + " due to TransactionTooLarge. Calling pullFinish with no data");
                        StatsEventParcel[] emptyData = new StatsEventParcel[]{};
                        try {
                            resultReceiver.pullFinished(atomTag, false, emptyData);
                        }
                        catch (RemoteException nestedException) {
                            Log.w(StatsManager.TAG, "StatsPullResultReceiver failed for tag " + this.mAtomId + " with empty payload");
                        }
                    }
                });
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public static interface StatsPullAtomCallback {
        public int onPullAtom(int var1, List<StatsEvent> var2);
    }

    public static class StatsQueryException
    extends AndroidException {
        public StatsQueryException(String reason) {
            super("Failed to query statsd: " + reason);
        }

        public StatsQueryException(String reason, Throwable e) {
            super("Failed to query statsd: " + reason, e);
        }
    }
}

