/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;

@SystemApi
public class StatsQuery {
    public static final int DIALECT_UNKNOWN = 0;
    public static final int DIALECT_SQLITE = 1;
    private final int sqlDialect;
    private final String rawSql;
    private final int minClientSqlVersion;
    private final byte[] policyConfig;

    private StatsQuery(int sqlDialect, String rawSql, int minClientSqlVersion, byte[] policyConfig) {
        this.sqlDialect = sqlDialect;
        this.rawSql = rawSql;
        this.minClientSqlVersion = minClientSqlVersion;
        this.policyConfig = policyConfig;
    }

    @SqlDialect
    public int getSqlDialect() {
        return this.sqlDialect;
    }

    public String getRawSql() {
        return this.rawSql;
    }

    public int getMinSqlClientVersion() {
        return this.minClientSqlVersion;
    }

    public byte[] getPolicyConfig() {
        return this.policyConfig;
    }

    public static class Builder {
        private int sqlDialect;
        private String rawSql;
        private int minSqlClientVersion;
        private byte[] policyConfig;

        public Builder(String rawSql) {
            if (rawSql == null) {
                throw new IllegalArgumentException("rawSql must not be null");
            }
            this.rawSql = rawSql;
            this.sqlDialect = 1;
            this.minSqlClientVersion = 1;
            this.policyConfig = null;
        }

        public Builder setSqlDialect(@SqlDialect int sqlDialect) {
            this.sqlDialect = sqlDialect;
            return this;
        }

        public Builder setMinSqlClientVersion(int minSqlClientVersion) {
            if (minSqlClientVersion < 0) {
                throw new IllegalArgumentException("minSqlClientVersion must be a positive integer");
            }
            this.minSqlClientVersion = minSqlClientVersion;
            return this;
        }

        public Builder setPolicyConfig(byte[] policyConfig) {
            this.policyConfig = policyConfig;
            return this;
        }

        public StatsQuery build() {
            return new StatsQuery(this.sqlDialect, this.rawSql, this.minSqlClientVersion, this.policyConfig);
        }
    }

    static @interface SqlDialect {
    }
}

