/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.SystemApi;
import android.app.admin.Authority;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Objects;

@SystemApi
public class EnforcingAdmin
implements Parcelable {
    private final String mPackageName;
    private final Authority mAuthority;
    private final UserHandle mUserHandle;
    public static final Parcelable.Creator<EnforcingAdmin> CREATOR = new Parcelable.Creator<EnforcingAdmin>(){

        @Override
        public EnforcingAdmin createFromParcel(Parcel source) {
            return new EnforcingAdmin(source);
        }

        public EnforcingAdmin[] newArray(int size) {
            return new EnforcingAdmin[size];
        }
    };

    public EnforcingAdmin(String packageName, Authority authority, UserHandle userHandle) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mAuthority = Objects.requireNonNull(authority);
        this.mUserHandle = Objects.requireNonNull(userHandle);
    }

    private EnforcingAdmin(Parcel source) {
        this.mPackageName = Objects.requireNonNull(source.readString());
        this.mUserHandle = new UserHandle(source.readInt());
        this.mAuthority = Objects.requireNonNull((Authority)source.readParcelable(Authority.class.getClassLoader()));
    }

    public Authority getAuthority() {
        return this.mAuthority;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnforcingAdmin other = (EnforcingAdmin)o;
        return Objects.equals(this.mPackageName, other.mPackageName) && Objects.equals(this.mAuthority, other.mAuthority) && Objects.equals(this.mUserHandle, other.mUserHandle);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, this.mAuthority, this.mUserHandle);
    }

    public String toString() {
        return "EnforcingAdmin { mPackageName= " + this.mPackageName + ", mAuthority= " + this.mAuthority + ", mUserHandle= " + this.mUserHandle + " }";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mUserHandle.getIdentifier());
        dest.writeParcelable(this.mAuthority, flags);
    }
}

