/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ManagedSubscriptionsPolicy
implements Parcelable {
    private static final String TAG = "ManagedSubscriptionsPolicy";
    public static final int TYPE_ALL_PERSONAL_SUBSCRIPTIONS = 0;
    public static final int TYPE_ALL_MANAGED_SUBSCRIPTIONS = 1;
    private final int mPolicyType;
    private static final String KEY_POLICY_TYPE = "policy_type";
    @NonNull
    public static final Parcelable.Creator<ManagedSubscriptionsPolicy> CREATOR = new Parcelable.Creator<ManagedSubscriptionsPolicy>(){

        @Override
        public ManagedSubscriptionsPolicy createFromParcel(Parcel in) {
            ManagedSubscriptionsPolicy policy = new ManagedSubscriptionsPolicy(in.readInt());
            return policy;
        }

        public ManagedSubscriptionsPolicy[] newArray(int size) {
            return new ManagedSubscriptionsPolicy[size];
        }
    };

    public ManagedSubscriptionsPolicy(int policyType) {
        if (policyType != 0 && policyType != 1) {
            throw new IllegalArgumentException("Invalid policy type");
        }
        this.mPolicyType = policyType;
    }

    public int getPolicyType() {
        return this.mPolicyType;
    }

    public String toString() {
        return TextUtils.formatSimple("ManagedSubscriptionsPolicy (type: %d)", this.mPolicyType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPolicyType);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof ManagedSubscriptionsPolicy)) {
            return false;
        }
        ManagedSubscriptionsPolicy that = (ManagedSubscriptionsPolicy)thatObject;
        return this.mPolicyType == that.mPolicyType;
    }

    public int hashCode() {
        return Objects.hash(this.mPolicyType);
    }

    @Nullable
    public static ManagedSubscriptionsPolicy readFromXml(@NonNull TypedXmlPullParser parser) {
        try {
            ManagedSubscriptionsPolicy policy = new ManagedSubscriptionsPolicy(parser.getAttributeInt(null, KEY_POLICY_TYPE, -1));
            return policy;
        }
        catch (IllegalArgumentException e) {
            Log.w(TAG, "Load xml failed", e);
            return null;
        }
    }

    public void saveToXml(TypedXmlSerializer out) throws IOException {
        out.attributeInt(null, KEY_POLICY_TYPE, this.mPolicyType);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ManagedSubscriptionsPolicyType {
    }
}

