/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class PackagePolicy
implements Parcelable {
    public static final int PACKAGE_POLICY_BLOCKLIST = 1;
    public static final int PACKAGE_POLICY_ALLOWLIST_AND_SYSTEM = 2;
    public static final int PACKAGE_POLICY_ALLOWLIST = 3;
    private int mPolicyType;
    private ArraySet<String> mPackageNames;
    public static final Parcelable.Creator<PackagePolicy> CREATOR = new Parcelable.Creator<PackagePolicy>(){

        @Override
        public PackagePolicy createFromParcel(Parcel in) {
            return new PackagePolicy(in);
        }

        public PackagePolicy[] newArray(int size) {
            return new PackagePolicy[size];
        }
    };

    public PackagePolicy(int policyType) {
        this(policyType, Collections.emptySet());
    }

    public PackagePolicy(int policyType, Set<String> packageNames) {
        if (policyType != 1 && policyType != 2 && policyType != 3) {
            throw new IllegalArgumentException("Invalid policy type");
        }
        this.mPolicyType = policyType;
        this.mPackageNames = new ArraySet<String>(packageNames);
    }

    private PackagePolicy(Parcel in) {
        this.mPolicyType = in.readInt();
        this.mPackageNames = in.readArraySet(null);
    }

    public int getPolicyType() {
        return this.mPolicyType;
    }

    public Set<String> getPackageNames() {
        return Collections.unmodifiableSet(this.mPackageNames);
    }

    public boolean isPackageAllowed(String packageName, Set<String> systemPackages) {
        if (this.mPolicyType == 1) {
            return !this.mPackageNames.contains(packageName);
        }
        return this.mPackageNames.contains(packageName) || this.mPolicyType == 2 && systemPackages.contains(packageName);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPolicyType);
        dest.writeArraySet(this.mPackageNames);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof PackagePolicy)) {
            return false;
        }
        PackagePolicy that = (PackagePolicy)thatObject;
        return this.mPolicyType == that.mPolicyType && this.mPackageNames.equals(that.mPackageNames);
    }

    public int hashCode() {
        return Objects.hash(this.mPolicyType, this.mPackageNames);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PackagePolicyType {
    }
}

