/*
 * Decompiled with CFR 0.152.
 */
package android.app.ambientcontext;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.ambientcontext.AmbientContextCallback;
import android.app.ambientcontext.AmbientContextEvent;
import android.app.ambientcontext.AmbientContextEventRequest;
import android.app.ambientcontext.IAmbientContextManager;
import android.app.ambientcontext.IAmbientContextObserver;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
public class AmbientContextManager {
    public static final String STATUS_RESPONSE_BUNDLE_KEY = "android.app.ambientcontext.AmbientContextStatusBundleKey";
    public static final String EXTRA_AMBIENT_CONTEXT_EVENTS = "android.app.ambientcontext.extra.AMBIENT_CONTEXT_EVENTS";
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_NOT_SUPPORTED = 2;
    public static final int STATUS_SERVICE_UNAVAILABLE = 3;
    public static final int STATUS_MICROPHONE_DISABLED = 4;
    public static final int STATUS_ACCESS_DENIED = 5;
    private final Context mContext;
    private final IAmbientContextManager mService;

    public static List<AmbientContextEvent> getEventsFromIntent(Intent intent) {
        if (intent.hasExtra(EXTRA_AMBIENT_CONTEXT_EVENTS)) {
            return intent.getParcelableArrayListExtra(EXTRA_AMBIENT_CONTEXT_EVENTS, AmbientContextEvent.class);
        }
        return new ArrayList<AmbientContextEvent>();
    }

    public AmbientContextManager(Context context, IAmbientContextManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.ACCESS_AMBIENT_CONTEXT_EVENT")
    public void queryAmbientContextServiceStatus(@AmbientContextEvent.EventCode Set<Integer> eventTypes, Executor executor, @StatusCode Consumer<Integer> consumer) {
        try {
            RemoteCallback callback = new RemoteCallback(result -> {
                int status = result.getInt(STATUS_RESPONSE_BUNDLE_KEY);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> consumer.accept(status));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            });
            this.mService.queryServiceStatus(AmbientContextManager.integerSetToIntArray(eventTypes), this.mContext.getOpPackageName(), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_AMBIENT_CONTEXT_EVENT")
    public void startConsentActivity(@AmbientContextEvent.EventCode Set<Integer> eventTypes) {
        try {
            this.mService.startConsentActivity(AmbientContextManager.integerSetToIntArray(eventTypes), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static int[] integerSetToIntArray(Set<Integer> integerSet) {
        int[] intArray = new int[integerSet.size()];
        int i = 0;
        for (Integer type : integerSet) {
            intArray[i++] = type;
        }
        return intArray;
    }

    @RequiresPermission(value="android.permission.ACCESS_AMBIENT_CONTEXT_EVENT")
    public void registerObserver(AmbientContextEventRequest request, PendingIntent resultPendingIntent, Executor executor, @StatusCode Consumer<Integer> statusConsumer) {
        Preconditions.checkArgument(!resultPendingIntent.isImmutable());
        try {
            RemoteCallback callback = new RemoteCallback(result -> {
                int statusCode = result.getInt(STATUS_RESPONSE_BUNDLE_KEY);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> statusConsumer.accept(statusCode));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            });
            this.mService.registerObserver(request, resultPendingIntent, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_AMBIENT_CONTEXT_EVENT")
    public void registerObserver(AmbientContextEventRequest request, final Executor executor, final AmbientContextCallback ambientContextCallback) {
        try {
            IAmbientContextObserver.Stub observer = new IAmbientContextObserver.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onEvents(List<AmbientContextEvent> events) throws RemoteException {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> ambientContextCallback.onEvents(events));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onRegistrationComplete(int statusCode) throws RemoteException {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> ambientContextCallback.onRegistrationComplete(statusCode));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            };
            this.mService.registerObserverWithCallback(request, this.mContext.getPackageName(), observer);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_AMBIENT_CONTEXT_EVENT")
    public void unregisterObserver() {
        try {
            this.mService.unregisterObserver(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static @interface StatusCode {
    }
}

