/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchManager;
import android.app.appsearch.AppSearchMigrationHelper;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.BatchResultCallback;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.GetByDocumentIdRequest;
import android.app.appsearch.GetSchemaResponse;
import android.app.appsearch.InternalSetSchemaResponse;
import android.app.appsearch.Migrator;
import android.app.appsearch.PutDocumentsRequest;
import android.app.appsearch.RemoveByDocumentIdRequest;
import android.app.appsearch.ReportUsageRequest;
import android.app.appsearch.SearchResults;
import android.app.appsearch.SearchSessionUtil;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.SearchSuggestionResult;
import android.app.appsearch.SearchSuggestionSpec;
import android.app.appsearch.SetSchemaRequest;
import android.app.appsearch.SetSchemaResponse;
import android.app.appsearch.StorageInfo;
import android.app.appsearch.VisibilityDocument;
import android.app.appsearch.aidl.AppSearchBatchResultParcel;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.DocumentsParcel;
import android.app.appsearch.aidl.IAppSearchBatchResultCallback;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.IAppSearchResultCallback;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.stats.SchemaMigrationStats;
import android.app.appsearch.util.SchemaMigrationUtil;
import android.content.AttributionSource;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class AppSearchSession
implements Closeable {
    private static final String TAG = "AppSearchSession";
    private final AttributionSource mCallerAttributionSource;
    private final String mDatabaseName;
    private final UserHandle mUserHandle;
    private final IAppSearchManager mService;
    private boolean mIsMutated = false;
    private boolean mIsClosed = false;

    static void createSearchSession(AppSearchManager.SearchContext searchContext, IAppSearchManager service, UserHandle userHandle, AttributionSource callerAttributionSource, Executor executor, Consumer<AppSearchResult<AppSearchSession>> callback) {
        AppSearchSession searchSession = new AppSearchSession(service, userHandle, callerAttributionSource, searchContext.mDatabaseName);
        searchSession.initialize(executor, callback);
    }

    private void initialize(final Executor executor, final Consumer<AppSearchResult<AppSearchSession>> callback) {
        try {
            this.mService.initialize(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            callback.accept(AppSearchResult.newSuccessfulResult(AppSearchSession.this));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private AppSearchSession(IAppSearchManager service, UserHandle userHandle, AttributionSource callerAttributionSource, String databaseName) {
        this.mService = service;
        this.mUserHandle = userHandle;
        this.mCallerAttributionSource = callerAttributionSource;
        this.mDatabaseName = databaseName;
    }

    public void setSchema(SetSchemaRequest request, Executor workExecutor, Executor callbackExecutor, Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(workExecutor);
        Objects.requireNonNull(callbackExecutor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        ArrayList<Bundle> schemaBundles = new ArrayList<Bundle>(request.getSchemas().size());
        for (AppSearchSchema schema : request.getSchemas()) {
            schemaBundles.add(schema.getBundle());
        }
        List<VisibilityDocument> visibilityDocuments = VisibilityDocument.toVisibilityDocuments(request);
        ArrayList<Bundle> visibilityBundles = new ArrayList<Bundle>(visibilityDocuments.size());
        for (int i = 0; i < visibilityDocuments.size(); ++i) {
            visibilityBundles.add(visibilityDocuments.get(i).getBundle());
        }
        if (request.getMigrators().isEmpty()) {
            this.setSchemaNoMigrations(request, schemaBundles, visibilityBundles, callbackExecutor, callback);
        } else {
            this.setSchemaWithMigrations(request, schemaBundles, visibilityBundles, workExecutor, callbackExecutor, callback);
        }
        this.mIsMutated = true;
    }

    public void getSchema(final Executor executor, final Consumer<AppSearchResult<GetSchemaResponse>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        String targetPackageName = Objects.requireNonNull(this.mCallerAttributionSource.getPackageName());
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getSchema(this.mCallerAttributionSource, targetPackageName, this.mDatabaseName, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            GetSchemaResponse response = new GetSchemaResponse(Objects.requireNonNull((Bundle)result.getResultValue()));
                            callback.accept(AppSearchResult.newSuccessfulResult(response));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getNamespaces(final Executor executor, final Consumer<AppSearchResult<Set<String>>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getNamespaces(this.mCallerAttributionSource, this.mDatabaseName, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            ArraySet namespaces = new ArraySet((Collection)result.getResultValue());
                            callback.accept(AppSearchResult.newSuccessfulResult(namespaces));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void put(PutDocumentsRequest request, final Executor executor, final BatchResultCallback<String, Void> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        DocumentsParcel documentsParcel = new DocumentsParcel(request.getGenericDocuments());
        try {
            this.mService.putDocuments(this.mCallerAttributionSource, this.mDatabaseName, documentsParcel, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchBatchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchBatchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.onResult(resultParcel.getResult()));
                }

                @Override
                public void onSystemError(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> SearchSessionUtil.sendSystemErrorToCallback(resultParcel.getResult(), callback));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getByDocumentId(GetByDocumentIdRequest request, Executor executor, BatchResultCallback<String, GenericDocument> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        String targetPackageName = Objects.requireNonNull(this.mCallerAttributionSource.getPackageName());
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getDocuments(this.mCallerAttributionSource, targetPackageName, this.mDatabaseName, request.getNamespace(), new ArrayList<String>(request.getIds()), request.getProjectionsInternal(), this.mUserHandle, SystemClock.elapsedRealtime(), SearchSessionUtil.createGetDocumentCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public SearchResults search(String queryExpression, SearchSpec searchSpec) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        return new SearchResults(this.mService, this.mCallerAttributionSource, this.mDatabaseName, queryExpression, searchSpec, this.mUserHandle);
    }

    public void searchSuggestion(String suggestionQueryExpression, SearchSuggestionSpec searchSuggestionSpec, final Executor executor, final Consumer<AppSearchResult<List<SearchSuggestionResult>>> callback) {
        Objects.requireNonNull(suggestionQueryExpression);
        Objects.requireNonNull(searchSuggestionSpec);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.searchSuggestion(this.mCallerAttributionSource, this.mDatabaseName, suggestionQueryExpression, searchSuggestionSpec.getBundle(), this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        try {
                            AppSearchResult result = resultParcel.getResult();
                            if (result.isSuccess()) {
                                List suggestionResultBundles = (List)result.getResultValue();
                                ArrayList<SearchSuggestionResult> searchSuggestionResults = new ArrayList<SearchSuggestionResult>(suggestionResultBundles.size());
                                for (int i = 0; i < suggestionResultBundles.size(); ++i) {
                                    SearchSuggestionResult searchSuggestionResult = new SearchSuggestionResult((Bundle)suggestionResultBundles.get(i));
                                    searchSuggestionResults.add(searchSuggestionResult);
                                }
                                callback.accept(AppSearchResult.newSuccessfulResult(searchSuggestionResults));
                            } else {
                                callback.accept(AppSearchResult.newFailedResult(result));
                            }
                        }
                        catch (Exception e) {
                            callback.accept(AppSearchResult.throwableToFailedResult(e));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportUsage(ReportUsageRequest request, final Executor executor, final Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        String targetPackageName = Objects.requireNonNull(this.mCallerAttributionSource.getPackageName());
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.reportUsage(this.mCallerAttributionSource, targetPackageName, this.mDatabaseName, request.getNamespace(), request.getDocumentId(), request.getUsageTimestampMillis(), false, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(resultParcel.getResult()));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void remove(RemoveByDocumentIdRequest request, final Executor executor, final BatchResultCallback<String, Void> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.removeByDocumentId(this.mCallerAttributionSource, this.mDatabaseName, request.getNamespace(), new ArrayList<String>(request.getIds()), this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchBatchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchBatchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.onResult(resultParcel.getResult()));
                }

                @Override
                public void onSystemError(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> SearchSessionUtil.sendSystemErrorToCallback(resultParcel.getResult(), callback));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void remove(String queryExpression, SearchSpec searchSpec, final Executor executor, final Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        if (searchSpec.getJoinSpec() != null) {
            throw new IllegalArgumentException("JoinSpec not allowed in removeByQuery, but JoinSpec was provided.");
        }
        try {
            this.mService.removeByQuery(this.mCallerAttributionSource, this.mDatabaseName, queryExpression, searchSpec.getBundle(), this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(resultParcel.getResult()));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getStorageInfo(final Executor executor, final Consumer<AppSearchResult<StorageInfo>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getStorageInfo(this.mCallerAttributionSource, this.mDatabaseName, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            StorageInfo response = new StorageInfo(Objects.requireNonNull((Bundle)result.getResultValue()));
                            callback.accept(AppSearchResult.newSuccessfulResult(response));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void close() {
        if (this.mIsMutated && !this.mIsClosed) {
            try {
                this.mService.persistToDisk(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime());
                this.mIsClosed = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to close the AppSearchSession", e);
            }
        }
    }

    private void setSchemaNoMigrations(SetSchemaRequest request, List<Bundle> schemaBundles, List<Bundle> visibilityBundles, final Executor executor, final Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        try {
            this.mService.setSchema(this.mCallerAttributionSource, this.mDatabaseName, schemaBundles, visibilityBundles, request.isForceOverride(), request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), 0, new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            try {
                                InternalSetSchemaResponse internalSetSchemaResponse = new InternalSetSchemaResponse((Bundle)result.getResultValue());
                                if (!internalSetSchemaResponse.isSuccess()) {
                                    callback.accept(AppSearchResult.newFailedResult(7, internalSetSchemaResponse.getErrorMessage()));
                                    return;
                                }
                                callback.accept(AppSearchResult.newSuccessfulResult(internalSetSchemaResponse.getSetSchemaResponse()));
                            }
                            catch (Throwable t) {
                                callback.accept(AppSearchResult.throwableToFailedResult(t));
                            }
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void setSchemaWithMigrations(SetSchemaRequest request, List<Bundle> schemaBundles, List<Bundle> visibilityBundles, Executor workExecutor, Executor callbackExecutor, Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        long totalLatencyStartTimeMillis = SystemClock.elapsedRealtime();
        long waitExecutorStartLatencyMillis = SystemClock.elapsedRealtime();
        SearchSessionUtil.safeExecute(workExecutor, callback, () -> {
            try {
                long waitExecutorEndLatencyMillis = SystemClock.elapsedRealtime();
                SchemaMigrationStats.Builder statsBuilder = new SchemaMigrationStats.Builder(this.mCallerAttributionSource.getPackageName(), this.mDatabaseName);
                long getSchemaLatencyStartTimeMillis = SystemClock.elapsedRealtime();
                CountDownLatch getSchemaLatch = new CountDownLatch(1);
                AtomicReference getSchemaResultRef = new AtomicReference();
                this.getSchema(callbackExecutor, result -> {
                    getSchemaResultRef.set(result);
                    getSchemaLatch.countDown();
                });
                getSchemaLatch.await();
                AppSearchResult getSchemaResult = (AppSearchResult)getSchemaResultRef.get();
                if (!getSchemaResult.isSuccess()) {
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(getSchemaResult)));
                    return;
                }
                GetSchemaResponse getSchemaResponse = Objects.requireNonNull((GetSchemaResponse)getSchemaResult.getResultValue());
                int currentVersion = getSchemaResponse.getVersion();
                int finalVersion = request.getVersion();
                Map<String, Migrator> activeMigrators = SchemaMigrationUtil.getActiveMigrators(getSchemaResponse.getSchemas(), request.getMigrators(), currentVersion, finalVersion);
                long getSchemaLatencyEndTimeMillis = SystemClock.elapsedRealtime();
                if (activeMigrators.isEmpty()) {
                    this.setSchemaNoMigrations(request, schemaBundles, visibilityBundles, callbackExecutor, callback);
                    return;
                }
                long firstSetSchemaLatencyStartMillis = SystemClock.elapsedRealtime();
                final CountDownLatch setSchemaLatch = new CountDownLatch(1);
                final AtomicReference setSchemaResultRef = new AtomicReference();
                this.mService.setSchema(this.mCallerAttributionSource, this.mDatabaseName, schemaBundles, visibilityBundles, false, request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), 1, new IAppSearchResultCallback.Stub(){

                    @Override
                    public void onResult(AppSearchResultParcel resultParcel) {
                        setSchemaResultRef.set(resultParcel.getResult());
                        setSchemaLatch.countDown();
                    }
                });
                setSchemaLatch.await();
                AppSearchResult setSchemaResult = (AppSearchResult)setSchemaResultRef.get();
                if (!setSchemaResult.isSuccess()) {
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(setSchemaResult)));
                    return;
                }
                InternalSetSchemaResponse internalSetSchemaResponse1 = new InternalSetSchemaResponse((Bundle)setSchemaResult.getResultValue());
                long firstSetSchemaLatencyEndTimeMillis = SystemClock.elapsedRealtime();
                SchemaMigrationUtil.checkDeletedAndIncompatibleAfterMigration(internalSetSchemaResponse1, activeMigrators.keySet());
                try (AppSearchMigrationHelper migrationHelper = new AppSearchMigrationHelper(this.mService, this.mUserHandle, this.mCallerAttributionSource, this.mDatabaseName, request.getSchemas());){
                    InternalSetSchemaResponse internalSetSchemaResponse;
                    long queryAndTransformLatencyStartTimeMillis = SystemClock.elapsedRealtime();
                    for (Map.Entry<String, Migrator> entry : activeMigrators.entrySet()) {
                        migrationHelper.queryAndTransform(entry.getKey(), entry.getValue(), currentVersion, finalVersion, statsBuilder);
                    }
                    long queryAndTransformLatencyEndTimeMillis = SystemClock.elapsedRealtime();
                    long secondSetSchemaLatencyStartMillis = SystemClock.elapsedRealtime();
                    if (internalSetSchemaResponse1.isSuccess()) {
                        internalSetSchemaResponse = internalSetSchemaResponse1;
                    } else {
                        final CountDownLatch setSchema2Latch = new CountDownLatch(1);
                        final AtomicReference setSchema2ResultRef = new AtomicReference();
                        this.mService.setSchema(this.mCallerAttributionSource, this.mDatabaseName, schemaBundles, visibilityBundles, true, request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), 2, new IAppSearchResultCallback.Stub(){

                            @Override
                            public void onResult(AppSearchResultParcel resultParcel) {
                                setSchema2ResultRef.set(resultParcel.getResult());
                                setSchema2Latch.countDown();
                            }
                        });
                        setSchema2Latch.await();
                        AppSearchResult setSchema2Result = (AppSearchResult)setSchema2ResultRef.get();
                        if (!setSchema2Result.isSuccess()) {
                            SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(setSchema2Result)));
                            return;
                        }
                        InternalSetSchemaResponse internalSetSchemaResponse2 = new InternalSetSchemaResponse((Bundle)setSchema2Result.getResultValue());
                        if (!internalSetSchemaResponse2.isSuccess()) {
                            SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(2, internalSetSchemaResponse2.getErrorMessage())));
                            return;
                        }
                        internalSetSchemaResponse = internalSetSchemaResponse2;
                    }
                    long secondSetSchemaLatencyEndTimeMillis = SystemClock.elapsedRealtime();
                    statsBuilder.setExecutorAcquisitionLatencyMillis((int)(waitExecutorEndLatencyMillis - waitExecutorStartLatencyMillis)).setGetSchemaLatencyMillis((int)(getSchemaLatencyEndTimeMillis - getSchemaLatencyStartTimeMillis)).setFirstSetSchemaLatencyMillis((int)(firstSetSchemaLatencyEndTimeMillis - firstSetSchemaLatencyStartMillis)).setIsFirstSetSchemaSuccess(internalSetSchemaResponse1.isSuccess()).setQueryAndTransformLatencyMillis((int)(queryAndTransformLatencyEndTimeMillis - queryAndTransformLatencyStartTimeMillis)).setSecondSetSchemaLatencyMillis((int)(secondSetSchemaLatencyEndTimeMillis - secondSetSchemaLatencyStartMillis));
                    SetSchemaResponse.Builder responseBuilder = internalSetSchemaResponse.getSetSchemaResponse().toBuilder().addMigratedTypes(activeMigrators.keySet());
                    AppSearchResult<SetSchemaResponse> putResult = migrationHelper.putMigratedDocuments(responseBuilder, statsBuilder, totalLatencyStartTimeMillis);
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(putResult));
                }
            }
            catch (Throwable t) {
                SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.throwableToFailedResult(t)));
            }
        });
    }
}

