/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.SuppressLint;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.PackageIdentifier;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.os.Bundle;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GetSchemaResponse {
    private static final String VERSION_FIELD = "version";
    private static final String SCHEMAS_FIELD = "schemas";
    private static final String SCHEMAS_NOT_DISPLAYED_BY_SYSTEM_FIELD = "schemasNotDisplayedBySystem";
    private static final String SCHEMAS_VISIBLE_TO_PACKAGES_FIELD = "schemasVisibleToPackages";
    private static final String SCHEMAS_VISIBLE_TO_PERMISSION_FIELD = "schemasVisibleToPermissions";
    private static final String ALL_REQUIRED_PERMISSION_FIELD = "allRequiredPermission";
    private Set<String> mSchemasNotDisplayedBySystem;
    private Map<String, Set<PackageIdentifier>> mSchemasVisibleToPackages;
    private Map<String, Set<Set<Integer>>> mSchemasVisibleToPermissions;
    private final Bundle mBundle;

    GetSchemaResponse(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public int getVersion() {
        return this.mBundle.getInt(VERSION_FIELD);
    }

    public Set<AppSearchSchema> getSchemas() {
        ArrayList schemaBundles = Objects.requireNonNull(this.mBundle.getParcelableArrayList(SCHEMAS_FIELD));
        ArraySet<AppSearchSchema> schemas = new ArraySet<AppSearchSchema>(schemaBundles.size());
        for (int i = 0; i < schemaBundles.size(); ++i) {
            schemas.add(new AppSearchSchema((Bundle)schemaBundles.get(i)));
        }
        return schemas;
    }

    public Set<String> getSchemaTypesNotDisplayedBySystem() {
        this.checkGetVisibilitySettingSupported();
        if (this.mSchemasNotDisplayedBySystem == null) {
            ArrayList<String> schemasNotDisplayedBySystemList = this.mBundle.getStringArrayList(SCHEMAS_NOT_DISPLAYED_BY_SYSTEM_FIELD);
            this.mSchemasNotDisplayedBySystem = Collections.unmodifiableSet(new ArraySet<String>(schemasNotDisplayedBySystemList));
        }
        return this.mSchemasNotDisplayedBySystem;
    }

    public Map<String, Set<PackageIdentifier>> getSchemaTypesVisibleToPackages() {
        this.checkGetVisibilitySettingSupported();
        if (this.mSchemasVisibleToPackages == null) {
            Bundle schemaVisibleToPackagesBundle = Objects.requireNonNull(this.mBundle.getBundle(SCHEMAS_VISIBLE_TO_PACKAGES_FIELD));
            ArrayMap copy = new ArrayMap();
            for (String key : schemaVisibleToPackagesBundle.keySet()) {
                List PackageIdentifierBundles = Objects.requireNonNull(schemaVisibleToPackagesBundle.getParcelableArrayList(key));
                ArraySet<PackageIdentifier> packageIdentifiers = new ArraySet<PackageIdentifier>(PackageIdentifierBundles.size());
                for (int i = 0; i < PackageIdentifierBundles.size(); ++i) {
                    packageIdentifiers.add(new PackageIdentifier((Bundle)PackageIdentifierBundles.get(i)));
                }
                copy.put(key, packageIdentifiers);
            }
            this.mSchemasVisibleToPackages = Collections.unmodifiableMap(copy);
        }
        return this.mSchemasVisibleToPackages;
    }

    public Map<String, Set<Set<Integer>>> getRequiredPermissionsForSchemaTypeVisibility() {
        this.checkGetVisibilitySettingSupported();
        if (this.mSchemasVisibleToPermissions == null) {
            ArrayMap copy = new ArrayMap();
            Bundle schemaVisibleToPermissionBundle = Objects.requireNonNull(this.mBundle.getBundle(SCHEMAS_VISIBLE_TO_PERMISSION_FIELD));
            for (String key : schemaVisibleToPermissionBundle.keySet()) {
                ArrayList allRequiredPermissionsBundle = schemaVisibleToPermissionBundle.getParcelableArrayList(key);
                ArraySet<ArraySet<Integer>> visibleToPermissions = new ArraySet<ArraySet<Integer>>();
                if (allRequiredPermissionsBundle != null) {
                    for (int i = 0; i < allRequiredPermissionsBundle.size(); ++i) {
                        visibleToPermissions.add(new ArraySet<Integer>(((Bundle)allRequiredPermissionsBundle.get(i)).getIntegerArrayList(ALL_REQUIRED_PERMISSION_FIELD)));
                    }
                }
                copy.put(key, visibleToPermissions);
            }
            this.mSchemasVisibleToPermissions = Collections.unmodifiableMap(copy);
        }
        return this.mSchemasVisibleToPermissions;
    }

    private void checkGetVisibilitySettingSupported() {
        if (!this.mBundle.containsKey(SCHEMAS_VISIBLE_TO_PACKAGES_FIELD)) {
            throw new UnsupportedOperationException("Get visibility setting is not supported with this backend/Android API level combination.");
        }
    }

    public static class Builder {
        private int mVersion = 0;
        private ArrayList<Bundle> mSchemaBundles = new ArrayList();
        private ArrayList<String> mSchemasNotDisplayedBySystem;
        private Bundle mSchemasVisibleToPackages;
        private Bundle mSchemasVisibleToPermissions;
        private boolean mBuilt = false;

        public Builder() {
            this(true);
        }

        public Builder(boolean getVisibilitySettingSupported) {
            if (getVisibilitySettingSupported) {
                this.mSchemasNotDisplayedBySystem = new ArrayList();
                this.mSchemasVisibleToPackages = new Bundle();
                this.mSchemasVisibleToPermissions = new Bundle();
            }
        }

        @CanIgnoreReturnValue
        public Builder setVersion(int version) {
            this.resetIfBuilt();
            this.mVersion = version;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSchema(AppSearchSchema schema) {
            Objects.requireNonNull(schema);
            this.resetIfBuilt();
            this.mSchemaBundles.add(schema.getBundle());
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addSchemaTypeNotDisplayedBySystem(String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            if (this.mSchemasNotDisplayedBySystem == null) {
                this.mSchemasNotDisplayedBySystem = new ArrayList();
            }
            this.mSchemasNotDisplayedBySystem.add(schemaType);
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSchemaTypeVisibleToPackages(String schemaType, Set<PackageIdentifier> packageIdentifiers) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(packageIdentifiers);
            this.resetIfBuilt();
            ArrayList<Bundle> bundles = new ArrayList<Bundle>(packageIdentifiers.size());
            for (PackageIdentifier packageIdentifier : packageIdentifiers) {
                bundles.add(packageIdentifier.getBundle());
            }
            this.mSchemasVisibleToPackages.putParcelableArrayList(schemaType, bundles);
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setRequiredPermissionsForSchemaTypeVisibility(String schemaType, Set<Set<Integer>> visibleToPermissions) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(visibleToPermissions);
            this.resetIfBuilt();
            ArrayList<Bundle> visibleToPermissionsBundle = new ArrayList<Bundle>();
            for (Set<Integer> allRequiredPermissions : visibleToPermissions) {
                for (int permission2 : allRequiredPermissions) {
                    Preconditions.checkArgumentInRange(permission2, 1, 6, "permission");
                }
                Bundle allRequiredPermissionsBundle = new Bundle();
                allRequiredPermissionsBundle.putIntegerArrayList(GetSchemaResponse.ALL_REQUIRED_PERMISSION_FIELD, new ArrayList<Integer>(allRequiredPermissions));
                visibleToPermissionsBundle.add(allRequiredPermissionsBundle);
            }
            this.mSchemasVisibleToPermissions.putParcelableArrayList(schemaType, visibleToPermissionsBundle);
            return this;
        }

        public GetSchemaResponse build() {
            Bundle bundle = new Bundle();
            bundle.putInt(GetSchemaResponse.VERSION_FIELD, this.mVersion);
            bundle.putParcelableArrayList(GetSchemaResponse.SCHEMAS_FIELD, this.mSchemaBundles);
            if (this.mSchemasNotDisplayedBySystem != null) {
                bundle.putStringArrayList(GetSchemaResponse.SCHEMAS_NOT_DISPLAYED_BY_SYSTEM_FIELD, this.mSchemasNotDisplayedBySystem);
                bundle.putBundle(GetSchemaResponse.SCHEMAS_VISIBLE_TO_PACKAGES_FIELD, this.mSchemasVisibleToPackages);
                bundle.putBundle(GetSchemaResponse.SCHEMAS_VISIBLE_TO_PERMISSION_FIELD, this.mSchemasVisibleToPermissions);
            }
            this.mBuilt = true;
            return new GetSchemaResponse(bundle);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mSchemaBundles = new ArrayList<Bundle>(this.mSchemaBundles);
                if (this.mSchemasNotDisplayedBySystem != null) {
                    this.mSchemasNotDisplayedBySystem = new ArrayList<String>(this.mSchemasNotDisplayedBySystem);
                    Bundle copyVisibleToPackages = new Bundle();
                    copyVisibleToPackages.putAll(this.mSchemasVisibleToPackages);
                    this.mSchemasVisibleToPackages = copyVisibleToPackages;
                    Bundle copyVisibleToPermissions = new Bundle();
                    copyVisibleToPermissions.putAll(this.mSchemasVisibleToPermissions);
                    this.mSchemasVisibleToPermissions = copyVisibleToPermissions;
                }
                this.mBuilt = false;
            }
        }
    }
}

