/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchResult;
import android.app.appsearch.BatchResultCallback;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.GetByDocumentIdRequest;
import android.app.appsearch.GetSchemaResponse;
import android.app.appsearch.ReportSystemUsageRequest;
import android.app.appsearch.SearchResults;
import android.app.appsearch.SearchSessionUtil;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.IAppSearchObserverProxy;
import android.app.appsearch.aidl.IAppSearchResultCallback;
import android.app.appsearch.exceptions.AppSearchException;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.observer.DocumentChangeInfo;
import android.app.appsearch.observer.ObserverCallback;
import android.app.appsearch.observer.ObserverSpec;
import android.app.appsearch.observer.SchemaChangeInfo;
import android.content.AttributionSource;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class GlobalSearchSession
implements Closeable {
    private static final String TAG = "AppSearchGlobalSearchSe";
    private final UserHandle mUserHandle;
    private final IAppSearchManager mService;
    private final AttributionSource mCallerAttributionSource;
    @GuardedBy(value={"mObserverCallbacksLocked"})
    private final Map<String, Map<ObserverCallback, IAppSearchObserverProxy>> mObserverCallbacksLocked = new ArrayMap<String, Map<ObserverCallback, IAppSearchObserverProxy>>();
    private boolean mIsMutated = false;
    private boolean mIsClosed = false;

    static void createGlobalSearchSession(IAppSearchManager service, UserHandle userHandle, AttributionSource attributionSource, Executor executor, Consumer<AppSearchResult<GlobalSearchSession>> callback) {
        GlobalSearchSession globalSearchSession = new GlobalSearchSession(service, userHandle, attributionSource);
        globalSearchSession.initialize(executor, callback);
    }

    private void initialize(final Executor executor, final Consumer<AppSearchResult<GlobalSearchSession>> callback) {
        try {
            this.mService.initialize(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            callback.accept(AppSearchResult.newSuccessfulResult(GlobalSearchSession.this));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private GlobalSearchSession(IAppSearchManager service, UserHandle userHandle, AttributionSource callerAttributionSource) {
        this.mService = service;
        this.mUserHandle = userHandle;
        this.mCallerAttributionSource = callerAttributionSource;
    }

    public void getByDocumentId(String packageName, String databaseName, GetByDocumentIdRequest request, Executor executor, BatchResultCallback<String, GenericDocument> callback) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(databaseName);
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        try {
            this.mService.getDocuments(this.mCallerAttributionSource, packageName, databaseName, request.getNamespace(), new ArrayList<String>(request.getIds()), request.getProjectionsInternal(), this.mUserHandle, SystemClock.elapsedRealtime(), SearchSessionUtil.createGetDocumentCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public SearchResults search(String queryExpression, SearchSpec searchSpec) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        return new SearchResults(this.mService, this.mCallerAttributionSource, null, queryExpression, searchSpec, this.mUserHandle);
    }

    public void reportSystemUsage(ReportSystemUsageRequest request, final Executor executor, final Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        try {
            this.mService.reportUsage(this.mCallerAttributionSource, request.getPackageName(), request.getDatabaseName(), request.getNamespace(), request.getDocumentId(), request.getUsageTimestampMillis(), true, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(resultParcel.getResult()));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getSchema(String packageName, String databaseName, final Executor executor, final Consumer<AppSearchResult<GetSchemaResponse>> callback) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(databaseName);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        try {
            this.mService.getSchema(this.mCallerAttributionSource, packageName, databaseName, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            GetSchemaResponse response = new GetSchemaResponse(Objects.requireNonNull((Bundle)result.getResultValue()));
                            callback.accept(AppSearchResult.newSuccessfulResult(response));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObserverCallback(String targetPackageName, ObserverSpec spec, final Executor executor, final ObserverCallback observer) throws AppSearchException {
        Objects.requireNonNull(targetPackageName);
        Objects.requireNonNull(spec);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(observer);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        Map<String, Map<ObserverCallback, IAppSearchObserverProxy>> map = this.mObserverCallbacksLocked;
        synchronized (map) {
            AppSearchResultParcel resultParcel;
            IAppSearchObserverProxy stub = null;
            Map<ObserverCallback, IAppSearchObserverProxy> observersForPackage = this.mObserverCallbacksLocked.get(targetPackageName);
            if (observersForPackage != null) {
                stub = observersForPackage.get(observer);
            }
            if (stub == null) {
                stub = new IAppSearchObserverProxy.Stub(){

                    @Override
                    public void onSchemaChanged(String packageName, String databaseName, List<String> changedSchemaNames) {
                        SearchSessionUtil.safeExecute(executor, this::suppressingErrorCallback, () -> {
                            SchemaChangeInfo changeInfo = new SchemaChangeInfo(packageName, databaseName, new ArraySet<String>(changedSchemaNames));
                            observer.onSchemaChanged(changeInfo);
                        });
                    }

                    @Override
                    public void onDocumentChanged(String packageName, String databaseName, String namespace, String schemaName, List<String> changedDocumentIds) {
                        SearchSessionUtil.safeExecute(executor, this::suppressingErrorCallback, () -> {
                            DocumentChangeInfo changeInfo = new DocumentChangeInfo(packageName, databaseName, namespace, schemaName, new ArraySet<String>(changedDocumentIds));
                            observer.onDocumentChanged(changeInfo);
                        });
                    }

                    private void suppressingErrorCallback(AppSearchResult<?> unused) {
                    }
                };
            }
            try {
                resultParcel = this.mService.registerObserverCallback(this.mCallerAttributionSource, targetPackageName, spec.getBundle(), this.mUserHandle, SystemClock.elapsedRealtime(), stub);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            AppSearchResult result = resultParcel.getResult();
            if (!result.isSuccess()) {
                throw new AppSearchException(result.getResultCode(), result.getErrorMessage());
            }
            if (observersForPackage == null) {
                observersForPackage = new ArrayMap<ObserverCallback, IAppSearchObserverProxy>();
                this.mObserverCallbacksLocked.put(targetPackageName, observersForPackage);
            }
            observersForPackage.put(observer, stub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObserverCallback(String targetPackageName, ObserverCallback observer) throws AppSearchException {
        Objects.requireNonNull(targetPackageName);
        Objects.requireNonNull(observer);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        Map<String, Map<ObserverCallback, IAppSearchObserverProxy>> map = this.mObserverCallbacksLocked;
        synchronized (map) {
            AppSearchResultParcel resultParcel;
            Map<ObserverCallback, IAppSearchObserverProxy> observersForPackage = this.mObserverCallbacksLocked.get(targetPackageName);
            if (observersForPackage == null) {
                return;
            }
            IAppSearchObserverProxy stub = observersForPackage.get(observer);
            if (stub == null) {
                return;
            }
            try {
                resultParcel = this.mService.unregisterObserverCallback(this.mCallerAttributionSource, targetPackageName, this.mUserHandle, SystemClock.elapsedRealtime(), stub);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            AppSearchResult result = resultParcel.getResult();
            if (!result.isSuccess()) {
                throw new AppSearchException(result.getResultCode(), result.getErrorMessage());
            }
            observersForPackage.remove(observer);
            if (observersForPackage.isEmpty()) {
                this.mObserverCallbacksLocked.remove(targetPackageName);
            }
        }
    }

    @Override
    public void close() {
        if (this.mIsMutated && !this.mIsClosed) {
            try {
                this.mService.persistToDisk(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime());
                this.mIsClosed = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to close the GlobalSearchSession", e);
            }
        }
    }
}

