/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.SetSchemaResponse;
import android.os.Bundle;
import java.util.Objects;

public class InternalSetSchemaResponse {
    private static final String IS_SUCCESS_FIELD = "isSuccess";
    private static final String SET_SCHEMA_RESPONSE_BUNDLE_FIELD = "setSchemaResponseBundle";
    private static final String ERROR_MESSAGE_FIELD = "errorMessage";
    private final Bundle mBundle;

    public InternalSetSchemaResponse(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
    }

    private InternalSetSchemaResponse(boolean isSuccess, SetSchemaResponse setSchemaResponse, String errorMessage) {
        Objects.requireNonNull(setSchemaResponse);
        this.mBundle = new Bundle();
        this.mBundle.putBoolean(IS_SUCCESS_FIELD, isSuccess);
        this.mBundle.putBundle(SET_SCHEMA_RESPONSE_BUNDLE_FIELD, setSchemaResponse.getBundle());
        this.mBundle.putString(ERROR_MESSAGE_FIELD, errorMessage);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public static InternalSetSchemaResponse newSuccessfulSetSchemaResponse(SetSchemaResponse setSchemaResponse) {
        return new InternalSetSchemaResponse(true, setSchemaResponse, null);
    }

    public static InternalSetSchemaResponse newFailedSetSchemaResponse(SetSchemaResponse setSchemaResponse, String errorMessage) {
        return new InternalSetSchemaResponse(false, setSchemaResponse, errorMessage);
    }

    public boolean isSuccess() {
        return this.mBundle.getBoolean(IS_SUCCESS_FIELD);
    }

    public SetSchemaResponse getSetSchemaResponse() {
        return new SetSchemaResponse(this.mBundle.getBundle(SET_SCHEMA_RESPONSE_BUNDLE_FIELD));
    }

    public String getErrorMessage() {
        return this.mBundle.getString(ERROR_MESSAGE_FIELD);
    }
}

