/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.SearchSpec;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.os.Bundle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class JoinSpec {
    static final String NESTED_QUERY = "nestedQuery";
    static final String NESTED_SEARCH_SPEC = "nestedSearchSpec";
    static final String CHILD_PROPERTY_EXPRESSION = "childPropertyExpression";
    static final String MAX_JOINED_RESULT_COUNT = "maxJoinedResultCount";
    static final String AGGREGATION_SCORING_STRATEGY = "aggregationScoringStrategy";
    private static final int DEFAULT_MAX_JOINED_RESULT_COUNT = 10;
    public static final String QUALIFIED_ID = "this.qualifiedId()";
    public static final int AGGREGATION_SCORING_OUTER_RESULT_RANKING_SIGNAL = 0;
    public static final int AGGREGATION_SCORING_RESULT_COUNT = 1;
    public static final int AGGREGATION_SCORING_MIN_RANKING_SIGNAL = 2;
    public static final int AGGREGATION_SCORING_AVG_RANKING_SIGNAL = 3;
    public static final int AGGREGATION_SCORING_MAX_RANKING_SIGNAL = 4;
    public static final int AGGREGATION_SCORING_SUM_RANKING_SIGNAL = 5;
    private final Bundle mBundle;

    public JoinSpec(Bundle bundle) {
        Objects.requireNonNull(bundle);
        this.mBundle = bundle;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public String getNestedQuery() {
        return this.mBundle.getString(NESTED_QUERY);
    }

    public String getChildPropertyExpression() {
        return this.mBundle.getString(CHILD_PROPERTY_EXPRESSION);
    }

    public int getMaxJoinedResultCount() {
        return this.mBundle.getInt(MAX_JOINED_RESULT_COUNT);
    }

    public SearchSpec getNestedSearchSpec() {
        return new SearchSpec(this.mBundle.getBundle(NESTED_SEARCH_SPEC));
    }

    public int getAggregationScoringStrategy() {
        return this.mBundle.getInt(AGGREGATION_SCORING_STRATEGY);
    }

    public static class Builder {
        private static final SearchSpec EMPTY_SEARCH_SPEC = new SearchSpec.Builder().build();
        private String mNestedQuery = "";
        private SearchSpec mNestedSearchSpec = EMPTY_SEARCH_SPEC;
        private final String mChildPropertyExpression;
        private int mMaxJoinedResultCount = 10;
        private int mAggregationScoringStrategy = 0;

        public Builder(String childPropertyExpression) {
            Objects.requireNonNull(childPropertyExpression);
            this.mChildPropertyExpression = childPropertyExpression;
        }

        @CanIgnoreReturnValue
        public Builder setNestedSearch(String nestedQuery, SearchSpec nestedSearchSpec) {
            Objects.requireNonNull(nestedQuery);
            Objects.requireNonNull(nestedSearchSpec);
            this.mNestedQuery = nestedQuery;
            this.mNestedSearchSpec = nestedSearchSpec;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxJoinedResultCount(int maxJoinedResultCount) {
            this.mMaxJoinedResultCount = maxJoinedResultCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAggregationScoringStrategy(int aggregationScoringStrategy) {
            Preconditions.checkArgumentInRange(aggregationScoringStrategy, 0, 5, JoinSpec.AGGREGATION_SCORING_STRATEGY);
            this.mAggregationScoringStrategy = aggregationScoringStrategy;
            return this;
        }

        public JoinSpec build() {
            Bundle bundle = new Bundle();
            bundle.putString(JoinSpec.NESTED_QUERY, this.mNestedQuery);
            bundle.putBundle(JoinSpec.NESTED_SEARCH_SPEC, this.mNestedSearchSpec.getBundle());
            bundle.putString(JoinSpec.CHILD_PROPERTY_EXPRESSION, this.mChildPropertyExpression);
            bundle.putInt(JoinSpec.MAX_JOINED_RESULT_COUNT, this.mMaxJoinedResultCount);
            bundle.putInt(JoinSpec.AGGREGATION_SCORING_STRATEGY, this.mAggregationScoringStrategy);
            return new JoinSpec(bundle);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AggregationScoringStrategy {
    }
}

