/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os._Original_Build;
import android.util.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ParcelableUtil {
    private static final String TAG = "AppSearchParcel";
    private static final String TEMP_FILE_PREFIX = "AppSearchSerializedBytes";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final int DOCUMENT_SIZE_LIMIT_IN_BYTES = 65536;

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static void writeBlob(Parcel parcel, byte[] bytes) {
        if (_Original_Build.VERSION.SDK_INT >= 33) {
            parcel.writeBlob(bytes);
        } else {
            ParcelableUtil.writeToParcelForSAndBelow(parcel, bytes);
        }
    }

    private static void writeToParcelForSAndBelow(Parcel parcel, byte[] bytes) {
        try {
            parcel.writeInt(bytes.length);
            if (bytes.length <= 65536) {
                parcel.writeByteArray(bytes);
            } else {
                ParcelFileDescriptor parcelFileDescriptor = ParcelableUtil.writeDataToTempFileAndUnlinkFile(bytes);
                parcel.writeFileDescriptor(parcelFileDescriptor.getFileDescriptor());
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Couldn't write to unlinked file.", e);
        }
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static byte[] readBlob(Parcel parcel) {
        if (_Original_Build.VERSION.SDK_INT >= 33) {
            return parcel.readBlob();
        }
        return ParcelableUtil.readFromParcelForSAndBelow(parcel);
    }

    private static byte[] readFromParcelForSAndBelow(Parcel parcel) {
        try {
            int length = parcel.readInt();
            if (length <= 65536) {
                byte[] documentByteArray = new byte[length];
                parcel.readByteArray(documentByteArray);
                return documentByteArray;
            }
            ParcelFileDescriptor pfd = parcel.readFileDescriptor();
            return ParcelableUtil.getDataFromFd(pfd, length);
        }
        catch (IOException e) {
            Log.w(TAG, "Couldn't read from unlinked file.", e);
            return null;
        }
    }

    private static byte[] getDataFromFd(ParcelFileDescriptor pfd, int length) throws IOException {
        try (DataInputStream in = new DataInputStream(new ParcelFileDescriptor.AutoCloseInputStream(pfd));){
            byte[] data = new byte[length];
            in.read(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    private static ParcelFileDescriptor writeDataToTempFileAndUnlinkFile(byte[] data) throws IOException {
        File unlinkedFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, null);
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(unlinkedFile));){
            out.write(data);
            out.flush();
        }
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open(unlinkedFile, 0x38000000);
        unlinkedFile.delete();
        return parcelFileDescriptor;
    }

    private ParcelableUtil() {
    }
}

