/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.SuppressLint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class PropertyPath
implements Iterable<PathSegment> {
    private final List<PathSegment> mPathList;

    public PropertyPath(List<PathSegment> pathList) {
        this.mPathList = new ArrayList<PathSegment>(pathList);
    }

    public PropertyPath(String path) {
        Objects.requireNonNull(path);
        this.mPathList = new ArrayList<PathSegment>();
        try {
            this.recursivePathScan(path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ": " + path);
        }
    }

    private void recursivePathScan(String path) throws IllegalArgumentException {
        String remainingPath;
        int controlPos = -1;
        boolean controlIsIndex = false;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ']') {
                throw new IllegalArgumentException("Malformed path (no starting '[')");
            }
            if (c != '[' && c != '.') continue;
            controlPos = i;
            controlIsIndex = c == '[';
            break;
        }
        if (controlPos == 0 || path.isEmpty()) {
            throw new IllegalArgumentException("Malformed path (blank property name)");
        }
        if (controlPos == -1) {
            this.mPathList.add(new PathSegment(path, -1));
            return;
        }
        if (!controlIsIndex) {
            String propertyName = path.substring(0, controlPos);
            remainingPath = path.substring(controlPos + 1);
            this.mPathList.add(new PathSegment(propertyName, -1));
        } else {
            remainingPath = this.consumePropertyWithIndex(path, controlPos);
            if (remainingPath == null) {
                return;
            }
        }
        this.recursivePathScan(remainingPath);
    }

    private String consumePropertyWithIndex(String path, int controlPos) {
        int index;
        Objects.requireNonNull(path);
        String propertyName = path.substring(0, controlPos);
        int endBracketIdx = path.indexOf(93, controlPos);
        if (endBracketIdx == -1) {
            throw new IllegalArgumentException("Malformed path (no ending ']')");
        }
        if (endBracketIdx + 1 < path.length() && path.charAt(endBracketIdx + 1) != '.') {
            throw new IllegalArgumentException("Malformed path (']' not followed by '.'): " + path);
        }
        String indexStr = path.substring(controlPos + 1, endBracketIdx);
        try {
            index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Malformed path (\"" + indexStr + "\" as path index)");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Malformed path (path index less than 0)");
        }
        this.mPathList.add(new PathSegment(propertyName, index));
        if (endBracketIdx + 1 < path.length()) {
            return path.substring(endBracketIdx + 2);
        }
        return null;
    }

    @SuppressLint(value={"KotlinOperator"})
    public PathSegment get(int index) {
        return this.mPathList.get(index);
    }

    public int size() {
        return this.mPathList.size();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.mPathList.size(); ++i) {
            result.append(this.get(i).toString());
            if (i >= this.mPathList.size() - 1) continue;
            result.append('.');
        }
        return result.toString();
    }

    @Override
    public Iterator<PathSegment> iterator() {
        return this.mPathList.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof PropertyPath)) {
            return false;
        }
        PropertyPath that = (PropertyPath)o;
        return Objects.equals(this.mPathList, that.mPathList);
    }

    public int hashCode() {
        return Objects.hash(this.mPathList);
    }

    public static class PathSegment {
        public static final int NON_REPEATED_CARDINALITY = -1;
        private final String mPropertyName;
        private final int mPropertyIndex;

        public static PathSegment create(String propertyName, int propertyIndex) {
            Objects.requireNonNull(propertyName);
            if (propertyName.isEmpty() || propertyName.contains("[") || propertyName.contains("]") || propertyName.contains(".")) {
                throw new IllegalArgumentException("Invalid propertyName value:" + propertyName);
            }
            if (propertyIndex < 0 && propertyIndex != -1) {
                throw new IllegalArgumentException("Invalid propertyIndex value:" + propertyIndex);
            }
            return new PathSegment(propertyName, propertyIndex);
        }

        public static PathSegment create(String propertyName) {
            return PathSegment.create(Objects.requireNonNull(propertyName), -1);
        }

        PathSegment(String propertyName, int propertyIndex) {
            this.mPropertyName = Objects.requireNonNull(propertyName);
            this.mPropertyIndex = propertyIndex;
        }

        public String getPropertyName() {
            return this.mPropertyName;
        }

        public int getPropertyIndex() {
            return this.mPropertyIndex;
        }

        public String toString() {
            if (this.mPropertyIndex != -1) {
                return this.mPropertyName + "[" + this.mPropertyIndex + "]";
            }
            return this.mPropertyName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof PathSegment)) {
                return false;
            }
            PathSegment that = (PathSegment)o;
            return this.mPropertyIndex == that.mPropertyIndex && this.mPropertyName.equals(that.mPropertyName);
        }

        public int hashCode() {
            return Objects.hash(this.mPropertyName, this.mPropertyIndex);
        }
    }
}

