/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.annotation.CanIgnoreReturnValue;
import com.android.internal.lang.System_Delegate;
import java.util.Objects;

public class ReportSystemUsageRequest {
    private final String mPackageName;
    private final String mDatabase;
    private final String mNamespace;
    private final String mDocumentId;
    private final long mUsageTimestampMillis;

    ReportSystemUsageRequest(String packageName, String database, String namespace, String documentId, long usageTimestampMillis) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mDatabase = Objects.requireNonNull(database);
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mDocumentId = Objects.requireNonNull(documentId);
        this.mUsageTimestampMillis = usageTimestampMillis;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getDatabaseName() {
        return this.mDatabase;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public String getDocumentId() {
        return this.mDocumentId;
    }

    public long getUsageTimestampMillis() {
        return this.mUsageTimestampMillis;
    }

    public static class Builder {
        private final String mPackageName;
        private final String mDatabase;
        private final String mNamespace;
        private final String mDocumentId;
        private Long mUsageTimestampMillis;

        public Builder(String packageName, String databaseName, String namespace, String documentId) {
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mDatabase = Objects.requireNonNull(databaseName);
            this.mNamespace = Objects.requireNonNull(namespace);
            this.mDocumentId = Objects.requireNonNull(documentId);
        }

        @CanIgnoreReturnValue
        public Builder setUsageTimestampMillis(long usageTimestampMillis) {
            this.mUsageTimestampMillis = usageTimestampMillis;
            return this;
        }

        public ReportSystemUsageRequest build() {
            if (this.mUsageTimestampMillis == null) {
                this.mUsageTimestampMillis = System_Delegate.currentTimeMillis();
            }
            return new ReportSystemUsageRequest(this.mPackageName, this.mDatabase, this.mNamespace, this.mDocumentId, this.mUsageTimestampMillis);
        }
    }
}

