/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import java.util.Objects;

public class SearchSuggestionResult {
    private static final String SUGGESTED_RESULT_FIELD = "suggestedResult";
    private final Bundle mBundle;
    private Integer mHashCode;

    SearchSuggestionResult(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public String getSuggestedResult() {
        return Objects.requireNonNull(this.mBundle.getString(SUGGESTED_RESULT_FIELD));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SearchSuggestionResult)) {
            return false;
        }
        SearchSuggestionResult otherResult = (SearchSuggestionResult)other;
        return BundleUtil.deepEquals(this.mBundle, otherResult.mBundle);
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            this.mHashCode = BundleUtil.deepHashCode(this.mBundle);
        }
        return this.mHashCode;
    }

    public static class Builder {
        private String mSuggestedResult = "";

        @CanIgnoreReturnValue
        public Builder setSuggestedResult(String suggestedResult) {
            Objects.requireNonNull(suggestedResult);
            Preconditions.checkStringNotEmpty(suggestedResult);
            this.mSuggestedResult = suggestedResult;
            return this;
        }

        public SearchSuggestionResult build() {
            Bundle bundle = new Bundle();
            bundle.putString(SearchSuggestionResult.SUGGESTED_RESULT_FIELD, this.mSuggestedResult);
            return new SearchSuggestionResult(bundle);
        }
    }
}

