/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.PropertyPath;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SearchSuggestionSpec {
    static final String NAMESPACE_FIELD = "namespace";
    static final String SCHEMA_FIELD = "schema";
    static final String PROPERTY_FIELD = "property";
    static final String DOCUMENT_IDS_FIELD = "documentIds";
    static final String MAXIMUM_RESULT_COUNT_FIELD = "maximumResultCount";
    static final String RANKING_STRATEGY_FIELD = "rankingStrategy";
    private final Bundle mBundle;
    private final int mMaximumResultCount;
    public static final int SUGGESTION_RANKING_STRATEGY_DOCUMENT_COUNT = 0;
    public static final int SUGGESTION_RANKING_STRATEGY_TERM_FREQUENCY = 1;
    public static final int SUGGESTION_RANKING_STRATEGY_NONE = 2;

    public SearchSuggestionSpec(Bundle bundle) {
        Objects.requireNonNull(bundle);
        this.mBundle = bundle;
        this.mMaximumResultCount = bundle.getInt(MAXIMUM_RESULT_COUNT_FIELD);
        Preconditions.checkArgument(this.mMaximumResultCount >= 1, "MaximumResultCount must be positive.");
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public int getMaximumResultCount() {
        return this.mMaximumResultCount;
    }

    public List<String> getFilterNamespaces() {
        ArrayList<String> namespaces = this.mBundle.getStringArrayList(NAMESPACE_FIELD);
        if (namespaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(namespaces);
    }

    public int getRankingStrategy() {
        return this.mBundle.getInt(RANKING_STRATEGY_FIELD);
    }

    public List<String> getFilterSchemas() {
        ArrayList<String> schemaTypes = this.mBundle.getStringArrayList(SCHEMA_FIELD);
        if (schemaTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(schemaTypes);
    }

    public Map<String, List<String>> getFilterProperties() {
        Bundle typePropertyPathsBundle = Objects.requireNonNull(this.mBundle.getBundle(PROPERTY_FIELD));
        Set<String> schemas = typePropertyPathsBundle.keySet();
        ArrayMap<String, List<String>> typePropertyPathsMap = new ArrayMap<String, List<String>>(schemas.size());
        for (String schema : schemas) {
            typePropertyPathsMap.put(schema, (List<String>)Objects.requireNonNull(typePropertyPathsBundle.getStringArrayList(schema)));
        }
        return typePropertyPathsMap;
    }

    public Map<String, List<String>> getFilterDocumentIds() {
        Bundle documentIdsBundle = Objects.requireNonNull(this.mBundle.getBundle(DOCUMENT_IDS_FIELD));
        Set<String> namespaces = documentIdsBundle.keySet();
        ArrayMap<String, List<String>> documentIdsMap = new ArrayMap<String, List<String>>(namespaces.size());
        for (String namespace : namespaces) {
            documentIdsMap.put(namespace, (List<String>)Objects.requireNonNull(documentIdsBundle.getStringArrayList(namespace)));
        }
        return documentIdsMap;
    }

    public static class Builder {
        private ArrayList<String> mNamespaces = new ArrayList();
        private ArrayList<String> mSchemas = new ArrayList();
        private Bundle mTypePropertyFilters = new Bundle();
        private Bundle mDocumentIds = new Bundle();
        private final int mTotalResultCount;
        private int mRankingStrategy = 0;
        private boolean mBuilt = false;

        public Builder(int maximumResultCount) {
            Preconditions.checkArgument(maximumResultCount >= 1, "maximumResultCount must be positive.");
            this.mTotalResultCount = maximumResultCount;
        }

        @CanIgnoreReturnValue
        public Builder addFilterNamespaces(String ... namespaces) {
            Objects.requireNonNull(namespaces);
            this.resetIfBuilt();
            return this.addFilterNamespaces(Arrays.asList(namespaces));
        }

        @CanIgnoreReturnValue
        public Builder addFilterNamespaces(Collection<String> namespaces) {
            Objects.requireNonNull(namespaces);
            this.resetIfBuilt();
            this.mNamespaces.addAll(namespaces);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRankingStrategy(int rankingStrategy) {
            Preconditions.checkArgumentInRange(rankingStrategy, 0, 2, "Suggestion ranking strategy");
            this.resetIfBuilt();
            this.mRankingStrategy = rankingStrategy;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFilterSchemas(String ... schemaTypes) {
            Objects.requireNonNull(schemaTypes);
            this.resetIfBuilt();
            return this.addFilterSchemas(Arrays.asList(schemaTypes));
        }

        @CanIgnoreReturnValue
        public Builder addFilterSchemas(Collection<String> schemaTypes) {
            Objects.requireNonNull(schemaTypes);
            this.resetIfBuilt();
            this.mSchemas.addAll(schemaTypes);
            return this;
        }

        public Builder addFilterProperties(String schema, Collection<String> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            this.resetIfBuilt();
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                Objects.requireNonNull(propertyPath);
                propertyPathsArrayList.add(propertyPath);
            }
            this.mTypePropertyFilters.putStringArrayList(schema, propertyPathsArrayList);
            return this;
        }

        public Builder addFilterPropertyPaths(String schema, Collection<PropertyPath> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (PropertyPath propertyPath : propertyPaths) {
                propertyPathsArrayList.add(propertyPath.toString());
            }
            return this.addFilterProperties(schema, propertyPathsArrayList);
        }

        @CanIgnoreReturnValue
        public Builder addFilterDocumentIds(String namespace, String ... documentIds) {
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(documentIds);
            this.resetIfBuilt();
            return this.addFilterDocumentIds(namespace, Arrays.asList(documentIds));
        }

        @CanIgnoreReturnValue
        public Builder addFilterDocumentIds(String namespace, Collection<String> documentIds) {
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(documentIds);
            this.resetIfBuilt();
            ArrayList<String> documentIdList = new ArrayList<String>(documentIds.size());
            for (String documentId : documentIds) {
                documentIdList.add(Objects.requireNonNull(documentId));
            }
            this.mDocumentIds.putStringArrayList(namespace, documentIdList);
            return this;
        }

        public SearchSuggestionSpec build() {
            Bundle bundle = new Bundle();
            if (!this.mSchemas.isEmpty()) {
                ArraySet<String> schemaFilter = new ArraySet<String>(this.mSchemas);
                for (String schema : this.mTypePropertyFilters.keySet()) {
                    if (schemaFilter.contains(schema)) continue;
                    throw new IllegalStateException("The schema: " + schema + " exists in the property filter but doesn't exist in the schema filter.");
                }
            }
            if (!this.mNamespaces.isEmpty()) {
                ArraySet<String> namespaceFilter = new ArraySet<String>(this.mNamespaces);
                for (String namespace : this.mDocumentIds.keySet()) {
                    if (namespaceFilter.contains(namespace)) continue;
                    throw new IllegalStateException("The namespace: " + namespace + " exists in the document id filter but doesn't exist in the namespace filter.");
                }
            }
            bundle.putStringArrayList(SearchSuggestionSpec.NAMESPACE_FIELD, this.mNamespaces);
            bundle.putStringArrayList(SearchSuggestionSpec.SCHEMA_FIELD, this.mSchemas);
            bundle.putBundle(SearchSuggestionSpec.PROPERTY_FIELD, this.mTypePropertyFilters);
            bundle.putBundle(SearchSuggestionSpec.DOCUMENT_IDS_FIELD, this.mDocumentIds);
            bundle.putInt(SearchSuggestionSpec.MAXIMUM_RESULT_COUNT_FIELD, this.mTotalResultCount);
            bundle.putInt(SearchSuggestionSpec.RANKING_STRATEGY_FIELD, this.mRankingStrategy);
            this.mBuilt = true;
            return new SearchSuggestionSpec(bundle);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mNamespaces = new ArrayList<String>(this.mNamespaces);
                this.mSchemas = new ArrayList<String>(this.mSchemas);
                this.mTypePropertyFilters = BundleUtil.deepCopy(this.mTypePropertyFilters);
                this.mDocumentIds = BundleUtil.deepCopy(this.mDocumentIds);
                this.mBuilt = false;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SuggestionRankingStrategy {
    }
}

