/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.observer;

import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.os.Bundle;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ObserverSpec {
    private static final String FILTER_SCHEMA_FIELD = "filterSchema";
    private final Bundle mBundle;
    private volatile Set<String> mFilterSchemas;

    public ObserverSpec(Bundle bundle) {
        Objects.requireNonNull(bundle);
        this.mBundle = bundle;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public Set<String> getFilterSchemas() {
        if (this.mFilterSchemas == null) {
            ArrayList<String> schemas = this.mBundle.getStringArrayList(FILTER_SCHEMA_FIELD);
            this.mFilterSchemas = schemas == null ? Collections.emptySet() : Collections.unmodifiableSet(new ArraySet<String>(schemas));
        }
        return this.mFilterSchemas;
    }

    public static class Builder {
        private ArrayList<String> mFilterSchemas = new ArrayList();
        private boolean mBuilt = false;

        @CanIgnoreReturnValue
        public Builder addFilterSchemas(String ... schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            return this.addFilterSchemas(Arrays.asList(schemas));
        }

        @CanIgnoreReturnValue
        public Builder addFilterSchemas(Collection<String> schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            this.mFilterSchemas.addAll(schemas);
            return this;
        }

        public ObserverSpec build() {
            Bundle bundle = new Bundle();
            bundle.putStringArrayList(ObserverSpec.FILTER_SCHEMA_FIELD, this.mFilterSchemas);
            this.mBuilt = true;
            return new ObserverSpec(bundle);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mFilterSchemas = new ArrayList<String>(this.mFilterSchemas);
                this.mBuilt = false;
            }
        }
    }
}

