/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.stats;

import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class SchemaMigrationStats {
    public static final int NO_MIGRATION = 0;
    public static final int FIRST_CALL_GET_INCOMPATIBLE = 1;
    public static final int SECOND_CALL_APPLY_NEW_SCHEMA = 2;
    private static final String PACKAGE_NAME_FIELD = "packageName";
    private static final String DATABASE_FIELD = "database";
    private static final String STATUS_CODE_FIELD = "StatusCode";
    private static final String EXECUTOR_ACQUISITION_MILLIS_FIELD = "ExecutorAcquisitionLatencyMillis";
    private static final String TOTAL_LATENCY_MILLIS_FIELD = "totalLatencyMillis";
    private static final String GET_SCHEMA_LATENCY_MILLIS_FIELD = "getSchemaLatencyMillis";
    private static final String QUERY_AND_TRANSFORM_LATENCY_MILLIS_FIELD = "queryAndTransformLatencyMillis";
    private static final String FIRST_SET_SCHEMA_LATENCY_MILLIS_FIELD = "firstSetSchemaLatencyMillis";
    private static final String IS_FIRST_SET_SCHEMA_SUCCESS_FIELD = "isFirstSetSchemaSuccess";
    private static final String SECOND_SET_SCHEMA_LATENCY_MILLIS_FIELD = "secondSetSchemaLatencyMillis";
    private static final String SAVE_DOCUMENT_LATENCY_MILLIS_FIELD = "saveDocumentLatencyMillis";
    private static final String TOTAL_NEED_MIGRATED_DOCUMENT_COUNT_FIELD = "totalNeedMigratedDocumentCount";
    private static final String MIGRATION_FAILURE_COUNT_FIELD = "migrationFailureCount";
    private static final String TOTAL_SUCCESS_MIGRATED_DOCUMENT_COUNT_FIELD = "totalSuccessMigratedDocumentCount";
    final Bundle mBundle;

    public SchemaMigrationStats(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public String getPackageName() {
        return this.mBundle.getString(PACKAGE_NAME_FIELD);
    }

    public String getDatabase() {
        return this.mBundle.getString(DATABASE_FIELD);
    }

    public int getStatusCode() {
        return this.mBundle.getInt(STATUS_CODE_FIELD);
    }

    public int getExecutorAcquisitionLatencyMillis() {
        return this.mBundle.getInt(EXECUTOR_ACQUISITION_MILLIS_FIELD);
    }

    public int getTotalLatencyMillis() {
        return this.mBundle.getInt(TOTAL_LATENCY_MILLIS_FIELD);
    }

    public int getGetSchemaLatencyMillis() {
        return this.mBundle.getInt(GET_SCHEMA_LATENCY_MILLIS_FIELD);
    }

    public int getQueryAndTransformLatencyMillis() {
        return this.mBundle.getInt(QUERY_AND_TRANSFORM_LATENCY_MILLIS_FIELD);
    }

    public int getFirstSetSchemaLatencyMillis() {
        return this.mBundle.getInt(FIRST_SET_SCHEMA_LATENCY_MILLIS_FIELD);
    }

    public boolean isFirstSetSchemaSuccess() {
        return this.mBundle.getBoolean(IS_FIRST_SET_SCHEMA_SUCCESS_FIELD);
    }

    public int getSecondSetSchemaLatencyMillis() {
        return this.mBundle.getInt(SECOND_SET_SCHEMA_LATENCY_MILLIS_FIELD);
    }

    public int getSaveDocumentLatencyMillis() {
        return this.mBundle.getInt(SAVE_DOCUMENT_LATENCY_MILLIS_FIELD);
    }

    public int getTotalNeedMigratedDocumentCount() {
        return this.mBundle.getInt(TOTAL_NEED_MIGRATED_DOCUMENT_COUNT_FIELD);
    }

    public int getMigrationFailureCount() {
        return this.mBundle.getInt(MIGRATION_FAILURE_COUNT_FIELD);
    }

    public int getTotalSuccessMigratedDocumentCount() {
        return this.mBundle.getInt(TOTAL_SUCCESS_MIGRATED_DOCUMENT_COUNT_FIELD);
    }

    public static class Builder {
        private final Bundle mBundle;

        public Builder(String packageName, String database) {
            this.mBundle = new Bundle();
            this.mBundle.putString(SchemaMigrationStats.PACKAGE_NAME_FIELD, packageName);
            this.mBundle.putString(SchemaMigrationStats.DATABASE_FIELD, database);
        }

        public Builder(SchemaMigrationStats stats) {
            this.mBundle = BundleUtil.deepCopy(stats.mBundle);
        }

        public Builder(Bundle bundle) {
            this.mBundle = Objects.requireNonNull(bundle);
        }

        @CanIgnoreReturnValue
        public Builder setStatusCode(int statusCode) {
            this.mBundle.putInt(SchemaMigrationStats.STATUS_CODE_FIELD, statusCode);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExecutorAcquisitionLatencyMillis(int executorAcquisitionLatencyMillis) {
            this.mBundle.putInt(SchemaMigrationStats.EXECUTOR_ACQUISITION_MILLIS_FIELD, executorAcquisitionLatencyMillis);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTotalLatencyMillis(int totalLatencyMillis) {
            this.mBundle.putInt(SchemaMigrationStats.TOTAL_LATENCY_MILLIS_FIELD, totalLatencyMillis);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setGetSchemaLatencyMillis(int getSchemaLatencyMillis) {
            this.mBundle.putInt(SchemaMigrationStats.GET_SCHEMA_LATENCY_MILLIS_FIELD, getSchemaLatencyMillis);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setQueryAndTransformLatencyMillis(int queryAndTransformLatencyMillis) {
            this.mBundle.putInt(SchemaMigrationStats.QUERY_AND_TRANSFORM_LATENCY_MILLIS_FIELD, queryAndTransformLatencyMillis);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFirstSetSchemaLatencyMillis(int firstSetSchemaLatencyMillis) {
            this.mBundle.putInt(SchemaMigrationStats.FIRST_SET_SCHEMA_LATENCY_MILLIS_FIELD, firstSetSchemaLatencyMillis);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsFirstSetSchemaSuccess(boolean isFirstSetSchemaSuccess) {
            this.mBundle.putBoolean(SchemaMigrationStats.IS_FIRST_SET_SCHEMA_SUCCESS_FIELD, isFirstSetSchemaSuccess);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSecondSetSchemaLatencyMillis(int secondSetSchemaLatencyMillis) {
            this.mBundle.putInt(SchemaMigrationStats.SECOND_SET_SCHEMA_LATENCY_MILLIS_FIELD, secondSetSchemaLatencyMillis);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSaveDocumentLatencyMillis(int saveDocumentLatencyMillis) {
            this.mBundle.putInt(SchemaMigrationStats.SAVE_DOCUMENT_LATENCY_MILLIS_FIELD, saveDocumentLatencyMillis);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTotalNeedMigratedDocumentCount(int migratedDocumentCount) {
            this.mBundle.putInt(SchemaMigrationStats.TOTAL_NEED_MIGRATED_DOCUMENT_COUNT_FIELD, migratedDocumentCount);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTotalSuccessMigratedDocumentCount(int totalSuccessMigratedDocumentCount) {
            this.mBundle.putInt(SchemaMigrationStats.TOTAL_SUCCESS_MIGRATED_DOCUMENT_COUNT_FIELD, totalSuccessMigratedDocumentCount);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMigrationFailureCount(int migrationFailureCount) {
            this.mBundle.putInt(SchemaMigrationStats.MIGRATION_FAILURE_COUNT_FIELD, migrationFailureCount);
            return this;
        }

        public SchemaMigrationStats build() {
            return new SchemaMigrationStats(this.mBundle);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SchemaMigrationCallType {
    }
}

