/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.util;

import android.app.appsearch.annotation.CanIgnoreReturnValue;

public class IndentingStringBuilder {
    private final StringBuilder mStringBuilder = new StringBuilder();
    private boolean mIndentNext = false;
    private int mIndentLevel = 0;

    @CanIgnoreReturnValue
    public IndentingStringBuilder increaseIndentLevel() {
        ++this.mIndentLevel;
        return this;
    }

    @CanIgnoreReturnValue
    public IndentingStringBuilder decreaseIndentLevel() throws IllegalStateException {
        if (this.mIndentLevel == 0) {
            throw new IllegalStateException("Cannot set indent level below 0.");
        }
        --this.mIndentLevel;
        return this;
    }

    @CanIgnoreReturnValue
    public IndentingStringBuilder append(String str) {
        this.applyIndentToString(str);
        return this;
    }

    @CanIgnoreReturnValue
    public IndentingStringBuilder append(Object obj) {
        this.applyIndentToString(obj.toString());
        return this;
    }

    public String toString() {
        return this.mStringBuilder.toString();
    }

    private void applyIndent() {
        for (int i = 0; i < this.mIndentLevel; ++i) {
            this.mStringBuilder.append("  ");
        }
    }

    private void applyIndentToString(String str) {
        int index = str.indexOf("\n");
        if (index == 0) {
            this.mStringBuilder.append("\n");
            this.mIndentNext = true;
            if (str.length() > 1) {
                this.applyIndentToString(str.substring(index + 1));
            }
        } else if (index >= 1) {
            String beforeIndentString = str.substring(0, index);
            this.applyIndentToString(beforeIndentString);
            this.mStringBuilder.append("\n");
            this.mIndentNext = true;
            if (str.length() > index + 1) {
                String afterIndentString = str.substring(index + 1);
                this.applyIndentToString(afterIndentString);
            }
        } else {
            if (this.mIndentNext) {
                this.applyIndent();
                this.mIndentNext = false;
            }
            this.mStringBuilder.append(str);
        }
    }
}

