/*
 * Decompiled with CFR 0.152.
 */
package android.app.assist;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PooledStringReader;
import android.os.PooledStringWriter;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewStructure;
import android.view.WindowManagerGlobal;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AssistStructure
implements Parcelable {
    private static final String TAG = "AssistStructure";
    private static final boolean DEBUG_PARCEL = false;
    private static final boolean DEBUG_PARCEL_CHILDREN = false;
    private static final boolean DEBUG_PARCEL_TREE = false;
    private static final int VALIDATE_WINDOW_TOKEN = 0x11111111;
    private static final int VALIDATE_VIEW_TOKEN = 0x22222222;
    private boolean mHaveData;
    private int mTaskId;
    private ComponentName mActivityComponent;
    private boolean mIsHomeActivity;
    private int mFlags;
    private int mAutofillFlags;
    private final ArrayList<WindowNode> mWindowNodes = new ArrayList();
    private final ArrayList<ViewNodeBuilder> mPendingAsyncChildren = new ArrayList();
    private SendChannel mSendChannel;
    private IBinder mReceiveChannel;
    private Rect mTmpRect = new Rect();
    private boolean mSanitizeOnWrite = false;
    private long mAcquisitionStartTime;
    private long mAcquisitionEndTime;
    private static final int TRANSACTION_XFER = 2;
    private static final String DESCRIPTOR = "android.app.AssistStructure";
    public static final Parcelable.Creator<AssistStructure> CREATOR = new Parcelable.Creator<AssistStructure>(){

        @Override
        public AssistStructure createFromParcel(Parcel in) {
            return new AssistStructure(in);
        }

        public AssistStructure[] newArray(int size) {
            return new AssistStructure[size];
        }
    };

    public void setAcquisitionStartTime(long acquisitionStartTime) {
        this.mAcquisitionStartTime = acquisitionStartTime;
    }

    public void setAcquisitionEndTime(long acquisitionEndTime) {
        this.mAcquisitionEndTime = acquisitionEndTime;
    }

    public void setHomeActivity(boolean isHomeActivity) {
        this.mIsHomeActivity = isHomeActivity;
    }

    public long getAcquisitionStartTime() {
        this.ensureData();
        return this.mAcquisitionStartTime;
    }

    public long getAcquisitionEndTime() {
        this.ensureData();
        return this.mAcquisitionEndTime;
    }

    public AssistStructure(Activity activity, boolean forAutoFill, int flags) {
        this.mHaveData = true;
        this.mFlags = flags;
        ArrayList<ViewRootImpl> views = WindowManagerGlobal.getInstance().getRootViews(activity.getActivityToken());
        for (int i = 0; i < views.size(); ++i) {
            ViewRootImpl root = views.get(i);
            if (root.getView() == null) {
                Log.w(TAG, "Skipping window with dettached view: " + root.getTitle());
                continue;
            }
            this.mWindowNodes.add(new WindowNode(this, root, forAutoFill, flags));
        }
    }

    public AssistStructure() {
        this.mHaveData = true;
        this.mFlags = 0;
    }

    public AssistStructure(Parcel in) {
        this.mTaskId = in.readInt();
        this.mActivityComponent = ComponentName.readFromParcel(in);
        this.mIsHomeActivity = in.readInt() == 1;
        this.mReceiveChannel = in.readStrongBinder();
    }

    public void sanitizeForParceling(boolean sanitize) {
        this.mSanitizeOnWrite = sanitize;
    }

    public void dump(boolean showSensitive) {
        if (this.mActivityComponent == null) {
            Log.i(TAG, "dump(): calling ensureData() first");
            this.ensureData();
        }
        Log.i(TAG, "Task id: " + this.mTaskId);
        Log.i(TAG, "Activity: " + (this.mActivityComponent != null ? this.mActivityComponent.flattenToShortString() : null));
        Log.i(TAG, "Sanitize on write: " + this.mSanitizeOnWrite);
        Log.i(TAG, "Flags: " + this.mFlags);
        int N = this.getWindowNodeCount();
        for (int i = 0; i < N; ++i) {
            WindowNode node = this.getWindowNodeAt(i);
            Log.i(TAG, "Window #" + i + " [" + node.getLeft() + "," + node.getTop() + " " + node.getWidth() + "x" + node.getHeight() + "] " + node.getTitle());
            this.dump("  ", node.getRootViewNode(), showSensitive);
        }
    }

    void dump(String prefix, ViewNode node, boolean showSensitive) {
        AutofillId autofillId;
        Bundle extras;
        String hint;
        Object[] mimeTypes;
        LocaleList localeList;
        ViewStructure.HtmlInfo htmlInfo;
        String webDomain;
        CharSequence text;
        CharSequence contentDescription;
        float alpha;
        float elevation;
        Matrix matrix;
        Log.i(TAG, prefix + "View [" + node.getLeft() + "," + node.getTop() + " " + node.getWidth() + "x" + node.getHeight() + "] " + node.getClassName());
        int id2 = node.getId();
        if (id2 != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            sb.append("  ID: #");
            sb.append(Integer.toHexString(id2));
            String entry = node.getIdEntry();
            if (entry != null) {
                String type = node.getIdType();
                String pkg = node.getIdPackage();
                sb.append(" ");
                sb.append(pkg);
                sb.append(":");
                sb.append(type);
                sb.append("/");
                sb.append(entry);
            }
            Log.i(TAG, sb.toString());
        }
        int scrollX = node.getScrollX();
        int scrollY = node.getScrollY();
        if (scrollX != 0 || scrollY != 0) {
            Log.i(TAG, prefix + "  Scroll: " + scrollX + "," + scrollY);
        }
        if ((matrix = node.getTransformation()) != null) {
            Log.i(TAG, prefix + "  Transformation: " + matrix);
        }
        if ((elevation = node.getElevation()) != 0.0f) {
            Log.i(TAG, prefix + "  Elevation: " + elevation);
        }
        if ((alpha = node.getAlpha()) != 0.0f) {
            Log.i(TAG, prefix + "  Alpha: " + elevation);
        }
        if ((contentDescription = node.getContentDescription()) != null) {
            Log.i(TAG, prefix + "  Content description: " + contentDescription);
        }
        if ((text = node.getText()) != null) {
            String safeText = node.isSanitized() || showSensitive ? text.toString() : "REDACTED[" + text.length() + " chars]";
            Log.i(TAG, prefix + "  Text (sel " + node.getTextSelectionStart() + "-" + node.getTextSelectionEnd() + "): " + safeText);
            Log.i(TAG, prefix + "  Text size: " + node.getTextSize() + " , style: #" + node.getTextStyle());
            Log.i(TAG, prefix + "  Text color fg: #" + Integer.toHexString(node.getTextColor()) + ", bg: #" + Integer.toHexString(node.getTextBackgroundColor()));
            Log.i(TAG, prefix + "  Input type: " + node.getInputType());
            Log.i(TAG, prefix + "  Resource id: " + node.getTextIdEntry());
        }
        if ((webDomain = node.getWebDomain()) != null) {
            Log.i(TAG, prefix + "  Web domain: " + webDomain);
        }
        if ((htmlInfo = node.getHtmlInfo()) != null) {
            Log.i(TAG, prefix + "  HtmlInfo: tag=" + htmlInfo.getTag() + ", attr=" + htmlInfo.getAttributes());
        }
        if ((localeList = node.getLocaleList()) != null) {
            Log.i(TAG, prefix + "  LocaleList: " + localeList);
        }
        if ((mimeTypes = node.getReceiveContentMimeTypes()) != null) {
            Log.i(TAG, prefix + "  MIME types: " + Arrays.toString(mimeTypes));
        }
        if ((hint = node.getHint()) != null) {
            Log.i(TAG, prefix + "  Hint: " + hint);
            Log.i(TAG, prefix + "  Resource id: " + node.getHintIdEntry());
        }
        if ((extras = node.getExtras()) != null) {
            Log.i(TAG, prefix + "  Extras: " + extras);
        }
        if (node.isAssistBlocked()) {
            Log.i(TAG, prefix + "  BLOCKED");
        }
        if ((autofillId = node.getAutofillId()) == null) {
            Log.i(TAG, prefix + " NO autofill ID");
        } else {
            Log.i(TAG, prefix + "  Autofill info: id= " + autofillId + ", type=" + node.getAutofillType() + ", options=" + Arrays.toString(node.getAutofillOptions()) + ", hints=" + Arrays.toString(node.getAutofillHints()) + ", value=" + node.getAutofillValue() + ", sanitized=" + node.isSanitized() + ", important=" + node.getImportantForAutofill());
        }
        int NCHILDREN = node.getChildCount();
        if (NCHILDREN > 0) {
            Log.i(TAG, prefix + "  Children:");
            String cprefix = prefix + "    ";
            for (int i = 0; i < NCHILDREN; ++i) {
                ViewNode cnode = node.getChildAt(i);
                this.dump(cprefix, cnode, showSensitive);
            }
        }
    }

    public void setTaskId(int taskId) {
        this.mTaskId = taskId;
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    public void setActivityComponent(ComponentName componentName) {
        this.mActivityComponent = componentName;
    }

    public ComponentName getActivityComponent() {
        return this.mActivityComponent;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean isHomeActivity() {
        return this.mIsHomeActivity;
    }

    public int getWindowNodeCount() {
        this.ensureData();
        return this.mWindowNodes.size();
    }

    public WindowNode getWindowNodeAt(int index) {
        this.ensureData();
        return this.mWindowNodes.get(index);
    }

    public void ensureDataForAutofill() {
        if (this.mHaveData) {
            return;
        }
        this.mHaveData = true;
        Binder.allowBlocking(this.mReceiveChannel);
        try {
            ParcelTransferReader reader = new ParcelTransferReader(this.mReceiveChannel);
            reader.go();
        }
        finally {
            Binder.defaultBlocking(this.mReceiveChannel);
        }
    }

    public void ensureData() {
        if (this.mHaveData) {
            return;
        }
        this.mHaveData = true;
        ParcelTransferReader reader = new ParcelTransferReader(this.mReceiveChannel);
        reader.go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForReady() {
        boolean skipStructure = false;
        AssistStructure assistStructure = this;
        synchronized (assistStructure) {
            long now;
            long endTime = SystemClock.uptimeMillis() + 5000L;
            while (this.mPendingAsyncChildren.size() > 0 && (now = SystemClock.uptimeMillis()) < endTime) {
                try {
                    this.wait(endTime - now);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.mPendingAsyncChildren.size() > 0) {
                Log.w(TAG, "Skipping assist structure, waiting too long for async children (have " + this.mPendingAsyncChildren.size() + " remaining");
                skipStructure = true;
            }
        }
        return !skipStructure;
    }

    public void clearSendChannel() {
        if (this.mSendChannel != null) {
            this.mSendChannel.mAssistStructure = null;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mTaskId);
        ComponentName.writeToParcel(this.mActivityComponent, out);
        out.writeInt(this.mIsHomeActivity ? 1 : 0);
        if (this.mHaveData) {
            if (this.mSendChannel == null) {
                this.mSendChannel = new SendChannel(this);
            }
            out.writeStrongBinder(this.mSendChannel);
        } else {
            out.writeStrongBinder(this.mReceiveChannel);
        }
    }

    public static class WindowNode {
        final int mX;
        final int mY;
        final int mWidth;
        final int mHeight;
        final CharSequence mTitle;
        final int mDisplayId;
        final ViewNode mRoot;

        WindowNode(AssistStructure assist, ViewRootImpl root, boolean forAutoFill, int flags) {
            int viewFlags;
            View view = root.getView();
            Rect rect = new Rect();
            view.getBoundsOnScreen(rect);
            this.mX = rect.left - view.getLeft();
            this.mY = rect.top - view.getTop();
            this.mWidth = rect.width();
            this.mHeight = rect.height();
            this.mTitle = root.getTitle();
            this.mDisplayId = root.getDisplayId();
            this.mRoot = new ViewNode();
            ViewNodeBuilder builder = new ViewNodeBuilder(assist, this.mRoot, false);
            if ((root.getWindowFlags() & 0x2000) != 0) {
                if (forAutoFill) {
                    viewFlags = this.resolveViewAutofillFlags(view.getContext(), flags);
                    view.onProvideAutofillStructure(builder, viewFlags);
                } else {
                    view.onProvideStructure(builder);
                    builder.setAssistBlocked(true);
                    return;
                }
            }
            if (forAutoFill) {
                viewFlags = this.resolveViewAutofillFlags(view.getContext(), flags);
                view.dispatchProvideAutofillStructure(builder, viewFlags);
            } else {
                view.dispatchProvideStructure(builder);
            }
        }

        WindowNode(ParcelTransferReader reader) {
            Parcel in = reader.readParcel(0x11111111, 0);
            ++reader.mNumReadWindows;
            this.mX = in.readInt();
            this.mY = in.readInt();
            this.mWidth = in.readInt();
            this.mHeight = in.readInt();
            this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mDisplayId = in.readInt();
            this.mRoot = new ViewNode(reader, 0);
        }

        int resolveViewAutofillFlags(Context context, int fillRequestFlags) {
            return (fillRequestFlags & 1) != 0 || context.isAutofillCompatibilityEnabled() || (fillRequestFlags & 0x200) != 0 ? 1 : 0;
        }

        void writeSelfToParcel(Parcel out, PooledStringWriter pwriter, float[] tmpMatrix) {
            out.writeInt(this.mX);
            out.writeInt(this.mY);
            out.writeInt(this.mWidth);
            out.writeInt(this.mHeight);
            TextUtils.writeToParcel(this.mTitle, out, 0);
            out.writeInt(this.mDisplayId);
        }

        public int getLeft() {
            return this.mX;
        }

        public int getTop() {
            return this.mY;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public CharSequence getTitle() {
            return this.mTitle;
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        public ViewNode getRootViewNode() {
            return this.mRoot;
        }
    }

    public static class ViewNode {
        public static final int TEXT_COLOR_UNDEFINED = 1;
        public static final int TEXT_STYLE_BOLD = 1;
        public static final int TEXT_STYLE_ITALIC = 2;
        public static final int TEXT_STYLE_UNDERLINE = 4;
        public static final int TEXT_STYLE_STRIKE_THRU = 8;
        int mId = -1;
        String mIdPackage;
        String mIdType;
        String mIdEntry;
        AutofillId mAutofillId;
        int mAutofillType = 0;
        String[] mAutofillHints;
        AutofillValue mAutofillValue;
        CharSequence[] mAutofillOptions;
        boolean mSanitized;
        ViewStructure.HtmlInfo mHtmlInfo;
        int mMinEms = -1;
        int mMaxEms = -1;
        int mMaxLength = -1;
        String mTextIdEntry;
        String mHintIdEntry;
        int mImportantForAutofill;
        AutofillOverlay mAutofillOverlay;
        int mX;
        int mY;
        int mScrollX;
        int mScrollY;
        int mWidth;
        int mHeight;
        Matrix mMatrix;
        float mElevation;
        float mAlpha = 1.0f;
        static final int FLAGS_DISABLED = 1;
        static final int FLAGS_VISIBILITY_MASK = 12;
        static final int FLAGS_FOCUSABLE = 16;
        static final int FLAGS_FOCUSED = 32;
        static final int FLAGS_SELECTED = 64;
        static final int FLAGS_ASSIST_BLOCKED = 128;
        static final int FLAGS_CHECKABLE = 256;
        static final int FLAGS_CHECKED = 512;
        static final int FLAGS_CLICKABLE = 1024;
        static final int FLAGS_LONG_CLICKABLE = 2048;
        static final int FLAGS_ACCESSIBILITY_FOCUSED = 4096;
        static final int FLAGS_ACTIVATED = 8192;
        static final int FLAGS_CONTEXT_CLICKABLE = 16384;
        static final int FLAGS_OPAQUE = 32768;
        static final int FLAGS_ALL_CONTROL = -65536;
        static final int FLAGS_HAS_MIME_TYPES = Integer.MIN_VALUE;
        static final int FLAGS_HAS_MATRIX = 0x40000000;
        static final int FLAGS_HAS_ALPHA = 0x20000000;
        static final int FLAGS_HAS_ELEVATION = 0x10000000;
        static final int FLAGS_HAS_SCROLL = 0x8000000;
        static final int FLAGS_HAS_LARGE_COORDS = 0x4000000;
        static final int FLAGS_HAS_CONTENT_DESCRIPTION = 0x2000000;
        static final int FLAGS_HAS_TEXT = 0x1000000;
        static final int FLAGS_HAS_COMPLEX_TEXT = 0x800000;
        static final int FLAGS_HAS_EXTRAS = 0x400000;
        static final int FLAGS_HAS_ID = 0x200000;
        static final int FLAGS_HAS_CHILDREN = 0x100000;
        static final int FLAGS_HAS_URL_DOMAIN = 524288;
        static final int FLAGS_HAS_INPUT_TYPE = 262144;
        static final int FLAGS_HAS_URL_SCHEME = 131072;
        static final int FLAGS_HAS_LOCALE_LIST = 65536;
        static final int AUTOFILL_FLAGS_HAS_AUTOFILL_VIEW_ID = 1;
        static final int AUTOFILL_FLAGS_HAS_AUTOFILL_VIRTUAL_VIEW_ID = 2;
        static final int AUTOFILL_FLAGS_HAS_AUTOFILL_VALUE = 4;
        static final int AUTOFILL_FLAGS_HAS_AUTOFILL_TYPE = 8;
        static final int AUTOFILL_FLAGS_HAS_AUTOFILL_HINTS = 16;
        static final int AUTOFILL_FLAGS_HAS_AUTOFILL_OPTIONS = 32;
        static final int AUTOFILL_FLAGS_HAS_HTML_INFO = 64;
        static final int AUTOFILL_FLAGS_HAS_TEXT_ID_ENTRY = 128;
        static final int AUTOFILL_FLAGS_HAS_MIN_TEXT_EMS = 256;
        static final int AUTOFILL_FLAGS_HAS_MAX_TEXT_EMS = 512;
        static final int AUTOFILL_FLAGS_HAS_MAX_TEXT_LENGTH = 1024;
        static final int AUTOFILL_FLAGS_HAS_AUTOFILL_SESSION_ID = 2048;
        static final int AUTOFILL_FLAGS_HAS_HINT_ID_ENTRY = 4096;
        int mFlags;
        int mAutofillFlags;
        String mClassName;
        CharSequence mContentDescription;
        ViewNodeText mText;
        int mInputType;
        String mWebScheme;
        String mWebDomain;
        Bundle mExtras;
        LocaleList mLocaleList;
        String[] mReceiveContentMimeTypes;
        ViewNode[] mChildren;

        @SystemApi
        public ViewNode() {
        }

        ViewNode(Parcel in) {
            this.initializeFromParcelWithoutChildren(in, null, null);
        }

        ViewNode(ParcelTransferReader reader, int nestingLevel) {
            Parcel in = reader.readParcel(0x22222222, nestingLevel);
            ++reader.mNumReadViews;
            this.initializeFromParcelWithoutChildren(in, Objects.requireNonNull(reader.mStringReader), Objects.requireNonNull(reader.mTmpMatrix));
            if ((this.mFlags & 0x100000) != 0) {
                int numChildren = in.readInt();
                this.mChildren = new ViewNode[numChildren];
                for (int i = 0; i < numChildren; ++i) {
                    this.mChildren[i] = new ViewNode(reader, nestingLevel + 1);
                }
            }
        }

        private static void writeString(Parcel out, PooledStringWriter pwriter, String str) {
            if (pwriter != null) {
                pwriter.writeString(str);
            } else {
                out.writeString(str);
            }
        }

        private static String readString(Parcel in, PooledStringReader preader) {
            if (preader != null) {
                return preader.readString();
            }
            return in.readString();
        }

        void initializeFromParcelWithoutChildren(Parcel in, PooledStringReader preader, float[] tmpMatrix) {
            this.mClassName = ViewNode.readString(in, preader);
            int flags = this.mFlags = in.readInt();
            int autofillFlags = this.mAutofillFlags = in.readInt();
            if ((flags & 0x200000) != 0) {
                this.mId = in.readInt();
                if (this.mId != -1) {
                    this.mIdEntry = ViewNode.readString(in, preader);
                    if (this.mIdEntry != null) {
                        this.mIdType = ViewNode.readString(in, preader);
                        this.mIdPackage = ViewNode.readString(in, preader);
                    }
                }
            }
            if (autofillFlags != 0) {
                this.mSanitized = in.readInt() == 1;
                this.mImportantForAutofill = in.readInt();
                if ((autofillFlags & 1) != 0) {
                    int autofillViewId = in.readInt();
                    this.mAutofillId = (autofillFlags & 2) != 0 ? new AutofillId(autofillViewId, in.readInt()) : new AutofillId(autofillViewId);
                    if ((autofillFlags & 0x800) != 0) {
                        this.mAutofillId.setSessionId(in.readInt());
                    }
                }
                if ((autofillFlags & 8) != 0) {
                    this.mAutofillType = in.readInt();
                }
                if ((autofillFlags & 0x10) != 0) {
                    this.mAutofillHints = in.readStringArray();
                }
                if ((autofillFlags & 4) != 0) {
                    this.mAutofillValue = in.readParcelable(null, AutofillValue.class);
                }
                if ((autofillFlags & 0x20) != 0) {
                    this.mAutofillOptions = in.readCharSequenceArray();
                }
                if ((autofillFlags & 0x40) != 0) {
                    this.mHtmlInfo = in.readParcelable(null, ViewStructure.HtmlInfo.class);
                }
                if ((autofillFlags & 0x100) != 0) {
                    this.mMinEms = in.readInt();
                }
                if ((autofillFlags & 0x200) != 0) {
                    this.mMaxEms = in.readInt();
                }
                if ((autofillFlags & 0x400) != 0) {
                    this.mMaxLength = in.readInt();
                }
                if ((autofillFlags & 0x80) != 0) {
                    this.mTextIdEntry = ViewNode.readString(in, preader);
                }
                if ((autofillFlags & 0x1000) != 0) {
                    this.mHintIdEntry = ViewNode.readString(in, preader);
                }
            }
            if ((flags & 0x4000000) != 0) {
                this.mX = in.readInt();
                this.mY = in.readInt();
                this.mWidth = in.readInt();
                this.mHeight = in.readInt();
            } else {
                int val = in.readInt();
                this.mX = val & Short.MAX_VALUE;
                this.mY = val >> 16 & Short.MAX_VALUE;
                val = in.readInt();
                this.mWidth = val & Short.MAX_VALUE;
                this.mHeight = val >> 16 & Short.MAX_VALUE;
            }
            if ((flags & 0x8000000) != 0) {
                this.mScrollX = in.readInt();
                this.mScrollY = in.readInt();
            }
            if ((flags & 0x40000000) != 0) {
                this.mMatrix = new Matrix();
                if (tmpMatrix == null) {
                    tmpMatrix = new float[9];
                }
                in.readFloatArray(tmpMatrix);
                this.mMatrix.setValues(tmpMatrix);
            }
            if ((flags & 0x10000000) != 0) {
                this.mElevation = in.readFloat();
            }
            if ((flags & 0x20000000) != 0) {
                this.mAlpha = in.readFloat();
            }
            if ((flags & 0x2000000) != 0) {
                this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
            if ((flags & 0x1000000) != 0) {
                this.mText = new ViewNodeText(in, (flags & 0x800000) == 0);
            }
            if ((flags & 0x40000) != 0) {
                this.mInputType = in.readInt();
            }
            if ((flags & 0x20000) != 0) {
                this.mWebScheme = in.readString();
            }
            if ((flags & 0x80000) != 0) {
                this.mWebDomain = in.readString();
            }
            if ((flags & 0x10000) != 0) {
                this.mLocaleList = in.readParcelable(null, LocaleList.class);
            }
            if ((flags & Integer.MIN_VALUE) != 0) {
                this.mReceiveContentMimeTypes = in.readStringArray();
            }
            if ((flags & 0x400000) != 0) {
                this.mExtras = in.readBundle();
            }
        }

        int writeSelfToParcel(Parcel out, PooledStringWriter pwriter, boolean sanitizeOnWrite, float[] tmpMatrix, boolean willWriteChildren) {
            boolean writeSensitive = true;
            int flags = this.mFlags & 0xFFFF;
            int autofillFlags = 0;
            if (this.mId != -1) {
                flags |= 0x200000;
            }
            if ((this.mX & Short.MIN_VALUE) != 0 || (this.mY & Short.MIN_VALUE) != 0 || (this.mWidth & Short.MIN_VALUE) != 0 | (this.mHeight & Short.MIN_VALUE) != 0) {
                flags |= 0x4000000;
            }
            if (this.mScrollX != 0 || this.mScrollY != 0) {
                flags |= 0x8000000;
            }
            if (this.mMatrix != null) {
                flags |= 0x40000000;
            }
            if (this.mElevation != 0.0f) {
                flags |= 0x10000000;
            }
            if (this.mAlpha != 1.0f) {
                flags |= 0x20000000;
            }
            if (this.mContentDescription != null) {
                flags |= 0x2000000;
            }
            if (this.mText != null) {
                flags |= 0x1000000;
                if (!this.mText.isSimple()) {
                    flags |= 0x800000;
                }
            }
            if (this.mInputType != 0) {
                flags |= 0x40000;
            }
            if (this.mWebScheme != null) {
                flags |= 0x20000;
            }
            if (this.mWebDomain != null) {
                flags |= 0x80000;
            }
            if (this.mLocaleList != null) {
                flags |= 0x10000;
            }
            if (this.mReceiveContentMimeTypes != null) {
                flags |= Integer.MIN_VALUE;
            }
            if (this.mExtras != null) {
                flags |= 0x400000;
            }
            if (this.mChildren != null && willWriteChildren) {
                flags |= 0x100000;
            }
            if (this.mAutofillId != null) {
                autofillFlags |= 1;
                if (this.mAutofillId.isVirtualInt()) {
                    autofillFlags |= 2;
                }
                if (this.mAutofillId.hasSession()) {
                    autofillFlags |= 0x800;
                }
            }
            if (this.mAutofillValue != null) {
                autofillFlags |= 4;
            }
            if (this.mAutofillType != 0) {
                autofillFlags |= 8;
            }
            if (this.mAutofillHints != null) {
                autofillFlags |= 0x10;
            }
            if (this.mAutofillOptions != null) {
                autofillFlags |= 0x20;
            }
            if (this.mHtmlInfo instanceof Parcelable) {
                autofillFlags |= 0x40;
            }
            if (this.mMinEms > -1) {
                autofillFlags |= 0x100;
            }
            if (this.mMaxEms > -1) {
                autofillFlags |= 0x200;
            }
            if (this.mMaxLength > -1) {
                autofillFlags |= 0x400;
            }
            if (this.mTextIdEntry != null) {
                autofillFlags |= 0x80;
            }
            if (this.mHintIdEntry != null) {
                autofillFlags |= 0x1000;
            }
            ViewNode.writeString(out, pwriter, this.mClassName);
            int writtenFlags = flags;
            if (autofillFlags != 0 && (this.mSanitized || !sanitizeOnWrite)) {
                writtenFlags = flags & 0xFFFFFDFF;
            }
            if (this.mAutofillOverlay != null) {
                writtenFlags = this.mAutofillOverlay.focused ? (writtenFlags |= 0x20) : (writtenFlags &= 0xFFFFFFDF);
            }
            out.writeInt(writtenFlags);
            out.writeInt(autofillFlags);
            if ((flags & 0x200000) != 0) {
                out.writeInt(this.mId);
                if (this.mId != -1) {
                    ViewNode.writeString(out, pwriter, this.mIdEntry);
                    if (this.mIdEntry != null) {
                        ViewNode.writeString(out, pwriter, this.mIdType);
                        ViewNode.writeString(out, pwriter, this.mIdPackage);
                    }
                }
            }
            if (autofillFlags != 0) {
                out.writeInt(this.mSanitized ? 1 : 0);
                out.writeInt(this.mImportantForAutofill);
                boolean bl = writeSensitive = this.mSanitized || !sanitizeOnWrite;
                if ((autofillFlags & 1) != 0) {
                    out.writeInt(this.mAutofillId.getViewId());
                    if ((autofillFlags & 2) != 0) {
                        out.writeInt(this.mAutofillId.getVirtualChildIntId());
                    }
                    if ((autofillFlags & 0x800) != 0) {
                        out.writeInt(this.mAutofillId.getSessionId());
                    }
                }
                if ((autofillFlags & 8) != 0) {
                    out.writeInt(this.mAutofillType);
                }
                if ((autofillFlags & 0x10) != 0) {
                    out.writeStringArray(this.mAutofillHints);
                }
                if ((autofillFlags & 4) != 0) {
                    AutofillValue sanitizedValue = writeSensitive ? this.mAutofillValue : (this.mAutofillOverlay != null && this.mAutofillOverlay.value != null ? this.mAutofillOverlay.value : null);
                    out.writeParcelable(sanitizedValue, 0);
                }
                if ((autofillFlags & 0x20) != 0) {
                    out.writeCharSequenceArray(this.mAutofillOptions);
                }
                if ((autofillFlags & 0x40) != 0) {
                    out.writeParcelable((Parcelable)((Object)this.mHtmlInfo), 0);
                }
                if ((autofillFlags & 0x100) != 0) {
                    out.writeInt(this.mMinEms);
                }
                if ((autofillFlags & 0x200) != 0) {
                    out.writeInt(this.mMaxEms);
                }
                if ((autofillFlags & 0x400) != 0) {
                    out.writeInt(this.mMaxLength);
                }
                if ((autofillFlags & 0x80) != 0) {
                    ViewNode.writeString(out, pwriter, this.mTextIdEntry);
                }
                if ((autofillFlags & 0x1000) != 0) {
                    ViewNode.writeString(out, pwriter, this.mHintIdEntry);
                }
            }
            if ((flags & 0x4000000) != 0) {
                out.writeInt(this.mX);
                out.writeInt(this.mY);
                out.writeInt(this.mWidth);
                out.writeInt(this.mHeight);
            } else {
                out.writeInt(this.mY << 16 | this.mX);
                out.writeInt(this.mHeight << 16 | this.mWidth);
            }
            if ((flags & 0x8000000) != 0) {
                out.writeInt(this.mScrollX);
                out.writeInt(this.mScrollY);
            }
            if ((flags & 0x40000000) != 0) {
                if (tmpMatrix == null) {
                    tmpMatrix = new float[9];
                }
                this.mMatrix.getValues(tmpMatrix);
                out.writeFloatArray(tmpMatrix);
            }
            if ((flags & 0x10000000) != 0) {
                out.writeFloat(this.mElevation);
            }
            if ((flags & 0x20000000) != 0) {
                out.writeFloat(this.mAlpha);
            }
            if ((flags & 0x2000000) != 0) {
                TextUtils.writeToParcel(this.mContentDescription, out, 0);
            }
            if ((flags & 0x1000000) != 0) {
                this.mText.writeToParcel(out, (flags & 0x800000) == 0, writeSensitive);
            }
            if ((flags & 0x40000) != 0) {
                out.writeInt(this.mInputType);
            }
            if ((flags & 0x20000) != 0) {
                out.writeString(this.mWebScheme);
            }
            if ((flags & 0x80000) != 0) {
                out.writeString(this.mWebDomain);
            }
            if ((flags & 0x10000) != 0) {
                out.writeParcelable(this.mLocaleList, 0);
            }
            if ((flags & Integer.MIN_VALUE) != 0) {
                out.writeStringArray(this.mReceiveContentMimeTypes);
            }
            if ((flags & 0x400000) != 0) {
                out.writeBundle(this.mExtras);
            }
            return flags;
        }

        public int getId() {
            return this.mId;
        }

        public String getIdPackage() {
            return this.mIdPackage;
        }

        public String getIdType() {
            return this.mIdType;
        }

        public String getIdEntry() {
            return this.mIdEntry;
        }

        public AutofillId getAutofillId() {
            return this.mAutofillId;
        }

        public int getAutofillType() {
            return this.mAutofillType;
        }

        public String[] getAutofillHints() {
            return this.mAutofillHints;
        }

        public AutofillValue getAutofillValue() {
            return this.mAutofillValue;
        }

        public void setAutofillOverlay(AutofillOverlay overlay) {
            this.mAutofillOverlay = overlay;
        }

        public CharSequence[] getAutofillOptions() {
            return this.mAutofillOptions;
        }

        public int getInputType() {
            return this.mInputType;
        }

        public boolean isSanitized() {
            return this.mSanitized;
        }

        public void updateAutofillValue(AutofillValue value) {
            this.mAutofillValue = value;
            if (value.isText()) {
                if (this.mText == null) {
                    this.mText = new ViewNodeText();
                }
                this.mText.mText = value.getTextValue();
            }
        }

        public int getLeft() {
            return this.mX;
        }

        public int getTop() {
            return this.mY;
        }

        public int getScrollX() {
            return this.mScrollX;
        }

        public int getScrollY() {
            return this.mScrollY;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public Matrix getTransformation() {
            return this.mMatrix;
        }

        public float getElevation() {
            return this.mElevation;
        }

        public float getAlpha() {
            return this.mAlpha;
        }

        public int getVisibility() {
            return this.mFlags & 0xC;
        }

        public boolean isAssistBlocked() {
            return (this.mFlags & 0x80) != 0;
        }

        public boolean isEnabled() {
            return (this.mFlags & 1) == 0;
        }

        public boolean isClickable() {
            return (this.mFlags & 0x400) != 0;
        }

        public boolean isFocusable() {
            return (this.mFlags & 0x10) != 0;
        }

        public boolean isFocused() {
            return (this.mFlags & 0x20) != 0;
        }

        public boolean isAccessibilityFocused() {
            return (this.mFlags & 0x1000) != 0;
        }

        public boolean isCheckable() {
            return (this.mFlags & 0x100) != 0;
        }

        public boolean isChecked() {
            return (this.mFlags & 0x200) != 0;
        }

        public boolean isSelected() {
            return (this.mFlags & 0x40) != 0;
        }

        public boolean isActivated() {
            return (this.mFlags & 0x2000) != 0;
        }

        public boolean isOpaque() {
            return (this.mFlags & 0x8000) != 0;
        }

        public boolean isLongClickable() {
            return (this.mFlags & 0x800) != 0;
        }

        public boolean isContextClickable() {
            return (this.mFlags & 0x4000) != 0;
        }

        public String getClassName() {
            return this.mClassName;
        }

        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }

        public String getWebDomain() {
            return this.mWebDomain;
        }

        public void setWebDomain(String domain) {
            if (domain == null) {
                return;
            }
            Uri uri = Uri.parse(domain);
            if (uri == null) {
                Log.w(AssistStructure.TAG, "Failed to parse web domain");
                return;
            }
            this.mWebScheme = uri.getScheme();
            if (this.mWebScheme == null) {
                uri = Uri.parse("http://" + domain);
            }
            this.mWebDomain = uri.getHost();
        }

        public String getWebScheme() {
            return this.mWebScheme;
        }

        public ViewStructure.HtmlInfo getHtmlInfo() {
            return this.mHtmlInfo;
        }

        public LocaleList getLocaleList() {
            return this.mLocaleList;
        }

        @SuppressLint(value={"NullableCollection"})
        public String[] getReceiveContentMimeTypes() {
            return this.mReceiveContentMimeTypes;
        }

        public CharSequence getText() {
            return this.mText != null ? this.mText.mText : null;
        }

        public int getTextSelectionStart() {
            return this.mText != null ? this.mText.mTextSelectionStart : -1;
        }

        public int getTextSelectionEnd() {
            return this.mText != null ? this.mText.mTextSelectionEnd : -1;
        }

        public int getTextColor() {
            return this.mText != null ? this.mText.mTextColor : 1;
        }

        public int getTextBackgroundColor() {
            return this.mText != null ? this.mText.mTextBackgroundColor : 1;
        }

        public float getTextSize() {
            return this.mText != null ? this.mText.mTextSize : 0.0f;
        }

        public int getTextStyle() {
            return this.mText != null ? this.mText.mTextStyle : 0;
        }

        public int[] getTextLineCharOffsets() {
            return this.mText != null ? this.mText.mLineCharOffsets : null;
        }

        public int[] getTextLineBaselines() {
            return this.mText != null ? this.mText.mLineBaselines : null;
        }

        public String getTextIdEntry() {
            return this.mTextIdEntry;
        }

        public String getHint() {
            return this.mText != null ? this.mText.mHint : null;
        }

        public String getHintIdEntry() {
            return this.mHintIdEntry;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public int getChildCount() {
            return this.mChildren != null ? this.mChildren.length : 0;
        }

        public ViewNode getChildAt(int index) {
            return this.mChildren[index];
        }

        public int getMinTextEms() {
            return this.mMinEms;
        }

        public int getMaxTextEms() {
            return this.mMaxEms;
        }

        public int getMaxTextLength() {
            return this.mMaxLength;
        }

        public int getImportantForAutofill() {
            return this.mImportantForAutofill;
        }
    }

    class ParcelTransferReader {
        final float[] mTmpMatrix = new float[9];
        PooledStringReader mStringReader;
        int mNumReadWindows;
        int mNumReadViews;
        private final IBinder mChannel;
        private IBinder mTransferToken;
        private Parcel mCurParcel;

        ParcelTransferReader(IBinder channel) {
            this.mChannel = channel;
        }

        void go() {
            this.fetchData();
            AssistStructure.this.mFlags = this.mCurParcel.readInt();
            AssistStructure.this.mAutofillFlags = this.mCurParcel.readInt();
            AssistStructure.this.mAcquisitionStartTime = this.mCurParcel.readLong();
            AssistStructure.this.mAcquisitionEndTime = this.mCurParcel.readLong();
            int N = this.mCurParcel.readInt();
            if (N > 0) {
                this.mStringReader = new PooledStringReader(this.mCurParcel);
                for (int i = 0; i < N; ++i) {
                    AssistStructure.this.mWindowNodes.add(new WindowNode(this));
                }
            }
            this.mCurParcel.recycle();
            this.mCurParcel = null;
        }

        Parcel readParcel(int validateToken, int level) {
            int token = this.mCurParcel.readInt();
            if (token != 0) {
                if (token != validateToken) {
                    throw new BadParcelableException("Got token " + Integer.toHexString(token) + ", expected token " + Integer.toHexString(validateToken));
                }
                return this.mCurParcel;
            }
            this.mTransferToken = this.mCurParcel.readStrongBinder();
            if (this.mTransferToken == null) {
                throw new IllegalStateException("Reached end of partial data without transfer token");
            }
            this.fetchData();
            this.mStringReader = new PooledStringReader(this.mCurParcel);
            this.mCurParcel.readInt();
            return this.mCurParcel;
        }

        private void fetchData() {
            Parcel data = Parcel.obtain();
            try {
                data.writeInterfaceToken(AssistStructure.DESCRIPTOR);
                data.writeStrongBinder(this.mTransferToken);
                if (this.mCurParcel != null) {
                    this.mCurParcel.recycle();
                }
                this.mCurParcel = Parcel.obtain();
                try {
                    this.mChannel.transact(2, data, this.mCurParcel, 0);
                }
                catch (RemoteException e) {
                    Log.w(AssistStructure.TAG, "Failure reading AssistStructure data", e);
                    throw new IllegalStateException("Failure reading AssistStructure data: " + e);
                }
            }
            finally {
                data.recycle();
            }
            this.mNumReadViews = 0;
            this.mNumReadWindows = 0;
        }
    }

    static class SendChannel
    extends Binder {
        volatile AssistStructure mAssistStructure;

        SendChannel(AssistStructure as) {
            this.mAssistStructure = as;
        }

        @Override
        protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            if (code == 2) {
                AssistStructure as = this.mAssistStructure;
                if (as == null) {
                    return true;
                }
                data.enforceInterface(AssistStructure.DESCRIPTOR);
                IBinder token = data.readStrongBinder();
                if (token != null) {
                    if (token instanceof ParcelTransferWriter) {
                        ParcelTransferWriter xfer = (ParcelTransferWriter)token;
                        xfer.writeToParcel(as, reply);
                        return true;
                    }
                    Log.w(AssistStructure.TAG, "Caller supplied bad token type: " + token);
                    return true;
                }
                ParcelTransferWriter xfer = new ParcelTransferWriter(as, reply);
                xfer.writeToParcel(as, reply);
                return true;
            }
            return super.onTransact(code, data, reply, flags);
        }
    }

    private static class HtmlInfoNodeBuilder
    extends ViewStructure.HtmlInfo.Builder {
        private final String mTag;
        private ArrayList<String> mNames;
        private ArrayList<String> mValues;

        HtmlInfoNodeBuilder(String tag) {
            this.mTag = tag;
        }

        @Override
        public ViewStructure.HtmlInfo.Builder addAttribute(String name, String value) {
            if (this.mNames == null) {
                this.mNames = new ArrayList();
                this.mValues = new ArrayList();
            }
            this.mNames.add(name);
            this.mValues.add(value);
            return this;
        }

        @Override
        public HtmlInfoNode build() {
            return new HtmlInfoNode(this);
        }
    }

    private static class HtmlInfoNode
    extends ViewStructure.HtmlInfo
    implements Parcelable {
        private final String mTag;
        private final String[] mNames;
        private final String[] mValues;
        private ArrayList<Pair<String, String>> mAttributes;
        public static final Parcelable.Creator<HtmlInfoNode> CREATOR = new Parcelable.Creator<HtmlInfoNode>(){

            @Override
            public HtmlInfoNode createFromParcel(Parcel parcel) {
                String tag = parcel.readString();
                HtmlInfoNodeBuilder builder = new HtmlInfoNodeBuilder(tag);
                String[] names = parcel.readStringArray();
                String[] values = parcel.readStringArray();
                if (names != null && values != null) {
                    if (names.length != values.length) {
                        Log.w(AssistStructure.TAG, "HtmlInfo attributes mismatch: names=" + names.length + ", values=" + values.length);
                    } else {
                        for (int i = 0; i < names.length; ++i) {
                            builder.addAttribute(names[i], values[i]);
                        }
                    }
                }
                return builder.build();
            }

            public HtmlInfoNode[] newArray(int size) {
                return new HtmlInfoNode[size];
            }
        };

        private HtmlInfoNode(HtmlInfoNodeBuilder builder) {
            this.mTag = builder.mTag;
            if (builder.mNames == null) {
                this.mNames = null;
                this.mValues = null;
            } else {
                this.mNames = new String[builder.mNames.size()];
                this.mValues = new String[builder.mValues.size()];
                builder.mNames.toArray(this.mNames);
                builder.mValues.toArray(this.mValues);
            }
        }

        @Override
        public String getTag() {
            return this.mTag;
        }

        @Override
        public List<Pair<String, String>> getAttributes() {
            if (this.mAttributes == null && this.mNames != null) {
                this.mAttributes = new ArrayList(this.mNames.length);
                for (int i = 0; i < this.mNames.length; ++i) {
                    Pair<String, String> pair = new Pair<String, String>(this.mNames[i], this.mValues[i]);
                    this.mAttributes.add(i, pair);
                }
            }
            return this.mAttributes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeString(this.mTag);
            parcel.writeStringArray(this.mNames);
            parcel.writeStringArray(this.mValues);
        }
    }

    public static class ViewNodeBuilder
    extends ViewStructure {
        final AssistStructure mAssist;
        final ViewNode mNode;
        final boolean mAsync;

        public ViewNodeBuilder() {
            this.mAssist = new AssistStructure();
            this.mNode = new ViewNode();
            this.mAsync = false;
        }

        ViewNodeBuilder(AssistStructure assist, ViewNode node, boolean async) {
            this.mAssist = assist;
            this.mNode = node;
            this.mAsync = async;
        }

        public ViewNode getViewNode() {
            return this.mNode;
        }

        @Override
        public void setId(int id2, String packageName, String typeName, String entryName) {
            this.mNode.mId = id2;
            this.mNode.mIdPackage = packageName;
            this.mNode.mIdType = typeName;
            this.mNode.mIdEntry = entryName;
        }

        @Override
        public void setDimens(int left, int top, int scrollX, int scrollY, int width, int height) {
            this.mNode.mX = left;
            this.mNode.mY = top;
            this.mNode.mScrollX = scrollX;
            this.mNode.mScrollY = scrollY;
            this.mNode.mWidth = width;
            this.mNode.mHeight = height;
        }

        @Override
        public void setTransformation(Matrix matrix) {
            this.mNode.mMatrix = matrix == null ? null : new Matrix(matrix);
        }

        @Override
        public void setElevation(float elevation) {
            this.mNode.mElevation = elevation;
        }

        @Override
        public void setAlpha(float alpha) {
            this.mNode.mAlpha = alpha;
        }

        @Override
        public void setVisibility(int visibility) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFF3 | visibility & 0xC;
        }

        @Override
        public void setAssistBlocked(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFF7F | (state ? 128 : 0);
        }

        @Override
        public void setEnabled(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFE | (state ? 0 : 1);
        }

        @Override
        public void setClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFBFF | (state ? 1024 : 0);
        }

        @Override
        public void setLongClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFF7FF | (state ? 2048 : 0);
        }

        @Override
        public void setContextClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFBFFF | (state ? 16384 : 0);
        }

        @Override
        public void setFocusable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFEF | (state ? 16 : 0);
        }

        @Override
        public void setFocused(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFDF | (state ? 32 : 0);
        }

        @Override
        public void setAccessibilityFocused(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFEFFF | (state ? 4096 : 0);
        }

        @Override
        public void setCheckable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFEFF | (state ? 256 : 0);
        }

        @Override
        public void setChecked(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFDFF | (state ? 512 : 0);
        }

        @Override
        public void setSelected(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFBF | (state ? 64 : 0);
        }

        @Override
        public void setActivated(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFDFFF | (state ? 8192 : 0);
        }

        @Override
        public void setOpaque(boolean opaque) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFF7FFF | (opaque ? 32768 : 0);
        }

        @Override
        public void setClassName(String className) {
            this.mNode.mClassName = className;
        }

        @Override
        public void setContentDescription(CharSequence contentDescription) {
            this.mNode.mContentDescription = contentDescription;
        }

        private ViewNodeText getNodeText() {
            if (this.mNode.mText != null) {
                return this.mNode.mText;
            }
            this.mNode.mText = new ViewNodeText();
            return this.mNode.mText;
        }

        @Override
        public void setText(CharSequence text) {
            ViewNodeText t = this.getNodeText();
            t.mText = TextUtils.trimNoCopySpans(text);
            t.mTextSelectionEnd = -1;
            t.mTextSelectionStart = -1;
        }

        @Override
        public void setText(CharSequence text, int selectionStart, int selectionEnd) {
            ViewNodeText t = this.getNodeText();
            t.mText = TextUtils.trimNoCopySpans(text);
            t.mTextSelectionStart = selectionStart;
            t.mTextSelectionEnd = selectionEnd;
        }

        @Override
        public void setTextStyle(float size, int fgColor, int bgColor, int style2) {
            ViewNodeText t = this.getNodeText();
            t.mTextColor = fgColor;
            t.mTextBackgroundColor = bgColor;
            t.mTextSize = size;
            t.mTextStyle = style2;
        }

        @Override
        public void setTextLines(int[] charOffsets, int[] baselines) {
            ViewNodeText t = this.getNodeText();
            t.mLineCharOffsets = charOffsets;
            t.mLineBaselines = baselines;
        }

        @Override
        public void setTextIdEntry(String entryName) {
            this.mNode.mTextIdEntry = Objects.requireNonNull(entryName);
        }

        @Override
        public void setHint(CharSequence hint) {
            this.getNodeText().mHint = hint != null ? hint.toString() : null;
        }

        @Override
        public void setHintIdEntry(String entryName) {
            this.mNode.mHintIdEntry = Objects.requireNonNull(entryName);
        }

        @Override
        public CharSequence getText() {
            return this.mNode.mText != null ? this.mNode.mText.mText : null;
        }

        @Override
        public int getTextSelectionStart() {
            return this.mNode.mText != null ? this.mNode.mText.mTextSelectionStart : -1;
        }

        @Override
        public int getTextSelectionEnd() {
            return this.mNode.mText != null ? this.mNode.mText.mTextSelectionEnd : -1;
        }

        @Override
        public CharSequence getHint() {
            return this.mNode.mText != null ? this.mNode.mText.mHint : null;
        }

        @Override
        public Bundle getExtras() {
            if (this.mNode.mExtras != null) {
                return this.mNode.mExtras;
            }
            this.mNode.mExtras = new Bundle();
            return this.mNode.mExtras;
        }

        @Override
        public boolean hasExtras() {
            return this.mNode.mExtras != null;
        }

        @Override
        public void setChildCount(int num) {
            this.mNode.mChildren = new ViewNode[num];
        }

        @Override
        public int addChildCount(int num) {
            if (this.mNode.mChildren == null) {
                this.setChildCount(num);
                return 0;
            }
            int start = this.mNode.mChildren.length;
            ViewNode[] newArray = new ViewNode[start + num];
            System.arraycopy(this.mNode.mChildren, 0, newArray, 0, start);
            this.mNode.mChildren = newArray;
            return start;
        }

        @Override
        public int getChildCount() {
            return this.mNode.mChildren != null ? this.mNode.mChildren.length : 0;
        }

        @Override
        public ViewStructure newChild(int index) {
            ViewNode node;
            this.mNode.mChildren[index] = node = new ViewNode();
            return new ViewNodeBuilder(this.mAssist, node, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ViewStructure asyncNewChild(int index) {
            AssistStructure assistStructure = this.mAssist;
            synchronized (assistStructure) {
                ViewNode node;
                this.mNode.mChildren[index] = node = new ViewNode();
                ViewNodeBuilder builder = new ViewNodeBuilder(this.mAssist, node, true);
                this.mAssist.mPendingAsyncChildren.add(builder);
                return builder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncCommit() {
            AssistStructure assistStructure = this.mAssist;
            synchronized (assistStructure) {
                if (!this.mAsync) {
                    throw new IllegalStateException("Child " + this + " was not created with ViewStructure.asyncNewChild");
                }
                if (!this.mAssist.mPendingAsyncChildren.remove(this)) {
                    throw new IllegalStateException("Child " + this + " already committed");
                }
                this.mAssist.notifyAll();
            }
        }

        @Override
        public Rect getTempRect() {
            return this.mAssist.mTmpRect;
        }

        @Override
        public void setAutofillId(AutofillId id2) {
            this.mNode.mAutofillId = id2;
        }

        @Override
        public void setAutofillId(AutofillId parentId, int virtualId) {
            this.mNode.mAutofillId = new AutofillId(parentId, virtualId);
        }

        @Override
        public AutofillId getAutofillId() {
            return this.mNode.mAutofillId;
        }

        @Override
        public void setAutofillType(int type) {
            this.mNode.mAutofillType = type;
        }

        @Override
        public void setAutofillHints(String[] hints) {
            this.mNode.mAutofillHints = hints;
        }

        @Override
        public void setAutofillValue(AutofillValue value) {
            this.mNode.mAutofillValue = value;
        }

        @Override
        public void setAutofillOptions(CharSequence[] options) {
            this.mNode.mAutofillOptions = options;
        }

        @Override
        public void setImportantForAutofill(int mode) {
            this.mNode.mImportantForAutofill = mode;
        }

        @Override
        public void setReceiveContentMimeTypes(String[] mimeTypes) {
            this.mNode.mReceiveContentMimeTypes = mimeTypes;
        }

        @Override
        public void setInputType(int inputType) {
            this.mNode.mInputType = inputType;
        }

        @Override
        public void setMinTextEms(int minEms) {
            this.mNode.mMinEms = minEms;
        }

        @Override
        public void setMaxTextEms(int maxEms) {
            this.mNode.mMaxEms = maxEms;
        }

        @Override
        public void setMaxTextLength(int maxLength) {
            this.mNode.mMaxLength = maxLength;
        }

        @Override
        public void setDataIsSensitive(boolean sensitive) {
            this.mNode.mSanitized = !sensitive;
        }

        @Override
        public void setWebDomain(String domain) {
            this.mNode.setWebDomain(domain);
        }

        @Override
        public void setLocaleList(LocaleList localeList) {
            this.mNode.mLocaleList = localeList;
        }

        @Override
        public ViewStructure.HtmlInfo.Builder newHtmlInfoBuilder(String tagName) {
            return new HtmlInfoNodeBuilder(tagName);
        }

        @Override
        public void setHtmlInfo(ViewStructure.HtmlInfo htmlInfo) {
            this.mNode.mHtmlInfo = htmlInfo;
        }
    }

    public static class AutofillOverlay {
        public boolean focused;
        public AutofillValue value;
    }

    public static class ViewNodeParcelable
    implements Parcelable {
        private final ViewNode mViewNode;
        public static final Parcelable.Creator<ViewNodeParcelable> CREATOR = new Parcelable.Creator<ViewNodeParcelable>(){

            @Override
            public ViewNodeParcelable createFromParcel(Parcel in) {
                return new ViewNodeParcelable(in);
            }

            public ViewNodeParcelable[] newArray(int size) {
                return new ViewNodeParcelable[size];
            }
        };

        public ViewNodeParcelable(ViewNode viewNode) {
            this.mViewNode = viewNode;
        }

        public ViewNodeParcelable(Parcel in) {
            this.mViewNode = new ViewNode(in);
        }

        public ViewNode getViewNode() {
            return this.mViewNode;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            this.mViewNode.writeSelfToParcel(parcel, null, false, null, false);
        }
    }

    static class ViewNodeText {
        CharSequence mText;
        float mTextSize;
        int mTextStyle;
        int mTextColor = 1;
        int mTextBackgroundColor = 1;
        int mTextSelectionStart;
        int mTextSelectionEnd;
        int[] mLineCharOffsets;
        int[] mLineBaselines;
        String mHint;

        ViewNodeText() {
        }

        boolean isSimple() {
            return this.mTextBackgroundColor == 1 && this.mTextSelectionStart == 0 && this.mTextSelectionEnd == 0 && this.mLineCharOffsets == null && this.mLineBaselines == null && this.mHint == null;
        }

        ViewNodeText(Parcel in, boolean simple) {
            this.mText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mTextSize = in.readFloat();
            this.mTextStyle = in.readInt();
            this.mTextColor = in.readInt();
            if (!simple) {
                this.mTextBackgroundColor = in.readInt();
                this.mTextSelectionStart = in.readInt();
                this.mTextSelectionEnd = in.readInt();
                this.mLineCharOffsets = in.createIntArray();
                this.mLineBaselines = in.createIntArray();
                this.mHint = in.readString();
            }
        }

        void writeToParcel(Parcel out, boolean simple, boolean writeSensitive) {
            TextUtils.writeToParcel(writeSensitive ? this.mText : "", out, 0);
            out.writeFloat(this.mTextSize);
            out.writeInt(this.mTextStyle);
            out.writeInt(this.mTextColor);
            if (!simple) {
                out.writeInt(this.mTextBackgroundColor);
                out.writeInt(this.mTextSelectionStart);
                out.writeInt(this.mTextSelectionEnd);
                out.writeIntArray(this.mLineCharOffsets);
                out.writeIntArray(this.mLineBaselines);
                out.writeString(this.mHint);
            }
        }
    }

    static class ParcelTransferWriter
    extends Binder {
        final boolean mWriteStructure;
        int mCurWindow;
        int mNumWindows;
        final ArrayList<ViewStackEntry> mViewStack = new ArrayList();
        ViewStackEntry mCurViewStackEntry;
        int mCurViewStackPos;
        int mNumWrittenWindows;
        int mNumWrittenViews;
        final float[] mTmpMatrix = new float[9];
        final boolean mSanitizeOnWrite;

        ParcelTransferWriter(AssistStructure as, Parcel out) {
            this.mSanitizeOnWrite = as.mSanitizeOnWrite;
            this.mWriteStructure = as.waitForReady();
            out.writeInt(as.mFlags);
            out.writeInt(as.mAutofillFlags);
            out.writeLong(as.mAcquisitionStartTime);
            out.writeLong(as.mAcquisitionEndTime);
            this.mNumWindows = as.mWindowNodes.size();
            if (this.mWriteStructure && this.mNumWindows > 0) {
                out.writeInt(this.mNumWindows);
            } else {
                out.writeInt(0);
            }
        }

        void writeToParcel(AssistStructure as, Parcel out) {
            int start = out.dataPosition();
            this.mNumWrittenWindows = 0;
            this.mNumWrittenViews = 0;
            boolean more = this.writeToParcelInner(as, out);
            Log.i(AssistStructure.TAG, "Flattened " + (more ? "partial" : "final") + " assist data: " + (out.dataPosition() - start) + " bytes, containing " + this.mNumWrittenWindows + " windows, " + this.mNumWrittenViews + " views");
        }

        boolean writeToParcelInner(AssistStructure as, Parcel out) {
            if (this.mNumWindows == 0) {
                return false;
            }
            PooledStringWriter pwriter = new PooledStringWriter(out);
            while (this.writeNextEntryToParcel(as, out, pwriter)) {
                if (out.dataSize() <= 65536) continue;
                out.writeInt(0);
                out.writeStrongBinder(this);
                pwriter.finish();
                return true;
            }
            pwriter.finish();
            this.mViewStack.clear();
            return false;
        }

        void pushViewStackEntry(ViewNode node, int pos) {
            ViewStackEntry entry;
            if (pos >= this.mViewStack.size()) {
                entry = new ViewStackEntry();
                this.mViewStack.add(entry);
            } else {
                entry = this.mViewStack.get(pos);
            }
            entry.node = node;
            entry.numChildren = node.getChildCount();
            entry.curChild = 0;
            this.mCurViewStackEntry = entry;
        }

        void writeView(ViewNode child, Parcel out, PooledStringWriter pwriter, int levelAdj) {
            out.writeInt(0x22222222);
            int flags = child.writeSelfToParcel(out, pwriter, this.mSanitizeOnWrite, this.mTmpMatrix, true);
            ++this.mNumWrittenViews;
            if ((flags & 0x100000) != 0) {
                out.writeInt(child.mChildren.length);
                int pos = ++this.mCurViewStackPos;
                this.pushViewStackEntry(child, pos);
            }
        }

        boolean writeNextEntryToParcel(AssistStructure as, Parcel out, PooledStringWriter pwriter) {
            int pos;
            if (this.mCurViewStackEntry != null) {
                if (this.mCurViewStackEntry.curChild < this.mCurViewStackEntry.numChildren) {
                    ViewNode child = this.mCurViewStackEntry.node.mChildren[this.mCurViewStackEntry.curChild];
                    ++this.mCurViewStackEntry.curChild;
                    this.writeView(child, out, pwriter, 1);
                    return true;
                }
                do {
                    int pos2;
                    if ((pos2 = --this.mCurViewStackPos) < 0) {
                        this.mCurViewStackEntry = null;
                        break;
                    }
                    this.mCurViewStackEntry = this.mViewStack.get(pos2);
                } while (this.mCurViewStackEntry.curChild >= this.mCurViewStackEntry.numChildren);
                return true;
            }
            if ((pos = this.mCurWindow++) < this.mNumWindows) {
                WindowNode win = as.mWindowNodes.get(pos);
                out.writeInt(0x11111111);
                win.writeSelfToParcel(out, pwriter, this.mTmpMatrix);
                ++this.mNumWrittenWindows;
                ViewNode root = win.mRoot;
                this.mCurViewStackPos = 0;
                this.writeView(root, out, pwriter, 0);
                return true;
            }
            return false;
        }
    }

    static class ViewStackEntry {
        ViewNode node;
        int curChild;
        int numChildren;

        ViewStackEntry() {
        }
    }
}

