/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Slog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SystemApi
public class BackupRestoreEventLogger {
    private static final String TAG = "BackupRestoreEventLogger";
    public static final int DATA_TYPES_ALLOWED = 15;
    private final int mOperationType;
    private final Map<String, DataTypeResult> mResults = new HashMap<String, DataTypeResult>();
    private final MessageDigest mHashDigest;

    public BackupRestoreEventLogger(int operationType) {
        this.mOperationType = operationType;
        MessageDigest hashDigest = null;
        try {
            hashDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            Slog.w("Couldn't create MessageDigest for hash computation", e);
        }
        this.mHashDigest = hashDigest;
    }

    public void logItemsBackedUp(String dataType, int count) {
        this.logSuccess(0, dataType, count);
    }

    public void logItemsBackupFailed(String dataType, int count, String error) {
        this.logFailure(0, dataType, count, error);
    }

    public void logBackupMetadata(String dataType, String metaData) {
        this.logMetaData(0, dataType, metaData);
    }

    public void logItemsRestored(String dataType, int count) {
        this.logSuccess(1, dataType, count);
    }

    public void logItemsRestoreFailed(String dataType, int count, String error) {
        this.logFailure(1, dataType, count, error);
    }

    public void logRestoreMetadata(String dataType, String metadata) {
        this.logMetaData(1, dataType, metadata);
    }

    public List<DataTypeResult> getLoggingResults() {
        return new ArrayList<DataTypeResult>(this.mResults.values());
    }

    public int getOperationType() {
        return this.mOperationType;
    }

    public void clearData() {
        this.mResults.clear();
    }

    private void logSuccess(int operationType, String dataType, int count) {
        DataTypeResult dataTypeResult = this.getDataTypeResult(operationType, dataType);
        if (dataTypeResult == null) {
            return;
        }
        dataTypeResult.mSuccessCount += count;
        this.mResults.put(dataType, dataTypeResult);
    }

    private void logFailure(int operationType, String dataType, int count, String error) {
        DataTypeResult dataTypeResult = this.getDataTypeResult(operationType, dataType);
        if (dataTypeResult == null) {
            return;
        }
        dataTypeResult.mFailCount += count;
        if (error != null) {
            dataTypeResult.mErrors.merge(error, count, Integer::sum);
        }
    }

    private void logMetaData(int operationType, String dataType, String metaData) {
        if (this.mHashDigest == null) {
            return;
        }
        DataTypeResult dataTypeResult = this.getDataTypeResult(operationType, dataType);
        if (dataTypeResult == null) {
            return;
        }
        dataTypeResult.mMetadataHash = this.getMetaDataHash(metaData);
    }

    private DataTypeResult getDataTypeResult(int operationType, String dataType) {
        if (operationType != this.mOperationType) {
            Slog.d(TAG, "Operation type mismatch: logger created for " + this.mOperationType + ", trying to log for " + operationType);
            return null;
        }
        if (!this.mResults.containsKey(dataType)) {
            if (this.mResults.keySet().size() == 15) {
                Slog.d(TAG, "Logger is full, ignoring new data type");
                return null;
            }
            this.mResults.put(dataType, new DataTypeResult(dataType));
        }
        return this.mResults.get(dataType);
    }

    private byte[] getMetaDataHash(String metaData) {
        return this.mHashDigest.digest(metaData.getBytes(StandardCharsets.UTF_8));
    }

    public static class DataTypeResult
    implements Parcelable {
        private final String mDataType;
        private int mSuccessCount;
        private int mFailCount;
        private final Map<String, Integer> mErrors = new HashMap<String, Integer>();
        private byte[] mMetadataHash;
        public static final Parcelable.Creator<DataTypeResult> CREATOR = new Parcelable.Creator<DataTypeResult>(){

            @Override
            public DataTypeResult createFromParcel(Parcel in) {
                String dataType = in.readString();
                int successCount = in.readInt();
                int failCount = in.readInt();
                ArrayMap<String, Integer> errors = new ArrayMap<String, Integer>();
                Bundle errorsBundle = in.readBundle(this.getClass().getClassLoader());
                for (String key : errorsBundle.keySet()) {
                    errors.put(key, errorsBundle.getInt(key));
                }
                byte[] metadataHash = in.createByteArray();
                DataTypeResult result = new DataTypeResult(dataType);
                result.mSuccessCount = successCount;
                result.mFailCount = failCount;
                result.mErrors.putAll(errors);
                result.mMetadataHash = metadataHash;
                return result;
            }

            public DataTypeResult[] newArray(int size) {
                return new DataTypeResult[size];
            }
        };

        public DataTypeResult(String dataType) {
            this.mDataType = dataType;
        }

        public String getDataType() {
            return this.mDataType;
        }

        public int getSuccessCount() {
            return this.mSuccessCount;
        }

        public int getFailCount() {
            return this.mFailCount;
        }

        public Map<String, Integer> getErrors() {
            return this.mErrors;
        }

        public byte[] getMetadataHash() {
            return this.mMetadataHash;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mDataType);
            dest.writeInt(this.mSuccessCount);
            dest.writeInt(this.mFailCount);
            Bundle errorsBundle = new Bundle();
            for (Map.Entry<String, Integer> e : this.mErrors.entrySet()) {
                errorsBundle.putInt(e.getKey(), e.getValue());
            }
            dest.writeBundle(errorsBundle);
            dest.writeByteArray(this.mMetadataHash);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackupRestoreError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackupRestoreDataType {
    }
}

