/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.annotation.RequiresPermission;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.content.ComponentName;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.BaseBundle;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.Log;
import android.util.TimeUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class JobInfo
implements Parcelable {
    private static String TAG = "JobInfo";
    public static final long DISALLOW_DEADLINES_FOR_PREFETCH_JOBS = 194532703L;
    public static final long THROW_ON_INVALID_PRIORITY_VALUE = 140852299L;
    public static final long REJECT_NEGATIVE_NETWORK_ESTIMATES = 253665015L;
    public static final int NETWORK_TYPE_NONE = 0;
    public static final int NETWORK_TYPE_ANY = 1;
    public static final int NETWORK_TYPE_UNMETERED = 2;
    public static final int NETWORK_TYPE_NOT_ROAMING = 3;
    public static final int NETWORK_TYPE_CELLULAR = 4;
    @Deprecated
    public static final int NETWORK_TYPE_METERED = 4;
    public static final int NETWORK_BYTES_UNKNOWN = -1;
    public static final long DEFAULT_INITIAL_BACKOFF_MILLIS = 30000L;
    public static final long MAX_BACKOFF_DELAY_MILLIS = 18000000L;
    public static final int BACKOFF_POLICY_LINEAR = 0;
    public static final int BACKOFF_POLICY_EXPONENTIAL = 1;
    private static final long MIN_PERIOD_MILLIS = 900000L;
    private static final long MIN_FLEX_MILLIS = 300000L;
    public static final long MIN_BACKOFF_MILLIS = 10000L;
    public static final int DEFAULT_BACKOFF_POLICY = 1;
    public static final int PRIORITY_MIN = 100;
    public static final int PRIORITY_LOW = 200;
    public static final int PRIORITY_DEFAULT = 300;
    public static final int PRIORITY_HIGH = 400;
    public static final int PRIORITY_MAX = 500;
    public static final int BIAS_DEFAULT = 0;
    public static final int BIAS_SYNC_EXPEDITED = 10;
    public static final int BIAS_SYNC_INITIALIZATION = 20;
    public static final int BIAS_BOUND_FOREGROUND_SERVICE = 30;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PRIORITY_FOREGROUND_APP = 30;
    public static final int BIAS_FOREGROUND_SERVICE = 35;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PRIORITY_FOREGROUND_SERVICE = 35;
    public static final int BIAS_TOP_APP = 40;
    public static final int BIAS_ADJ_OFTEN_RUNNING = -40;
    public static final int BIAS_ADJ_ALWAYS_RUNNING = -80;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int FLAG_WILL_BE_FOREGROUND = 1;
    public static final int FLAG_IMPORTANT_WHILE_FOREGROUND = 2;
    public static final int FLAG_PREFETCH = 4;
    public static final int FLAG_EXEMPT_FROM_APP_STANDBY = 8;
    public static final int FLAG_EXPEDITED = 16;
    public static final int FLAG_USER_INITIATED = 32;
    public static final int CONSTRAINT_FLAG_CHARGING = 1;
    public static final int CONSTRAINT_FLAG_BATTERY_NOT_LOW = 2;
    public static final int CONSTRAINT_FLAG_DEVICE_IDLE = 4;
    public static final int CONSTRAINT_FLAG_STORAGE_NOT_LOW = 8;
    @UnsupportedAppUsage
    private final int jobId;
    private final PersistableBundle extras;
    private final Bundle transientExtras;
    private final ClipData clipData;
    private final int clipGrantFlags;
    @UnsupportedAppUsage
    private final ComponentName service;
    private final int constraintFlags;
    private final int mPreferredConstraintFlags;
    private final TriggerContentUri[] triggerContentUris;
    private final long triggerContentUpdateDelay;
    private final long triggerContentMaxDelay;
    private final boolean hasEarlyConstraint;
    private final boolean hasLateConstraint;
    private final NetworkRequest networkRequest;
    private final long networkDownloadBytes;
    private final long networkUploadBytes;
    private final long minimumNetworkChunkBytes;
    private final long minLatencyMillis;
    private final long maxExecutionDelayMillis;
    private final boolean isPeriodic;
    private final boolean isPersisted;
    private final long intervalMillis;
    private final long flexMillis;
    private final long initialBackoffMillis;
    private final int backoffPolicy;
    private final int mBias;
    private final int mPriority;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final int flags;
    public static final Parcelable.Creator<JobInfo> CREATOR = new Parcelable.Creator<JobInfo>(){

        @Override
        public JobInfo createFromParcel(Parcel in) {
            return new JobInfo(in);
        }

        public JobInfo[] newArray(int size) {
            return new JobInfo[size];
        }
    };

    public static long getMinPeriodMillis() {
        return 900000L;
    }

    public static long getMinFlexMillis() {
        return 300000L;
    }

    public static long getMinBackoffMillis() {
        return 10000L;
    }

    public int getId() {
        return this.jobId;
    }

    public PersistableBundle getExtras() {
        return this.extras;
    }

    public Bundle getTransientExtras() {
        return this.transientExtras;
    }

    public ClipData getClipData() {
        return this.clipData;
    }

    public int getClipGrantFlags() {
        return this.clipGrantFlags;
    }

    public ComponentName getService() {
        return this.service;
    }

    public int getBias() {
        return this.mBias;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isExemptedFromAppStandby() {
        return (this.flags & 8) != 0 && !this.isPeriodic();
    }

    public boolean isPreferBatteryNotLow() {
        return (this.mPreferredConstraintFlags & 2) != 0;
    }

    public boolean isPreferCharging() {
        return (this.mPreferredConstraintFlags & 1) != 0;
    }

    public boolean isPreferDeviceIdle() {
        return (this.mPreferredConstraintFlags & 4) != 0;
    }

    public boolean isRequireCharging() {
        return (this.constraintFlags & 1) != 0;
    }

    public boolean isRequireBatteryNotLow() {
        return (this.constraintFlags & 2) != 0;
    }

    public boolean isRequireDeviceIdle() {
        return (this.constraintFlags & 4) != 0;
    }

    public boolean isRequireStorageNotLow() {
        return (this.constraintFlags & 8) != 0;
    }

    public int getConstraintFlags() {
        return this.constraintFlags;
    }

    public int getPreferredConstraintFlags() {
        return this.mPreferredConstraintFlags;
    }

    public TriggerContentUri[] getTriggerContentUris() {
        return this.triggerContentUris;
    }

    public long getTriggerContentUpdateDelay() {
        return this.triggerContentUpdateDelay;
    }

    public long getTriggerContentMaxDelay() {
        return this.triggerContentMaxDelay;
    }

    @Deprecated
    public int getNetworkType() {
        if (this.networkRequest == null) {
            return 0;
        }
        if (this.networkRequest.hasCapability(11)) {
            return 2;
        }
        if (this.networkRequest.hasCapability(18)) {
            return 3;
        }
        if (this.networkRequest.hasTransport(0)) {
            return 4;
        }
        return 1;
    }

    public NetworkRequest getRequiredNetwork() {
        return this.networkRequest;
    }

    public long getEstimatedNetworkDownloadBytes() {
        return this.networkDownloadBytes;
    }

    public long getEstimatedNetworkUploadBytes() {
        return this.networkUploadBytes;
    }

    public long getMinimumNetworkChunkBytes() {
        return this.minimumNetworkChunkBytes;
    }

    public long getMinLatencyMillis() {
        return this.minLatencyMillis;
    }

    public long getMaxExecutionDelayMillis() {
        return this.maxExecutionDelayMillis;
    }

    public boolean isPeriodic() {
        return this.isPeriodic;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    public long getFlexMillis() {
        return this.flexMillis;
    }

    public long getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public int getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public boolean isExpedited() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isUserInitiated() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isImportantWhileForeground() {
        return (this.flags & 2) != 0;
    }

    public boolean isPrefetch() {
        return (this.flags & 4) != 0;
    }

    public boolean hasEarlyConstraint() {
        return this.hasEarlyConstraint;
    }

    public boolean hasLateConstraint() {
        return this.hasLateConstraint;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JobInfo)) {
            return false;
        }
        JobInfo j = (JobInfo)o;
        if (this.jobId != j.jobId) {
            return false;
        }
        if (!BaseBundle.kindofEquals(this.extras, j.extras)) {
            return false;
        }
        if (!BaseBundle.kindofEquals(this.transientExtras, j.transientExtras)) {
            return false;
        }
        if (this.clipData != j.clipData) {
            return false;
        }
        if (this.clipGrantFlags != j.clipGrantFlags) {
            return false;
        }
        if (!Objects.equals(this.service, j.service)) {
            return false;
        }
        if (this.constraintFlags != j.constraintFlags) {
            return false;
        }
        if (this.mPreferredConstraintFlags != j.mPreferredConstraintFlags) {
            return false;
        }
        if (!Arrays.equals(this.triggerContentUris, j.triggerContentUris)) {
            return false;
        }
        if (this.triggerContentUpdateDelay != j.triggerContentUpdateDelay) {
            return false;
        }
        if (this.triggerContentMaxDelay != j.triggerContentMaxDelay) {
            return false;
        }
        if (this.hasEarlyConstraint != j.hasEarlyConstraint) {
            return false;
        }
        if (this.hasLateConstraint != j.hasLateConstraint) {
            return false;
        }
        if (!Objects.equals(this.networkRequest, j.networkRequest)) {
            return false;
        }
        if (this.networkDownloadBytes != j.networkDownloadBytes) {
            return false;
        }
        if (this.networkUploadBytes != j.networkUploadBytes) {
            return false;
        }
        if (this.minimumNetworkChunkBytes != j.minimumNetworkChunkBytes) {
            return false;
        }
        if (this.minLatencyMillis != j.minLatencyMillis) {
            return false;
        }
        if (this.maxExecutionDelayMillis != j.maxExecutionDelayMillis) {
            return false;
        }
        if (this.isPeriodic != j.isPeriodic) {
            return false;
        }
        if (this.isPersisted != j.isPersisted) {
            return false;
        }
        if (this.intervalMillis != j.intervalMillis) {
            return false;
        }
        if (this.flexMillis != j.flexMillis) {
            return false;
        }
        if (this.initialBackoffMillis != j.initialBackoffMillis) {
            return false;
        }
        if (this.backoffPolicy != j.backoffPolicy) {
            return false;
        }
        if (this.mBias != j.mBias) {
            return false;
        }
        if (this.mPriority != j.mPriority) {
            return false;
        }
        return this.flags == j.flags;
    }

    public int hashCode() {
        int hashCode = this.jobId;
        if (this.extras != null) {
            hashCode = 31 * hashCode + this.extras.hashCode();
        }
        if (this.transientExtras != null) {
            hashCode = 31 * hashCode + this.transientExtras.hashCode();
        }
        if (this.clipData != null) {
            hashCode = 31 * hashCode + this.clipData.hashCode();
        }
        hashCode = 31 * hashCode + this.clipGrantFlags;
        if (this.service != null) {
            hashCode = 31 * hashCode + this.service.hashCode();
        }
        hashCode = 31 * hashCode + this.constraintFlags;
        hashCode = 31 * hashCode + this.mPreferredConstraintFlags;
        if (this.triggerContentUris != null) {
            hashCode = 31 * hashCode + Arrays.hashCode(this.triggerContentUris);
        }
        hashCode = 31 * hashCode + Long.hashCode(this.triggerContentUpdateDelay);
        hashCode = 31 * hashCode + Long.hashCode(this.triggerContentMaxDelay);
        hashCode = 31 * hashCode + Boolean.hashCode(this.hasEarlyConstraint);
        hashCode = 31 * hashCode + Boolean.hashCode(this.hasLateConstraint);
        if (this.networkRequest != null) {
            hashCode = 31 * hashCode + this.networkRequest.hashCode();
        }
        hashCode = 31 * hashCode + Long.hashCode(this.networkDownloadBytes);
        hashCode = 31 * hashCode + Long.hashCode(this.networkUploadBytes);
        hashCode = 31 * hashCode + Long.hashCode(this.minimumNetworkChunkBytes);
        hashCode = 31 * hashCode + Long.hashCode(this.minLatencyMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.maxExecutionDelayMillis);
        hashCode = 31 * hashCode + Boolean.hashCode(this.isPeriodic);
        hashCode = 31 * hashCode + Boolean.hashCode(this.isPersisted);
        hashCode = 31 * hashCode + Long.hashCode(this.intervalMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.flexMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.initialBackoffMillis);
        hashCode = 31 * hashCode + this.backoffPolicy;
        hashCode = 31 * hashCode + this.mBias;
        hashCode = 31 * hashCode + this.mPriority;
        hashCode = 31 * hashCode + this.flags;
        return hashCode;
    }

    private JobInfo(Parcel in) {
        this.jobId = in.readInt();
        PersistableBundle persistableExtras = in.readPersistableBundle();
        this.extras = persistableExtras != null ? persistableExtras : PersistableBundle.EMPTY;
        this.transientExtras = in.readBundle();
        if (in.readInt() != 0) {
            this.clipData = ClipData.CREATOR.createFromParcel(in);
            this.clipGrantFlags = in.readInt();
        } else {
            this.clipData = null;
            this.clipGrantFlags = 0;
        }
        this.service = (ComponentName)in.readParcelable(null);
        this.constraintFlags = in.readInt();
        this.mPreferredConstraintFlags = in.readInt();
        this.triggerContentUris = in.createTypedArray(TriggerContentUri.CREATOR);
        this.triggerContentUpdateDelay = in.readLong();
        this.triggerContentMaxDelay = in.readLong();
        this.networkRequest = in.readInt() != 0 ? NetworkRequest.CREATOR.createFromParcel(in) : null;
        this.networkDownloadBytes = in.readLong();
        this.networkUploadBytes = in.readLong();
        this.minimumNetworkChunkBytes = in.readLong();
        this.minLatencyMillis = in.readLong();
        this.maxExecutionDelayMillis = in.readLong();
        this.isPeriodic = in.readInt() == 1;
        this.isPersisted = in.readInt() == 1;
        this.intervalMillis = in.readLong();
        this.flexMillis = in.readLong();
        this.initialBackoffMillis = in.readLong();
        this.backoffPolicy = in.readInt();
        this.hasEarlyConstraint = in.readInt() == 1;
        this.hasLateConstraint = in.readInt() == 1;
        this.mBias = in.readInt();
        this.mPriority = in.readInt();
        this.flags = in.readInt();
    }

    private JobInfo(Builder b) {
        this.jobId = b.mJobId;
        this.extras = b.mExtras.deepCopy();
        this.transientExtras = b.mTransientExtras.deepCopy();
        this.clipData = b.mClipData;
        this.clipGrantFlags = b.mClipGrantFlags;
        this.service = b.mJobService;
        this.constraintFlags = b.mConstraintFlags;
        this.mPreferredConstraintFlags = b.mPreferredConstraintFlags;
        this.triggerContentUris = b.mTriggerContentUris != null ? b.mTriggerContentUris.toArray(new TriggerContentUri[b.mTriggerContentUris.size()]) : null;
        this.triggerContentUpdateDelay = b.mTriggerContentUpdateDelay;
        this.triggerContentMaxDelay = b.mTriggerContentMaxDelay;
        this.networkRequest = b.mNetworkRequest;
        this.networkDownloadBytes = b.mNetworkDownloadBytes;
        this.networkUploadBytes = b.mNetworkUploadBytes;
        this.minimumNetworkChunkBytes = b.mMinimumNetworkChunkBytes;
        this.minLatencyMillis = b.mMinLatencyMillis;
        this.maxExecutionDelayMillis = b.mMaxExecutionDelayMillis;
        this.isPeriodic = b.mIsPeriodic;
        this.isPersisted = b.mIsPersisted;
        this.intervalMillis = b.mIntervalMillis;
        this.flexMillis = b.mFlexMillis;
        this.initialBackoffMillis = b.mInitialBackoffMillis;
        this.backoffPolicy = b.mBackoffPolicy;
        this.hasEarlyConstraint = b.mHasEarlyConstraint;
        this.hasLateConstraint = b.mHasLateConstraint;
        this.mBias = b.mBias;
        this.mPriority = b.mPriority;
        this.flags = b.mFlags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.jobId);
        out.writePersistableBundle(this.extras);
        out.writeBundle(this.transientExtras);
        if (this.clipData != null) {
            out.writeInt(1);
            this.clipData.writeToParcel(out, flags);
            out.writeInt(this.clipGrantFlags);
        } else {
            out.writeInt(0);
        }
        out.writeParcelable(this.service, flags);
        out.writeInt(this.constraintFlags);
        out.writeInt(this.mPreferredConstraintFlags);
        out.writeTypedArray(this.triggerContentUris, flags);
        out.writeLong(this.triggerContentUpdateDelay);
        out.writeLong(this.triggerContentMaxDelay);
        if (this.networkRequest != null) {
            out.writeInt(1);
            this.networkRequest.writeToParcel(out, flags);
        } else {
            out.writeInt(0);
        }
        out.writeLong(this.networkDownloadBytes);
        out.writeLong(this.networkUploadBytes);
        out.writeLong(this.minimumNetworkChunkBytes);
        out.writeLong(this.minLatencyMillis);
        out.writeLong(this.maxExecutionDelayMillis);
        out.writeInt(this.isPeriodic ? 1 : 0);
        out.writeInt(this.isPersisted ? 1 : 0);
        out.writeLong(this.intervalMillis);
        out.writeLong(this.flexMillis);
        out.writeLong(this.initialBackoffMillis);
        out.writeInt(this.backoffPolicy);
        out.writeInt(this.hasEarlyConstraint ? 1 : 0);
        out.writeInt(this.hasLateConstraint ? 1 : 0);
        out.writeInt(this.mBias);
        out.writeInt(this.mPriority);
        out.writeInt(this.flags);
    }

    public String toString() {
        return "(job:" + this.jobId + "/" + this.service.flattenToShortString() + ")";
    }

    public void enforceValidity(boolean disallowPrefetchDeadlines, boolean rejectNegativeNetworkEstimates) {
        boolean hasDeadline;
        if ((this.networkDownloadBytes > 0L || this.networkUploadBytes > 0L || this.minimumNetworkChunkBytes > 0L) && this.networkRequest == null) {
            throw new IllegalArgumentException("Can't provide estimated network usage without requiring a network");
        }
        if (this.networkRequest != null && rejectNegativeNetworkEstimates) {
            if (this.networkUploadBytes != -1L && this.networkUploadBytes < 0L) {
                throw new IllegalArgumentException("Invalid network upload bytes: " + this.networkUploadBytes);
            }
            if (this.networkDownloadBytes != -1L && this.networkDownloadBytes < 0L) {
                throw new IllegalArgumentException("Invalid network download bytes: " + this.networkDownloadBytes);
            }
        }
        long estimatedTransfer = this.networkUploadBytes == -1L ? this.networkDownloadBytes : this.networkUploadBytes + (this.networkDownloadBytes == -1L ? 0L : this.networkDownloadBytes);
        if (this.minimumNetworkChunkBytes != -1L && estimatedTransfer != -1L && this.minimumNetworkChunkBytes > estimatedTransfer) {
            throw new IllegalArgumentException("Minimum chunk size can't be greater than estimated network usage");
        }
        if (this.minimumNetworkChunkBytes != -1L && this.minimumNetworkChunkBytes <= 0L) {
            throw new IllegalArgumentException("Minimum chunk size must be positive");
        }
        boolean bl = hasDeadline = this.maxExecutionDelayMillis != 0L;
        if (this.isPeriodic) {
            if (hasDeadline) {
                throw new IllegalArgumentException("Can't call setOverrideDeadline() on a periodic job.");
            }
            if (this.minLatencyMillis != 0L) {
                throw new IllegalArgumentException("Can't call setMinimumLatency() on a periodic job");
            }
            if (this.triggerContentUris != null) {
                throw new IllegalArgumentException("Can't call addTriggerContentUri() on a periodic job");
            }
        }
        if (disallowPrefetchDeadlines && hasDeadline && (this.flags & 4) != 0) {
            throw new IllegalArgumentException("Can't call setOverrideDeadline() on a prefetch job.");
        }
        if (this.isPersisted) {
            if (this.networkRequest != null && this.networkRequest.getNetworkSpecifier() != null) {
                throw new IllegalArgumentException("Network specifiers aren't supported for persistent jobs");
            }
            if (this.triggerContentUris != null) {
                throw new IllegalArgumentException("Can't call addTriggerContentUri() on a persisted job");
            }
            if (!this.transientExtras.isEmpty()) {
                throw new IllegalArgumentException("Can't call setTransientExtras() on a persisted job");
            }
            if (this.clipData != null) {
                throw new IllegalArgumentException("Can't call setClipData() on a persisted job");
            }
        }
        if ((this.flags & 2) != 0) {
            if (this.hasEarlyConstraint) {
                throw new IllegalArgumentException("An important while foreground job cannot have a time delay");
            }
            if (this.mPriority != 400 && this.mPriority != 300) {
                throw new IllegalArgumentException("An important while foreground job must be high or default priority. Don't mark unimportant tasks as important while foreground.");
            }
        }
        boolean isExpedited = (this.flags & 0x10) != 0;
        boolean isUserInitiated = (this.flags & 0x20) != 0;
        switch (this.mPriority) {
            case 500: {
                if (isExpedited || isUserInitiated) break;
                throw new IllegalArgumentException("Only expedited or user-initiated jobs can have max priority");
            }
            case 400: {
                if ((this.flags & 4) != 0) {
                    throw new IllegalArgumentException("Prefetch jobs cannot be high priority");
                }
                if (!this.isPeriodic) break;
                throw new IllegalArgumentException("Periodic jobs cannot be high priority");
            }
            case 100: 
            case 200: 
            case 300: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid priority level provided: " + this.mPriority);
            }
        }
        if (isExpedited) {
            if (this.hasEarlyConstraint) {
                throw new IllegalArgumentException("An expedited job cannot have a time delay");
            }
            if (this.hasLateConstraint) {
                throw new IllegalArgumentException("An expedited job cannot have a deadline");
            }
            if (this.isPeriodic) {
                throw new IllegalArgumentException("An expedited job cannot be periodic");
            }
            if (isUserInitiated) {
                throw new IllegalArgumentException("An expedited job cannot be user-initiated");
            }
            if (this.mPriority != 500 && this.mPriority != 400) {
                throw new IllegalArgumentException("An expedited job must be high or max priority. Don't use expedited jobs for unimportant tasks.");
            }
            if ((this.constraintFlags & 0xFFFFFFF7) != 0 || (this.flags & 0xFFFFFFE7) != 0) {
                throw new IllegalArgumentException("An expedited job can only have network and storage-not-low constraints");
            }
            if (this.triggerContentUris != null && this.triggerContentUris.length > 0) {
                throw new IllegalArgumentException("Can't call addTriggerContentUri() on an expedited job");
            }
        }
        if ((this.constraintFlags & this.mPreferredConstraintFlags) != 0) {
            if ((this.constraintFlags & 2) != 0 && (this.mPreferredConstraintFlags & 2) != 0) {
                throw new IllegalArgumentException("battery-not-low constraint cannot be both preferred and required");
            }
            if ((this.constraintFlags & 1) != 0 && (this.mPreferredConstraintFlags & 1) != 0) {
                throw new IllegalArgumentException("charging constraint cannot be both preferred and required");
            }
            if ((this.constraintFlags & 4) != 0 && (this.mPreferredConstraintFlags & 4) != 0) {
                throw new IllegalArgumentException("device idle constraint cannot be both preferred and required");
            }
            throw new IllegalArgumentException("constraints cannot be both preferred and required");
        }
        if (isUserInitiated) {
            if (this.hasEarlyConstraint) {
                throw new IllegalArgumentException("A user-initiated job cannot have a time delay");
            }
            if (this.hasLateConstraint) {
                throw new IllegalArgumentException("A user-initiated job cannot have a deadline");
            }
            if (this.isPeriodic) {
                throw new IllegalArgumentException("A user-initiated job cannot be periodic");
            }
            if ((this.flags & 4) != 0) {
                throw new IllegalArgumentException("A user-initiated job cannot also be a prefetch job");
            }
            if (this.mPriority != 500) {
                throw new IllegalArgumentException("A user-initiated job must be max priority.");
            }
            if ((this.constraintFlags & 4) != 0 || (this.mPreferredConstraintFlags & 4) != 0) {
                throw new IllegalArgumentException("A user-initiated job cannot have a device-idle constraint");
            }
            if (this.triggerContentUris != null && this.triggerContentUris.length > 0) {
                throw new IllegalArgumentException("Can't call addTriggerContentUri() on a user-initiated job");
            }
            if (this.networkRequest == null) {
                throw new IllegalArgumentException("A user-initiated data transfer job must specify a valid network type");
            }
        }
    }

    public static String getBiasString(int bias) {
        switch (bias) {
            case 0: {
                return "0 [DEFAULT]";
            }
            case 10: {
                return "10 [SYNC_EXPEDITED]";
            }
            case 20: {
                return "20 [SYNC_INITIALIZATION]";
            }
            case 30: {
                return "30 [BFGS_APP]";
            }
            case 35: {
                return "35 [FGS_APP]";
            }
            case 40: {
                return "40 [TOP_APP]";
            }
        }
        return bias + " [UNKNOWN]";
    }

    public static String getPriorityString(int priority) {
        switch (priority) {
            case 100: {
                return priority + " [MIN]";
            }
            case 200: {
                return priority + " [LOW]";
            }
            case 300: {
                return priority + " [DEFAULT]";
            }
            case 400: {
                return priority + " [HIGH]";
            }
            case 500: {
                return priority + " [MAX]";
            }
        }
        return priority + " [UNKNOWN]";
    }

    public static class TriggerContentUri
    implements Parcelable {
        private final Uri mUri;
        private final int mFlags;
        public static final int FLAG_NOTIFY_FOR_DESCENDANTS = 1;
        public static final Parcelable.Creator<TriggerContentUri> CREATOR = new Parcelable.Creator<TriggerContentUri>(){

            @Override
            public TriggerContentUri createFromParcel(Parcel in) {
                return new TriggerContentUri(in);
            }

            public TriggerContentUri[] newArray(int size) {
                return new TriggerContentUri[size];
            }
        };

        public TriggerContentUri(Uri uri, int flags) {
            this.mUri = Objects.requireNonNull(uri);
            this.mFlags = flags;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TriggerContentUri)) {
                return false;
            }
            TriggerContentUri t = (TriggerContentUri)o;
            return Objects.equals(t.mUri, this.mUri) && t.mFlags == this.mFlags;
        }

        public int hashCode() {
            return (this.mUri == null ? 0 : this.mUri.hashCode()) ^ this.mFlags;
        }

        private TriggerContentUri(Parcel in) {
            this.mUri = Uri.CREATOR.createFromParcel(in);
            this.mFlags = in.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            this.mUri.writeToParcel(out, flags);
            out.writeInt(this.mFlags);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flags {
        }
    }

    public static class Builder {
        private final int mJobId;
        private final ComponentName mJobService;
        private PersistableBundle mExtras = PersistableBundle.EMPTY;
        private Bundle mTransientExtras = Bundle.EMPTY;
        private ClipData mClipData;
        private int mClipGrantFlags;
        private int mBias = 0;
        private int mPriority = 300;
        private int mFlags;
        private int mConstraintFlags;
        private int mPreferredConstraintFlags;
        private NetworkRequest mNetworkRequest;
        private long mNetworkDownloadBytes = -1L;
        private long mNetworkUploadBytes = -1L;
        private long mMinimumNetworkChunkBytes = -1L;
        private ArrayList<TriggerContentUri> mTriggerContentUris;
        private long mTriggerContentUpdateDelay = -1L;
        private long mTriggerContentMaxDelay = -1L;
        private boolean mIsPersisted;
        private long mMinLatencyMillis;
        private long mMaxExecutionDelayMillis;
        private boolean mIsPeriodic;
        private boolean mHasEarlyConstraint;
        private boolean mHasLateConstraint;
        private long mIntervalMillis;
        private long mFlexMillis;
        private long mInitialBackoffMillis = 30000L;
        private int mBackoffPolicy = 1;
        private boolean mBackoffPolicySet = false;

        public Builder(int jobId, ComponentName jobService) {
            this.mJobService = jobService;
            this.mJobId = jobId;
        }

        public Builder(JobInfo job) {
            this.mJobId = job.getId();
            this.mJobService = job.getService();
            this.mExtras = job.getExtras();
            this.mTransientExtras = job.getTransientExtras();
            this.mClipData = job.getClipData();
            this.mClipGrantFlags = job.getClipGrantFlags();
            this.mBias = job.getBias();
            this.mFlags = job.getFlags();
            this.mConstraintFlags = job.getConstraintFlags();
            this.mPreferredConstraintFlags = job.getPreferredConstraintFlags();
            this.mNetworkRequest = job.getRequiredNetwork();
            this.mNetworkDownloadBytes = job.getEstimatedNetworkDownloadBytes();
            this.mNetworkUploadBytes = job.getEstimatedNetworkUploadBytes();
            this.mMinimumNetworkChunkBytes = job.getMinimumNetworkChunkBytes();
            this.mTriggerContentUris = job.getTriggerContentUris() != null ? new ArrayList<TriggerContentUri>(Arrays.asList(job.getTriggerContentUris())) : null;
            this.mTriggerContentUpdateDelay = job.getTriggerContentUpdateDelay();
            this.mTriggerContentMaxDelay = job.getTriggerContentMaxDelay();
            this.mIsPersisted = job.isPersisted();
            this.mMinLatencyMillis = job.getMinLatencyMillis();
            this.mMaxExecutionDelayMillis = job.getMaxExecutionDelayMillis();
            this.mIsPeriodic = job.isPeriodic();
            this.mHasEarlyConstraint = job.hasEarlyConstraint();
            this.mHasLateConstraint = job.hasLateConstraint();
            this.mIntervalMillis = job.getIntervalMillis();
            this.mFlexMillis = job.getFlexMillis();
            this.mInitialBackoffMillis = job.getInitialBackoffMillis();
            this.mBackoffPolicy = job.getBackoffPolicy();
            this.mPriority = job.getPriority();
        }

        public Builder setBias(int bias) {
            this.mBias = bias;
            return this;
        }

        public Builder setPriority(int priority) {
            if (priority > 500 || priority < 100) {
                if (Compatibility.isChangeEnabled(140852299L)) {
                    throw new IllegalArgumentException("Invalid priority value");
                }
                return this;
            }
            this.mPriority = priority;
            return this;
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        public Builder setExtras(PersistableBundle extras) {
            this.mExtras = extras;
            return this;
        }

        public Builder setTransientExtras(Bundle extras) {
            this.mTransientExtras = extras;
            return this;
        }

        public Builder setClipData(ClipData clip, int grantFlags) {
            this.mClipData = clip;
            this.mClipGrantFlags = grantFlags;
            return this;
        }

        public Builder setRequiredNetworkType(int networkType) {
            if (networkType == 0) {
                return this.setRequiredNetwork(null);
            }
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            builder.addCapability(12);
            builder.addCapability(16);
            builder.removeCapability(15);
            builder.removeCapability(13);
            if (networkType != 1) {
                if (networkType == 2) {
                    builder.addCapability(11);
                } else if (networkType == 3) {
                    builder.addCapability(18);
                } else if (networkType == 4) {
                    builder.addTransportType(0);
                }
            }
            return this.setRequiredNetwork(builder.build());
        }

        public Builder setRequiredNetwork(NetworkRequest networkRequest) {
            this.mNetworkRequest = networkRequest;
            return this;
        }

        public Builder setEstimatedNetworkBytes(long downloadBytes, long uploadBytes) {
            this.mNetworkDownloadBytes = downloadBytes;
            this.mNetworkUploadBytes = uploadBytes;
            return this;
        }

        public Builder setMinimumNetworkChunkBytes(long chunkSizeBytes) {
            if (chunkSizeBytes != -1L && chunkSizeBytes <= 0L) {
                throw new IllegalArgumentException("Minimum chunk size must be positive");
            }
            this.mMinimumNetworkChunkBytes = chunkSizeBytes;
            return this;
        }

        public Builder setPrefersBatteryNotLow(boolean prefersBatteryNotLow) {
            this.mPreferredConstraintFlags = this.mPreferredConstraintFlags & 0xFFFFFFFD | (prefersBatteryNotLow ? 2 : 0);
            return this;
        }

        public Builder setPrefersCharging(boolean prefersCharging) {
            this.mPreferredConstraintFlags = this.mPreferredConstraintFlags & 0xFFFFFFFE | (prefersCharging ? 1 : 0);
            return this;
        }

        public Builder setPrefersDeviceIdle(boolean prefersDeviceIdle) {
            this.mPreferredConstraintFlags = this.mPreferredConstraintFlags & 0xFFFFFFFB | (prefersDeviceIdle ? 4 : 0);
            return this;
        }

        public Builder setRequiresCharging(boolean requiresCharging) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFE | (requiresCharging ? 1 : 0);
            return this;
        }

        public Builder setRequiresBatteryNotLow(boolean batteryNotLow) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFD | (batteryNotLow ? 2 : 0);
            return this;
        }

        public Builder setRequiresDeviceIdle(boolean requiresDeviceIdle) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFB | (requiresDeviceIdle ? 4 : 0);
            return this;
        }

        public Builder setRequiresStorageNotLow(boolean storageNotLow) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFF7 | (storageNotLow ? 8 : 0);
            return this;
        }

        public Builder addTriggerContentUri(TriggerContentUri uri) {
            if (this.mTriggerContentUris == null) {
                this.mTriggerContentUris = new ArrayList();
            }
            this.mTriggerContentUris.add(uri);
            return this;
        }

        public Builder setTriggerContentUpdateDelay(long durationMs) {
            this.mTriggerContentUpdateDelay = durationMs;
            return this;
        }

        public Builder setTriggerContentMaxDelay(long durationMs) {
            this.mTriggerContentMaxDelay = durationMs;
            return this;
        }

        public Builder setPeriodic(long intervalMillis) {
            return this.setPeriodic(intervalMillis, intervalMillis);
        }

        public Builder setPeriodic(long intervalMillis, long flexMillis) {
            long percentClamp;
            long minFlex;
            long minPeriod = JobInfo.getMinPeriodMillis();
            if (intervalMillis < minPeriod) {
                Log.w(TAG, "Requested interval " + TimeUtils.formatDuration(intervalMillis) + " for job " + this.mJobId + " is too small; raising to " + TimeUtils.formatDuration(minPeriod));
                intervalMillis = minPeriod;
            }
            if (flexMillis < (minFlex = Math.max(percentClamp = 5L * intervalMillis / 100L, JobInfo.getMinFlexMillis()))) {
                Log.w(TAG, "Requested flex " + TimeUtils.formatDuration(flexMillis) + " for job " + this.mJobId + " is too small; raising to " + TimeUtils.formatDuration(minFlex));
                flexMillis = minFlex;
            }
            this.mIsPeriodic = true;
            this.mIntervalMillis = intervalMillis;
            this.mFlexMillis = flexMillis;
            this.mHasLateConstraint = true;
            this.mHasEarlyConstraint = true;
            return this;
        }

        public Builder setMinimumLatency(long minLatencyMillis) {
            this.mMinLatencyMillis = minLatencyMillis;
            this.mHasEarlyConstraint = true;
            return this;
        }

        public Builder setOverrideDeadline(long maxExecutionDelayMillis) {
            this.mMaxExecutionDelayMillis = maxExecutionDelayMillis;
            this.mHasLateConstraint = true;
            return this;
        }

        public Builder setBackoffCriteria(long initialBackoffMillis, int backoffPolicy) {
            long minBackoff = JobInfo.getMinBackoffMillis();
            if (initialBackoffMillis < minBackoff) {
                Log.w(TAG, "Requested backoff " + TimeUtils.formatDuration(initialBackoffMillis) + " for job " + this.mJobId + " is too small; raising to " + TimeUtils.formatDuration(minBackoff));
                initialBackoffMillis = minBackoff;
            }
            this.mBackoffPolicySet = true;
            this.mInitialBackoffMillis = initialBackoffMillis;
            this.mBackoffPolicy = backoffPolicy;
            return this;
        }

        public Builder setExpedited(boolean expedited) {
            if (expedited) {
                this.mFlags |= 0x10;
                if (this.mPriority == 300) {
                    this.mPriority = 500;
                }
            } else {
                if (this.mPriority == 500 && (this.mFlags & 0x10) != 0) {
                    this.mPriority = 300;
                }
                this.mFlags &= 0xFFFFFFEF;
            }
            return this;
        }

        @RequiresPermission(value="android.permission.RUN_USER_INITIATED_JOBS")
        public Builder setUserInitiated(boolean userInitiated) {
            if (userInitiated) {
                this.mFlags |= 0x20;
                if (this.mPriority == 300) {
                    this.mPriority = 500;
                }
            } else {
                if (this.mPriority == 500 && (this.mFlags & 0x20) != 0) {
                    this.mPriority = 300;
                }
                this.mFlags &= 0xFFFFFFDF;
            }
            return this;
        }

        @Deprecated
        public Builder setImportantWhileForeground(boolean importantWhileForeground) {
            if (importantWhileForeground) {
                this.mFlags |= 2;
                if (this.mPriority == 300) {
                    this.mPriority = 400;
                }
            } else {
                if (this.mPriority == 400 && (this.mFlags & 2) != 0) {
                    this.mPriority = 300;
                }
                this.mFlags &= 0xFFFFFFFD;
            }
            return this;
        }

        public Builder setPrefetch(boolean prefetch) {
            this.mFlags = prefetch ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
            return this;
        }

        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public Builder setPersisted(boolean isPersisted) {
            this.mIsPersisted = isPersisted;
            return this;
        }

        public JobInfo build() {
            return this.build(Compatibility.isChangeEnabled(194532703L), Compatibility.isChangeEnabled(253665015L));
        }

        public JobInfo build(boolean disallowPrefetchDeadlines, boolean rejectNegativeNetworkEstimates) {
            if (this.mBackoffPolicySet && (this.mConstraintFlags & 4) != 0) {
                throw new IllegalArgumentException("An idle mode job will not respect any back-off policy, so calling setBackoffCriteria with setRequiresDeviceIdle is an error.");
            }
            JobInfo jobInfo = new JobInfo(this);
            jobInfo.enforceValidity(disallowPrefetchDeadlines, rejectNegativeNetworkEstimates);
            return jobInfo;
        }

        public String summarize() {
            String service = this.mJobService != null ? this.mJobService.flattenToShortString() : "null";
            return "JobInfo.Builder{job:" + this.mJobId + "/" + service + "}";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackoffPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkType {
    }
}

