/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.job.IUserVisibleJobObserver;
import android.app.job.JobInfo;
import android.app.job.JobSnapshot;
import android.app.job.JobWorkItem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;

public abstract class JobScheduler {
    public static final long THROW_ON_INVALID_DATA_TRANSFER_IMPLEMENTATION = 255371817L;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int PENDING_JOB_REASON_INVALID_JOB_ID = -2;
    public static final int PENDING_JOB_REASON_EXECUTING = -1;
    public static final int PENDING_JOB_REASON_UNDEFINED = 0;
    public static final int PENDING_JOB_REASON_APP = 1;
    public static final int PENDING_JOB_REASON_APP_STANDBY = 2;
    public static final int PENDING_JOB_REASON_BACKGROUND_RESTRICTION = 3;
    public static final int PENDING_JOB_REASON_CONSTRAINT_BATTERY_NOT_LOW = 4;
    public static final int PENDING_JOB_REASON_CONSTRAINT_CHARGING = 5;
    public static final int PENDING_JOB_REASON_CONSTRAINT_CONNECTIVITY = 6;
    public static final int PENDING_JOB_REASON_CONSTRAINT_CONTENT_TRIGGER = 7;
    public static final int PENDING_JOB_REASON_CONSTRAINT_DEVICE_IDLE = 8;
    public static final int PENDING_JOB_REASON_CONSTRAINT_MINIMUM_LATENCY = 9;
    public static final int PENDING_JOB_REASON_CONSTRAINT_PREFETCH = 10;
    public static final int PENDING_JOB_REASON_CONSTRAINT_STORAGE_NOT_LOW = 11;
    public static final int PENDING_JOB_REASON_DEVICE_STATE = 12;
    public static final int PENDING_JOB_REASON_JOB_SCHEDULER_OPTIMIZATION = 13;
    public static final int PENDING_JOB_REASON_QUOTA = 14;
    public static final int PENDING_JOB_REASON_USER = 15;

    public JobScheduler forNamespace(String namespace) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public String getNamespace() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public static String sanitizeNamespace(String namespace) {
        if (namespace == null) {
            return null;
        }
        return namespace.trim().intern();
    }

    public abstract int schedule(JobInfo var1);

    public abstract int enqueue(JobInfo var1, JobWorkItem var2);

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public abstract int scheduleAsPackage(JobInfo var1, String var2, int var3, String var4);

    public abstract void cancel(int var1);

    public abstract void cancelAll();

    public void cancelInAllNamespaces() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract List<JobInfo> getAllPendingJobs();

    public Map<String, List<JobInfo>> getPendingJobsInAllNamespaces() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract JobInfo getPendingJob(int var1);

    public int getPendingJobReason(int jobId) {
        return 0;
    }

    public boolean canRunUserInitiatedJobs() {
        return false;
    }

    public boolean hasRunUserInitiatedJobsPermission(String packageName, int userId) {
        return false;
    }

    public abstract List<JobInfo> getStartedJobs();

    public abstract List<JobSnapshot> getAllJobSnapshots();

    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public abstract void registerUserVisibleJobObserver(IUserVisibleJobObserver var1);

    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public abstract void unregisterUserVisibleJobObserver(IUserVisibleJobObserver var1);

    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public abstract void notePendingUserRequestedAppStop(String var1, int var2, String var3);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PendingJobReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }
}

