/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.annotation.SuppressLint;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;

public class JobWorkItem
implements Parcelable {
    private final PersistableBundle mExtras;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    final Intent mIntent;
    private final long mNetworkDownloadBytes;
    private final long mNetworkUploadBytes;
    private final long mMinimumChunkBytes;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mDeliveryCount;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mWorkId;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    Object mGrants;
    public static final Parcelable.Creator<JobWorkItem> CREATOR = new Parcelable.Creator<JobWorkItem>(){

        @Override
        public JobWorkItem createFromParcel(Parcel in) {
            return new JobWorkItem(in);
        }

        public JobWorkItem[] newArray(int size) {
            return new JobWorkItem[size];
        }
    };

    public JobWorkItem(Intent intent) {
        this(intent, -1L, -1L);
    }

    public JobWorkItem(Intent intent, long downloadBytes, long uploadBytes) {
        this(intent, downloadBytes, uploadBytes, -1L);
    }

    public JobWorkItem(Intent intent, long downloadBytes, long uploadBytes, long minimumChunkBytes) {
        this.mExtras = PersistableBundle.EMPTY;
        this.mIntent = intent;
        this.mNetworkDownloadBytes = downloadBytes;
        this.mNetworkUploadBytes = uploadBytes;
        this.mMinimumChunkBytes = minimumChunkBytes;
        this.enforceValidity(Compatibility.isChangeEnabled(253665015L));
    }

    private JobWorkItem(Builder builder) {
        this.mDeliveryCount = builder.mDeliveryCount;
        this.mExtras = builder.mExtras.deepCopy();
        this.mIntent = builder.mIntent;
        this.mNetworkDownloadBytes = builder.mNetworkDownloadBytes;
        this.mNetworkUploadBytes = builder.mNetworkUploadBytes;
        this.mMinimumChunkBytes = builder.mMinimumNetworkChunkBytes;
    }

    public PersistableBundle getExtras() {
        return this.mExtras;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public long getEstimatedNetworkDownloadBytes() {
        return this.mNetworkDownloadBytes;
    }

    public long getEstimatedNetworkUploadBytes() {
        return this.mNetworkUploadBytes;
    }

    public long getMinimumNetworkChunkBytes() {
        return this.mMinimumChunkBytes;
    }

    public int getDeliveryCount() {
        return this.mDeliveryCount;
    }

    public void bumpDeliveryCount() {
        ++this.mDeliveryCount;
    }

    public void setWorkId(int id2) {
        this.mWorkId = id2;
    }

    public int getWorkId() {
        return this.mWorkId;
    }

    public void setGrants(Object grants) {
        this.mGrants = grants;
    }

    public Object getGrants() {
        return this.mGrants;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("JobWorkItem{id=");
        sb.append(this.mWorkId);
        sb.append(" intent=");
        sb.append(this.mIntent);
        sb.append(" extras=");
        sb.append(this.mExtras);
        if (this.mNetworkDownloadBytes != -1L) {
            sb.append(" downloadBytes=");
            sb.append(this.mNetworkDownloadBytes);
        }
        if (this.mNetworkUploadBytes != -1L) {
            sb.append(" uploadBytes=");
            sb.append(this.mNetworkUploadBytes);
        }
        if (this.mMinimumChunkBytes != -1L) {
            sb.append(" minimumChunkBytes=");
            sb.append(this.mMinimumChunkBytes);
        }
        if (this.mDeliveryCount != 0) {
            sb.append(" dcount=");
            sb.append(this.mDeliveryCount);
        }
        sb.append("}");
        return sb.toString();
    }

    public void enforceValidity(boolean rejectNegativeNetworkEstimates) {
        if (rejectNegativeNetworkEstimates) {
            if (this.mNetworkUploadBytes != -1L && this.mNetworkUploadBytes < 0L) {
                throw new IllegalArgumentException("Invalid network upload bytes: " + this.mNetworkUploadBytes);
            }
            if (this.mNetworkDownloadBytes != -1L && this.mNetworkDownloadBytes < 0L) {
                throw new IllegalArgumentException("Invalid network download bytes: " + this.mNetworkDownloadBytes);
            }
        }
        long estimatedTransfer = this.mNetworkUploadBytes == -1L ? this.mNetworkDownloadBytes : this.mNetworkUploadBytes + (this.mNetworkDownloadBytes == -1L ? 0L : this.mNetworkDownloadBytes);
        if (this.mMinimumChunkBytes != -1L && estimatedTransfer != -1L && this.mMinimumChunkBytes > estimatedTransfer) {
            throw new IllegalArgumentException("Minimum chunk size can't be greater than estimated network usage");
        }
        if (this.mMinimumChunkBytes != -1L && this.mMinimumChunkBytes <= 0L) {
            throw new IllegalArgumentException("Minimum chunk size must be positive");
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        if (this.mIntent != null) {
            out.writeInt(1);
            this.mIntent.writeToParcel(out, 0);
        } else {
            out.writeInt(0);
        }
        out.writePersistableBundle(this.mExtras);
        out.writeLong(this.mNetworkDownloadBytes);
        out.writeLong(this.mNetworkUploadBytes);
        out.writeLong(this.mMinimumChunkBytes);
        out.writeInt(this.mDeliveryCount);
        out.writeInt(this.mWorkId);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    JobWorkItem(Parcel in) {
        this.mIntent = in.readInt() != 0 ? Intent.CREATOR.createFromParcel(in) : null;
        PersistableBundle extras = in.readPersistableBundle();
        this.mExtras = extras != null ? extras : PersistableBundle.EMPTY;
        this.mNetworkDownloadBytes = in.readLong();
        this.mNetworkUploadBytes = in.readLong();
        this.mMinimumChunkBytes = in.readLong();
        this.mDeliveryCount = in.readInt();
        this.mWorkId = in.readInt();
    }

    public static class Builder {
        private int mDeliveryCount;
        private PersistableBundle mExtras = PersistableBundle.EMPTY;
        private Intent mIntent;
        private long mNetworkDownloadBytes = -1L;
        private long mNetworkUploadBytes = -1L;
        private long mMinimumNetworkChunkBytes = -1L;

        public Builder setDeliveryCount(int deliveryCount) {
            this.mDeliveryCount = deliveryCount;
            return this;
        }

        public Builder setExtras(PersistableBundle extras) {
            if (extras == null) {
                throw new IllegalArgumentException("extras cannot be null");
            }
            this.mExtras = extras;
            return this;
        }

        public Builder setIntent(Intent intent) {
            this.mIntent = intent;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setEstimatedNetworkBytes(long downloadBytes, long uploadBytes) {
            if (downloadBytes != -1L && downloadBytes < 0L) {
                throw new IllegalArgumentException("Invalid network download bytes: " + downloadBytes);
            }
            if (uploadBytes != -1L && uploadBytes < 0L) {
                throw new IllegalArgumentException("Invalid network upload bytes: " + uploadBytes);
            }
            this.mNetworkDownloadBytes = downloadBytes;
            this.mNetworkUploadBytes = uploadBytes;
            return this;
        }

        public Builder setMinimumNetworkChunkBytes(long chunkSizeBytes) {
            if (chunkSizeBytes != -1L && chunkSizeBytes <= 0L) {
                throw new IllegalArgumentException("Minimum chunk size must be positive");
            }
            this.mMinimumNetworkChunkBytes = chunkSizeBytes;
            return this;
        }

        public JobWorkItem build() {
            return this.build(Compatibility.isChangeEnabled(253665015L));
        }

        public JobWorkItem build(boolean rejectNegativeNetworkEstimates) {
            JobWorkItem jobWorkItem = new JobWorkItem(this);
            jobWorkItem.enforceValidity(rejectNegativeNetworkEstimates);
            return jobWorkItem;
        }
    }
}

